/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.linksecurity;

import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Isl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class IslEspTableModel
extends KTableModel {
    public static Map<String, Integer> modeMap = new HashMap<String, Integer>();
    public static Map<Integer, String> reverseModeMap = new HashMap<Integer, String>();
    public final int ColumnSize = Column.values().length;
    private Map<Isl, Integer> islIndexMap = new HashMap<Isl, Integer>();

    public IslEspTableModel(String[] headers) {
        this.setHeaders(headers);
        Array data = new Array();
        this.setData(data);
    }

    public synchronized Isl[] deleteRows(int[] rowIndexes) {
        if (rowIndexes == null) {
            return new Isl[0];
        }
        ArrayList<Isl> deletedIslRows = new ArrayList<Isl>();
        Arrays.sort(rowIndexes);
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            Isl result = this.deleteRow(rowIndexes[i], false);
            if (result == null) continue;
            deletedIslRows.add(result);
        }
        this.fireTableDataChanged();
        return deletedIslRows.toArray(new Isl[deletedIslRows.size()]);
    }

    public synchronized Isl deleteRow(int rowIndex) {
        return this.deleteRow(rowIndex, true);
    }

    private synchronized Isl deleteRow(int rowIndex, boolean fireDataChanged) {
        Array data = this.getData();
        Object[] row = (Object[])data.elementAt(rowIndex);
        Isl isl = (Isl)row[Column.ISL.ordinal()];
        this.getData().removeElementAt(rowIndex);
        if (fireDataChanged) {
            this.fireTableDataChanged();
        }
        return isl;
    }

    public synchronized void clearAll() {
        this.getData().clear();
        this.fireTableDataChanged();
    }

    public synchronized void deleteEntriesFor(Isl isl) {
        Array data = this.getData();
        Integer index = null;
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            if (!isl.equals(row[Column.ISL.ordinal()])) continue;
            index = i;
            break;
        }
        if (index != null) {
            data.removeElementAt(index);
            this.fireTableDataChanged();
        }
    }

    public synchronized void addEntry(Isl isl, Integer ingress, Integer egress, String mode) throws Exception {
        if (this.islIndexMap.containsKey(isl)) {
            throw new Exception("Entry already exists");
        }
        if (mode == null || !modeMap.containsKey(mode)) {
            throw new Exception("Not a valid mode entry");
        }
        Object[] row = new Object[this.ColumnSize];
        row[Column.ISL.ordinal()] = isl;
        row[Column.Ingress.ordinal()] = ingress;
        row[Column.Egress.ordinal()] = egress;
        row[Column.Mode.ordinal()] = mode;
        this.getData().addElement(row);
        this.fireTableDataChanged();
    }

    static {
        modeMap.put("GCM (Authenticated and Encrypted)", new Integer(2));
        modeMap.put("GMAC (Authenticated Only)", new Integer(3));
        reverseModeMap.put(new Integer(2), "GCM (Authenticated and Encrypted)");
        reverseModeMap.put(new Integer(3), "GMAC (Authenticated Only)");
    }

    public static enum Column {
        ISL,
        Ingress,
        Egress,
        Mode;

    }
}

