/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.linksecurity;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.linksecurity.IslEspTable;
import com.cisco.dcbu.sm.client.linksecurity.IslEspTableModel;
import com.cisco.dcbu.sm.client.linksecurity.LinkSecurityWizard;
import com.cisco.dcbu.sm.client.linksecurity.SASwitchPair;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.wizardTask.IntegerAsStringRenderer;
import com.cisco.dcbu.sm.client.wizardTask.IslRenderer;
import com.cisco.dcbu.sm.common.dto.ESPDto;
import com.cisco.dcbu.sm.common.model.IslBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class LinkSecurityESPConfigStep
extends WizardPanel
implements ActionListener {
    public static final String StepTitle = "Step 3 of 4: Specify SPIs for ISLs";
    public static final String StepDesp = "Select each ISL and specify the Ingress/Egress SPI(Security Parameter Index) of the SA for each. The SPIs you specify will apply to the switch, port listed first in the ISL and the inverse of this will be set for the opposite switch, port.";
    private JScrollPane _scrPanel;
    List<Isl> _selectedIsls = ((LinkSecurityWizard)this.getWizard()).getSelectedIslList();
    JComboBox _islsBox;
    JComboBox ingressSPIChoice;
    JComboBox egressSPIChoice;
    JComboBox modeChoice;
    IslEspTableModel _espTableModel;
    IslEspTable _espTable;
    Map<Isl, SASwitchPair> _swPairsForIsls;
    DefaultComboBoxModel _islSelectModel;
    Map<IslBase, List<ESPDto>> _secureIslData;

    public LinkSecurityESPConfigStep(LinkSecurityWizard wizard) {
        super(StepTitle, StepDesp, wizard, LinkSecurityWizard.WIZARD_ICON);
        if (this._selectedIsls == null) {
            this._selectedIsls = new ArrayList<Isl>();
        }
        this._islSelectModel = new DefaultComboBoxModel();
        this.initialize();
    }

    @Override
    public String getTitle() {
        return StepTitle;
    }

    private void initialize() {
        JButton[] buttons;
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEtchedBorder(1));
        JLabel[] labels = DialogUtil.buildLabels(new String[]{"ISLs", "Ingress-SA(SPI)", "Egress-SA(SPI)", "Mode"});
        Dimension labelDim = new Dimension(80, 20);
        JPanel compPanel = new JPanel();
        compPanel.setLayout(new BoxLayout(compPanel, 1));
        JPanel row1 = new JPanel(new FlowLayout(0));
        JPanel row2 = new JPanel(new FlowLayout(0));
        JPanel row3 = new JPanel(new FlowLayout(0));
        this._islsBox = new JComboBox<Object>(this._selectedIsls.toArray());
        this._islsBox.setPreferredSize(new Dimension(300, 22));
        this._islsBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LinkSecurityESPConfigStep.this.updateFields();
            }
        });
        labels[0].setPreferredSize(labelDim);
        row1.add(labels[0]);
        row1.add(this._islsBox);
        compPanel.add(row1);
        this.ingressSPIChoice = new JComboBox();
        this.ingressSPIChoice.setPreferredSize(new Dimension(120, 22));
        labels[1].setPreferredSize(labelDim);
        row2.add(labels[1]);
        row2.add(this.ingressSPIChoice);
        compPanel.add(row2);
        this.egressSPIChoice = new JComboBox();
        this.egressSPIChoice.setPreferredSize(new Dimension(120, 22));
        labels[2].setPreferredSize(labelDim);
        row2.add(labels[2]);
        row2.add(this.egressSPIChoice);
        labels[3].setPreferredSize(labelDim);
        this.modeChoice = new JComboBox<Object>(IslEspTableModel.modeMap.keySet().toArray());
        this.modeChoice.setPreferredSize(new Dimension(250, 22));
        row3.add(labels[3]);
        row3.add(this.modeChoice);
        compPanel.add(row3);
        topPanel.add(compPanel);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        for (JButton nextButton : buttons = DialogUtil.buildButtons(new String[][]{{"Add", "A"}, {"Delete", "D"}, {"Delete All", "DA"}}, (ActionListener)this)) {
            buttonPanel.add(nextButton);
        }
        bottomPanel.add((Component)buttonPanel, "North");
        this._espTableModel = new IslEspTableModel(new String[]{"ISL", "Ingress-SA(SPI)", "Egress-SA(SPI)", "Mode"});
        this._espTableModel.setEditable(new boolean[]{false, false, false});
        this._espTable = new IslEspTable(this._espTableModel);
        this._espTable.setColumnWidth(new int[]{25, 6, 6, 25});
        IslRenderer islRenderer = new IslRenderer();
        this._espTable.setDefaultRenderer(Isl.class, islRenderer);
        IntegerAsStringRenderer intAsStringRenderer = new IntegerAsStringRenderer();
        this._espTable.setDefaultRenderer(Integer.class, intAsStringRenderer);
        this._scrPanel = new JScrollPane(this._espTable);
        bottomPanel.add((Component)this._scrPanel, "Center");
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)bottomPanel, "Center");
        this.add((Component)mainPanel, "Center");
    }

    @Override
    public boolean refresh() {
        List<Isl> selectedIsls = ((LinkSecurityWizard)this.getWizard()).getSelectedIslList();
        List<SASwitchPair> swPairs = ((LinkSecurityWizard)this.getWizard()).getSwitchPairs();
        this._secureIslData = ((LinkSecurityWizard)this.getWizard()).getSecuredIslData();
        if (!this._selectedIsls.equals(selectedIsls)) {
            ArrayList<Isl> deletedList = new ArrayList<Isl>();
            deletedList.addAll(this._selectedIsls);
            deletedList.removeAll(selectedIsls);
            for (Isl nextIsl : deletedList) {
                this._espTableModel.deleteEntriesFor(nextIsl);
                this._islSelectModel.removeElement(nextIsl);
            }
            ArrayList<Isl> addedList = new ArrayList<Isl>();
            addedList.addAll(selectedIsls);
            addedList.removeAll(this._selectedIsls);
            for (Isl nextIsl : addedList) {
                this._islSelectModel.addElement(nextIsl);
            }
        }
        this._selectedIsls.clear();
        this._selectedIsls.addAll(selectedIsls);
        this._swPairsForIsls = new HashMap<Isl, SASwitchPair>();
        for (Isl nextIsl : selectedIsls) {
            SASwitchPair pair = this.findSwitchPairForISL(nextIsl, swPairs);
            this._swPairsForIsls.put(nextIsl, pair);
        }
        this.removeAllESPEntriesNotValid();
        this._islsBox.setModel(this._islSelectModel);
        this.updateFields();
        return super.refresh();
    }

    private void removeAllESPEntriesNotValid() {
        Isl[] removedIsls;
        Array data = this._espTableModel.getData();
        ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            Isl isl = (Isl)row[IslEspTableModel.Column.ISL.ordinal()];
            Integer ingress = (Integer)row[IslEspTableModel.Column.Ingress.ordinal()];
            Integer egress = (Integer)row[IslEspTableModel.Column.Egress.ordinal()];
            SASwitchPair pair = this._swPairsForIsls.get(isl);
            List<Integer> commonSPI = pair.getAllCommonSpiList();
            if (commonSPI.contains(ingress) && commonSPI.contains(egress)) continue;
            indexesToRemove.add(i);
        }
        int[] removeIndexes = new int[indexesToRemove.size()];
        for (int pos = 0; pos < indexesToRemove.size(); ++pos) {
            Integer index = (Integer)indexesToRemove.get(pos);
            removeIndexes[pos] = index;
        }
        for (Isl nextIsl : removedIsls = this._espTableModel.deleteRows(removeIndexes)) {
            this._islSelectModel.addElement(nextIsl);
        }
    }

    private void updateFields() {
        Isl selectedIsl = (Isl)this._islsBox.getSelectedItem();
        this.modeChoice.setEnabled(true);
        if (selectedIsl != null) {
            SASwitchPair islSwPair = this._swPairsForIsls.get(selectedIsl);
            if (islSwPair != null) {
                List<Integer> allSPI = islSwPair.getAllCommonSpiList();
                DefaultComboBoxModel<Object> selectModel = new DefaultComboBoxModel<Object>(allSPI.toArray());
                this.ingressSPIChoice.setModel(selectModel);
                DefaultComboBoxModel<Object> selectModel2 = new DefaultComboBoxModel<Object>(allSPI.toArray());
                this.egressSPIChoice.setModel(selectModel2);
                if (selectedIsl.getIslBase().getEspSecure()) {
                    List<ESPDto> islEspDtos = this._secureIslData.get(selectedIsl.getIslBase());
                    ESPDto firstDto = null;
                    ESPDto secondDto = null;
                    for (ESPDto nextDto : islEspDtos) {
                        if (nextDto.getSw().getWwn().equals(selectedIsl.getIslBase().getSwitch1PK()._wwn) && nextDto.getIfIndex().equals(selectedIsl.getIfIndex1())) {
                            firstDto = nextDto;
                            continue;
                        }
                        secondDto = nextDto;
                    }
                    if (firstDto != null && secondDto != null) {
                        if (firstDto.getIngress1().equals(secondDto.getEgress())) {
                            selectModel.setSelectedItem(firstDto.getIngress1());
                        } else if (firstDto.getIngress2().equals(secondDto.getEgress())) {
                            selectModel.setSelectedItem(firstDto.getIngress2());
                        } else {
                            selectModel.insertElementAt("", 0);
                            selectModel.setSelectedItem("");
                        }
                        selectModel2.setSelectedItem(firstDto.getEgress());
                        Integer modeInt = firstDto.getEspMode();
                        String modeStr = IslEspTableModel.reverseModeMap.get(modeInt);
                        this.modeChoice.setSelectedItem(modeStr);
                        this.modeChoice.setEnabled(false);
                    }
                }
            } else {
                this.emptyBothIngressEgressCombo();
            }
        } else {
            this.emptyBothIngressEgressCombo();
        }
    }

    private void emptyBothIngressEgressCombo() {
        DefaultComboBoxModel selectModel = new DefaultComboBoxModel();
        this.ingressSPIChoice.setModel(selectModel);
        DefaultComboBoxModel selectModel2 = new DefaultComboBoxModel();
        this.egressSPIChoice.setModel(selectModel2);
    }

    private SASwitchPair findSwitchPairForISL(Isl isl, List<SASwitchPair> swPairs) {
        for (SASwitchPair nextPair : swPairs) {
            if (!this.isSwitchPairForIsl(isl, nextPair)) continue;
            return nextPair;
        }
        return null;
    }

    private boolean isSwitchPairForIsl(Isl isl, SASwitchPair swpair) {
        Switch sw1 = isl.getSwitch1();
        Switch sw2 = isl.getSwitch2();
        return sw1.equals(swpair.getSw1()) && sw2.equals(swpair.getSw2()) || sw1.equals(swpair.getSw2()) && sw2.equals(swpair.getSw1());
    }

    @Override
    public void doNext() {
        if (this._islsBox.getSelectedItem() != null) {
            JOptionPane.showMessageDialog(this, "All ISLs must have their ingress/egress set before you may continue.", "Error :FC-SP ESP Setup Wizard", 0);
            return;
        }
        Array data = this._espTableModel.getData();
        HashMap<Isl, ESPDto> results = new HashMap<Isl, ESPDto>();
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            Isl isl = (Isl)row[IslEspTableModel.Column.ISL.ordinal()];
            Integer ingress = (Integer)row[IslEspTableModel.Column.Ingress.ordinal()];
            Integer egress = (Integer)row[IslEspTableModel.Column.Egress.ordinal()];
            String mode = (String)row[IslEspTableModel.Column.Mode.ordinal()];
            Integer modeInt = IslEspTableModel.modeMap.get(mode);
            ESPDto dto = new ESPDto(null, modeInt, ingress, null, egress, null, null);
            results.put(isl, dto);
        }
        ((LinkSecurityWizard)this.getWizard()).setESPData(results);
        this.setDataValid(false);
        super.doNext();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("A")) {
            Isl selectedIsl = (Isl)this._islsBox.getSelectedItem();
            if (selectedIsl != null) {
                Integer ingressSpi = (Integer)this.ingressSPIChoice.getSelectedItem();
                Integer egressSpi = (Integer)this.egressSPIChoice.getSelectedItem();
                String mode = (String)this.modeChoice.getSelectedItem();
                if (selectedIsl.getIslBase().getEspSecure()) {
                    List<ESPDto> islEspDtos = this._secureIslData.get(selectedIsl.getIslBase());
                    ESPDto firstDto = null;
                    ESPDto secondDto = null;
                    for (ESPDto nextDto : islEspDtos) {
                        if (nextDto.getSw().getWwn().equals(selectedIsl.getIslBase().getSwitch1PK()._wwn) && nextDto.getIfIndex().equals(selectedIsl.getIfIndex1())) {
                            firstDto = nextDto;
                            continue;
                        }
                        secondDto = nextDto;
                    }
                    Integer previousIngress = null;
                    if (firstDto != null && secondDto != null) {
                        if (firstDto.getIngress1().equals(secondDto.getEgress())) {
                            previousIngress = firstDto.getIngress1();
                        } else if (firstDto.getIngress2().equals(secondDto.getEgress())) {
                            previousIngress = firstDto.getIngress2();
                        }
                        if (ingressSpi.equals(previousIngress) && egressSpi.equals(firstDto.getEgress())) {
                            Util.errorMessage((Component)this, new Exception("Add not allowed: This is a secure link and you have not modified the settings to differ from their current values.\nPlease modify at least one of the SPI's before clicking add."));
                            return;
                        }
                    }
                }
                try {
                    this._espTableModel.addEntry(selectedIsl, ingressSpi, egressSpi, mode);
                    this._islSelectModel.removeElement(selectedIsl);
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this, ex);
                }
            } else {
                Util.errorMessage((Component)this, new Exception("No selected Isl to add"));
            }
        } else if (cmd.equals("DA")) {
            this._espTableModel.clearAll();
            this._islSelectModel.removeAllElements();
            this._islSelectModel = new DefaultComboBoxModel<Object>(this._selectedIsls.toArray());
            this._islsBox.setModel(this._islSelectModel);
            this.updateFields();
        } else if (cmd.equals("D")) {
            int[] selectedRows = this._espTable.getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                Isl[] removedIsls;
                for (Isl nextIsl : removedIsls = this._espTableModel.deleteRows(selectedRows)) {
                    this._islSelectModel.addElement(nextIsl);
                }
            } else {
                Util.errorMessage((Component)this, "There are no selected rows.");
                return;
            }
        }
    }
}

