/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.logicaltree;

import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.logicaltree.VsanTree;
import com.cisco.dcbu.sm.client.model.Vlan;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

class LanVlanListener
implements PropertyChangeListener {
    LanVlanListener() {
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent event) {
        Object obj = event.getSource();
        if (obj == null) {
            return;
        }
        String prop = event.getPropertyName();
        if (prop == null || prop.equals("")) {
            return;
        }
        if (prop.equals("vlanAdded")) {
            Vlan vlan = (Vlan)event.getNewValue();
            if (vlan != null) {
                VsanTree.getInstance().addVlan(vlan);
            }
        } else if (prop.equals("vlanRemoved")) {
            Vlan vlan = (Vlan)event.getOldValue();
            if (vlan != null) {
                if (ClientController.getInstance().getSelectedDomain() == vlan) {
                    ClientController.getInstance().setSelectedDomain(vlan.getLan());
                }
                VsanTree.getInstance().removeVlan(vlan);
            }
            try {
                vlan.destroy();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (prop.equals("endOfEvents")) {
            VsanTree.getInstance().repaint();
        }
    }
}

