/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.logicaltree;

import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeCommand;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeNode;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.model.VsanUnion;
import com.cisco.dcbu.sm.common.model.VsanBase;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class SegmentedVsanTreeNode
extends DefaultMutableTreeNode {
    private short _vsanId;
    private String _vsanName;

    public SegmentedVsanTreeNode(Vsan vsan) {
        this._vsanId = vsan.getId();
        this._vsanName = ((VsanBase)vsan.getBaseModelObject()).getName();
        this.setUserObject(new VsanUnion(vsan));
    }

    public short getId() {
        return this._vsanId;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        this.updateVsans();
    }

    @Override
    public void remove(int childIndex) {
        super.remove(childIndex);
        this.updateVsans();
    }

    private void updateVsans() {
        VsanUnion vsanUnion = (VsanUnion)this.getUserObject();
        Array<Vsan> vsanArray = new Array<Vsan>();
        VsanTreeCommand vsanTreeCommand = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            vsanTreeCommand = (VsanTreeCommand)((VsanTreeNode)this.getChildAt(i)).getUserObject();
            vsanArray.addElement(vsanTreeCommand._vsan);
        }
        vsanUnion.setVsans(vsanArray);
    }

    @Override
    public String toString() {
        String name = this._vsanName;
        if (name == null || name.length() == 0) {
            name = "VSAN" + this.getId();
        }
        boolean needIdAfterName = !name.endsWith(Integer.toString(this.getId()));
        StringBuffer sb = new StringBuffer(128);
        sb.append(name);
        if (needIdAfterName) {
            sb.append(" (" + this.getId() + ", " + this.getChildCount() + " segments)");
            return sb.toString();
        }
        sb.append(" (" + this.getChildCount() + " segments)");
        return sb.toString();
    }
}

