/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.logicaltree;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.IconManager;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.tree.DynamicTreeNode;
import com.cisco.dcbu.lib.ui.tree.Tree;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientContext;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.cfs.ps.PortSecurityWizard;
import com.cisco.dcbu.sm.client.dialogs.SmVsanTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.EditUserDefinedGroup;
import com.cisco.dcbu.sm.client.gui.SmCommand;
import com.cisco.dcbu.sm.client.gui.SmCommandDispatcher;
import com.cisco.dcbu.sm.client.gui.TreeCommand;
import com.cisco.dcbu.sm.client.gui.UIActions;
import com.cisco.dcbu.sm.client.gui.UIControls;
import com.cisco.dcbu.sm.client.hostcom.HostCommisioningWizard;
import com.cisco.dcbu.sm.client.logicaltree.DefaultZoneTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.IvrVsanTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.LanVlanListener;
import com.cisco.dcbu.sm.client.logicaltree.MyRenderer;
import com.cisco.dcbu.sm.client.logicaltree.SanVsanListener;
import com.cisco.dcbu.sm.client.logicaltree.SegmentedVsanTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.VlanTreeCommand;
import com.cisco.dcbu.sm.client.logicaltree.VlanTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.VsanTopTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeAction;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeCommand;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeCommandNode;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.ZoneSetTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.ZoneTreeNode;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.HighlightAction;
import com.cisco.dcbu.sm.client.map.actions.UserDefinedGroupHighlightAction;
import com.cisco.dcbu.sm.client.map.actions.VlanHighlightAction;
import com.cisco.dcbu.sm.client.map.actions.VsanHighlightAction;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Lan;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.UserDefinedGroup;
import com.cisco.dcbu.sm.client.model.UserDefinedGroupManager;
import com.cisco.dcbu.sm.client.model.UserDefinedGroupUnion;
import com.cisco.dcbu.sm.client.model.Vlan;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.model.VsanUnion;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.GroupPK;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class VsanTree
extends Tree
implements SnmpAggregrateIf,
ActionListener,
TreeSelectionListener,
ChangeListener {
    public static final String DATACENTER = "Datacenter";
    public static final String LAN = "LAN";
    public static final String USER_DEFINED = "Groups";
    public static final String ALL_VSANS = "All VSANs";
    public static final String SEGMENTED_VSANS = "Segmented VSANs";
    private static final int SAN_PATH = 1;
    private static final int FABRIC_PATH = 2;
    private static final int VSAN_PATH = 3;
    private static final int EDIT_ITEM = 0;
    private static final int DEACTIVE_ITEM = 1;
    private static final int COPY_ITEM = 2;
    private static final int COPY_TOPO = 3;
    private static final int ADD_VSAN = 4;
    private static final int DEL_VSAN = 5;
    private static final int CREATE_VSAN = 6;
    private static final int LEAF_ICON_SIZE = 12;
    private static String EDIT_REGULAR = "Edit Local Full Zone Database...";
    private static String DEACTIVATE_REGULAR = "Deactivate Zoneset...";
    private static String RECOVER_REGULAR = "Copy Full Zone Database...";
    private static DefaultTreeCellRenderer _defaultRenderer = null;
    static Icon _switchIcon = null;
    static Icon _endPortIcon = null;
    static Icon _dataCenterIcon = null;
    static Icon _lanIcon = null;
    static Icon _sanIcon = null;
    static Icon _fabricIcon = null;
    public static boolean USE_OLD_FOLDER_ICONS = false;
    public static Logger _logger = Logger.getLogger(VsanTree.class);
    public static boolean USE_SEGMENTED_VSANS_FOLDER = false;
    protected Array _setErrMsg;
    public static boolean _invokeDefaultCommand = true;
    static VsanTree _Instance;
    DefaultMutableTreeNode _datacenter;
    DefaultMutableTreeNode _san;
    DefaultMutableTreeNode _lan;
    JPopupMenu _menu;
    private JPopupMenu _createGroupMenu;
    private JPopupMenu _groupMenu;
    TreePath _path;
    MgmtDomainIf _selectedMgmtDomain;
    private static SanVsanListener _SanVsanListener;
    private static LanVlanListener _LanVlanListener;
    boolean _bKeySelChanged;
    private ClientContext recordedContext = new ClientContext();
    static final String[][] _Menus;
    static final String[][] _GroupMenus;

    public static VsanTree getInstance() {
        if (_Instance == null) {
            if (ClientController.showCDP()) {
                DefaultMutableTreeNode root = new DefaultMutableTreeNode(DataCenter.getInstance());
                DefaultMutableTreeNode san = new DefaultMutableTreeNode(San.getInstance());
                DefaultMutableTreeNode lan = new DefaultMutableTreeNode(Lan.getInstance());
                if (San.getInstance().getFabricCount() > 0) {
                    root.add(san);
                }
                root.add(lan);
                _Instance = new VsanTree(root);
                _Instance.setRootVisible(true);
                _Instance.setShowsRootHandles(true);
                VsanTree._Instance._san = san;
                VsanTree._Instance._lan = lan;
                VsanTree._Instance._datacenter = root;
                San.getInstance().addPropertyChangeListener(_SanVsanListener);
                Lan.getInstance().addPropertyChangeListener(_LanVlanListener);
            } else {
                DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
                DefaultMutableTreeNode san = new DefaultMutableTreeNode(San.getInstance());
                root.add(san);
                _Instance = new VsanTree(root);
                _Instance.setRootVisible(false);
                _Instance.setShowsRootHandles(true);
                VsanTree._Instance._san = san;
                San.getInstance().addPropertyChangeListener(_SanVsanListener);
            }
        }
        return _Instance;
    }

    public static void setIconToUseFolderOnly(boolean useFolder) {
        USE_OLD_FOLDER_ICONS = useFolder;
    }

    public static boolean getIconToUseFolderOnly() {
        return USE_OLD_FOLDER_ICONS;
    }

    private VsanTree(TreeNode tn) {
        super(tn);
        this._setErrMsg = new Array();
        TreeSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.addTreeSelectionListener(this);
        selectionModel.setSelectionMode(1);
        _defaultRenderer = new MyRenderer();
        this.setCellRenderer(_defaultRenderer);
        _switchIcon = new ImageIcon(IconManager.getIcon("switch.gif").getImage().getScaledInstance(12, 12, 1));
        _endPortIcon = new ImageIcon(IconManager.getIcon("port_grouping.gif").getImage().getScaledInstance(12, 12, 1));
        _dataCenterIcon = Util.loadIcon("icons/base.gif");
        _lanIcon = Util.loadIcon("icons/san.gif");
        _sanIcon = Util.loadIcon("icons/san.gif");
        _fabricIcon = Util.loadIcon("icons/SANFabric16TWht.gif");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                VsanTree.this.checkMouseEvent(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                VsanTree.this.checkMouseEvent(me);
            }
        });
    }

    public MgmtDomainIf getSelectedDomain() {
        return this._selectedMgmtDomain;
    }

    private void selectTreePath(TreePath path) {
        BrowserFrame.getInstance().setSanPhysicalTreeVisible();
        if (path == null) {
            this._path = path;
            return;
        }
        TreeNode n = (TreeNode)path.getLastPathComponent();
        Object o = ((DefaultMutableTreeNode)n).getUserObject();
        SmMap map = null;
        if (this._selectedMgmtDomain != null && this._selectedMgmtDomain.getFabric() != null) {
            map = MapFactory.getInstance().getMap(this._selectedMgmtDomain.getFabric());
        }
        if (map == null) {
            map = SmMap.getSelectedMap();
        }
        map.setSelectedVsanID(0);
        MgmtDomainIf mgmtDomain = this.getSelectedMgmtDomain(path);
        if (map.isSaveRequired(mgmtDomain == null ? null : mgmtDomain.getPK())) {
            try {
                map.save();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (mgmtDomain == null || mgmtDomain.getFabric() != null) {
            SmMap.ClearAll();
        }
        if (mgmtDomain != null && mgmtDomain.isZone()) {
            mgmtDomain = mgmtDomain.getParent();
        }
        ClientController.getInstance().setSelectedDomain(mgmtDomain);
        this.firePropertyChange("selectionChanged", null, mgmtDomain);
        this.firePropertyChange("domainChanged", null, mgmtDomain);
        this._path = path;
        this._selectedMgmtDomain = mgmtDomain;
        Fabric fabric = this.getCurFabric(path);
        if (this._selectedMgmtDomain != null && !this._selectedMgmtDomain.isCustomDefined() || this._selectedMgmtDomain instanceof UserDefinedGroup) {
            if (this._selectedMgmtDomain instanceof DataCenter) {
                BrowserFrame.getInstance().showDataCenterTab();
            } else if (this._selectedMgmtDomain instanceof Lan || this._selectedMgmtDomain instanceof Vlan) {
                BrowserFrame.getInstance().showLanTab();
            } else if (fabric == null) {
                BrowserFrame.getInstance().showPathTab();
            } else {
                BrowserFrame.getInstance().showFabricTab(fabric);
            }
        }
        DataView dataView = BrowserFrame.getDataView();
        if (mgmtDomain != null && mgmtDomain.isDataCenter()) {
            dataView.cleanup();
            if (_invokeDefaultCommand) {
                SmCommand.dataCenterMemberReport(BrowserFrame.getDataView(), "/" + mgmtDomain.getName(), mgmtDomain, null, null, null);
            }
        } else if (mgmtDomain != null && mgmtDomain.isLAN()) {
            dataView.cleanup();
            if (_invokeDefaultCommand) {
                SmCommand.lanMemberReport(BrowserFrame.getDataView(), "/" + mgmtDomain.getName(), mgmtDomain, null, null, null);
            }
            if (map != null) {
                map.clearAll();
            }
        } else {
            String p;
            SnmpPeer[] peerLst;
            Object tc;
            if (mgmtDomain != null && mgmtDomain.isSan()) {
                dataView.cleanup();
                if (_invokeDefaultCommand) {
                    SmCommand.sanMemberReport(BrowserFrame.getDataView(), "/" + mgmtDomain.getName(), mgmtDomain, null, null, null);
                }
                SmMap.getSelectedMap().setLayoutFilter(null);
                Fabric[] fs = ((San)mgmtDomain).getFabrics();
                if (fs != null && fs.length > 0) {
                    ArrayList<Fabric> list = new ArrayList<Fabric>(fs.length);
                    for (int i = 0; i < fs.length; ++i) {
                        list.add(fs[i]);
                    }
                    HighlightAction.getInstance().setObjects(list, null);
                    HighlightAction.getInstance().execute();
                }
                return;
            }
            if (n instanceof VsanTopTreeNode) {
                if (_invokeDefaultCommand) {
                    dataView.cleanup();
                    SmCommandDispatcher.invoke("fabricTab", dataView, null, BrowserFrame.getPathName(path));
                }
                SmMap.getSelectedMap().setLayoutFilter(null);
                return;
            }
            if (o instanceof VsanTreeCommand) {
                tc = (VsanTreeCommand)o;
                SmFilter[] filter = null;
                if (((VsanTreeCommand)tc)._vsan != null) {
                    peerLst = ((VsanTreeCommand)tc)._vsan.getSnmpPeers(true);
                    if (peerLst == null || peerLst.length == 0) {
                        this.markVsan(((VsanTreeCommand)tc)._vsan);
                        return;
                    }
                    filter = new SmFilter[peerLst.length];
                    for (int i = 0; i < filter.length; ++i) {
                        filter[i] = new SmFilter(peerLst[i], new int[][]{{((VsanTreeCommand)tc)._vsan.getVsanId()}});
                    }
                }
                if (_invokeDefaultCommand) {
                    Integer userObject = null;
                    if (n instanceof ZoneSetTreeNode && ((ZoneSetTreeNode)n)._vsan == null) {
                        userObject = new Integer(((ZoneSetTreeNode)n).getRegionId());
                    } else if (n instanceof ZoneTreeNode && ((ZoneSetTreeNode)n.getParent())._vsan == null) {
                        userObject = new Integer(((ZoneTreeNode)n).getRegionId());
                    }
                    dataView.cleanup();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    SmCommandDispatcher.invoke(((VsanTreeCommand)tc)._method, BrowserFrame.getDataView(), filter, BrowserFrame.getPathName(path), null, userObject);
                    this.setCursor(Cursor.getDefaultCursor());
                }
            } else if (o instanceof VsanUnion) {
                VsanUnion vsanUnion = (VsanUnion)o;
                SmFilter[] filters = null;
                Array<SmFilter> filterArray = new Array<SmFilter>();
                Vsan[] vsans = vsanUnion.getVsans();
                Vsan vsan = null;
                if (vsans != null && vsans.length != 0) {
                    for (int j = 0; j < vsans.length; ++j) {
                        SnmpPeer[] peers;
                        vsan = vsans[j];
                        if (vsan == null || (peers = vsan.getSnmpPeers(true)) == null || peers.length == 0) continue;
                        filters = new SmFilter[peers.length];
                        for (int i = 0; i < filters.length; ++i) {
                            filters[i] = new SmFilter(peers[i], new int[][]{{vsan.getVsanId()}});
                            filterArray.addElement(filters[i]);
                        }
                    }
                }
                if (_invokeDefaultCommand) {
                    dataView.cleanup();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    SmCommandDispatcher.invoke("vsanMemberReport", BrowserFrame.getDataView(), filterArray.toArray(new SmFilter[filterArray.size()]), BrowserFrame.getPathName(path));
                    this.setCursor(Cursor.getDefaultCursor());
                }
            } else if (o instanceof VlanTreeCommand) {
                tc = (VlanTreeCommand)o;
                SmFilter[] filter = null;
                if (((VlanTreeCommand)tc)._vlan != null && ((peerLst = ((VlanTreeCommand)tc)._vlan.getSnmpPeers(true)) == null || peerLst.length == 0)) {
                    this.markVlan(((VlanTreeCommand)tc)._vlan);
                }
                if (_invokeDefaultCommand) {
                    Object userObject = null;
                    dataView.cleanup();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    SmCommandDispatcher.invoke(((VlanTreeCommand)tc)._method, BrowserFrame.getDataView(), filter, BrowserFrame.getPathName(path), null, userObject);
                    this.setCursor(Cursor.getDefaultCursor());
                }
            } else if (o instanceof TreeCommand) {
                dataView.cleanup();
                tc = (TreeCommand)o;
                SmCommandDispatcher.invoke(((TreeCommand)tc).getMethod(), BrowserFrame.getDataView(), null, BrowserFrame.getPathName(path));
                if (((TreeCommand)o).toString().equals(ALL_VSANS)) {
                    SmMap.getSelectedMap().setLayoutFilter(null);
                }
            } else if (!(o instanceof EnforcedZone) && (p = BrowserFrame.getPathName(path)).indexOf(USER_DEFINED) != -1) {
                dataView.cleanup();
                SmCommandDispatcher.invoke("fabricTab", dataView, null, BrowserFrame.getPathName(path));
            }
        }
        if (n instanceof ZoneTreeNode) {
            ZoneTreeNode ztn = (ZoneTreeNode)n;
            this.markZone(ztn._zone, ztn.getVsan());
        } else if (n instanceof DefaultZoneTreeNode) {
            Vsan vsan = ((VsanTreeCommand)o)._vsan;
            try {
                this.markZone(vsan.getEnforcedZones()[0], vsan);
            }
            catch (Exception ex) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        } else if (n instanceof VsanTreeNode || n instanceof VsanTreeCommandNode || n instanceof ZoneSetTreeNode) {
            this.markVsan(this.getCurVsan());
        } else if (n instanceof SegmentedVsanTreeNode) {
            this.markVsan((VsanUnion)o);
        } else if (n instanceof VlanTreeNode) {
            this.markVlan(((VlanTreeNode)n).getVlan());
            BrowserFrame.getInstance().setLanPhysicalTreeVisible();
        } else if (this._selectedMgmtDomain instanceof UserDefinedGroupUnion) {
            this.higlightUserDefinedGroup((UserDefinedGroupUnion)this._selectedMgmtDomain);
        } else if (this._selectedMgmtDomain != null && this._selectedMgmtDomain.isCustomDefined()) {
            this.higlightUserDefinedGroup((UserDefinedGroup)this._selectedMgmtDomain);
        } else if (this._selectedMgmtDomain != null && this._selectedMgmtDomain instanceof DataCenter) {
            BrowserFrame.getInstance().setDataCenterPhysicalTreeVisible();
        } else if (this._selectedMgmtDomain != null && this._selectedMgmtDomain instanceof Lan) {
            BrowserFrame.getInstance().setLanPhysicalTreeVisible();
        } else {
            SmMap.getSelectedMap().setLayoutFilter(this._selectedMgmtDomain);
        }
    }

    private void higlightUserDefinedGroup(UserDefinedGroup group) {
        SmMap map;
        UserDefinedGroupHighlightAction.getInstance().setUserDefinedGroup(group);
        UserDefinedGroupHighlightAction.getInstance().execute();
        SmMap smMap = map = group == null ? SmMap.getSelectedMap() : MapFactory.getInstance().getMap(group.getFabric());
        if (map != null) {
            map.setLayoutFilter(group == null ? null : group.getPK());
        }
    }

    private void higlightUserDefinedGroup(UserDefinedGroupUnion group) {
        SmMap map;
        UserDefinedGroupHighlightAction.getInstance().setUserDefinedGroup(group);
        UserDefinedGroupHighlightAction.getInstance().execute();
        SmMap smMap = map = group == null ? SmMap.getSelectedMap() : MapFactory.getInstance().getMap(group.getFabric());
        if (map != null) {
            // empty if block
        }
    }

    private void markVsan(Vsan v) {
        SmMap map = v == null ? SmMap.getSelectedMap() : MapFactory.getInstance().getMap(v.getFabric());
        VsanHighlightAction.getInstance().setVsan(v);
        VsanHighlightAction.getInstance().execute();
        if (map != null) {
            map.setLayoutFilter(v == null ? null : v.getPK());
            if (v != null) {
                map.setSelectedVsanID(v.getVsanId());
            }
        }
    }

    private void markVsan(VsanUnion vsanUnion) {
        SmMap map = vsanUnion == null ? SmMap.getSelectedMap() : MapFactory.getInstance().getMap(vsanUnion.getFabric());
        VsanHighlightAction.getInstance().setVsan(vsanUnion);
        VsanHighlightAction.getInstance().execute();
        if (map != null) {
            // empty if block
        }
    }

    private void markZone(EnforcedZone zone, Vsan v) {
        ArrayList<EndPort> znMemAr = new ArrayList<EndPort>();
        for (int i = 0; i < zone.getMembers().size(); ++i) {
            EnforcedZoneMember ezm = (EnforcedZoneMember)zone.getMembers().elementAt(i);
            if (ezm.getType() == 4 || ezm.getType() == 6) {
                ArrayList ob = ezm.getAttachedEndPorts();
                if (null == ob) continue;
                znMemAr.addAll(ob);
                continue;
            }
            EndPort port = ezm.getEndPort(v == null ? ezm.getEnforcedZone().getFabric() : v.getFabric());
            if (null == port) continue;
            znMemAr.add(port);
        }
        this.markVsan(v);
        HighlightAction.getInstance().setObjects(znMemAr, null);
        HighlightAction.getInstance().execute();
    }

    private void markVlan(Vlan v) {
        SmMap map = v == null ? SmMap.getSelectedMap() : SmMap.getInstance(2);
        VlanHighlightAction.getInstance().setVlan(v);
        VlanHighlightAction.getInstance().execute();
        if (map != null) {
            map.setLayoutFilter(v == null ? null : v.getPK());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            TreePath menuPath = this.getPathForLocation(e.getX(), e.getY());
            if (menuPath == null) {
                return;
            }
            Object lastPathComponent = menuPath.getLastPathComponent();
            if (lastPathComponent instanceof VsanTopTreeNode) {
                if (ClientController.getInstance().isAdmin() || ClientController.getInstance().isSAAdmin()) {
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(Util.createMenuItem("Delete Fabric", "deleteFabric", "Delete Fabric", this));
                    this.setSelectionPath(menuPath);
                    menu.show(this, e.getX(), e.getY());
                    return;
                }
            } else if (!(lastPathComponent instanceof VsanTreeNode)) {
                JPopupMenu menu = null;
                this.buildMenu();
                if (lastPathComponent.toString().equals(USER_DEFINED)) {
                    menu = this._createGroupMenu;
                } else if (((TreeNode)lastPathComponent).getParent().toString().equals(USER_DEFINED)) {
                    UserDefinedGroup group = (UserDefinedGroup)((DefaultMutableTreeNode)lastPathComponent).getUserObject();
                    if (!group.isEditable()) return;
                    menu = this._groupMenu;
                } else {
                    menu = this._menu;
                }
                this.setSelectionPath(menuPath);
                if (menu != this._menu) {
                    menu.show(this, e.getX(), e.getY());
                    return;
                }
            } else {
                this._menu = this.buildMenu();
            }
            boolean showAddVsan = this.showAddVsan(lastPathComponent);
            boolean showDelVsan = this.showDelVsan(lastPathComponent);
            boolean showZoneItems = this.isZoneMenuAvailable(lastPathComponent);
            boolean showCreateVsan = this.showCreateVsan(lastPathComponent);
            if (this._menu != null) {
                this._menu.getComponent(4).setVisible(showAddVsan);
                this._menu.getComponent(5).setVisible(showDelVsan);
                this._menu.getComponent(6).setVisible(showCreateVsan);
                this._menu.getComponent(0).setVisible(showZoneItems);
                this._menu.getComponent(1).setVisible(showZoneItems);
                this._menu.getComponent(2).setVisible(showZoneItems);
                this._menu.getComponent(3).setVisible(showZoneItems);
            }
            if (showZoneItems) {
                boolean hasZoneSet;
                boolean isIvr = this.isIvrNode(menuPath);
                if (isIvr) {
                    ConcurrentHashMap<Integer, String> ivrZst = ClientController.getInstance().getFabric().getAllIvrEnforcedZoneSetName();
                    hasZoneSet = ivrZst != null && ivrZst.size() > 0;
                } else {
                    Vsan v = this.getCurVsan(menuPath);
                    boolean bl = hasZoneSet = v != null && v.getEnforcedZoneSetName() != null;
                }
                if (this._menu != null) {
                    this._menu.getComponent(1).setEnabled(hasZoneSet);
                    this._menu.getComponent(3).setVisible(isIvr);
                }
            }
            if (!showAddVsan && !showDelVsan && !showZoneItems && !showCreateVsan) return;
            this.setSelectionPath(menuPath);
            if (this._menu == null) return;
            this._menu.show(this, e.getX(), e.getY());
            return;
        } else {
            if (e.getID() != 501) return;
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            if (this._path != null && path != null && path.equals(this._path) && !this._bKeySelChanged) {
                this.selectTreePath(path);
            }
            this._bKeySelChanged = false;
        }
    }

    private JPopupMenu buildMenu() {
        int i;
        this._createGroupMenu = new JPopupMenu();
        this._createGroupMenu.add(Util.createMenuItem("Create Switch Group...", "createSwitchGroup", "Create Switch Group...", this));
        this._createGroupMenu.add(Util.createMenuItem("Create NxPort Group...", "createNxPortGroup", "Create NxPort Group...", this));
        this._groupMenu = new JPopupMenu();
        for (i = 0; i < _GroupMenus.length; ++i) {
            this._groupMenu.add(Util.createMenuItem(_GroupMenus[i][0], _GroupMenus[i][1], this));
        }
        this._menu = new JPopupMenu();
        for (i = 0; i < _Menus.length; ++i) {
            this._menu.add(Util.createMenuItem(_Menus[i][0], _Menus[i][1], this));
        }
        return this._menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String cmd = ((AbstractButton)e.getSource()).getActionCommand();
            switch (cmd.charAt(0)) {
                case 'E': {
                    this.invokeZoneMgr(this.isIvrNode(this.getSelectionPath()));
                    break;
                }
                case 'e': {
                    UserDefinedGroup group = null;
                    try {
                        group = (UserDefinedGroup)((DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent()).getUserObject();
                    }
                    catch (Exception ex1) {
                        // empty catch block
                    }
                    if (group == null) break;
                    if (!group.isEditable()) {
                        JOptionPane.showMessageDialog(this, "This is an auto-generated group and is not editable.", "This action is not allowed", 0);
                        break;
                    }
                    EditUserDefinedGroup eud = new EditUserDefinedGroup(((GroupPK)group.getPK()).getFabricPK(), ((GroupPK)group.getPK()).getName());
                    eud.setVisible(true);
                    break;
                }
                case 'd': {
                    if (cmd.equalsIgnoreCase("deletegroup")) {
                        UserDefinedGroup group = null;
                        try {
                            group = (UserDefinedGroup)((DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent()).getUserObject();
                        }
                        catch (Exception ex1) {
                            // empty catch block
                        }
                        if (group == null) break;
                        if (!group.isEditable()) {
                            JOptionPane.showMessageDialog(this, "This is an auto-generated group and can not be deleted.", "This action is not allowed", 0);
                            break;
                        }
                        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the group?", "Confirm", 0) != 0 || (group = UserDefinedGroupManager.getInstance().removeGroup((GroupPK)group.getPK())) == null || this._selectedMgmtDomain != group) break;
                        UserDefinedGroupHighlightAction.getInstance().clear();
                        this._selectedMgmtDomain = SmMap.getSelectedMap().getFabric();
                        break;
                    }
                    if (!cmd.equalsIgnoreCase("deleteFabric")) break;
                    final Fabric fab = ((VsanTopTreeNode)this.getSelectionPath().getLastPathComponent()).getFabric();
                    if (fab != null) {
                        JOptionPane pane = new JOptionPane("Are you sure you want to delete fabric: " + fab.getFabricName() + "?\nIt will be removed from the server and database.", 3, 0);
                        JDialog dialog = pane.createDialog(this, "Fabric Delete");
                        dialog.setLocationRelativeTo(null);
                        dialog.setVisible(true);
                        int response = -1;
                        Object selectedValue = pane.getValue();
                        if (selectedValue != null && selectedValue instanceof Integer) {
                            response = (Integer)selectedValue;
                        }
                        if (response == 0) {
                            Thread runner = new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        ClientController.getInstance().closeFabric((FabricPK)fab.getPK());
                                    }
                                    catch (Exception ex) {
                                        Util.errorMessage(null, "Unable to delete fabric, received error:" + Util.getErrorMessage(ex));
                                    }
                                }
                            };
                            runner.run();
                        }
                    }
                    break;
                }
                case 'D': {
                    this.invokeDeactivateZnst(this.isIvrNode(this.getSelectionPath()));
                    break;
                }
                case 'c': {
                    Fabric fabric;
                    SmMap map = SmMap.getSelectedMap();
                    if (map == null) {
                        map = SmMap.getInstance();
                    }
                    if ((fabric = map.getFabric()) == null) break;
                    short type = 0;
                    type = cmd.equalsIgnoreCase("createSwitchGroup") ? (short)1 : 2;
                    EditUserDefinedGroup eud = new EditUserDefinedGroup((FabricPK)fabric.getPK(), type);
                    eud.setVisible(true);
                    break;
                }
                case 'C': {
                    this.invokeCopyZnst(this.isIvrNode(this.getSelectionPath()));
                    break;
                }
                case 'T': {
                    VsanTreeAction.getInstance().copyIvrTopology();
                    break;
                }
                case 'A': {
                    this.invokeAddVsan();
                    break;
                }
                case 'R': {
                    this.invokeDelVsan();
                }
            }
        }
        catch (Exception ex) {
            if (SnmpSession.isTrace()) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            Util.errorMessage((Component)this, ex);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && paths.length > 0) {
            this._bKeySelChanged = true;
            this.selectTreePath(paths[0]);
            UIControls.getInstance().refreshPerspectiveMode(false);
        }
    }

    private Vsan promptForVsan() throws SnmpException {
        Vsan v = this.getCurVsan();
        if (null == v) {
            Fabric fabric = ClientController.getInstance().getFabric();
            Object[] vsans = fabric.getVsans();
            Arrays.sort(vsans);
            v = (Vsan)JOptionPane.showInputDialog(BrowserFrame.getInstance(), "Select VSAN", "Select VSAN - " + fabric.getPath('/'), 3, null, vsans, vsans[0]);
        }
        return v;
    }

    private int promptForIVRRegionID() throws SnmpException {
        Object o;
        TreePath tpt = this.getSelectionPath();
        if (tpt != null && (o = tpt.getLastPathComponent()) instanceof ZoneSetTreeNode) {
            return ((ZoneSetTreeNode)o).getRegionId();
        }
        return -1;
    }

    public void invokeZoneMgr(boolean isIvr) throws Exception {
        if (isIvr) {
            if (!UIActions.getInstance().validateAtLeastOneMDSSupport(ClientController.getInstance().getFabric())) {
                return;
            }
            UIActions.getInstance().invokeZoneMgr(null, true);
        } else {
            Vsan v = this.promptForVsan();
            if (null == v) {
                return;
            }
            SnmpPeer[] peerLst = v.getSnmpPeers(true, true, true);
            if (null == peerLst || peerLst.length == 0) {
                throw new SnmpException("The login user does not have permission to edit zones for switches in selected VSAN.\nTo edit zones please discover the switches in selected VSAN using SNMP User with read/write permission.");
            }
            UIActions.getInstance().invokeZoneMgr(v, true);
        }
    }

    public HostCommisioningWizard invokeHostProvisioningWizard() throws Exception {
        Vsan v = this.promptForVsan();
        if (null == v) {
            return null;
        }
        HostCommisioningWizard hWiz = new HostCommisioningWizard(BrowserFrame.getInstance(), v);
        hWiz.setVisible(true);
        return hWiz;
    }

    public PortSecurityWizard invokePortSecurityWizard() throws Exception {
        Vsan v = this.promptForVsan();
        if (null == v) {
            return null;
        }
        PortSecurityWizard pWiz = new PortSecurityWizard(BrowserFrame.getInstance(), v);
        pWiz.setVisible(true);
        return pWiz;
    }

    public void invokeCopyZnst(boolean isIvr) throws Exception {
        if (isIvr) {
            VsanTreeAction.getInstance().copyActiveZnst(null);
        } else {
            Vsan v = this.promptForVsan();
            if (null == v) {
                return;
            }
            VsanTreeAction.getInstance().copyActiveZnst(v);
        }
    }

    public void invokeDeactivateZnst(boolean isIvr) throws Exception {
        if (isIvr) {
            TreePath tpt = this.getSelectionPath();
            if (tpt != null) {
                Object o = tpt.getLastPathComponent();
                if (o instanceof ZoneSetTreeNode) {
                    VsanTreeAction.getInstance().deactivate(null, ((ZoneSetTreeNode)o).getRegionId());
                } else {
                    Util.errorMessage((Component)BrowserFrame.getInstance(), "Please Select IVR Active Zoneset tree Node from logical domain.");
                }
            } else {
                Util.errorMessage((Component)BrowserFrame.getInstance(), "Please Select IVR Active Zoneset tree Node from logical domain.");
            }
        } else {
            Vsan v = this.promptForVsan();
            if (null == v) {
                return;
            }
            VsanTreeAction.getInstance().deactivate(v, -100);
        }
    }

    public void addVlan(Vlan vlan) {
        if (vlan == null) {
            return;
        }
        Lan lan = vlan.getLan();
        this.addVlan(lan, vlan);
    }

    public void addVlan(Lan lan, Vlan vlan) {
        DefaultMutableTreeNode lNode = this.getLanNode(lan);
        if (lNode != null) {
            VlanTreeNode vlanNode = this.getVlanNode(vlan);
            if (vlanNode != null) {
                this.refreshNode(vlan);
                return;
            }
            VlanTreeNode newNd = new VlanTreeNode(new VlanTreeCommand(vlan, null, "vlanMemberReport"));
            this.addVlan(lNode, newNd);
        }
    }

    private void addVlan(DefaultMutableTreeNode lanNode, VlanTreeNode vlanNode) {
        if (lanNode == null || vlanNode == null) {
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        int index = 0;
        for (int i = 0; i < model.getChildCount(lanNode); ++i) {
            Object child = model.getChild(lanNode, i);
            if (!(child instanceof VlanTreeNode)) continue;
            VlanTreeNode vNode = (VlanTreeNode)child;
            if (vNode.getVlan().getId() > vlanNode.getVlan().getId()) break;
            ++index;
        }
        model.insertNodeInto(vlanNode, lanNode, index);
    }

    public void removeVlan(Vlan vlan) {
        if (vlan == null) {
            return;
        }
        this.removeVlan(vlan.getLan(), vlan);
    }

    public void removeVlan(Lan lan, Vlan vlan) {
        VlanTreeNode vNode = this.getVlanNode(vlan);
        if (vNode != null) {
            this.removeNode((DefaultTreeModel)this.getModel(), vNode);
        }
    }

    public void refreshNode(Vlan vlan) {
        if (vlan == null) {
            return;
        }
        VlanTreeNode vNode = this.getVlanNode(vlan);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        if (vNode != null) {
            MutableTreeNode tn;
            VlanTreeNode newNode = new VlanTreeNode(new VlanTreeCommand(vlan, null, "vlanMemberReport"));
            MutableTreeNode mutableTreeNode = tn = vNode._loaded ? (MutableTreeNode)vNode.getChildAt(0) : null;
            if (tn != null) {
                this.removeNode(model, tn);
                model.insertNodeInto(newNode, vNode, 0);
            }
            model.nodeChanged(vNode);
        }
        this.repaint();
    }

    public void addVsan(Vsan vsan) {
        if (vsan == null) {
            return;
        }
        Fabric fabric = vsan.getFabric();
        if (fabric.inVsanScope(vsan.getId())) {
            this.addVsan(fabric, vsan);
        }
    }

    private void addVsan(Fabric f, Vsan vs) {
        VsanTopTreeNode fNode = this.getFabricNode(f);
        if (null != fNode) {
            VsanTreeNode vsanNode = this.getVsanNode(vs);
            if (vsanNode != null) {
                this.refreshNode(vs);
                return;
            }
            VsanTreeNode newNd = new VsanTreeNode(new VsanTreeCommand(vs, null, "vsanMemberReport"));
            this.addVsan(fNode, newNd);
            this.removeSegmentedVsanNodes(fNode, vs);
        }
    }

    private void addVsan(VsanTopTreeNode fabricNode, VsanTreeNode vsanNode) {
        if (fabricNode == null || vsanNode == null) {
            return;
        }
        DefaultMutableTreeNode parent = null;
        parent = !vsanNode.getVsan().isSegmented() ? fabricNode : (USE_SEGMENTED_VSANS_FOLDER ? this.getSegementedVsansNode(fabricNode) : this.getSegementedVsansNode(fabricNode, vsanNode.getVsan(), true));
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        int index = 0;
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            DefaultMutableTreeNode vNode;
            Object child = model.getChild(parent, i);
            if (child instanceof VsanTreeNode) {
                vNode = (VsanTreeNode)child;
                if (((VsanTreeNode)vNode).getVsan().getId() > vsanNode.getVsan().getId()) break;
                ++index;
                continue;
            }
            if (child instanceof SegmentedVsanTreeNode) {
                vNode = (SegmentedVsanTreeNode)child;
                if (((SegmentedVsanTreeNode)vNode).getId() > vsanNode.getVsan().getId()) break;
                ++index;
                continue;
            }
            if (USER_DEFINED.equals(child.toString())) continue;
            ++index;
        }
        model.insertNodeInto(vsanNode, parent, index);
    }

    DefaultMutableTreeNode getSegementedVsansNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!node.getChildAt(i).toString().equals(SEGMENTED_VSANS)) continue;
            return (DefaultMutableTreeNode)node.getChildAt(i);
        }
        return null;
    }

    DefaultMutableTreeNode getSegementedVsansNode(DefaultMutableTreeNode fabricNode, Vsan vsan, boolean doCreate) {
        if (fabricNode == null || vsan == null) {
            return null;
        }
        SegmentedVsanTreeNode segmentedVsanTreeNode = null;
        int index = 0;
        for (int i = 0; i < fabricNode.getChildCount(); ++i) {
            if (fabricNode.getChildAt(i) instanceof SegmentedVsanTreeNode) {
                segmentedVsanTreeNode = (SegmentedVsanTreeNode)fabricNode.getChildAt(i);
                if (segmentedVsanTreeNode.getId() == vsan.getId()) {
                    return segmentedVsanTreeNode;
                }
                if (segmentedVsanTreeNode.getId() > vsan.getId()) break;
                ++index;
                continue;
            }
            if (fabricNode.getChildAt(i) instanceof VsanTreeNode) {
                VsanTreeNode vNode = (VsanTreeNode)fabricNode.getChildAt(i);
                if (vNode.getVsan().getId() > vsan.getId()) break;
                ++index;
                continue;
            }
            if (USER_DEFINED.equals(fabricNode.getChildAt(i).toString())) continue;
            ++index;
        }
        if (doCreate) {
            SegmentedVsanTreeNode newSegNode = new SegmentedVsanTreeNode(vsan);
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.insertNodeInto(newSegNode, fabricNode, index);
            return newSegNode;
        }
        return null;
    }

    public void updateIvrZones(Fabric f) {
        VsanTopTreeNode fNode = this.getFabricNode(f);
        if (fNode == null) {
            return;
        }
        if (this.getModel().getChildCount(fNode) == 0) {
            return;
        }
        DefaultMutableTreeNode allVsanNode = (DefaultMutableTreeNode)this.getModel().getChild(fNode, 0);
        if (fNode != null && f != fNode.getFabric()) {
            return;
        }
        if (null != fNode) {
            for (int v = 0; v < this.getModel().getChildCount(allVsanNode); ++v) {
                Object obVsan = this.getModel().getChild(allVsanNode, v);
                if (!(obVsan instanceof IvrVsanTreeNode)) continue;
                IvrVsanTreeNode ivrVsanNode = (IvrVsanTreeNode)obVsan;
                ((DefaultTreeModel)this.getModel()).removeNodeFromParent(ivrVsanNode);
                ivrVsanNode = new IvrVsanTreeNode(new VsanTreeCommand(f, null, "ivrAttributeTab"));
                ((DefaultTreeModel)this.getModel()).insertNodeInto(ivrVsanNode, allVsanNode, v);
                return;
            }
        }
    }

    public void removeSegmentedVsanNodes(VsanTopTreeNode fabricNode, Vsan vsan) {
        if (vsan.isSegmented()) {
            return;
        }
        DefaultMutableTreeNode parent = null;
        if (USE_SEGMENTED_VSANS_FOLDER) {
            parent = this.getSegementedVsansNode(fabricNode);
        } else {
            parent = this.getSegementedVsansNode(fabricNode, vsan, false);
            if (parent == null) {
                return;
            }
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        for (int i = model.getChildCount(parent) - 1; i >= 0; --i) {
            VsanTreeNode vNode;
            Object child = model.getChild(parent, i);
            if (!(child instanceof VsanTreeNode) || (vNode = (VsanTreeNode)child).getVsan().getId() != vsan.getId()) continue;
            vNode.setUserObject(null);
            model.removeNodeFromParent(vNode);
        }
        if (!USE_SEGMENTED_VSANS_FOLDER && parent != null && parent.getChildCount() == 0) {
            model.removeNodeFromParent(parent);
        }
    }

    public void removeVsan(Vsan vsan) {
        if (vsan == null) {
            return;
        }
        this.removeVsan(vsan.getFabric(), vsan);
    }

    public void removeVsan(Fabric f, Vsan vs) {
        VsanTreeNode vNode = this.getVsanNode(vs);
        if (vNode != null) {
            this.removeNode((DefaultTreeModel)this.getModel(), vNode);
        }
    }

    public void refreshVsan(Vsan vs) {
        this.refreshNode(vs);
    }

    public void refreshNode(Vsan vs) {
        if (vs == null) {
            return;
        }
        VsanTreeNode vNode = this.getVsanNode(vs);
        if (this._selectedMgmtDomain != null && this._selectedMgmtDomain.getParent() == vs) {
            this._path = null;
            this._selectedMgmtDomain = vs;
        }
        try {
            if (this._selectedMgmtDomain != null && this._selectedMgmtDomain != vs && this._selectedMgmtDomain.equals(vs)) {
                this._selectedMgmtDomain = vs;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        if (vNode != null) {
            MutableTreeNode tn;
            DefaultMutableTreeNode newNode = vs.getEnforcedZoneSetName() == null || vs.getEnforcedZoneSetName().length() == 0 ? new DefaultZoneTreeNode(new VsanTreeCommand(vs, null, "defaultZoneReport")) : new ZoneSetTreeNode(new VsanTreeCommand(vs, null, "zonesetMemberReport"), vs);
            MutableTreeNode mutableTreeNode = tn = vNode._loaded ? (MutableTreeNode)vNode.getChildAt(0) : null;
            if (tn != null) {
                this.removeNode(model, tn);
                model.insertNodeInto(newNode, vNode, 0);
            }
            model.nodeChanged(vNode);
        }
        this.repaint();
    }

    public void vsanSegmented(Vsan vsan, boolean isSegmented) {
        if (vsan == null) {
            return;
        }
        VsanTreeNode node = VsanTree.getInstance().getVsanNode(vsan);
        if (node != null) {
            boolean underFabric;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            boolean noSeg = !vsan.isSegmented();
            noSeg = !isSegmented;
            if (noSeg ^ (underFabric = parent instanceof VsanTopTreeNode)) {
                vsan.setSegmentedWithNoEvent(isSegmented);
                this.removeNode((DefaultTreeModel)this.getModel(), node);
                this.addVsan(vsan);
            }
        }
        this.repaint();
    }

    synchronized void removeNode(DefaultTreeModel model, MutableTreeNode node) {
        int n = 0;
        if (!(node.isLeaf() || node instanceof DynamicTreeNode && !((DynamicTreeNode)node)._loaded)) {
            n = node.getChildCount();
        }
        for (int i = n - 1; i >= 0; --i) {
            try {
                MutableTreeNode tn = (MutableTreeNode)node.getChildAt(i);
                this.removeNode(model, tn);
                continue;
            }
            catch (Exception ex) {
                _logger.info((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (this._path != null && this._path.getLastPathComponent() == node) {
            this._selectedMgmtDomain = null;
            this._path = null;
        }
        node.setUserObject(null);
        model.removeNodeFromParent(node);
    }

    public void clearSan() {
        this.clearSelection();
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        int n = model.getChildCount(this._san);
        for (int i = n - 1; i >= 0; --i) {
            MutableTreeNode tn = (MutableTreeNode)model.getChild(this._san, i);
            this.removeNode(model, tn);
        }
    }

    public void clearLan() {
        this.clearSelection();
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        int n = model.getChildCount(this._lan);
        for (int i = n - 1; i >= 0; --i) {
            MutableTreeNode tn = (MutableTreeNode)model.getChild(this._lan, i);
            this.removeNode(model, tn);
        }
    }

    public DefaultMutableTreeNode getLanNode(Lan lan) {
        if (this._lan == null) {
            return null;
        }
        Lan lanNodeUserObj = (Lan)this._lan.getUserObject();
        if (lanNodeUserObj != null && (lan == null || lan.equals(lanNodeUserObj))) {
            return this._lan;
        }
        return null;
    }

    VsanTopTreeNode getFabricNode(Fabric fa) {
        for (int i = 0; i < this.getModel().getChildCount(this._san); ++i) {
            try {
                VsanTopTreeNode fNode = (VsanTopTreeNode)this.getModel().getChild(this._san, i);
                if (fNode.getFabric() != fa) continue;
                return fNode;
            }
            catch (Exception ex) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    synchronized VsanTreeNode getVsanNode(Fabric fa, int vsanId) {
        VsanTopTreeNode fNode = this.getFabricNode(fa);
        if (fNode != null) {
            for (int i = 0; i < this.getModel().getChildCount(fNode); ++i) {
                VsanTreeNode vNode;
                Object obVsan = this.getModel().getChild(fNode, i);
                if (!(obVsan instanceof VsanTreeNode) || (vNode = (VsanTreeNode)obVsan).getVsan().getId() != vsanId) continue;
                return vNode;
            }
            DefaultMutableTreeNode segmented = this.getSegementedVsansNode(fNode);
            if (segmented != null) {
                for (int i = 0; i < this.getModel().getChildCount(segmented); ++i) {
                    VsanTreeNode vNode;
                    Object obVsan = this.getModel().getChild(segmented, i);
                    if (!(obVsan instanceof VsanTreeNode) || (vNode = (VsanTreeNode)obVsan).getVsan().getId() != vsanId) continue;
                    return vNode;
                }
            }
        }
        return null;
    }

    public synchronized IvrVsanTreeNode getIVRNode(Fabric fa) {
        if (fa == null) {
            return null;
        }
        VsanTopTreeNode fNode = this.getFabricNode(fa);
        if (fNode != null) {
            if (this.getModel().getChildCount(fNode) == 0) {
                return null;
            }
            DefaultMutableTreeNode allVsanNode = (DefaultMutableTreeNode)this.getModel().getChild(fNode, 0);
            if (fa != fNode.getFabric()) {
                return null;
            }
            for (int v = 0; v < this.getModel().getChildCount(allVsanNode); ++v) {
                Object obVsan = this.getModel().getChild(allVsanNode, v);
                if (!(obVsan instanceof IvrVsanTreeNode)) continue;
                return (IvrVsanTreeNode)obVsan;
            }
        }
        return null;
    }

    public synchronized VsanTreeNode getVsanNode(Vsan vsan) {
        if (vsan == null) {
            return null;
        }
        Fabric fa = vsan.getFabric();
        VsanTopTreeNode fNode = this.getFabricNode(fa);
        if (fNode != null) {
            int childCount = fNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                VsanTreeNode vNode;
                TreeNode bChild;
                int j;
                int segmentedCount;
                DefaultMutableTreeNode segmented;
                TreeNode aChild = fNode.getChildAt(i);
                if (aChild instanceof VsanTreeNode) {
                    VsanTreeNode vNode2 = (VsanTreeNode)aChild;
                    if (!vNode2.getVsan().equals(vsan)) continue;
                    return vNode2;
                }
                if (aChild.toString().equals(SEGMENTED_VSANS)) {
                    segmented = (DefaultMutableTreeNode)aChild;
                    segmentedCount = segmented.getChildCount();
                    for (j = 0; j < segmentedCount; ++j) {
                        bChild = segmented.getChildAt(j);
                        if (!(bChild instanceof VsanTreeNode) || !(vNode = (VsanTreeNode)bChild).getVsan().equalsByVsanPK(vsan)) continue;
                        return vNode;
                    }
                    continue;
                }
                if (!(aChild instanceof SegmentedVsanTreeNode) || ((SegmentedVsanTreeNode)(segmented = (SegmentedVsanTreeNode)aChild)).getId() != vsan.getId()) continue;
                segmentedCount = segmented.getChildCount();
                for (j = 0; j < segmentedCount; ++j) {
                    bChild = segmented.getChildAt(j);
                    if (!(bChild instanceof VsanTreeNode) || !(vNode = (VsanTreeNode)bChild).getVsan().equalsByVsanPK(vsan)) continue;
                    return vNode;
                }
            }
        }
        return null;
    }

    public synchronized VlanTreeNode getVlanNode(Vlan vlan) {
        if (vlan == null) {
            return null;
        }
        DefaultMutableTreeNode lNode = this.getLanNode(vlan.getLan());
        if (lNode != null) {
            int childCount = lNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                VlanTreeNode vNode;
                TreeNode aChild = lNode.getChildAt(i);
                if (!(aChild instanceof VlanTreeNode) || !(vNode = (VlanTreeNode)aChild).getVlan().equals(vlan)) continue;
                return vNode;
            }
        }
        return null;
    }

    public Fabric getFirstFabric() {
        if (this._san != null) {
            TreeNode treeNode = null;
            for (int i = 0; i < this._san.getChildCount(); ++i) {
                treeNode = this._san.getChildAt(i);
                if (!(treeNode instanceof VsanTopTreeNode)) continue;
                VsanTopTreeNode fabricNode = (VsanTopTreeNode)treeNode;
                return fabricNode.getFabric();
            }
        }
        return null;
    }

    synchronized void addFabric(Fabric fabric, boolean isResync) {
        if (fabric == null) {
            return;
        }
        if (this._datacenter.getIndex(this._san) == -1) {
            ((DefaultTreeModel)this.getModel()).insertNodeInto(this._san, this._datacenter, 0);
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        int pos = 0;
        int rows = this.getVisibleRowCount();
        VsanTopTreeNode newFabricNode = new VsanTopTreeNode(fabric);
        for (int i = 0; i < this._san.getChildCount(); ++i) {
            TreeNode child = this._san.getChildAt(i);
            if (!(child instanceof VsanTopTreeNode)) continue;
            VsanTopTreeNode oldFabricNode = (VsanTopTreeNode)child;
            int compResult = oldFabricNode.getFabric().getName().compareTo(fabric.getName());
            if (compResult == 0) {
                oldFabricNode.setUserObject(null);
                model.removeNodeFromParent(oldFabricNode);
                break;
            }
            if (compResult > 0) break;
            ++pos;
        }
        model.insertNodeInto(newFabricNode, this._san, pos);
        fabric.addPropertyChangeListener(_SanVsanListener);
        TreePath path = new TreePath(new Object[]{this._san.getParent(), this._san});
        int offset = 0;
        if (this._san.getChildCount() > 1) {
            offset = 1;
        }
        if (pos <= 0) {
            ((DefaultTreeModel)this.getModel()).reload();
            this.expandRow(offset + 0);
            this.expandRow(offset + 1);
        } else if (path != null) {
            rows = this.getRowForPath(path);
            this.expandPath(path);
            if (rows >= 0) {
                this.expandRow(offset + rows);
            }
        }
        this.checkSelection(isResync);
    }

    public synchronized int getFabricCount() {
        return this._san.getChildCount();
    }

    public synchronized void addGroup(UserDefinedGroup group) {
        int pos;
        DefaultMutableTreeNode groupsNode = this.getGroupsNode(group);
        if (group == null || groupsNode == null) {
            return;
        }
        int l = groupsNode.getChildCount();
        for (int i = 0; i < l; ++i) {
            DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)groupsNode.getChildAt(i);
            if (!groupNode.getUserObject().equals(group)) continue;
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        int size = groupsNode.getChildCount();
        String name = null;
        String gname = group.toString();
        for (pos = 0; pos < size; ++pos) {
            try {
                name = model.getChild(groupsNode, pos).toString();
            }
            catch (Exception ex) {
                continue;
            }
            if (name.compareTo(gname) > 0) break;
        }
        model.insertNodeInto(new DefaultMutableTreeNode(group), groupsNode, pos);
        ((UserDefinedGroupUnion)groupsNode.getUserObject()).addGroup(group);
    }

    public synchronized void updateGroup(UserDefinedGroup group) {
        if (group == null) {
            return;
        }
        MgmtDomainIf mgmtDomain = this.getSelectedDomain();
        if (mgmtDomain == null || !(mgmtDomain instanceof UserDefinedGroup)) {
            return;
        }
        if (group.getPK().equals(((UserDefinedGroup)mgmtDomain).getPK())) {
            TreePath[] paths = this.getSelectionPaths();
            this.selectTreePath(paths[0]);
        }
    }

    public synchronized DefaultMutableTreeNode getGroupsNode(UserDefinedGroup group) {
        Fabric fa = group.getFabric();
        VsanTopTreeNode fNode = this.getFabricNode(fa);
        if (fNode != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)fNode.getChildAt(this.getModel().getChildCount(fNode) - 1);
            return node;
        }
        return null;
    }

    public synchronized DefaultMutableTreeNode getGroupNode(UserDefinedGroup group) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode groupsNode = this.getGroupsNode(group);
        if (groupsNode == null) {
            return null;
        }
        int l = groupsNode.getChildCount();
        for (int i = 0; i < l; ++i) {
            DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)model.getChild(groupsNode, i);
            if (!groupNode.getUserObject().equals(group)) continue;
            return groupNode;
        }
        return null;
    }

    public synchronized DefaultMutableTreeNode removeGroup(UserDefinedGroup group) {
        if (group == null) {
            return null;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode groupNode = this.getGroupNode(group);
        if (groupNode != null) {
            ((UserDefinedGroupUnion)((DefaultMutableTreeNode)groupNode.getParent()).getUserObject()).removeGroup(group);
            model.removeNodeFromParent(groupNode);
            return groupNode;
        }
        return null;
    }

    public synchronized VsanTreeCommandNode getIvrZoneNode(Fabric fab, Wwn pwwn) {
        IvrVsanTreeNode ivrNode = this.getIVRNode(fab);
        if (ivrNode == null) {
            return null;
        }
        int ivrChildCount = ivrNode.getChildCount();
        for (int i = 0; i < ivrChildCount; ++i) {
            TreeNode ivrChildNode = ivrNode.getChildAt(i);
            if (!(ivrChildNode instanceof ZoneSetTreeNode)) continue;
            ZoneSetTreeNode zoneSetTreeNode = (ZoneSetTreeNode)ivrChildNode;
            int zoneSetChildCount = zoneSetTreeNode.getChildCount();
            for (int j = 0; j < zoneSetChildCount; ++j) {
                TreeNode zoneChildNode = zoneSetTreeNode.getChildAt(j);
                if (!(zoneChildNode instanceof ZoneTreeNode)) continue;
                ZoneTreeNode zoneTreeNode = (ZoneTreeNode)zoneChildNode;
                if (!this.zoneHasPwwn(zoneTreeNode._zone, pwwn)) continue;
                return zoneTreeNode;
            }
        }
        return null;
    }

    public synchronized VsanTreeCommandNode getZoneNode(VsanTreeNode vsanTreeNode, Vsan vsan, Wwn pwwn) {
        if (vsanTreeNode == null) {
            return null;
        }
        int vsanChildCount = vsanTreeNode.getChildCount();
        for (int i = 0; i < vsanChildCount; ++i) {
            TreeNode vsanChildNode = vsanTreeNode.getChildAt(i);
            if (vsanChildNode instanceof DefaultZoneTreeNode) {
                DefaultZoneTreeNode defaultZoneTreeNode = (DefaultZoneTreeNode)vsanChildNode;
                Vsan vsanTreeCommand = ((VsanTreeCommand)defaultZoneTreeNode.getUserObject())._vsan;
                if (!this.zoneHasPwwn(vsanTreeCommand.getEnforcedZones()[0], pwwn)) continue;
                return defaultZoneTreeNode;
            }
            if (!(vsanChildNode instanceof ZoneSetTreeNode)) continue;
            ZoneSetTreeNode zoneSetTreeNode = (ZoneSetTreeNode)vsanChildNode;
            int zoneSetChildCount = zoneSetTreeNode.getChildCount();
            for (int j = 0; j < zoneSetChildCount; ++j) {
                TreeNode zoneChildNode = zoneSetTreeNode.getChildAt(j);
                if (!(zoneChildNode instanceof ZoneTreeNode)) continue;
                ZoneTreeNode zoneTreeNode = (ZoneTreeNode)zoneChildNode;
                if (!this.zoneHasPwwn(zoneTreeNode._zone, pwwn)) continue;
                return zoneTreeNode;
            }
        }
        return null;
    }

    private boolean zoneHasPwwn(EnforcedZone eZone, Wwn pwwn) {
        if (eZone == null || pwwn == null) {
            return false;
        }
        Array zoneMembers = eZone.getMembers();
        EnforcedZoneMember zoneMember = null;
        for (int i = 0; i < zoneMembers.size(); ++i) {
            zoneMember = (EnforcedZoneMember)zoneMembers.elementAt(i);
            if (!zoneMember.equals(pwwn.getValue())) continue;
            return true;
        }
        return false;
    }

    public void selectIvrZoneNode(Wwn pwwn, VsanTreeCommandNode zoneNode, Component component) {
        if (component == null) {
            component = BrowserFrame.getInstance();
        }
        if (zoneNode == null) {
            Util.errorMessage(component, SnmpString.toHexString(pwwn.getValue()) + " not found in IVR zone.", false);
            return;
        }
        TreePath treePath = new TreePath(zoneNode.getPath());
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        String fullPWWN = pwwn.toString();
        int i = fullPWWN.lastIndexOf(32);
        if (i != -1) {
            BrowserFrame.getDataView()._table.clearSelection();
            BrowserFrame.getDataView()._table.find(true, fullPWWN.substring(i + 1), true, false, true);
        } else {
            BrowserFrame.getDataView()._table.clearSelection();
            BrowserFrame.getDataView()._table.find(true, fullPWWN, true, false, true);
        }
    }

    public void selectZoneNode(Wwn pwwn, VsanTreeCommandNode zoneNode, Component component) {
        if (component == null) {
            component = BrowserFrame.getInstance();
        }
        if (zoneNode == null) {
            Util.errorMessage(component, SnmpString.toHexString(pwwn.getValue()) + " not found in zone.", false);
            return;
        }
        TreePath treePath = new TreePath(zoneNode.getPath());
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
        String fullPWWN = pwwn.toString();
        int i = fullPWWN.lastIndexOf(32);
        if (i != -1) {
            BrowserFrame.getDataView()._table.clearSelection();
            BrowserFrame.getDataView()._table.find(true, fullPWWN.substring(i + 1), true, false, true);
        } else {
            BrowserFrame.getDataView()._table.clearSelection();
            BrowserFrame.getDataView()._table.find(true, fullPWWN, true, false, true);
        }
    }

    public synchronized void updateSan() {
        this.clearSan();
        this._san.removeAllChildren();
        Fabric[] fabrics = San.getInstance().getFabrics();
        if (fabrics != null) {
            for (int j = fabrics.length - 1; j >= 0; --j) {
                this.addFabric(fabrics[j], false);
            }
            this.expandRow(1);
            this.expandRow(0);
        }
        if ((fabrics == null || fabrics.length == 0) && this._datacenter.getIndex(this._san) != -1) {
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(this._san);
        }
    }

    public synchronized void updateLan() {
        this.clearLan();
        this._lan.removeAllChildren();
        if (ClientController.getInstance().showLan()) {
            Vlan[] vlans;
            if (this._datacenter.getIndex(this._lan) == -1) {
                ((DefaultTreeModel)this.getModel()).insertNodeInto(this._lan, this._datacenter, this._datacenter.getChildCount());
            }
            if ((vlans = Lan.getInstance().getVlans()) != null) {
                for (int i = 0; i < vlans.length; ++i) {
                    this.addVlan(vlans[i]);
                }
            }
            return;
        }
        if (this._datacenter.getIndex(this._lan) != -1) {
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(this._lan);
        }
    }

    synchronized void removeSan(San san) {
        DefaultMutableTreeNode sanNode;
        if (this._selectedMgmtDomain == san) {
            this._path = null;
            this._selectedMgmtDomain = null;
        }
        if ((sanNode = this.getSanNode(san)) != null) {
            sanNode.setUserObject(null);
        }
    }

    synchronized void removeFabric(Fabric fabric, final boolean isResync) {
        if (this._selectedMgmtDomain == fabric) {
            this._path = null;
            this._selectedMgmtDomain = null;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        VsanTopTreeNode fabricNode = this.getFabricNode(fabric);
        if (fabricNode != null) {
            try {
                this.removeNode(model, fabricNode);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!isResync && this._san.getChildCount() == 0 && this._datacenter.getIndex(this._san) != -1) {
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(this._san);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VsanTree.this.checkSelection(isResync);
            }
        });
    }

    public boolean pathExists(TreePath desiredPath) {
        if (desiredPath == null) {
            return false;
        }
        Object[] path = desiredPath.getPath();
        for (int i = 0; i < path.length; ++i) {
            System.out.println(i + " " + path[i]);
        }
        return false;
    }

    public void selectFirstFabric() {
        DefaultMutableTreeNode sanNode = this.getSanNode(null);
        if (sanNode != null && sanNode.getChildCount() > 0) {
            DefaultMutableTreeNode nextFabric = (DefaultMutableTreeNode)sanNode.getChildAt(0);
            TreePath treePath = new TreePath(nextFabric.getPath());
            this.getSelectionModel().setSelectionPath(treePath);
            Fabric fabric = this.getCurFabric(treePath);
            if (fabric != null) {
                BrowserFrame.getInstance().showFabricTab(fabric);
            }
        }
    }

    public void checkSelection(boolean isResync) {
        if (isResync && this.recordedContext != null) {
            DefaultLogger._DefLogger.debug((Object)"VsanTree.checkSelection");
            this.setContext(this.recordedContext);
        }
        TreePath path = this.getSelectionPath();
        DefaultMutableTreeNode sanNode = this.getSanNode(null);
        if (path == null) {
            if (sanNode.getChildCount() > 0) {
                DefaultMutableTreeNode nextFabric = (DefaultMutableTreeNode)sanNode.getChildAt(0);
                this.getSelectionModel().setSelectionPath(new TreePath(nextFabric.getPath()));
            } else {
                if (this._datacenter != null) {
                    this.getSelectionModel().setSelectionPath(new TreePath(this._datacenter.getPath()));
                    return;
                }
                this.getSelectionModel().setSelectionPath(new TreePath(sanNode.getPath()));
            }
        } else {
            Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (userObject != null && (userObject instanceof DataCenter || userObject instanceof Lan || userObject instanceof Vlan)) {
                this.selectTreePath(this.getSelectionPaths()[0]);
            }
        }
    }

    public void recordSelectionPath() {
        if (this.recordedContext == null) {
            this.recordedContext = new ClientContext();
        }
        this.recordedContext.clear();
        if (this._selectedMgmtDomain != null) {
            this.recordedContext.setLogicalDomainSelection(this._selectedMgmtDomain.getName());
        }
    }

    DefaultMutableTreeNode getSanNode(San san) {
        return this._san;
    }

    public Vsan getCurVsan() {
        return this.getCurVsan(this.getSelectionPath());
    }

    private MgmtDomainIf getSelectedMgmtDomain(TreePath path) {
        if (path == null) {
            return null;
        }
        while (path != null) {
            Object o = path.getLastPathComponent();
            Object u = ((DefaultMutableTreeNode)o).getUserObject();
            if (u instanceof MgmtDomainIf) {
                return (MgmtDomainIf)u;
            }
            if (o instanceof VsanTopTreeNode) {
                return ((VsanTopTreeNode)o).getFabric();
            }
            if (o instanceof VsanTreeNode) {
                return ((VsanTreeNode)o).getVsan();
            }
            if (o instanceof ZoneTreeNode) {
                return ((ZoneTreeNode)o)._zone;
            }
            if (o instanceof VlanTreeNode) {
                return ((VlanTreeNode)o).getVlan();
            }
            path = path.getParentPath();
        }
        return null;
    }

    private Fabric getCurFabric(TreePath path) {
        Object o;
        if (path != null && path.getPathCount() > 2 && (o = path.getPathComponent(2)) instanceof VsanTopTreeNode) {
            return ((VsanTopTreeNode)o).getFabric();
        }
        return null;
    }

    private Vsan getCurVsan(TreePath path) {
        while (path != null) {
            Object o = path.getLastPathComponent();
            if (o instanceof VsanTreeNode) {
                return ((VsanTreeNode)o).getVsan();
            }
            path = path.getParentPath();
        }
        return null;
    }

    private boolean isZoneMenuAvailable(Object lastCmp) {
        if (lastCmp != null) {
            return lastCmp instanceof IvrVsanTreeNode || lastCmp instanceof VsanTreeNode || lastCmp instanceof ZoneSetTreeNode || lastCmp instanceof ZoneTreeNode || lastCmp instanceof DefaultZoneTreeNode;
        }
        return false;
    }

    boolean showAddVsan(Object lastCmp) {
        if (lastCmp != null && lastCmp instanceof VsanTreeNode) {
            VsanTreeNode vsanNode = (VsanTreeNode)lastCmp;
            VsanTreeCommand tc = (VsanTreeCommand)vsanNode.getUserObject();
            short vsanId = tc._vsan.getId();
            Fabric fb = tc._vsan.getFabric();
            int switchLength = 0;
            if (fb != null && fb.getSwitches() != null) {
                switchLength = fb.getSwitches().length;
            }
            return switchLength > tc._vsan.getSnmpPeers(true).length && vsanId != 1;
        }
        return false;
    }

    boolean showCreateVsan(Object lastCmp) {
        TreeCommand tc;
        Object userObj;
        return lastCmp != null && (userObj = ((DefaultMutableTreeNode)lastCmp).getUserObject()) instanceof TreeCommand && (tc = (TreeCommand)userObj).toString().equals(ALL_VSANS);
    }

    public String getSelectedDomainPath() {
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        if (mgmtDomain != null) {
            return mgmtDomain.getPath('/');
        }
        return "";
    }

    private void invokeAddVsan() {
        BrowserFrame.getInstance();
        DataView dv = BrowserFrame.getDataView();
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObj = node.getUserObject();
        VsanTopTreeNode top = null;
        top = !(node.getParent() instanceof VsanTopTreeNode) ? (VsanTopTreeNode)node.getParent().getParent() : (VsanTopTreeNode)node.getParent();
        DefaultMutableTreeNode san = (DefaultMutableTreeNode)top.getParent();
        String title = this._san.toString() + san.toString() + "/" + top.toString() + "/" + node.toString() + "/Vsan Attributes";
        if (userObj instanceof TreeCommand) {
            dv._filter = null;
        }
        SmCommand.vsanTableOnly(dv, title, null, dv._filter, null, null);
        try {
            dv.insert();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        if (err != null && err.length() != 0 && !err.equals("")) {
            this._setErrMsg.addElement(err);
        }
    }

    boolean showDelVsan(Object lastCmp) {
        if (lastCmp == null || !(lastCmp instanceof VsanTreeNode)) {
            return false;
        }
        VsanTreeNode vsanNode = (VsanTreeNode)lastCmp;
        VsanTreeCommand tc = (VsanTreeCommand)vsanNode.getUserObject();
        return tc._vsan.getId() != 1;
    }

    private void invokeDelVsan() throws Exception {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return;
        }
        VsanTreeNode node = (VsanTreeNode)path.getLastPathComponent();
        VsanTreeCommand tc = (VsanTreeCommand)node.getUserObject();
        Vsan vsan = tc._vsan;
        short vsanId = vsan.getId();
        Integer oVsanId = new Integer(vsanId);
        Switch[] switches = vsan.getSwitches();
        HashMap vsans2PeersToBeDeleted = new HashMap();
        HashMap<SnmpPeer, SnmpPDU> pdus = new HashMap<SnmpPeer, SnmpPDU>();
        StringBuffer nullPeerStringBuffer = new StringBuffer();
        int nullPeerCount = 0;
        if (switches != null && switches.length > 0) {
            for (int i = 0; i < switches.length; ++i) {
                SnmpPeer peer = switches[i].getPeer();
                if (peer == null) {
                    ++nullPeerCount;
                    nullPeerStringBuffer.append("\n  ");
                    nullPeerStringBuffer.append(switches[i].getName());
                    continue;
                }
                Array<SnmpPeer> peers = new Array<SnmpPeer>();
                peers.addElement(peer);
                vsans2PeersToBeDeleted.put(oVsanId, peers);
                SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
                pdu.setAddress(peer.getAddress());
                pdus.put(peer, pdu);
                pdu.addVar(new SnmpOID(MibNode.get("vsanRowStatus").getOid(), (int)vsanId), new SnmpInt(6));
            }
        }
        if (nullPeerCount > 0 ? JOptionPane.showOptionDialog(BrowserFrame.getInstance(), "These switches are not logged in:" + nullPeerStringBuffer.toString() + "\nContinue deletion?", "DCNM-SAN", 0, 2, null, new String[]{"Yes", "No"}, "No") != 0 : DataView._ConfirmRowDeletion && JOptionPane.showOptionDialog(BrowserFrame.getInstance(), "Please confirm deletion", "DCNM-SAN", 0, 2, null, new String[]{"Yes", "No"}, "No") != 0) {
            return;
        }
        if (SmVsanTableModel.processVsanChange(vsans2PeersToBeDeleted, 1)) {
            SnmpAggregrate aggregrate = new SnmpAggregrate();
            this._setErrMsg.clear();
            int successfulSets = aggregrate.set(pdus.keySet().iterator(), pdus.values().iterator(), this);
            try {
                ClientController.getInstance().getFabric().rediscover();
            }
            catch (Exception ex) {
                Util.errorMessage((Component)BrowserFrame.getInstance(), ex);
            }
            if (successfulSets < pdus.size()) {
                int failedSets = pdus.size() - successfulSets;
                throw new Exception(this.postErrorMsg() + "\nFailed on " + failedSets + " of " + pdus.size() + " device(s).");
            }
            this.clearSelection();
            DefaultMutableTreeNode sibling = node.getPreviousSibling();
            if (sibling != null) {
                TreePath newPath = new TreePath(sibling.getPath());
                this.setSelectionPath(newPath);
            }
        }
    }

    public String postErrorMsg() throws Exception {
        if (this._setErrMsg.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._setErrMsg.size(); ++i) {
            sb.append(this._setErrMsg.elementAt(i));
            sb.append('\n');
            if (i != 50) continue;
            sb.append("...see log for details.\n");
            throw new SnmpException(sb.toString());
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return "";
    }

    public boolean isIvrNode(TreePath path) {
        if (path != null) {
            Object lastCmp = path.getLastPathComponent();
            while (lastCmp != null) {
                if (lastCmp instanceof IvrVsanTreeNode) {
                    return true;
                }
                lastCmp = ((DefaultMutableTreeNode)lastCmp).getParent();
            }
        }
        return false;
    }

    public void setRootString(String root) {
        this._san.setUserObject(root);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        MgmtDomainIf selectedDomain;
        SmMap map = BrowserFrame.getInstance().getSelectedMap();
        DefaultMutableTreeNode node = null;
        if (map == null) {
            return;
        }
        if (map.isDataCenterMap()) {
            node = this._datacenter;
        } else if (map.isLanMap()) {
            selectedDomain = this.getSelectedDomain();
            if (selectedDomain == null || !selectedDomain.isVlan()) {
                node = this._lan;
            }
        } else {
            selectedDomain = this.getSelectedDomain();
            Fabric f = map.getFabric();
            if (f == null) {
                if (selectedDomain == null || !selectedDomain.isSan()) {
                    node = this.getSanNode(null);
                }
            } else if (selectedDomain == null || selectedDomain.isSan() || selectedDomain.isDataCenter() || f != selectedDomain.getFabric()) {
                node = this.getFabricNode(f);
            }
        }
        if (node != null) {
            TreeSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    public void setContext(ClientContext context) {
        TreePath domainTreePath;
        if (context == null) {
            return;
        }
        String domainName = context.getLogicalDomainSelection();
        String fabricName = context.getFabricName();
        DefaultLogger._DefLogger.debug((Object)("VsanTree.setContext context.getLogicalDomainSelection()=" + context.getLogicalDomainSelection()));
        DefaultLogger._DefLogger.debug((Object)("VsanTree.setContext context.getFabricName()=" + context.getFabricName()));
        if (!(domainName != null && domainName.length() != 0 || fabricName != null && fabricName.length() != 0)) {
            return;
        }
        TreeSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel == null) {
            return;
        }
        TreePath fabricTreePath = null;
        DefaultMutableTreeNode fabricNode = null;
        if (fabricName != null && (fabricTreePath = this.getNextEqualsMatch(fabricName, null)) != null) {
            fabricNode = (DefaultMutableTreeNode)fabricTreePath.getLastPathComponent();
        }
        if (domainName != null && (domainTreePath = this.getNextEqualsMatch(domainName, fabricNode)) != null) {
            this.scrollPathToVisible(domainTreePath);
            this.getSelectionModel().setSelectionPath(domainTreePath);
            return;
        }
        if (fabricTreePath != null) {
            this.scrollPathToVisible(fabricTreePath);
            this.getSelectionModel().setSelectionPath(fabricTreePath);
        }
    }

    static {
        _SanVsanListener = new SanVsanListener();
        _LanVlanListener = new LanVlanListener();
        _Menus = new String[][]{{EDIT_REGULAR, "E"}, {DEACTIVATE_REGULAR, "D"}, {RECOVER_REGULAR, "C"}, {"Copy Full Topology...", "T"}, {"Add Switches to VSAN...", "A"}, {"Delete VSAN...", "R"}, {"Create VSAN...", "A"}};
        _GroupMenus = new String[][]{{"Edit...", "editGroup"}, {"Delete", "deleteGroup"}};
    }
}

