/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.logicaltree;

import com.cisco.dcbu.lib.ui.tree.DynamicTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.DefaultZoneTreeNode;
import com.cisco.dcbu.sm.client.logicaltree.VsanTreeCommand;
import com.cisco.dcbu.sm.client.logicaltree.ZoneSetTreeNode;
import com.cisco.dcbu.sm.client.model.Vsan;

class VsanTreeNode
extends DynamicTreeNode {
    public VsanTreeNode(VsanTreeCommand userObject) {
        super(userObject);
    }

    @Override
    public boolean loadChildren() {
        Vsan vsan = this.getVsan();
        String enforcedZnSt = vsan.getEnforcedZoneSetName();
        if (enforcedZnSt == null) {
            DefaultZoneTreeNode znNd = new DefaultZoneTreeNode(new VsanTreeCommand(vsan, null, "defaultZoneReport"));
            this.insert(znNd, 0);
        } else {
            ZoneSetTreeNode zs = new ZoneSetTreeNode(new VsanTreeCommand(vsan, null, "zonesetMemberReport"), vsan);
            this.insert(zs, 0);
        }
        VsanTreeCommand.load(this, vsan, 1);
        return false;
    }

    @Override
    public void setUserObject(Object userObject) {
        try {
            VsanTreeCommand vtc = (VsanTreeCommand)this.getUserObject();
            if (vtc != null) {
                vtc._vsan = null;
                vtc._method = null;
                vtc._label = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setUserObject(userObject);
    }

    public Vsan getVsan() {
        try {
            return ((VsanTreeCommand)this.getUserObject())._vsan;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String toString() {
        if (this.getVsan() == null) {
            return "";
        }
        return this.getVsan().toString();
    }
}

