/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.sm.client.map.DataCenterMapFactory;
import com.cisco.dcbu.sm.client.map.LanMapPropertyChangeListner;
import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.LayoutAction;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.DataCenter;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import java.beans.PropertyChangeEvent;

class DataCenterMapPropertyChangeListner
extends LanMapPropertyChangeListner {
    public DataCenterMapPropertyChangeListner(SmMap map) {
        super(map);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        block24: {
            super.propertyChange(event);
            String prop = event.getPropertyName();
            if (prop == null || prop.equals("")) {
                return;
            }
            Object obj = event.getSource();
            if (obj == null) {
                return;
            }
            if (obj instanceof DataCenter) {
                if (prop.equals("switchAdded")) {
                    this._map.setNeedLayout(true);
                    this._map.addSwitch((Switch)event.getNewValue());
                } else if (prop.equals("islAdded")) {
                    this._map.addIsl((Isl)event.getNewValue());
                } else if (prop.equals("npvLinkAdded")) {
                    this._map.addNpvLink((NpvLink)event.getNewValue());
                } else if (prop.equals("switchRemoved")) {
                    MapNode n = DataCenterMapFactory.getInstance().getNode((Switch)event.getOldValue());
                    if (n != null) {
                        this._map.removeNode(n);
                    }
                } else if (prop.equals("islRemoved")) {
                    MapLink l = this._map.getLink((Isl)event.getOldValue());
                    if (l != null) {
                        this._map.removeLink(l);
                    }
                } else if (prop.equals("npvLinkRemoved")) {
                    MapLink l = this._map.getLink((NpvLink)event.getOldValue());
                    if (l != null) {
                        this._map.removeLink(l);
                    }
                } else if (prop.equals("purge")) {
                    Fabric f = this._map.getFabric();
                    LayoutAction.getInstance().cancel();
                    this._map.store(null);
                    this._map.resetData();
                    DataCenter.getInstance().removePropertyChangeListener(this);
                    this._map.fabricDiscovered(f);
                }
            } else if (obj instanceof AbstractSwitch) {
                try {
                    MapNode n = DataCenterMapFactory.getInstance().getNode((AbstractSwitch)event.getSource());
                    if (n != null) {
                        n.update();
                    }
                }
                catch (Exception ex) {
                    if (!_Logger.isTraceEnabled()) break block24;
                    _Logger.trace((Object)"logEmptyCatch - switch update", (Throwable)ex);
                }
            }
        }
    }
}

