/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyLinkPainter;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.lib.ui.TitleMenuItem;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.MenuFactory;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.AttributesAction;
import com.cisco.dcbu.sm.client.map.actions.MapAction;
import com.cisco.dcbu.sm.client.model.AbstractLink;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.nm.esper.model.BaseObjectPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public abstract class MapLink
extends TopologyLink
implements ActionListener {
    protected JMenuItem[] _menuItems = null;
    private JPopupMenu _popup = null;
    private static HashMap _Popups = new HashMap();
    int _hashCode = 0;
    public static Logger _Logger = Logger.getLogger(MapLink.class);

    public MapLink(MapNode n1, MapNode n2, int id) {
        super(n1, n2);
        if (n1 == null) {
            throw new NullPointerException("MapLink() n1 == null");
        }
        if (n2 == null) {
            throw new NullPointerException("MapLink() n2 == null");
        }
        this.initMenus();
    }

    @Override
    public boolean isPresent() {
        AbstractModelObject obj = (AbstractModelObject)this.getModel();
        return obj == null ? false : obj.isPresent();
    }

    @Override
    public boolean hasMinorFault() {
        AbstractModelObject obj = (AbstractModelObject)this.getModel();
        return obj == null ? false : obj.isMinorAlarm();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapLink)) {
            return false;
        }
        MapLink otherLink = (MapLink)o;
        Object model = this.getModel();
        if (model == null || ((AbstractModelObject)model).getBaseModelObject() == null) {
            return false;
        }
        PKIf thisPK = ((AbstractModelObject)model).getPK();
        if (thisPK == null) {
            return false;
        }
        Object otherLinkModel = null;
        if (otherLink == null || (otherLinkModel = otherLink.getModel()) == null) {
            return false;
        }
        PKIf otherPK = ((AbstractModelObject)otherLinkModel).getPK();
        return thisPK.equals(otherPK);
    }

    @Override
    public JPopupMenu getPopup() {
        if (this._popup == null) {
            this.initMenus();
        }
        if (this._popup == null) {
            return null;
        }
        ArrayList links = ((TopologyGraph)this.getOwner()).getSelectedNodes();
        try {
            TitleMenuItem tmi = (TitleMenuItem)this._popup.getComponent(0);
            String title = this.getClassName();
            if (links.size() > 1) {
                title = title + "...";
            }
            tmi.setText(title);
        }
        catch (Exception e) {
            _Logger.trace((Object)"logEmptyCatch - setText", (Throwable)e);
        }
        block4: for (int i = 1; i < this._popup.getComponentCount(); ++i) {
            try {
                JMenuItem mi;
                ActionListener[] al;
                if (!(this._popup.getComponent(i) instanceof JMenuItem) || (al = (mi = (JMenuItem)this._popup.getComponent(i)).getActionListeners()) == null) continue;
                for (int j = 0; j < al.length; ++j) {
                    if (al[j] == null || !(al[j] instanceof MapAction)) continue;
                    ((MapAction)al[j]).validate(mi, (TopologyGraph)this.getOwner());
                    continue block4;
                }
                continue;
            }
            catch (Exception ex) {
                _Logger.trace((Object)"logEmptyCatch - validate", (Throwable)ex);
            }
        }
        return this._popup;
    }

    @Override
    public void setPopup(JPopupMenu popup) {
        this._popup = popup;
        if (this._popup == null) {
            _Popups.remove(this.getClass().getName());
        } else {
            _Popups.put(this.getClass().getName(), this._popup);
        }
        this._menuItems = null;
    }

    @Override
    public void actionDoubleClick() {
        AttributesAction.getInstance().actionPerformed(null);
    }

    @Override
    public int hashCode() {
        Object model;
        if (this._hashCode != 0) {
            return this._hashCode;
        }
        String s = this.toString();
        this._hashCode = s != null && s.length() > 0 ? s.hashCode() : ((model = this.getModel()) == null ? 0 : model.hashCode());
        return this._hashCode;
    }

    @Override
    public String toString() {
        Object model = this.getModel();
        if (model != null) {
            try {
                return model.toString();
            }
            catch (Exception ex) {
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
            }
        }
        if (this.getFromNode() != null && this.getToNode() != null) {
            return this.getFromNode().toString() + " <-> " + this.getToNode().toString();
        }
        return null;
    }

    public TopologyLinkPainter getRenderer() {
        return TopologyLinkPainter.getInstance();
    }

    public BaseObjectPainter getPainter() {
        TopologyLinkPainter r = this.getRenderer();
        if (r != null) {
            return r;
        }
        return super.getPainter();
    }

    public String getClassName() {
        return "";
    }

    public static JMenuItem[] getMenuItems(JMenuItem[] _menuItems) {
        if (_menuItems != null) {
            return _menuItems;
        }
        _menuItems = new JMenuItem[]{Util.createMenuItem("Interface Attributes", "interfaceAttributes", "Interface Attributes", AttributesAction.getInstance())};
        return _menuItems;
    }

    protected void initMenus() {
        if (this._popup != null) {
            return;
        }
        this._popup = (JPopupMenu)_Popups.get(this.getClass().getName());
        if (this._popup != null) {
            return;
        }
        JMenuItem[] mi = MenuFactory.getMenuItems(this, this._menuItems);
        if (mi == null || mi.length == 0) {
            return;
        }
        this._popup = new JPopupMenu();
        this._popup.add(new TitleMenuItem());
        Component previousVisible = null;
        for (int i = 0; i < mi.length; ++i) {
            if (mi[i] == null) {
                if (previousVisible == null || previousVisible instanceof JPopupMenu.Separator) continue;
                this._popup.addSeparator();
                previousVisible = this._popup.getComponent(this._popup.getComponentCount() - 1);
                continue;
            }
            this._popup.add(mi[i]);
            if (!mi[i].isVisible()) continue;
            previousVisible = mi[i];
        }
        if (previousVisible instanceof JPopupMenu.Separator) {
            previousVisible.setVisible(false);
        }
        _Popups.put(this.getClass().getName(), this._popup);
    }

    public boolean purge() throws Exception {
        return false;
    }

    public void update() {
        this.setFormattedTooltip(null);
        this._hashCode = 0;
    }

    @Override
    public int compareTo(Object l) {
        AbstractModelObject o2;
        if (this == l) {
            return 0;
        }
        if (l == null) {
            return 1;
        }
        AbstractModelObject o1 = (AbstractModelObject)this.getModel();
        if (o1 == (o2 = (AbstractModelObject)((MapLink)l).getModel())) {
            return 0;
        }
        if (o1 == null || o2 == null) {
            String s1 = this.toString();
            String s2 = ((MapLink)l).toString();
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }
        return o1.compare(o1, o2);
    }

    @Override
    public void destroy() {
        AbstractModelObject model = (AbstractModelObject)this.getModel();
        if (model != null) {
            model.setUserObject(null);
        }
        super.destroy();
    }

    @Override
    public String getTooltip() {
        AbstractModelObject model = (AbstractModelObject)this.getModel();
        if (model == null) {
            return null;
        }
        TopologyNode n1 = this.getFromNode();
        TopologyNode n2 = this.getToNode();
        if (n2.getIconCenterX() < n1.getIconCenterX() || n2.getIconCenterX() == n1.getIconCenterX() && n1.getIconCenterY() < n2.getIconCenterY()) {
            if (model instanceof AbstractLink) {
                return ((AbstractLink)model).getDetails(true);
            }
            if (model instanceof NpvLink) {
                return ((NpvLink)model).getDetails(true);
            }
            if (model instanceof Isl) {
                return ((Isl)model).getDetails(true);
            }
            if (model instanceof EndPort) {
                return ((EndPort)model).getDetails(true);
            }
        }
        return model.getDetails();
    }

    @Override
    public Color getStrokeColor() {
        if (this.isHighlighted() && !this.isSelected()) {
            return Color.lightGray;
        }
        Color strokeColor = super.getStrokeColor();
        Color mapBackgroundColor = SmMap.getBackgroundColor();
        if (mapBackgroundColor != null && mapBackgroundColor.equals(Color.BLACK)) {
            strokeColor = Color.WHITE;
        }
        return strokeColor;
    }

    public long getSpeed() {
        return 0L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }
}

