/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.ui.TitleMenuItem;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.UIControls;
import com.cisco.dcbu.sm.client.map.MapToolPanel;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.AlignMapAction;
import com.cisco.dcbu.sm.client.map.actions.CopyAction;
import com.cisco.dcbu.sm.client.map.actions.ExpandLoopMapAction;
import com.cisco.dcbu.sm.client.map.actions.ExpandMultipleLinksMapAction;
import com.cisco.dcbu.sm.client.map.actions.FixLocationMapAction;
import com.cisco.dcbu.sm.client.map.actions.HighlightAction;
import com.cisco.dcbu.sm.client.map.actions.LayoutAction;
import com.cisco.dcbu.sm.client.map.actions.MapAction;
import com.cisco.dcbu.sm.client.map.actions.MiscMapActions;
import com.cisco.dcbu.sm.client.map.actions.OverViewMapAction;
import com.cisco.dcbu.sm.client.map.actions.ShowEndDeviceLabelsMapAction;
import com.cisco.dcbu.sm.client.map.actions.ShowEndDevicesMapAction;
import com.cisco.dcbu.sm.client.map.actions.ShowNpvSwitchesMapAction;
import com.cisco.dcbu.sm.client.map.actions.ZoomMapAction;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class MapMenus {
    private static JPopupMenu _Popup = null;
    private static MapMenus _Instance = null;
    private static JButton _layoutButton = null;
    private static JButton _refreshButton = null;
    private static JButton _sanButton = null;
    private static JButton _showHideEndDevicesButton = null;
    private static JButton _dimHideVsanButton = null;
    private static JButton _showHideNpvSwitchesButton = null;
    public static Logger _Logger = Logger.getLogger(MapMenus.class);

    public static MapMenus getInstance() {
        if (_Instance == null) {
            _Instance = new MapMenus();
        }
        return _Instance;
    }

    public static JPanel getToolPanel() {
        MapToolPanel toolPanel = new MapToolPanel();
        JPanel tb = new JPanel(new GridLayout(11, 1, 0, 0));
        _sanButton = Util.createButton("icons/small_cloud.png", "Show Fabric Paths or All Paths or First Shortest Path", "sanMap", MiscMapActions.getInstance());
        tb.add(_sanButton);
        tb.add(Util.createButton("icons/view_list_16.gif", "Expand/Collapse Multiple Links", "expandMultipleLinks", ExpandMultipleLinksMapAction.getInstance()));
        _showHideEndDevicesButton = Util.createButton("icons/show_multiple.gif", "Show/Hide End Devices", "displayEndDevices", ShowEndDevicesMapAction.getInstance());
        tb.add(_showHideEndDevicesButton);
        _showHideNpvSwitchesButton = Util.createButton("icons/show_npv_switches.gif", "Show/Hide NPV Switches", "displayNpvSwitches", ShowNpvSwitchesMapAction.getInstance());
        tb.add(_showHideNpvSwitchesButton);
        _dimHideVsanButton = Util.createButton("icons/togglevsan.gif", "Dim/Hide Unselected VSAN Members", "vsanFilter", HighlightAction.getInstance());
        tb.add(_dimHideVsanButton);
        tb.add(Util.createButton("icons/new_topomap_16.gif", "Clear Map Highlighting", "clearAll", HighlightAction.getInstance()));
        tb.add(Util.createButton("icons/zoom_in16.gif", "Zoom In", "zoomIn", ZoomMapAction.getInstance()));
        tb.add(Util.createButton("icons/zoom_out16.gif", "Zoom Out", "zoomOut", ZoomMapAction.getInstance()));
        tb.add(Util.createButton("icons/zoom_normal16.gif", "Zoom To Fit", "zoomFit", ZoomMapAction.getInstance()));
        tb.add(Util.createButton("icons/window_topomap_16.gif", "Show/Hide OverView Window", "overView", OverViewMapAction.getInstance()));
        _layoutButton = Util.createButton("icons/Fabric_16-1.gif", "Layout Map", "layout", LayoutAction.getInstance());
        tb.add(_layoutButton);
        _refreshButton = Util.createButton("icons/Refresh16.gif", "Refresh Map", "refreshMap", MiscMapActions.getInstance());
        tb.add(_refreshButton);
        toolPanel.add(tb);
        toolPanel.setLayoutButton(_layoutButton);
        toolPanel.setSanButton(_sanButton);
        toolPanel.setRefreshButton(_refreshButton);
        toolPanel.setDimHideVsanButton(_dimHideVsanButton);
        toolPanel.setShowHideEndDevicesButton(_showHideEndDevicesButton);
        return toolPanel;
    }

    public static JPopupMenu getPopup() {
        JMenu menu = null;
        TitleMenuItem mi = null;
        _Popup = new JPopupMenu();
        mi = new TitleMenuItem("Fabric");
        _Popup.add(mi);
        mi.setFont(ChangedCellRenderer.getChangeFont());
        _Popup.add(Util.createMenuItem("Find...", "findDevice", MiscMapActions.getInstance()));
        _Popup.add(Util.createMenuItem("Copy", "copy", CopyAction.getInstance()));
        _Popup.addSeparator();
        menu = Util.createMenu("Layout");
        _Popup.add(menu);
        menu.addActionListener(LayoutAction.getInstance());
        menu.addMenuListener(new FabricLayoutMenuListener());
        menu.add(Util.createMenuItem("Cancel", "cancelLayout", LayoutAction.getInstance()));
        menu.addSeparator();
        menu.add(Util.createMenuItem("Spring", "springLayout", LayoutAction.getInstance()));
        menu.add(Util.createMenuItem("Quick", "quickLayout", LayoutAction.getInstance()));
        menu.addSeparator();
        menu.add(Util.createMenuItem("Fix All Nodes", "fixAll", FixLocationMapAction.getInstance()));
        menu.add(Util.createMenuItem("Unfix All Nodes", "unfixAll", FixLocationMapAction.getInstance()));
        menu.addSeparator();
        menu.add(Util.createMenuItem("Align Vertical", "alignVertical", AlignMapAction.getInstance()));
        menu.add(Util.createMenuItem("Align Horizontal", "alignHorizontal", AlignMapAction.getInstance()));
        menu.addSeparator();
        menu.add(Util.createMenuItem("Save Layout As...", "saveLayout", LayoutAction.getInstance()));
        menu.add(Util.createMenuItem("Delete Saved Layout...", "deleteLayout", LayoutAction.getInstance()));
        menu = Util.createMenu("Zoom");
        _Popup.add(menu);
        menu.add(Util.createMenuItem("Zoom &In", "zoomIn", ZoomMapAction.getInstance()));
        menu.add(Util.createMenuItem("Zoom &Out", "zoomOut", ZoomMapAction.getInstance()));
        menu.add(Util.createMenuItem("Zoom To &Fit", "zoomFit", ZoomMapAction.getInstance()));
        _Popup.addSeparator();
        _Popup.add(Util.createMenuItem("Purge Down Elements", "purgeFabric", "Purge Down Elements", MiscMapActions.getInstance()));
        _Popup.add(Util.createMenuItem("Authenticate Switches", "authenticateSwitches", "Authenticate Switches", MiscMapActions.getInstance()));
        if (_Popup.getComponent(_Popup.getComponentCount() - 1).isVisible()) {
            _Popup.addSeparator();
        }
        _Popup.add(Util.createMenuItem("Refresh", "refreshMap", MiscMapActions.getInstance()));
        _Popup.add(Util.createMenuItem("Print...", "print", MiscMapActions.getInstance()));
        _Popup.add(Util.createMenuItem("Save Image...", "save", MiscMapActions.getInstance()));
        _Popup.addSeparator();
        _Popup.add(Util.createCheckBoxMenuItem("Grid", "grid", MiscMapActions.getInstance()));
        _Popup.add(Util.createCheckBoxMenuItem("OverView Window", "overView", OverViewMapAction.getInstance()));
        _Popup.add(Util.createMenuItem("Legend...", "legend", MiscMapActions.getInstance()));
        _Popup.add(Util.createMenuItem("Filter...", "filter", MiscMapActions.getInstance()));
        _Popup.addSeparator();
        _Popup.add(Util.createCheckBoxMenuItem("Expand &Multiple Links", "expandMultipleLinks", ExpandMultipleLinksMapAction.getInstance()));
        _Popup.add(Util.createCheckBoxMenuItem("Expand Loops", "expandLoops", ExpandLoopMapAction.getInstance()));
        _Popup.add(Util.createCheckBoxMenuItem("Show &End Devices", "showEndDevices", ShowEndDevicesMapAction.getInstance()));
        _Popup.add(Util.createCheckBoxMenuItem("Show End Device &Labels", "showEndDeviceLabels", ShowEndDeviceLabelsMapAction.getInstance()));
        _Popup.add(Util.createCheckBoxMenuItem("Show NPV Switches", "showNpvSwitches", ShowNpvSwitchesMapAction.getInstance()));
        _Popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                for (int i = 1; i < _Popup.getComponentCount(); ++i) {
                    try {
                        if (!(_Popup.getComponent(i) instanceof JMenuItem)) continue;
                        JMenuItem mi = (JMenuItem)_Popup.getComponent(i);
                        ActionListener[] al = mi.getActionListeners();
                        if (al != null) {
                            for (int j = 0; j < al.length; ++j) {
                                if (al[j] == null || !(al[j] instanceof MapAction)) continue;
                                ((MapAction)al[j]).validate(mi, null);
                                break;
                            }
                        }
                        if (!(mi instanceof JMenu)) continue;
                        block6: for (int k = 0; k < ((JMenu)mi).getItemCount(); ++k) {
                            try {
                                JMenuItem m = ((JMenu)mi).getItem(k);
                                if (m == null || (al = m.getActionListeners()) == null) continue;
                                for (int j = 0; j < al.length; ++j) {
                                    if (al[j] == null || !(al[j] instanceof MapAction)) continue;
                                    ((MapAction)al[j]).validate(m, null);
                                    continue block6;
                                }
                                continue;
                            }
                            catch (Exception ex1) {
                                _Logger.trace((Object)"logEmptyCatch - for", (Throwable)ex1);
                            }
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
                    }
                }
            }
        });
        return _Popup;
    }

    public static void addLayoutMenus(JMenu m) {
        String[] properties = ClientController.getInstance().getLayouts();
        if (properties != null && properties.length > 0) {
            String layoutName = SmMap.getSelectedMap().getLayoutName();
            for (int i = 0; i < properties.length; ++i) {
                JCheckBoxMenuItem mi = Util.createCheckBoxMenuItem(properties[i], "namedLayout", UIControls.getInstance());
                m.add(mi);
                if (layoutName.equals(properties[i])) {
                    mi.setSelected(true);
                    continue;
                }
                mi.setSelected(false);
            }
        }
    }

    public static JButton getLayoutButton() {
        return _layoutButton;
    }

    public static JButton getRefreshButton() {
        return _refreshButton;
    }

    public static JButton getSanButton() {
        return _sanButton;
    }

    public static JButton getShowHideEndDevicesButton() {
        return _showHideEndDevicesButton;
    }

    public static JButton getDimHideVsanButton() {
        return _dimHideVsanButton;
    }

    static class FabricLayoutMenuListener
    implements MenuListener {
        FabricLayoutMenuListener() {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            JMenu m = (JMenu)e.getSource();
            String cmd = m.getText();
            if ("Layout".equals(cmd)) {
                try {
                    boolean doing = LayoutAction.getInstance().isLayoutRunning();
                    m.getItem(0).setEnabled(doing);
                    m.getItem(2).setEnabled(!doing);
                    m.getItem(3).setEnabled(!doing);
                    int count = m.getItemCount();
                    for (int i = count - 1; i >= 13; --i) {
                        m.remove(i);
                    }
                    MapMenus.addLayoutMenus(m);
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
                }
            }
        }
    }
}

