/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.map.DeviceNode;
import com.cisco.dcbu.sm.client.map.LoopLink;
import com.cisco.dcbu.sm.client.map.LoopNode;
import com.cisco.dcbu.sm.client.map.PlatformNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.AttributesAction;
import com.cisco.dcbu.sm.client.map.actions.DMMapAction;
import com.cisco.dcbu.sm.client.map.actions.ExpandMultipleLinksMapAction;
import com.cisco.dcbu.sm.client.map.actions.GroupAction;
import com.cisco.dcbu.sm.client.map.actions.ShowEndDevicesMapAction;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.nm.esper.model.Graph;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class SwitchNode
extends DeviceNode {
    private Logger _logger = Logger.getLogger(this.getClass());
    private static final String ICON_NAME = "switch.gif";
    private static final String KUBRICK_ICON_NAME = "Device_generic_3048_";
    boolean _checkEndNodeVisible = true;
    boolean _hasNoVisibleEndNodes = true;
    boolean _showISCSI = true;
    boolean _showTargets = true;
    boolean _showInitiators = true;
    public static final int HIDE_DOMAIN_ID = 0;
    public static final int SHOW_DOMAIN_ID_AS_HEX = 1;
    public static final int SHOW_DOMAIN_ID_AS_DECIMAL = 2;
    private static int _showDomainIdAs = 0;

    public SwitchNode(AbstractSwitch sw) {
        super(sw);
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    @Override
    public int getDefaultIconHeight() {
        if (SmMap.isClassUseKubrickIcons()) {
            return SwitchNode.getKubrickSize();
        }
        return 18;
    }

    @Override
    public String getKubrickIconName() {
        return KUBRICK_ICON_NAME;
    }

    @Override
    public int getDegree() {
        TopologyNode n;
        TopologyLink l;
        int count = 0;
        Iterator itr1 = this.inedges();
        while (itr1.hasNext()) {
            l = (TopologyLink)itr1.next();
            if (!l.isVisible()) continue;
            n = (TopologyNode)l.getTargetNode();
            if (n == this) {
                n = (TopologyNode)l.getSourceNode();
            }
            if (l instanceof LoopLink) {
                count += n.getDegree() - 1;
                continue;
            }
            ++count;
        }
        Iterator itr2 = this.outedges();
        while (itr2.hasNext()) {
            l = (TopologyLink)itr2.next();
            if (!l.isVisible()) continue;
            n = (TopologyNode)l.getSourceNode();
            if (n == this) {
                n = (TopologyNode)l.getTargetNode();
            }
            if (l instanceof LoopLink) {
                count += n.getDegree() - 1;
                continue;
            }
            ++count;
        }
        return count;
    }

    public int getVisibleEndNodeCount() {
        ArrayList list = this.getVisibleEndNodes(null);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public ArrayList getVisibleEndNodes(ArrayList nodeList) {
        TopologyLink l;
        TopologyNode other = null;
        if (nodeList == null) {
            nodeList = new HashedArrayList<TopologyNode>();
        }
        Iterator itr1 = this.inedges();
        while (itr1.hasNext()) {
            l = (TopologyLink)itr1.next();
            if (l.hasDummyLink() && !l.isDummyLink()) continue;
            other = (TopologyNode)l.getTargetNode();
            if (other == this) {
                other = (TopologyNode)l.getSourceNode();
            }
            if (!other.isSetVisible()) continue;
            if (other instanceof LoopNode && !((ArrayList)nodeList).contains(other)) {
                ((ArrayList)nodeList).add(other);
                if (!other.isExpanded()) continue;
                other.getNeighbors(nodeList);
                continue;
            }
            if (!(other instanceof PlatformNode) || ((ArrayList)nodeList).contains(other)) continue;
            ((ArrayList)nodeList).add(other);
        }
        Iterator itr2 = this.outedges();
        while (itr2.hasNext()) {
            l = (TopologyLink)itr2.next();
            if (l.hasDummyLink() && !l.isDummyLink()) continue;
            other = (TopologyNode)l.getSourceNode();
            if (other == this) {
                other = (TopologyNode)l.getTargetNode();
            }
            if (other == null) {
                ((SmMap)this.getOwner()).removeLink(l);
                continue;
            }
            if (!other.isSetVisible()) continue;
            if (other instanceof LoopNode && !((ArrayList)nodeList).contains(other)) {
                ((ArrayList)nodeList).add(other);
                if (!other.isExpanded()) continue;
                other.getNeighbors(nodeList);
                continue;
            }
            if (!(other instanceof PlatformNode) || ((ArrayList)nodeList).contains(other)) continue;
            ((ArrayList)nodeList).add(other);
        }
        ((ArrayList)nodeList).remove(this);
        return nodeList;
    }

    public boolean hasEndNode() {
        TopologyLink l;
        TopologyNode other = null;
        Iterator itr1 = this.inedges();
        while (itr1.hasNext()) {
            l = (TopologyLink)itr1.next();
            if (l.hasDummyLink() && !l.isDummyLink()) continue;
            other = (TopologyNode)l.getTargetNode();
            if (other == this) {
                other = (TopologyNode)l.getSourceNode();
            }
            if (!(other instanceof PlatformNode) && !(other instanceof LoopNode)) continue;
            return true;
        }
        Iterator itr2 = this.outedges();
        while (itr2.hasNext()) {
            l = (TopologyLink)itr2.next();
            if (l.hasDummyLink() && !l.isDummyLink()) continue;
            other = (TopologyNode)l.getSourceNode();
            if (other == this) {
                other = (TopologyNode)l.getTargetNode();
            }
            if (other == null) {
                ((SmMap)this.getOwner()).removeLink(l);
                continue;
            }
            if (!(other instanceof PlatformNode) && !(other instanceof LoopNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        Boolean visibility = TopologyNode.isCachedVisible(this);
        if (visibility != null) {
            return this.isVisibleByType(visibility);
        }
        boolean isVisible = super.isVisible();
        if (!isVisible && this.isDimmed()) {
            TopologyLink l;
            Iterator itr1 = this.inedges();
            while (itr1.hasNext()) {
                l = (TopologyLink)itr1.next();
                if (!(l.isDummyLink() ? !l.isDimmed() : l.isVisible())) continue;
                return this.isVisibleByType(TopologyNode.setCachedVisible(this, true));
            }
            Iterator itr2 = this.outedges();
            while (itr2.hasNext()) {
                l = (TopologyLink)itr2.next();
                if (!(l.isDummyLink() ? !l.isDimmed() : l.isVisible())) continue;
                return this.isVisibleByType(TopologyNode.setCachedVisible(this, true));
            }
        }
        return this.isVisibleByType(TopologyNode.setCachedVisible(this, isVisible));
    }

    boolean isVisibleByType(boolean isVisible) {
        try {
            if (!isVisible || this.getOwner() == null || this.getModel() == null) {
                return isVisible;
            }
            return !(this.getModel() instanceof Switch) || !((Switch)this.getModel()).isNpvEnabled() || ((SmMap)this.getOwner()).isDisplayNpvSwitches();
        }
        catch (Exception ex) {
            return isVisible;
        }
    }

    @Override
    public void setExpanded(boolean expand) {
        super.setExpanded(expand);
    }

    @Override
    public boolean isExpanded() {
        boolean isExpanded = super.isExpanded();
        if (isExpanded) {
            return true;
        }
        if (this._checkEndNodeVisible) {
            this._hasNoVisibleEndNodes = this.getVisibleEndNodeCount() == 0;
            this._checkEndNodeVisible = false;
        }
        return this._hasNoVisibleEndNodes;
    }

    private boolean isHiddenByFilters(TopologyNode topologyNode) {
        if (this.isFilterOn(-1L)) {
            return false;
        }
        if (topologyNode == null) {
            return false;
        }
        Object modelObject = topologyNode.getModel();
        if (modelObject == null) {
            return false;
        }
        if (modelObject instanceof Enclosure) {
            Enclosure e = (Enclosure)modelObject;
            boolean isTarget = e.isTarget();
            boolean isHost = !isTarget;
            boolean areAnyMembersVirtualized = e.areAnyMembersVirtualized();
            boolean areAnyMembersISCSI = e.areAnyMembersISCSI();
            if (isTarget && areAnyMembersVirtualized && !this.isFilterOn(128L)) {
                return true;
            }
            if (isHost && areAnyMembersVirtualized && !this.isFilterOn(256L)) {
                return true;
            }
            if (isTarget && areAnyMembersISCSI && !this.isFilterOn(32L)) {
                return true;
            }
            if (isHost && areAnyMembersISCSI && !this.isFilterOn(64L)) {
                return true;
            }
        } else if (modelObject instanceof EndPort) {
            EndPort e = (EndPort)modelObject;
            boolean isTarget = e.isTarget();
            boolean isInitiator = !isTarget;
            boolean isVirtualized = e.isVirtualized();
            boolean isISCSI = e.isISCSI();
            if (isTarget && isVirtualized && !this.isFilterOn(128L)) {
                return true;
            }
            if (isInitiator && isVirtualized && !this.isFilterOn(256L)) {
                return true;
            }
            if (isTarget && isISCSI && !this.isFilterOn(32L)) {
                return true;
            }
            if (isInitiator && isISCSI && !this.isFilterOn(64L)) {
                return true;
            }
            if (isTarget && !isVirtualized && !isISCSI && !this.isFilterOn(8L)) {
                return true;
            }
            if (isInitiator && !isVirtualized && !isISCSI && !this.isFilterOn(16L)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAnyHiddenEndNodes() {
        TopologyLink l;
        if (this.isFilterOn(-1L)) {
            return false;
        }
        TopologyNode other = null;
        Iterator itr1 = this.inedges();
        while (itr1.hasNext()) {
            l = (TopologyLink)itr1.next();
            if (l.hasDummyLink() && !l.isDummyLink()) continue;
            other = (TopologyNode)l.getTargetNode();
            if (other == this) {
                other = (TopologyNode)l.getSourceNode();
            }
            if (!this.isHiddenByFilters(other)) continue;
            return true;
        }
        Iterator itr2 = this.outedges();
        while (itr2.hasNext()) {
            l = (TopologyLink)itr2.next();
            if (l.hasDummyLink() && !l.isDummyLink()) continue;
            other = (TopologyNode)l.getSourceNode();
            if (other == this) {
                other = (TopologyNode)l.getTargetNode();
            }
            if (other == null) {
                ((SmMap)this.getOwner()).removeLink(l);
                continue;
            }
            if (!this.isHiddenByFilters(other)) continue;
            return true;
        }
        return false;
    }

    public boolean isDisplayISCSI() {
        return this._showISCSI;
    }

    public void setDisplayISCSI(boolean showISCSI) {
        this._showISCSI = showISCSI;
    }

    public boolean isDisplayTargets() {
        return this._showTargets;
    }

    public void setDisplayTargets(boolean showTargets) {
        this._showTargets = showTargets;
    }

    public boolean isDisplayInitiators() {
        return this._showInitiators;
    }

    public void setDisplayInitiators(boolean showInitiators) {
        this._showInitiators = showInitiators;
    }

    @Override
    public boolean purge() throws Exception {
        Switch sw = (Switch)this.getModel();
        if (sw == null) {
            return false;
        }
        Fabric fabric = sw.getFabric();
        if (fabric == null) {
            return false;
        }
        FabricPK fpk = fabric.getPK() == null ? null : (FabricPK)fabric.getPK();
        this._logger.info((Object)("SwitchNode purge() swPK=" + sw.getPK()));
        ClientController.getInstance().purgeSwitch(fpk, (WwnKey)sw.getPK());
        return true;
    }

    public static JMenuItem[] getMenuItems(JMenuItem[] _menuItems) {
        if (_menuItems != null) {
            return _menuItems;
        }
        JMenuItem[] mi = DeviceNode.getMenuItems(_menuItems);
        int number = 7;
        _menuItems = new JMenuItem[mi.length + number];
        int l = mi.length;
        try {
            System.arraycopy(mi, 0, _menuItems, 0, l);
        }
        catch (Exception e) {
            l = 0;
        }
        for (int i = 0; i < l; ++i) {
            JMenu menu;
            if (_menuItems[i] == null) continue;
            if (_menuItems[i].getText().equals("Device Attributes")) {
                menu = Util.createMenu("Switch Attributes");
                menu.addMenuListener(AttributesAction.getMapMenuListener());
                menu.add(Util.createMenuItem("System", "switchAttributes", "System", AttributesAction.getInstance()));
                menu.add(Util.createMenuItem("Physical", "switchPhysicalAttributes", "Physical", AttributesAction.getInstance()));
                _menuItems[i] = menu;
                continue;
            }
            if (!_menuItems[i].getText().equals("Interface Attributes")) continue;
            menu = Util.createMenu("Interface Attributes");
            menu.addMenuListener(AttributesAction.getMapMenuListener());
            menu.add(Util.createMenuItem("FC", "fcInterfaceAttributes", AttributesAction.getInstance()));
            menu.add(Util.createMenuItem("vFC", "vfcInterfaceAttributes", AttributesAction.getInstance()));
            menu.add(Util.createMenuItem("IPS", "ipInterfaceAttributes", AttributesAction.getInstance()));
            menu.add(Util.createMenuItem("Ethernet", "ethernetInterfaceAttributes", AttributesAction.getInstance()));
            _menuItems[i] = menu;
        }
        _menuItems[l++] = null;
        _menuItems[l++] = Util.createCheckBoxMenuItem("&Show End Devices", "showDevEndDevices", ShowEndDevicesMapAction.getInstance());
        _menuItems[l++] = Util.createCheckBoxMenuItem("&Expand Multiple Links", "expandMultipleLinks", ExpandMultipleLinksMapAction.getInstance());
        _menuItems[l++] = null;
        JMenu menu = Util.createMenu("Other");
        menu.addMenuListener(AttributesAction.getMapMenuListener());
        menu.add(Util.createMenuItem("Reauthenticate", "reauthenticate", DMMapAction.getInstance()));
        menu.add(Util.createMenuItem("View Running Config", "viewRunningConfig", DMMapAction.getInstance()));
        menu.add(Util.createMenuItem("View Startup Config", "viewStartupConfig", DMMapAction.getInstance()));
        menu.add(Util.createMenuItem("View Config Differences", "viewConfigDiffs", DMMapAction.getInstance()));
        menu.add(Util.createMenuItem("Reset", "reset", DMMapAction.getInstance()));
        _menuItems[l++] = menu;
        menu = Util.createMenu("Group", "Group", Util.PERSPECTIVE_FILTERABLE_TYPE);
        if (menu != null) {
            menu.addActionListener(GroupAction.getInstance());
            menu.add(Util.createMenuItem("Create Switch Group...", "createSwitchGroup", GroupAction.getInstance()));
            JMenu jm = Util.createMenu("Add To");
            menu.add(jm);
            jm.addMenuListener(GroupAction.getInstance());
            menu.addMenuListener(GroupAction.getInstance());
            menu.addMenuListener(AttributesAction.getMapMenuListener());
        }
        _menuItems[l++] = menu;
        return _menuItems;
    }

    public static JMenuItem[] getMenuItemsForTable(JMenuItem[] _menuItems) {
        if (_menuItems != null) {
            return _menuItems;
        }
        JMenuItem[] mi = DeviceNode.getMenuItemsForTable(_menuItems);
        int number = 4;
        _menuItems = new JMenuItem[mi.length + number];
        int l = mi.length;
        try {
            System.arraycopy(mi, 0, _menuItems, 0, l);
        }
        catch (Exception e) {
            l = 0;
        }
        for (int i = 0; i < l; ++i) {
            JMenu menu;
            if (_menuItems[i] == null) continue;
            if (_menuItems[i].getText().equals("Device Attributes")) {
                menu = Util.createMenu("Switch Attributes");
                menu.addMenuListener(AttributesAction.getMapMenuListener());
                menu.add(Util.createMenuItem("System", "switchAttributes", "System", AttributesAction.getInstance()));
                menu.add(Util.createMenuItem("Physical", "switchPhysicalAttributes", "Physical", AttributesAction.getInstance()));
                _menuItems[i] = menu;
                continue;
            }
            if (!_menuItems[i].getText().equals("Interface Attributes")) continue;
            menu = Util.createMenu("Interface Attributes");
            menu.addMenuListener(AttributesAction.getMapMenuListener());
            menu.add(Util.createMenuItem("FC", "fcInterfaceAttributes", AttributesAction.getInstance()));
            menu.add(Util.createMenuItem("vFC", "vfcInterfaceAttributes", AttributesAction.getInstance()));
            menu.add(Util.createMenuItem("IPS", "ipInterfaceAttributes", AttributesAction.getInstance()));
            menu.add(Util.createMenuItem("Ethernet", "ethernetInterfaceAttributes", AttributesAction.getInstance()));
            _menuItems[i] = menu;
        }
        _menuItems[l++] = null;
        JMenu menu = Util.createMenu("Other");
        menu.addMenuListener(AttributesAction.getMapMenuListener());
        menu.add(Util.createMenuItem("Reauthenticate", "reauthenticate", DMMapAction.getInstance()));
        menu.add(Util.createMenuItem("View Running Config", "viewRunningConfig", DMMapAction.getInstance()));
        menu.add(Util.createMenuItem("View Startup Config", "viewStartupConfig", DMMapAction.getInstance()));
        menu.add(Util.createMenuItem("View Config Differences", "viewConfigDiffs", DMMapAction.getInstance()));
        menu.add(Util.createMenuItem("Reset", "reset", DMMapAction.getInstance()));
        _menuItems[l++] = menu;
        menu = Util.createMenu("Group", "Group", Util.PERSPECTIVE_FILTERABLE_TYPE);
        if (menu != null) {
            menu.addActionListener(GroupAction.getInstance());
            menu.add(Util.createMenuItem("Create Switch Group...", "createSwitchGroup", GroupAction.getInstance()));
            JMenu jm = Util.createMenu("Add To");
            menu.add(jm);
            jm.addMenuListener(GroupAction.getInstance());
            menu.addMenuListener(GroupAction.getInstance());
            menu.addMenuListener(AttributesAction.getMapMenuListener());
        }
        _menuItems[l++] = menu;
        return _menuItems;
    }

    public void updateName(AbstractModelObject obj) {
        if (obj.isDestoryed()) {
            return;
        }
        this.setBold(false);
        int selectedVsanID = 0;
        String name = obj.getName();
        if (obj instanceof Switch) {
            Switch switchModel = (Switch)this.getModel();
            Graph owner = this.getOwner();
            if (owner != null && owner instanceof SmMap) {
                SmMap myMap = (SmMap)owner;
                selectedVsanID = myMap.getSelectedVsanID();
            }
            if (selectedVsanID >= 0) {
                short domainID = switchModel.getDomainId(selectedVsanID);
                Vsan vsan = switchModel.getVsan((short)selectedVsanID);
                VsanBase vsanBase = null;
                if (vsan != null) {
                    vsanBase = (VsanBase)vsan.getBaseModelObject();
                }
                if (domainID != 0 && vsan != null && vsanBase != null) {
                    if (!vsanBase.isDown()) {
                        if (_showDomainIdAs == 1) {
                            name = name + " (0x" + Integer.toHexString(domainID) + ")";
                        } else if (_showDomainIdAs == 2) {
                            name = name + " (" + domainID + ")";
                        }
                    }
                    WwnKey switchPK = switchModel.getSwitchPK();
                    if (vsan != null && vsan.getPrincipalSwitch() != null) {
                        WwnKey principalSwitchPK = vsan.getPrincipalSwitch().getSwitchPK();
                        if (switchPK != null && principalSwitchPK != null && switchPK.equals(principalSwitchPK)) {
                            this.setBold(true);
                        }
                    }
                }
            }
        }
        this.setFormattedTooltip(null);
        if (name != null && !name.equals(this.getNodeLabelString())) {
            this.nameChanged(this, name);
        }
    }

    @Override
    public void update() {
        AbstractModelObject obj = (AbstractModelObject)this.getModel();
        if (obj == null) {
            return;
        }
        this.updateName(obj);
        if (this._hashCode != 0) {
            this._prevHashCode = this._hashCode;
        }
        this._hashCode = 0;
    }

    public static int getDisplayDomainIdAs() {
        return _showDomainIdAs;
    }

    public static void setDisplayDomainIdAsD(int showDomainIdAs) {
        _showDomainIdAs = showDomainIdAs;
    }
}

