/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.map.common.MultipleLinkHandler;
import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.lib.map.common.TopologyNodePainter;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.map.ClutteredSwitchNode;
import com.cisco.dcbu.sm.client.map.LayoutServerIf;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import com.cisco.nm.esper.model.Transform;
import com.cisco.nm.esper.model.palette.NodeLabelPalette;
import com.cisco.nm.esper.model.palette.NodePalette;
import com.cisco.nm.esper.shape.Bounds;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxContainer;
import com.loox.jloox.LxGraph;
import com.loox.jloox.LxLayoutManager;
import com.loox.jloox.LxLink;
import com.loox.jloox.LxRectangle;
import com.loox.jloox.layout.LxHierarchicalLayout;
import com.loox.jloox.layout.LxSpringLayout;
import com.loox.jloox.layout.LxSpringNodeConstraints;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class TopologyLayoutServer
implements LayoutServerIf {
    private LxLayoutManager _layoutManager = null;
    private static LxSpringNodeConstraints _SpringNodeConstraints;
    private static int _layoutWidth;
    private static int _layoutHeight;
    public static Logger _Logger;

    public TopologyLayoutServer() {
        if (_SpringNodeConstraints == null) {
            _SpringNodeConstraints = new LxSpringNodeConstraints();
            _SpringNodeConstraints.setFixed(true);
            Thread initThread = new Thread("Init Layout Server Thread"){

                @Override
                public void run() {
                    new LxGraph();
                }
            };
            initThread.start();
        }
    }

    @Override
    public void setSize(int width, int height) {
        if (width > 1) {
            _layoutWidth = width;
        }
        if (height > 1) {
            _layoutHeight = height;
        }
    }

    @Override
    public void interrupt() {
        if (this._layoutManager != null) {
            // empty if block
        }
    }

    @Override
    public void layout(TopologyGraph graph, int divideDegree, boolean zero) throws Exception {
        this.layout(graph, true, divideDegree, zero);
    }

    public void layout(TopologyGraph graph, boolean useSizeParams, int divideDegree, boolean zero) throws Exception {
        this.layout(graph, useSizeParams, 0, 0, divideDegree, zero);
    }

    public void layout(TopologyGraph graph, boolean useSizeParams, int offX, int offY, int divideDegree, boolean zero) throws Exception {
        LxAbstractGraph lxgraph;
        try {
            if (graph == null || (graph.graphs() == null || graph.graphs().size() < 1) && (graph.nodes() == null || graph.nodes().size() < 1)) {
                return;
            }
        }
        catch (Exception ex) {
            _Logger.error((Object)("TopologyLayoutServer.layout() " + ex.getMessage()));
        }
        if (graph.graphs() != null && graph.graphs().size() > 0) {
            boolean subGraphSizeParams = useSizeParams;
            if (graph.graphs().size() != 1) {
                subGraphSizeParams = false;
            }
            ((LxSpringLayout)this._layoutManager).setSpecifyLayoutSize(false);
            for (TopologyGraph g : graph.graphs()) {
                if (!g.isExpanded() || !g.isVisible()) continue;
                this.layout(g, subGraphSizeParams, divideDegree, zero);
            }
        }
        if ((lxgraph = this.getServerGraph(graph, useSizeParams, divideDegree, zero)).getComponents() == null || lxgraph.getComponents().length > 600) {
            // empty if block
        }
        if (lxgraph == null || lxgraph.getComponents().length <= 1) {
            graph.compactBounds();
            return;
        }
        try {
            try {
                this._layoutManager.run();
            }
            catch (Exception e) {
                _Logger.error((Object)"logEmptyCatch", (Throwable)e);
            }
            this.copyGeometry(graph, lxgraph, offX, offY, useSizeParams);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.freeResources(lxgraph);
            this._layoutManager = null;
            lxgraph = null;
        }
    }

    public LxAbstractGraph getServerGraph(TopologyGraph graph, boolean useSizeParams, int divideDegree, boolean zero) throws Exception {
        LxGraph lxgraph = null;
        try {
            lxgraph = new LxGraph();
        }
        catch (Exception ex) {
            _Logger.error((Object)("TopologyLayoutServer.getServerGraph() " + ex.getMessage()));
            return null;
        }
        this._layoutManager = graph instanceof SmMap && ((SmMap)graph).isRestrictedTopology() ? this.init((LxAbstractGraph)lxgraph, _layoutWidth, _layoutHeight) : this.init((LxAbstractGraph)lxgraph, _layoutWidth, _layoutHeight);
        HashedArrayList<LxRectangle> roots = new HashedArrayList<LxRectangle>();
        LxComponent source = null;
        LxComponent target = null;
        LxLink lxedge = null;
        int sizex = _layoutWidth;
        int sizey = _layoutHeight;
        if (!useSizeParams) {
            sizex = ((graph.nodes() != null ? graph.nodes().size() : 0) + (graph.graphs() != null ? graph.graphs().size() : 0) * 5) * 25;
            if (sizex < 50) {
                sizex = 50;
            }
            if (sizex > 500) {
                sizex = 500;
            }
            sizey = sizex;
        }
        if (graph.graphs() != null && graph.graphs().size() > 0) {
            for (TopologyGraph g : graph.graphs()) {
                if (g == null || !g.isVisible()) continue;
                LxRectangle lxnode = new LxRectangle();
                lxnode.setUserData((Object)g);
                lxnode.setLocation(0.0, 0.0);
                Bounds b = g.getBounds();
                int width = (int)b.getWidth();
                int height = (int)b.getHeight();
                if (width < 0) {
                    width = 50;
                }
                if (width > sizex) {
                    width = sizex;
                }
                if (height < 0) {
                    height = 50;
                }
                if (height > sizey) {
                    height = sizey;
                }
                lxnode.setSize((double)width, (double)height);
                g.setUserObject(lxnode);
                lxgraph.add((LxComponent)lxnode);
                this._layoutManager.add((LxComponent)lxnode);
            }
        }
        if (graph.nodes() != null && graph.nodes().size() > 0) {
            Iterator nodeIter = graph.nodes().iterator();
            boolean fixed = false;
            int n = 16;
            if (useSizeParams) {
                n = (graph.nodes() != null ? graph.nodes().size() : 0) + (graph.graphs() != null ? graph.graphs().size() : 0) * 5;
                if ((n = sizex * sizey / 130 / n) > 32) {
                    n = 32;
                } else if (n < 4) {
                    n = 4;
                }
            }
            Point p = new Point(0, 0);
            if (divideDegree != 0) {
                HashedArrayList<ClutteredSwitchNode> clutteredNodes = new HashedArrayList<ClutteredSwitchNode>();
                ArrayList endNodes = null;
                while (nodeIter.hasNext()) {
                    TopologyNode node = (TopologyNode)nodeIter.next();
                    try {
                        if (!(node instanceof SwitchNode) || !node.isVisible() || (endNodes = ((SwitchNode)node).getVisibleEndNodes(null)).size() < divideDegree) continue;
                        ((ArrayList)clutteredNodes).add(new ClutteredSwitchNode(node, endNodes));
                    }
                    catch (Exception ex1) {
                        if (!_Logger.isTraceEnabled()) continue;
                        _Logger.trace((Object)ex1.getMessage(), (Throwable)ex1);
                    }
                }
                if (clutteredNodes.size() > 0) {
                    Object[] cNodes = clutteredNodes.toArray(new ClutteredSwitchNode[clutteredNodes.size()]);
                    Arrays.sort(cNodes);
                    for (int i = 0; i < cNodes.length; ++i) {
                        this.processComplexSwitchNode((LxAbstractGraph)lxgraph, this._layoutManager, ((ClutteredSwitchNode)cNodes[i])._switchNode, sizex, sizey, n, ((ClutteredSwitchNode)cNodes[i])._endNodes, zero);
                    }
                }
            }
            for (TopologyNode node : graph.nodes()) {
                if (node == null) continue;
                if (!node.isVisible()) {
                    if (!node.isLocationFixed()) {
                        node.setIconCenter(0.0, 0.0);
                    }
                    try {
                        TopologyNodePainter np = (TopologyNodePainter)node.getPainter();
                        if (n > np.getImageWidth()) {
                            n = np.getImageWidth();
                        }
                        node.setIconSize(n, n);
                    }
                    catch (Exception e) {
                        node.setIconSize(n * 3 / 4, n * 3 / 4);
                    }
                    continue;
                }
                if (node.getUserObject() != null) continue;
                LxRectangle lxnode = new LxRectangle();
                if (node.isRoot()) {
                    ((ArrayList)roots).add(lxnode);
                }
                lxnode.setUserData((Object)node);
                node.setUserObject(lxnode);
                p.y = 0;
                p.x = 0;
                if (node.isLocationFixed() || !zero) {
                    p.x = (int)node.getIconCenterX();
                    p.y = (int)node.getIconCenterY();
                }
                if (p.x == 0 && p.y == 0) {
                    fixed = false;
                    p.x = (int)(Math.random() * 1000.0) % sizex;
                    p.y = (int)(Math.random() * 1000.0) % sizey;
                } else {
                    fixed = true;
                }
                lxnode.setLocation((double)p.x, (double)p.y);
                lxnode.setSize((double)n, (double)n);
                lxgraph.add((LxComponent)lxnode);
                this._layoutManager.add((LxComponent)lxnode);
                if (!fixed) continue;
                ((LxSpringLayout)this._layoutManager).setNodeConstraints((LxComponent)lxnode, _SpringNodeConstraints);
            }
        }
        if (graph.edges() != null && graph.edges().size() > 0) {
            for (TopologyLink edge : graph.edges()) {
                if ((!edge.hasDummyLink() ? !edge.isVisible() : !edge.isDummyLink()) || edge.getUserObject() != null) continue;
                source = (LxComponent)edge.getSourceNode().getUserObject();
                target = (LxComponent)edge.getTargetNode().getUserObject();
                if (source == null || target == null) continue;
                lxedge = new LxLink(source.getHandle(0), target.getHandle(0));
                edge.setUserObject(lxedge);
                lxgraph.add((LxComponent)lxedge);
            }
        }
        if (roots == null || roots.size() <= 0 || !(graph instanceof SmMap) || ((SmMap)graph).isRestrictedTopology()) {
            // empty if block
        }
        return lxgraph;
    }

    private void processComplexSwitchNode(LxAbstractGraph graph, LxLayoutManager lm, TopologyNode nd, int sizex, int sizey, int n, ArrayList list, boolean zero) {
        TopologyLink l;
        if (list == null || list.size() == 0) {
            return;
        }
        double size = list.size() * n / 2;
        double factor = 2.0;
        try {
            factor = (double)((TopologyGraph)nd.getOwner()).nodes().size() / (double)list.size();
        }
        catch (Exception e) {
            DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
        }
        if (factor < 1.0) {
            factor = 1.0;
        }
        if (size > (double)(2 * sizex) / factor) {
            size = (double)(2 * sizex) / factor;
        }
        if (size > (double)(2 * sizey) / factor) {
            size = (double)(2 * sizey) / factor;
        }
        if (size < 80.0) {
            size = 80.0;
        }
        LxSpringLayout sp = new LxSpringLayout((LxContainer)graph, (Rectangle2D)new Rectangle2D.Double(Math.random() * (double)sizex, Math.random() * (double)sizey, size, size));
        sp.setAutoEdgeLength(true);
        sp.setEpsilon(0.002);
        sp.setUseObjectsSizes(true);
        boolean fixed = false;
        LxRectangle lxnode = new LxRectangle();
        lxnode.setUserData((Object)nd);
        nd.setUserObject(lxnode);
        Point p = new Point();
        p.y = 0;
        p.x = 0;
        if (nd.isLocationFixed() || !zero) {
            p.x = (int)nd.getIconCenterX();
            p.y = (int)nd.getIconCenterY();
        }
        if (p.x == 0 && p.y == 0) {
            fixed = false;
            p.x = (int)(Math.random() * 1000.0) % sizex;
            p.y = (int)(Math.random() * 1000.0) % sizey;
        } else {
            fixed = true;
        }
        lxnode.setLocation((double)p.x, (double)p.y);
        lxnode.setSize((double)n, (double)n);
        graph.add((LxComponent)lxnode);
        sp.add((LxComponent)lxnode);
        if (fixed) {
            sp.setNodeConstraints((LxComponent)lxnode, _SpringNodeConstraints);
        }
        for (int i = 0; i < list.size(); ++i) {
            try {
                TopologyNode node = (TopologyNode)list.get(i);
                if (node.getUserObject() != null || node instanceof SwitchNode) continue;
                lxnode = new LxRectangle();
                lxnode.setUserData((Object)node);
                node.setUserObject(lxnode);
                p.y = 0;
                p.x = 0;
                if (node.isLocationFixed() || !zero) {
                    p.x = (int)node.getIconCenterX();
                    p.y = (int)node.getIconCenterY();
                }
                if (p.x == 0 && p.y == 0) {
                    fixed = false;
                    p.x = (int)(Math.random() * 1000.0) % sizex;
                    p.y = (int)(Math.random() * 1000.0) % sizey;
                } else {
                    fixed = true;
                }
                lxnode.setLocation((double)p.x, (double)p.y);
                lxnode.setSize((double)n, (double)n);
                graph.add((LxComponent)lxnode);
                sp.add((LxComponent)lxnode);
                if (!fixed) continue;
                sp.setNodeConstraints((LxComponent)lxnode, _SpringNodeConstraints);
                continue;
            }
            catch (Exception e) {
                _Logger.error((Object)"logEmptyCatch", (Throwable)e);
            }
        }
        LxComponent source = null;
        LxComponent target = null;
        LxLink lxedge = null;
        Iterator itr1 = nd.inedges();
        while (itr1.hasNext()) {
            l = (TopologyLink)itr1.next();
            if (l.hasDummyLink() ? !l.isDummyLink() : !l.isVisible()) continue;
            source = (LxComponent)l.getSourceNode().getUserObject();
            target = (LxComponent)l.getTargetNode().getUserObject();
            if (source == null || target == null) continue;
            lxedge = new LxLink(source.getHandle(0), target.getHandle(0));
            l.setUserObject(lxedge);
            graph.add((LxComponent)lxedge);
        }
        Iterator itr2 = nd.outedges();
        while (itr2.hasNext()) {
            l = (TopologyLink)itr2.next();
            if (l.hasDummyLink() ? !l.isDummyLink() : !l.isVisible()) continue;
            source = (LxComponent)l.getSourceNode().getUserObject();
            target = (LxComponent)l.getTargetNode().getUserObject();
            if (source == null || target == null) continue;
            lxedge = new LxLink(source.getHandle(0), target.getHandle(0));
            l.setUserObject(lxedge);
            graph.add((LxComponent)lxedge);
        }
        sp.run();
        graph.add((LxComponent)sp);
        lm.add((LxComponent)sp);
    }

    private void copyGeometry(TopologyGraph graph, LxAbstractGraph lxgraph, int offX, int offY, boolean useSizeParams) {
        TopologyNodePainter np;
        Serializable node;
        LxComponent lxnode;
        int i;
        LxComponent[] comps = lxgraph.getComponents();
        int n = 0;
        if (useSizeParams) {
            block55: {
                n = (comps != null ? comps.length : (graph.nodes() != null ? graph.nodes().size() : 0)) + (graph.graphs() != null ? graph.graphs().size() : 0) * 5;
                try {
                    if (graph != null && ((SmMap)graph).getFabric() != null && ((SmMap)graph).getFabric().getSwitches() != null) {
                        n += ((SmMap)graph).getFabric().getSwitches().length;
                    }
                }
                catch (Exception ex1) {
                    if (!_Logger.isTraceEnabled()) break block55;
                    _Logger.trace((Object)("logEmptyCatch - getSwitches graph=" + graph.getText()), (Throwable)ex1);
                }
            }
            n = _layoutWidth * _layoutHeight / 130 / n;
            if (n > 32) {
                n = 32;
            } else if (n < 8) {
                n = 8;
            }
        } else {
            n = 16;
        }
        double x = 0.0;
        double y = 0.0;
        double sx = 1.0;
        double sy = 1.0;
        double l = 10000.0;
        double r = -10000.0;
        double b = -10000.0;
        double t = 10000.0;
        Transform ident = new Transform();
        Rectangle rect = null;
        int lw = 0;
        int rw = 0;
        int th = 0;
        int bh = 0;
        int maxW = 8;
        if (useSizeParams) {
            for (i = 0; i < comps.length; ++i) {
                try {
                    lxnode = comps[i];
                    if (lxnode instanceof LxLayoutManager || lxnode.getUserData() == null || !(lxnode.getUserData() instanceof TopologyNode)) continue;
                    node = (TopologyNode)lxnode.getUserData();
                    node.setUserObject(null);
                    rect = null;
                    x = lxnode.getX();
                    y = lxnode.getY();
                    if (x < l) {
                        l = x;
                        if (rect == null) {
                            rect = node.getPaintBounds(ident, rect);
                        }
                        lw = (int)rect.getWidth();
                    }
                    if (x > r) {
                        r = x;
                        if (rect == null) {
                            rect = node.getPaintBounds(ident, rect);
                        }
                        rw = (int)rect.getWidth();
                    }
                    if (y < t) {
                        t = y;
                        if (rect == null) {
                            rect = node.getPaintBounds(ident, rect);
                        }
                        th = (int)rect.getHeight();
                    }
                    if (y > b) {
                        b = y;
                        if (rect == null) {
                            rect = node.getPaintBounds(ident, rect);
                        }
                        bh = (int)rect.getHeight();
                    }
                    try {
                        np = (TopologyNodePainter)node.getPainter();
                        if (np.getImageWidth() <= maxW) continue;
                        maxW = np.getImageWidth();
                    }
                    catch (Exception e) {}
                    continue;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)"copyGeometry", (Throwable)ex);
                }
            }
            x = r - l;
            y = b - t;
            if (lw > 80) {
                lw = 80;
            }
            if (rw > 80) {
                rw = 80;
            }
            if (th > 80) {
                th = 80;
            }
            if (bh > 80) {
                bh = 80;
            }
            sx = (double)(_layoutWidth - lw / 2 - rw / 2) / x;
            sx = (double)((int)(1000.0 * sx)) / 1000.0;
            sy = (double)(_layoutHeight - th / 2 - bh / 2) / y;
            sy = (double)((int)(1000.0 * sy)) / 1000.0;
        } else {
            for (i = 0; i < comps.length; ++i) {
                lxnode = comps[i];
                if (lxnode instanceof LxLayoutManager || lxnode.getUserData() == null || !(lxnode.getUserData() instanceof TopologyNode)) continue;
                node = (TopologyNode)lxnode.getUserData();
                node.setUserObject(null);
                try {
                    np = (TopologyNodePainter)node.getPainter();
                    if (np.getImageWidth() <= maxW) continue;
                    maxW = np.getImageWidth();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        try {
            int fs = 11;
            if (n < 32) {
                fs = (n + 3) / 5 + 4;
            }
            Font font = new Font("sans-serif", 0, fs);
            NodePalette.INSTANCE.setFont(font);
            NodeLabelPalette.INSTANCE.setFont(font);
        }
        catch (Exception e) {
            _Logger.error((Object)"logEmptyCatch - setFont", (Throwable)e);
        }
        if (rect == null) {
            rect = new Rectangle(0, 0, 0, 0);
        } else {
            rect.setRect(0.0, 0.0, 0.0, 0.0);
        }
        for (int i2 = 0; i2 < comps.length; ++i2) {
            lxnode = comps[i2];
            if (lxnode.getUserData() instanceof TopologyNode) {
                block56: {
                    node = (TopologyNode)lxnode.getUserData();
                    if (node == null) continue;
                    x = (double)(lw / 2) + (lxnode.getX() - l) * sx;
                    y = (double)(th / 2) + (lxnode.getY() - t) * sy;
                    try {
                        np = (TopologyNodePainter)node.getPainter();
                        int nn = (n + 1) * np.getImageWidth() / maxW;
                        if (nn == 0) {
                            nn = n * 3 / 4;
                        } else if (nn < 8) {
                            nn = 8;
                        }
                        node.setIconSize(nn, nn);
                    }
                    catch (Exception e) {
                        try {
                            node.setIconSize(n * 3 / 4, n * 3 / 4);
                        }
                        catch (Exception ex) {
                            if (!_Logger.isTraceEnabled()) break block56;
                            _Logger.trace((Object)"logEmptyCatch - node.setIconSize()", (Throwable)ex);
                        }
                    }
                }
                if (!((TopologyNode)node).isLocationFixed()) {
                    try {
                        node.setIconCenter((double)((int)x + offX) + rect.getWidth() / 2.0, (double)((int)y + offY) + rect.getHeight() / 2.0);
                    }
                    catch (Exception e) {
                        if (_Logger.isTraceEnabled()) {
                            _Logger.trace((Object)"logEmptyCatch - node.setIconCenter()", (Throwable)e);
                        }
                    }
                }
            } else if (lxnode.getUserData() instanceof TopologyGraph) {
                node = (TopologyGraph)lxnode.getUserData();
                if (node == null) continue;
                node.setCenter(lxnode.getX() + lxnode.getWidth() / 2.0 + (double)offX, lxnode.getY() + lxnode.getHeight() / 2.0 + (double)offY);
            }
            lxnode.setUserData(null);
        }
        if (graph.edges() != null) {
            for (TopologyLink edge : graph.edges()) {
                Object o = edge.getUserObject();
                edge.setUserObject(null);
                if (o != null && o instanceof LxLink) {
                    try {
                        LxLink ll = (LxLink)o;
                        lxgraph.remove((LxComponent)ll);
                        ll.setHandles(null, null);
                    }
                    catch (Exception ex) {
                        _Logger.error((Object)"logEmptyCatch - link", (Throwable)ex);
                    }
                }
                if (!edge.isDummyLink() || edge.isVisible()) continue;
                MultipleLinkHandler.getInstance().handle(edge.getSourceNode(), edge.getTargetNode());
            }
        }
        graph.compactBounds();
    }

    private void freeResources(LxAbstractGraph lxgraph) {
        if (lxgraph != null) {
            if (this._layoutManager.getComponents() != null) {
                this._layoutManager.removeAll();
            }
            lxgraph.cleanUp();
        }
    }

    private LxLayoutManager init(LxAbstractGraph graph, double w, double h) {
        LxSpringLayout lm = new LxSpringLayout((LxContainer)graph, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, w, h));
        if (w > 1.0 && h > 1.0) {
            lm.setSpecifyLayoutSize(true);
        }
        lm.setAutoEdgeLength(true);
        lm.setEpsilon(0.002);
        lm.setUseObjectsSizes(true);
        return lm;
    }

    private LxLayoutManager initH(LxAbstractGraph graph, double w, double h) {
        LxHierarchicalLayout lm = new LxHierarchicalLayout((LxContainer)graph, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, w, h));
        lm.setDirection(2);
        lm.setAlignment(1);
        lm.setStraightenPaths(true);
        return lm;
    }

    static {
        _layoutWidth = 500;
        _layoutHeight = 500;
        _Logger = Logger.getLogger(TopologyLayoutServer.class);
    }
}

