/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.sm.client.map.FabricNode;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.SwitchNode;
import com.cisco.dcbu.sm.client.map.actions.LayoutAction;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class FilterTargetEndDevicesMapAction
extends MapActionAdapter {
    public static String displayTargets = "displayTargets";
    private static FilterTargetEndDevicesMapAction _Instance = null;
    public static Logger _Logger = Logger.getLogger(FilterTargetEndDevicesMapAction.class);

    public static FilterTargetEndDevicesMapAction getInstance() {
        if (_Instance == null) {
            _Instance = new FilterTargetEndDevicesMapAction();
        }
        return _Instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean show;
        ArrayList nodes;
        SmMap map;
        block19: {
            map = SmMap.getSelectedMap();
            nodes = map.getSelectedNodes();
            try {
                map.updateLayoutName();
            }
            catch (Exception ex1) {
                _Logger.trace((Object)"logEmptyCatch", (Throwable)ex1);
            }
            show = false;
            try {
                show = ((JCheckBoxMenuItem)e.getSource()).getState();
            }
            catch (ClassCastException cce) {
                if (nodes.size() != 0) {
                    try {
                        for (int i = 0; i < nodes.size(); ++i) {
                            TopologyNode topoNode = (TopologyNode)nodes.get(i);
                            if (topoNode == null || !(topoNode instanceof SwitchNode)) continue;
                            show = !((SwitchNode)topoNode).isDisplayTargets();
                        }
                    }
                    catch (Exception ex) {
                        show = true;
                        break block19;
                    }
                }
                if (map == null) {
                    show = !SmMap.isClassDisplayTargets();
                }
                Fabric f = map.getFabric();
                if (f != null) {
                    show = true;
                    Switch[] sws = f.getSwitches();
                    if (sws == null || sws.length <= 0) break block19;
                    for (int i = 0; i < sws.length; ++i) {
                        MapNode sn = MapFactory.getInstance().getNode(sws[i]);
                        SwitchNode switchNode = (SwitchNode)sn;
                        if (switchNode == null || !switchNode.isDisplayTargets() || !switchNode.isVisible() || switchNode.getVisibleEndNodeCount() <= 0) continue;
                        show = false;
                    }
                }
                show = !SmMap.isClassDisplayTargets();
            }
            catch (Exception ex) {
                boolean bl = show = !SmMap.isClassDisplayTargets();
            }
        }
        if (nodes.size() == 0) {
            SmMap.setClassDisplayTargets(show);
            if (map == null) {
                return;
            }
            if (show) {
                FilterTargetEndDevicesMapAction.showEndNodes(map);
                if (SmMap.isLayoutNewDevices()) {
                    LayoutAction.getInstance().layout(map);
                }
            } else {
                FilterTargetEndDevicesMapAction.hideEndNodes(map);
            }
            map.repaint(false);
            return;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            TopologyNode n = (TopologyNode)nodes.get(i);
            if (show) {
                FilterTargetEndDevicesMapAction.showEndNodes(n);
                if (!SmMap.isLayoutNewDevices()) continue;
                LayoutAction.getInstance().layout((SmMap)n.getParent());
                continue;
            }
            FilterTargetEndDevicesMapAction.hideEndNodes(n);
        }
        map.repaint(false);
    }

    public static void hideEndNodes(SmMap map) {
        if (map == null) {
            return;
        }
        TopologyNode n2 = null;
        for (TopologyNode n2 : map.nodes()) {
            if (n2 == null) continue;
            try {
                if (!(n2 instanceof SwitchNode)) continue;
                ((SwitchNode)n2).setDisplayTargets(false);
            }
            catch (Exception ex) {
                _Logger.error((Object)("ShowEndDevicesMapAction.hideEndNodes() " + ex.getMessage()));
            }
        }
        if (map.graphs() != null) {
            for (SmMap g : map.graphs()) {
                FilterTargetEndDevicesMapAction.hideEndNodes(g);
            }
        }
    }

    private static void hideEndNodes(TopologyNode node) {
        Object n = null;
        if (node == null && !(node instanceof SwitchNode) && !(n instanceof FabricNode)) {
            return;
        }
        if (node instanceof SwitchNode) {
            ((SwitchNode)node).setDisplayTargets(false);
        }
    }

    private static void showEndNodes(TopologyNode node) {
        if (node != null && node instanceof SwitchNode) {
            ((SwitchNode)node).setDisplayTargets(true);
        }
    }

    public static void showEndNodes(SmMap map) {
        TopologyNode n2 = null;
        if (map == null) {
            return;
        }
        Fabric fabric = map.getFabric();
        if (fabric == null) {
            for (TopologyNode n2 : map.nodes()) {
                if (n2 == null || !(n2 instanceof SwitchNode) && !(n2 instanceof FabricNode)) continue;
                FilterTargetEndDevicesMapAction.showEndNodes(n2);
            }
        } else {
            Switch[] sws = fabric.getSwitches();
            if (sws != null && sws.length > 0) {
                for (int i = 0; i < sws.length; ++i) {
                    MapNode sn = MapFactory.getInstance().getNode(sws[i]);
                    if (sn == null || !(sn instanceof SwitchNode) || !sn.isVisible()) continue;
                    FilterTargetEndDevicesMapAction.showEndNodes(sn);
                }
            }
        }
        if (map.graphs() != null) {
            for (SmMap g : map.graphs()) {
                FilterTargetEndDevicesMapAction.showEndNodes(g);
            }
        }
    }

    @Override
    public void validate(JMenuItem menuItem, TopologyGraph g) {
        SmMap map = g == null ? SmMap.getSelectedMap() : (SmMap)g;
        ArrayList nodes = map.getSelectedNodes();
        boolean enable = false;
        boolean state = false;
        if (nodes.size() == 0) {
            enable = true;
            state = SmMap.isClassDisplayTargets();
        } else {
            for (TopologyNode n : nodes) {
                if (!(n instanceof SwitchNode) && !(n instanceof FabricNode) || !SmMap.hasEndNodeNeighbors(n)) continue;
                enable = true;
                if (!(n instanceof SwitchNode) || !((SwitchNode)n).isDisplayTargets()) continue;
                state = true;
            }
        }
        menuItem.setEnabled(enable);
        if (enable) {
            ((JCheckBoxMenuItem)menuItem).setState(state);
        } else {
            ((JCheckBoxMenuItem)menuItem).setState(false);
        }
    }

    public static void displayEndDevices(boolean allMaps, boolean display) {
        if (allMaps) {
            SmMap[] maps;
            SmMap.setClassDisplayTargets(display);
            FilterTargetEndDevicesMapAction.displayEndDevices(SmMap.getInstance(), display);
            Object object = maps = allMaps ? MapFactory.getMaps() : null;
            if (maps != null && maps.length > 0) {
                for (int i = 0; i < maps.length; ++i) {
                    FilterTargetEndDevicesMapAction.displayEndDevices(maps[i], display);
                }
            }
        } else {
            FilterTargetEndDevicesMapAction.displayEndDevices(display);
        }
    }

    private static void displayEndDevices(boolean display) {
        SmMap map = SmMap.getSelectedMap();
        FilterTargetEndDevicesMapAction.displayEndDevices(map, display);
    }

    private static void displayEndDevices(SmMap map, boolean display) {
        if (display) {
            FilterTargetEndDevicesMapAction.showEndNodes(map);
        } else {
            FilterTargetEndDevicesMapAction.hideEndNodes(map);
        }
    }
}

