/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.map.DeviceNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.Device;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class LoginMapAction
extends MapActionAdapter {
    static final int TELNET_PORT = 23;
    static final int SSH_PORT = 22;
    private static LoginMapAction _Instance = null;
    public static Logger _Logger = Logger.getLogger(LoginMapAction.class);

    public static LoginMapAction getInstance() {
        if (_Instance == null) {
            _Instance = new LoginMapAction();
        }
        return _Instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cli();
    }

    public void cli() {
        SmMap map = SmMap.getSelectedMap();
        ArrayList nodes = map.getSelectedNodes();
        boolean success = false;
        StringBuffer errorMsg = new StringBuffer();
        for (int i = 0; i < nodes.size(); ++i) {
            TopologyNode n = (TopologyNode)nodes.get(i);
            if (n == null || !(n instanceof DeviceNode)) continue;
            Device dev = (Device)n.getModel();
            boolean mds = false;
            if (dev == null || dev.getIpAddress() == null) continue;
            try {
                boolean useSSH;
                boolean sshEnabledOnSwitch;
                boolean telnetEnabledOnSwitch;
                if (dev instanceof Switch) {
                    mds = ((Switch)dev).isMDS();
                }
                if (mds) {
                    Switch sw = (Switch)dev;
                    telnetEnabledOnSwitch = sw.isTelnetEnabled();
                    sshEnabledOnSwitch = sw.isSSHEnabled();
                    useSSH = ExternalTools._UseSSH;
                    if (!sshEnabledOnSwitch && !telnetEnabledOnSwitch) {
                        Util.errorMessage((Component)BrowserFrame.getInstance(), "Please enable SSH or Telnet on " + dev.getIpAddress());
                        return;
                    }
                    if (sshEnabledOnSwitch) {
                        useSSH = true;
                    } else if (telnetEnabledOnSwitch) {
                        useSSH = false;
                    }
                    if (sw.isLocallyManageable()) {
                        SnmpPeer peer = sw.getPeer();
                        ExternalTools.cli(dev.getIpAddress(), peer.getAddress().getHostAddress(), peer.isV3() ? peer.getUserName() : null, useSSH);
                    } else {
                        Fabric fabric = ((Switch)dev).getFabric();
                        SnmpUserOpt snmpUserOpt = fabric.getSnmpUserOpt();
                        String snmpUsername = snmpUserOpt.isV3() ? snmpUserOpt.getUsername() : null;
                        ExternalTools.cli(dev.getIpAddress(), dev.getIpAddress(), snmpUsername, useSSH);
                    }
                } else if (dev instanceof AbstractSwitch) {
                    AbstractSwitch abstractSwitch = (AbstractSwitch)((Object)dev);
                    telnetEnabledOnSwitch = abstractSwitch.isTelnetEnabled();
                    sshEnabledOnSwitch = abstractSwitch.isSSHEnabled();
                    useSSH = ExternalTools._UseSSH;
                    if (!sshEnabledOnSwitch && !telnetEnabledOnSwitch) {
                        Util.errorMessage((Component)BrowserFrame.getInstance(), "Please enable SSH or Telnet on " + dev.getIpAddress());
                        return;
                    }
                    if (sshEnabledOnSwitch) {
                        useSSH = true;
                    } else if (telnetEnabledOnSwitch) {
                        useSSH = false;
                    }
                    ExternalTools.cli(dev.getIpAddress(), useSSH);
                } else if (LoginMapAction.isPortEnabled(dev.getIpAddress(), 22)) {
                    ExternalTools.cli(dev.getIpAddress(), true);
                } else if (LoginMapAction.isPortEnabled(dev.getIpAddress(), 23)) {
                    ExternalTools.cli(dev.getIpAddress(), false);
                }
                success = true;
                continue;
            }
            catch (Exception ex) {
                errorMsg.append("Exception while trying to talk to " + dev.getIpAddress() + " message: " + ex.getMessage());
                if (!SnmpSession.isTrace()) continue;
                _Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        if (!success) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), errorMsg.length() > 0 ? errorMsg.toString() : "Please select a device with IP address");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortEnabled(String host, int port) {
        InputStream in = null;
        OutputStream out = null;
        Socket socket = null;
        boolean compatible = true;
        try {
            socket = new Socket(host, port);
            in = socket.getInputStream();
            out = socket.getOutputStream();
        }
        catch (Exception e) {
            compatible = false;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex) {}
        }
        return compatible;
    }

    @Override
    public void validate(JMenuItem menuitem, TopologyGraph g) {
        if (g == null) {
            g = SmMap.getSelectedMap();
        }
        ArrayList nodes = g.getSelectedNodes();
        boolean valid = false;
        boolean exists = false;
        for (int i = 0; i < nodes.size(); ++i) {
            try {
                Device dev;
                TopologyNode n = (TopologyNode)nodes.get(i);
                if (!(n.getModel() instanceof Device) || (dev = (Device)n.getModel()) == null) continue;
                exists = true;
                if (dev.getIpAddress() == null) continue;
                valid = true;
                continue;
            }
            catch (Exception e) {
                _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
            }
        }
        menuitem.setEnabled(valid && exists);
    }
}

