/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.dcbu.sm.client.map.DataCenterMapFactory;
import com.cisco.dcbu.sm.client.map.LanMapFactory;
import com.cisco.dcbu.sm.client.map.LoopNode;
import com.cisco.dcbu.sm.client.map.MapFactory;
import com.cisco.dcbu.sm.client.map.PlatformNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.dcbu.sm.client.model.AbstractLink;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.nm.esper.GraphComponent;
import com.cisco.nm.esper.model.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SelectionAction
extends MapActionAdapter {
    private static SelectionAction _Instance = null;
    private TopologyGraph _graph = null;
    private Logger _logger = Logger.getLogger(this.getClass());
    private boolean _clearMapBeforeExecute = true;

    public static SelectionAction getSharedInstance() {
        return SelectionAction.getInstance();
    }

    public static SelectionAction getInstance() {
        if (_Instance == null) {
            _Instance = new SelectionAction();
        }
        return _Instance;
    }

    public static Collection getSelectedNodes() {
        return SmMap.getSelectedMap().getSelectedNodes();
    }

    public static Collection getSelectedLinks() {
        return SmMap.getSelectedMap().getSelectedLinks();
    }

    public void clearSelection() {
        TopologyGraph g = this._graph;
        if (g == null) {
            g = SmMap.getSelectedMap();
        }
        g.clearSelection();
    }

    public static void selectNode(TopologyNode node, GraphComponent gc) {
        if (node == null) {
            return;
        }
        if (!node.isVisible()) {
            node.setSelected(true);
            ArrayList list = node.getNeighbors(null);
            for (int i = 0; i < list.size(); ++i) {
                TopologyNode n = (TopologyNode)list.get(i);
                if (!(n instanceof LoopNode) || n.isExpanded()) continue;
                n.setSelected(true);
            }
        } else {
            node.setSelected(true);
            gc.makeVisible(node.getIconCenterX() - 10.0, node.getIconCenterY() - 30.0, false);
            gc.makeVisible(node.getIconCenterX() + 10.0, node.getIconCenterY() + 10.0, false);
        }
    }

    @Override
    public void execute() {
        Collection links;
        Collection nodes = this.getNodes();
        SmMap g = SmMap.getSelectedMap();
        if (g == null) {
            g = SmMap.getInstance();
        }
        GraphComponent gc = g.getGraphComponent();
        TopologyNode n = null;
        TopologyLink l = null;
        if (this.isClearMapBeforeExecute()) {
            SmMap.ClearSelection();
        }
        if (nodes != null && nodes.size() > 0) {
            Iterator itr = nodes.iterator();
            while (itr.hasNext()) {
                try {
                    Object obj = itr.next();
                    Fabric fabric = null;
                    if (obj instanceof TopologyNode) {
                        n = (TopologyNode)obj;
                    } else if (obj instanceof AbstractSwitch) {
                        fabric = ((AbstractSwitch)obj).getFabric();
                        if (g.isDataCenterMap()) {
                            n = DataCenterMapFactory.getInstance().getNode((AbstractModelObject)obj);
                        } else if (g.isLanMap()) {
                            n = LanMapFactory.getInstance().getNode((AbstractModelObject)obj);
                        } else {
                            if (g.isSanMap() && (obj = San.getInstance().findSwitchByPKInRestrictedTopology(((AbstractSwitch)obj).getPK())) == null) continue;
                            n = MapFactory.getInstance().getNode((AbstractModelObject)obj);
                        }
                    } else if (obj instanceof Enclosure) {
                        fabric = g.getFabric();
                        n = g.getEnclosureNode((Enclosure)obj);
                    } else {
                        if (!(obj instanceof EndPort)) continue;
                        EndPort ep = (EndPort)obj;
                        if (ep.getEnclosure() != null) {
                            n = MapFactory.getInstance().getNode(ep);
                            l = g.getLink((EndPort)obj, true);
                            if (l != null) {
                                l.setSelected(true);
                                if (g.isSanMap()) {
                                    Node sourceNode = l.getSourceNode();
                                    Node targetNode = l.getTargetNode();
                                    if (sourceNode instanceof PlatformNode) {
                                        sourceNode.setSelected(true);
                                    } else if (targetNode instanceof PlatformNode) {
                                        targetNode.setSelected(true);
                                    }
                                }
                            }
                        } else {
                            n = MapFactory.getInstance().getNode(ep);
                        }
                    }
                    SelectionAction.selectNode(n, gc);
                }
                catch (Exception e) {
                    this._logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if ((links = this.getLinks()) != null && links.size() > 0) {
            Iterator itr = links.iterator();
            while (itr.hasNext()) {
                try {
                    Object obj = itr.next();
                    if (obj instanceof TopologyLink) {
                        l = (TopologyLink)obj;
                    } else if (obj instanceof AbstractLink) {
                        if (g.isDataCenterMap()) {
                            l = DataCenterMapFactory.getInstance().getLink((AbstractLink)obj);
                        } else if (g.isLanMap()) {
                            l = LanMapFactory.getInstance().getLink((AbstractLink)obj);
                        } else if (obj instanceof NpvLink) {
                            if (g.isSanMap()) {
                                NpvLink npvLink = (NpvLink)obj;
                                NpvLinkBase npvLinkBase = (NpvLinkBase)npvLink.getBaseModelObject();
                                npvLinkBase.getNpPortPK();
                                obj = San.getInstance().findNpvLinkByFportKey(npvLinkBase.getNpPortPK());
                                if (obj == null) continue;
                                l = (TopologyLink)((NpvLink)obj).getUserObject();
                            } else {
                                l = MapFactory.getInstance().getLink((NpvLink)obj);
                            }
                        } else if (obj instanceof Isl) {
                            if (g.isSanMap()) {
                                Isl isl = (Isl)obj;
                                IslBase islBase = (IslBase)isl.getBaseModelObject();
                                IslPK islPK = islBase.getIslPK();
                                obj = San.getInstance().findIslBySwitchIntKey(islPK.getSwitchIntKey1(), true);
                                if (obj == null) continue;
                                l = (TopologyLink)((Isl)obj).getUserObject();
                            } else {
                                l = MapFactory.getInstance().getLink((Isl)obj);
                            }
                        }
                    } else {
                        if (!(obj instanceof EndPort)) continue;
                        g = MapFactory.getInstance().getMap(((EndPort)obj).getFabric());
                        l = g.getLink((EndPort)obj, true);
                    }
                    if (l != null) {
                        g = (SmMap)l.getParent();
                        gc = g.getGraphComponent();
                    }
                    if (l == null) continue;
                    l.setSelected(true);
                }
                catch (Exception e) {
                    this._logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        g.repaint();
    }

    public void setGraph(TopologyGraph g) {
        this._graph = g;
    }

    public TopologyGraph getGraph() {
        return this._graph;
    }

    public boolean isClearMapBeforeExecute() {
        return this._clearMapBeforeExecute;
    }

    public void setClearMapBeforeExecute(boolean clearMapBeforeExecute) {
        this._clearMapBeforeExecute = clearMapBeforeExecute;
    }
}

