/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.sm.client.map.MapLink;
import com.cisco.dcbu.sm.client.map.MapNode;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.dcbu.sm.client.model.EthIsl;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Vlan;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class VlanHighlightAction
extends MapActionAdapter {
    public static Logger _Logger = Logger.getLogger(VlanHighlightAction.class);
    private static VlanHighlightAction _Instance = null;
    private Vlan _vlan = null;

    public static VlanHighlightAction getSharedInstance() {
        return VlanHighlightAction.getInstance();
    }

    public static VlanHighlightAction getInstance() {
        if (_Instance == null) {
            _Instance = new VlanHighlightAction();
        }
        return _Instance;
    }

    public void clear() {
        SmMap map = SmMap.getInstance(2);
        if (map == null) {
            return;
        }
        map.setDimmed(false);
        map.updateBounds();
    }

    @Override
    public void execute() {
        if (this._vlan == null) {
            return;
        }
        SmMap g = SmMap.getInstance(2);
        if (g == null) {
            return;
        }
        g.setDimmed(true);
        this.execute(g);
        g.repaint();
    }

    private void execute(SmMap g) {
        ArrayList<EthIsl> isls;
        if (this._vlan == null) {
            return;
        }
        EthSwitch[] sws = this._vlan.getEthSwitches();
        if (sws != null && sws.length > 0) {
            for (int i = 0; i < sws.length; ++i) {
                try {
                    MapNode n = g.getNode(sws[i]);
                    if (n == null) continue;
                    n.setDimmed(false);
                    continue;
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - Switches", (Throwable)ex);
                }
            }
        }
        if ((isls = this._vlan.getEthIsls(null)) != null && isls.size() > 0) {
            for (int i = 0; i < isls.size(); ++i) {
                try {
                    MapLink l = g.getLink(isls.get(i));
                    if (l == null) continue;
                    l.setDimmed(false);
                    continue;
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - Isls", (Throwable)ex);
                }
            }
        }
        if (g.graphs() != null) {
            for (SmMap tg : g.graphs()) {
                this.execute(tg);
            }
        }
        g.updateBounds();
    }

    public void setVlan(Vlan vlan) {
        this._vlan = vlan;
    }

    public Vlan getVlan() {
        return this._vlan;
    }
}

