/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.map.actions;

import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.UIActions;
import com.cisco.dcbu.sm.client.map.EdgeMapLink;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.map.actions.MapActionAdapter;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneDialog;
import com.cisco.dcbu.sm.client.zm.zonewizard.ZoneMemWizard;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.ws.rs.GET;
import org.apache.log4j.Logger;

public class ZoneAction
extends MapActionAdapter {
    private static ZoneAction _Instance = null;
    public static Logger _Logger = Logger.getLogger(ZoneAction.class);

    public static ZoneAction getInstance() {
        if (_Instance == null) {
            _Instance = new ZoneAction();
        }
        return _Instance;
    }

    @Override
    @GET
    public void actionPerformed(ActionEvent e) {
        try {
            HashedArrayList selPorts = new HashedArrayList();
            Array vsanList = new Array();
            ZoneMemWizard.getSelectedPortsAndVsans(selPorts, vsanList);
            if (vsanList.size() > 1) {
                ZoneMemWizard.launchIvrWizard(BrowserFrame.getInstance(), ((Vsan)vsanList.elementAt(0)).getFabric(), selPorts, vsanList);
            } else {
                Vsan v = (Vsan)vsanList.elementAt(0);
                Object ob = ZoneDialog.launchNewZoneDialog(BrowserFrame.getInstance(), selPorts, v);
                if (ob != null && ob instanceof String) {
                    if (((String)ob).length() == 0) {
                        Util.errorMessage((Component)BrowserFrame.getInstance(), "Please specify valid zone name.");
                        return;
                    }
                    ZoneDialog dlg = UIActions.getInstance().invokeZoneMgr(v, false);
                    dlg.refreshAndCalcSize();
                    dlg.runcreateAndShoZone(selPorts, ob);
                    dlg.setVisible(true);
                }
            }
        }
        catch (Exception ex) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), ex.getMessage());
        }
    }

    @Override
    public void validate(JMenuItem menuitem, TopologyGraph g) {
        SmMap map = SmMap.getSelectedMap();
        ArrayList links = map.getSelectedLinks();
        boolean exists = false;
        for (int i = 0; i < links.size(); ++i) {
            try {
                if (!(links.get(i) instanceof EdgeMapLink)) continue;
                exists = true;
                continue;
            }
            catch (Exception e) {
                _Logger.trace((Object)"logEmptyCatch", (Throwable)e);
            }
        }
        menuitem.setEnabled(exists);
    }
}

