/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.Device;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.UserDefinedGroup;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.Hba;
import com.cisco.dcbu.sm.common.model.ScsiTarget;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.vi.model.HostSystem;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Enclosure
extends AbstractModelObject
implements Device,
Cloneable {
    protected San _san;
    protected ArrayList<EndPort> lnkEndPort;
    private static String[] _AllowableDeviceTypes = null;
    public static final String DEVICE_TYPE_HOST = "Host";
    public static final String DEVICE_TYPE_STORAGE = "Storage";
    public static final int DEVICE_TYPE_MAX = 2;

    public Enclosure(EnclosureBase enclosureBase, San san) {
        super(enclosureBase);
        this._san = san;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        Enclosure enclosure1 = (Enclosure)o1;
        Enclosure enclosure2 = (Enclosure)o2;
        int result = enclosure1.getName().compareTo(enclosure2.getName());
        return result;
    }

    @Override
    public String getName() {
        return ((EnclosureBase)this._baseModelObject).getName();
    }

    public String getEnclosureName() {
        return ((EnclosureBase)this._baseModelObject).getEnclosureName();
    }

    public NameKey getEnclosurePK() {
        return ((EnclosureBase)this._baseModelObject).getEnclosurePK();
    }

    public San getSan() {
        return this._san;
    }

    public void setSan(San san) {
        this._san = san;
    }

    public void sync(Enclosure enclosure) {
        this.setSan(enclosure.getSan());
        this.setDMPath(enclosure.getDMPath());
        this.setUserObject(enclosure.getUserObject());
        this.setType(enclosure.getType());
        this.setScsiTarget(enclosure.getScsiTarget());
        this.setHBAs(enclosure.getHBAs());
        this.setIpAddress(enclosure.getIpAddress());
        this.setLastScanTime(enclosure._baseModelObject.getLastScanTime());
        this.setPresent(enclosure.isPresent());
        this.setUserObject(enclosure.getUserObject());
        ArrayList members = (ArrayList)enclosure.getMembers().clone();
        if (members != null && members.size() > 0) {
            for (int i = 0; i < members.size(); ++i) {
                this.addMember((EndPort)members.get(i));
            }
        }
    }

    @Override
    public boolean isPresent() {
        boolean isPresent = false;
        if (this.lnkEndPort != null) {
            for (EndPort ep : this.lnkEndPort) {
                if (!ep.isPresent()) continue;
                isPresent = true;
                break;
            }
        }
        return isPresent;
    }

    @Override
    public boolean isMinorAlarm() {
        boolean hasMinorAlarm = false;
        if (this.lnkEndPort != null) {
            for (EndPort ep : this.lnkEndPort) {
                if (ep.isPresent()) continue;
                hasMinorAlarm = true;
                break;
            }
        }
        return hasMinorAlarm;
    }

    @Override
    public boolean isManageable() {
        return true;
    }

    @Override
    public String getSysLocation() {
        return "";
    }

    @Override
    public String getSysContact() {
        return "";
    }

    @Override
    public long getSysUpTime() {
        return 0L;
    }

    @Override
    public String getIpAddress() {
        return ((EnclosureBase)this._baseModelObject).getIpAddress();
    }

    public ScsiTarget getScsiTarget() {
        return ((EnclosureBase)this._baseModelObject).getScsiTarget();
    }

    public void setScsiTarget(ScsiTarget scsiTarget) {
        ((EnclosureBase)this._baseModelObject).setScsiTarget(scsiTarget);
    }

    public Hba[] getHBAs() {
        return ((EnclosureBase)this._baseModelObject).getHbas();
    }

    public void setHBAs(Hba[] hbas) {
        ((EnclosureBase)this._baseModelObject).setHbas(hbas);
    }

    public String getMultiPath() {
        return ((EnclosureBase)this._baseModelObject).getMultiPath();
    }

    public String getDMPath() {
        return ((EnclosureBase)this._baseModelObject).getDMPath();
    }

    public void setDMPath(String dmPath) {
        String oldPath = this.getDMPath();
        if (((EnclosureBase)this._baseModelObject).setDMPath(dmPath)) {
            HashedArrayList<Fabric> fabrics = new HashedArrayList<Fabric>();
            if (this.lnkEndPort != null) {
                Iterator<EndPort> it = this.lnkEndPort.iterator();
                while (it.hasNext()) {
                    Fabric fabric = it.next().getFabric();
                    if (fabric == null || ((ArrayList)fabrics).contains(fabric)) continue;
                    ((ArrayList)fabrics).add(fabric);
                    fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "dmPath", oldPath, dmPath));
                }
            }
        }
    }

    public boolean setIpAddress(String ipAddress) {
        String oldName = this.getName();
        ((EnclosureBase)this._baseModelObject).setIpAddress(ipAddress);
        String newName = this.getName();
        if (GenUtil.equals(oldName, newName)) {
            return false;
        }
        this._san.removeEnclosure(new NameKey(oldName));
        this._san.addEnclosure(this);
        PropertyChangeEvent event = new PropertyChangeEvent(this, "enclosureName", oldName, newName);
        HashedArrayList<Fabric> fabrics = new HashedArrayList<Fabric>();
        if (this.lnkEndPort != null) {
            Iterator<EndPort> it = this.lnkEndPort.iterator();
            while (it.hasNext()) {
                Fabric fabric = it.next().getFabric();
                if (fabric == null || ((ArrayList)fabrics).contains(fabric)) continue;
                ((ArrayList)fabrics).add(fabric);
                fabric.addPropertyChangeEvent(event);
            }
        }
        this._san.addPropertyChangeEvent(event);
        return true;
    }

    @Override
    public void firePropertyChangeEvents() {
        HashedArrayList<Fabric> fabrics = new HashedArrayList<Fabric>();
        if (this.lnkEndPort != null) {
            Iterator<EndPort> it = this.lnkEndPort.iterator();
            while (it.hasNext()) {
                Fabric fabric = it.next().getFabric();
                if (fabric == null || ((ArrayList)fabrics).contains(fabric)) continue;
                ((ArrayList)fabrics).add(fabric);
                fabric.firePropertyChangeEvents();
            }
        }
        this._san.firePropertyChangeEvents();
    }

    public void addMember(EndPort endPort) {
        ((EnclosureBase)this._baseModelObject).addEndPort((WwnKey)endPort.getPK());
        if (this.lnkEndPort == null) {
            this.lnkEndPort = new HashedArrayList<EndPort>();
        }
        if (!this.lnkEndPort.contains(endPort)) {
            this.lnkEndPort.add(endPort);
        }
        San.getInstance().enclosureMemberAdded(this, endPort);
    }

    public boolean removeMember(EndPort endPort) {
        boolean removed = ((EnclosureBase)this._baseModelObject).removeEndPort((WwnKey)endPort.getPK());
        if (removed && this.lnkEndPort != null) {
            int index = this.lnkEndPort.indexOf(endPort);
            if (index != -1) {
                this.lnkEndPort.remove(index);
            }
            San.getInstance().enclosureMemberRemoved(this, endPort);
        }
        return removed;
    }

    public boolean isMemberOfVsan(Vsan vsan) {
        if (this.lnkEndPort != null) {
            for (int i = 0; i < this.lnkEndPort.size(); ++i) {
                if (!this.lnkEndPort.get(i).isMemberOfVsan(vsan)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMemberOfGroup(UserDefinedGroup group) {
        if (this.lnkEndPort != null) {
            for (int i = 0; i < this.lnkEndPort.size(); ++i) {
                EndPort ep = this.lnkEndPort.get(i);
                if (!group.exists(ep.getSwitch()) && !group.exists(ep)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMemberOfMultiFabrics() {
        if (this.lnkEndPort != null) {
            FabricPK fabricPK = null;
            for (int i = 0; i < this.lnkEndPort.size(); ++i) {
                Fabric fabric;
                EndPort ep = this.lnkEndPort.get(i);
                if (ep == null || (fabric = ep.getFabric()) == null) continue;
                if (fabricPK == null) {
                    fabricPK = (FabricPK)fabric.getPK();
                    continue;
                }
                if (fabricPK.equals(fabric.getPK())) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList getFabricPKs() {
        HashedArrayList<FabricPK> list = new HashedArrayList<FabricPK>();
        if (this.lnkEndPort != null) {
            FabricPK fabricPK = null;
            for (int i = 0; i < this.lnkEndPort.size(); ++i) {
                EndPort ep = this.lnkEndPort.get(i);
                Fabric fabric = ep.getFabric();
                if (fabric == null || ((ArrayList)list).contains(fabricPK = (FabricPK)fabric.getPK())) continue;
                ((ArrayList)list).add(fabricPK);
            }
        }
        return list;
    }

    public boolean isMemberOf(FabricPK fabricPK) {
        if (fabricPK == null) {
            return false;
        }
        if (this.lnkEndPort != null) {
            for (int i = 0; i < this.lnkEndPort.size(); ++i) {
                EndPort ep = this.lnkEndPort.get(i);
                if (ep.getFabric() == null || !fabricPK.equals(ep.getFabric().getPK())) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList getMembers(FabricPK fabricPK) {
        HashedArrayList<EndPort> eps = new HashedArrayList<EndPort>();
        if (this.lnkEndPort != null) {
            for (int i = 0; i < this.lnkEndPort.size(); ++i) {
                EndPort ep = this.lnkEndPort.get(i);
                FabricPK aFabricPK = ep.getFabric() != null ? (FabricPK)ep.getFabric().getPK() : null;
                if (fabricPK != null && !fabricPK.equals(aFabricPK) || ((ArrayList)eps).contains(ep)) continue;
                ((ArrayList)eps).add(ep);
            }
        }
        return eps;
    }

    public int getMemberCount() {
        return this.lnkEndPort == null ? 0 : this.lnkEndPort.size();
    }

    public ArrayList<EndPort> getMembers() {
        return this.lnkEndPort;
    }

    public synchronized boolean isMember(EndPort endPort) {
        return ((EnclosureBase)this._baseModelObject).hasEndPort((WwnKey)endPort.getPK());
    }

    public int getType() {
        return ((EnclosureBase)this._baseModelObject).getType();
    }

    public String getTypeName() {
        return this.isHost() ? DEVICE_TYPE_HOST : DEVICE_TYPE_STORAGE;
    }

    public boolean isTarget() {
        return ((EnclosureBase)this._baseModelObject).isStorage();
    }

    public boolean isHost() {
        return ((EnclosureBase)this._baseModelObject).isHost();
    }

    public void setType(int type) {
        Integer oldType = new Integer(((EnclosureBase)this._baseModelObject).getType());
        if (((EnclosureBase)this._baseModelObject).setType(type)) {
            HashedArrayList<Fabric> fabrics = new HashedArrayList<Fabric>();
            if (this.lnkEndPort != null) {
                Iterator<EndPort> it = this.lnkEndPort.iterator();
                while (it.hasNext()) {
                    Fabric fabric = it.next().getFabric();
                    if (fabric == null || ((ArrayList)fabrics).contains(fabric)) continue;
                    ((ArrayList)fabrics).add(fabric);
                    fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "isTarget", oldType, new Integer(type)));
                }
            }
        }
    }

    public static int getDeviceType(Enclosure encl, String typeString) {
        int type;
        block5: {
            type = 0;
            if (typeString != null && typeString.length() > 0) {
                try {
                    if (typeString.equalsIgnoreCase(DEVICE_TYPE_HOST) || typeString.equals("false")) {
                        type = 47;
                        break block5;
                    }
                    type = 0;
                }
                catch (Exception ex) {
                    type = encl == null ? 0 : encl.getType();
                }
            } else {
                type = encl == null ? 0 : encl.getType();
            }
        }
        return type;
    }

    public static String[] getAllowedDeviceTypes() {
        if (_AllowableDeviceTypes == null) {
            HashedArrayList<String> types = new HashedArrayList<String>(2);
            ((ArrayList)types).add(DEVICE_TYPE_HOST);
            ((ArrayList)types).add(DEVICE_TYPE_STORAGE);
            _AllowableDeviceTypes = types.toArray(new String[types.size()]);
            return _AllowableDeviceTypes;
        }
        return _AllowableDeviceTypes;
    }

    public boolean isVirtual() {
        return ((EnclosureBase)this._baseModelObject).isVirtual();
    }

    public String getVendor() {
        String vendor = ((EnclosureBase)this._baseModelObject).getVendor();
        if (vendor == null) {
            if (this.isTarget()) {
                ScsiTarget target = this.getScsiTarget();
                if (target != null) {
                    return target.getVendorId();
                }
            } else {
                Hba[] hba = this.getHBAs();
                if (hba != null && hba.length > 0) {
                    return hba[0].getManufacturer();
                }
            }
            if (this.lnkEndPort != null && this.lnkEndPort.size() > 0) {
                try {
                    vendor = WwnDictionary.getVendor(this.lnkEndPort.get(0).getPortWwn().getValue());
                }
                catch (Exception ex) {
                    vendor = "";
                    this._logger.error((Object)("NPE caught. Enclosure Name: " + this.getEnclosureName() + ", PK: " + this.getEnclosurePK() + ", IP:" + this.getIpAddress()), (Throwable)ex);
                }
            }
        }
        return vendor;
    }

    public void setVendor(String vendor) {
        ((EnclosureBase)this._baseModelObject).setVendor(vendor);
    }

    public void setOSInfo(String info) {
        ((EnclosureBase)this._baseModelObject).setOSInfo(info);
    }

    public boolean setNumVms(int numVms) {
        Integer oldNumVms = new Integer(this.getNumVms());
        if (((EnclosureBase)this._baseModelObject).setNumVms(numVms)) {
            HashedArrayList<Fabric> fabrics = new HashedArrayList<Fabric>();
            if (this.lnkEndPort != null) {
                Iterator<EndPort> it = this.lnkEndPort.iterator();
                while (it.hasNext()) {
                    Fabric fabric = it.next().getFabric();
                    if (fabric == null || ((ArrayList)fabrics).contains(fabric)) continue;
                    ((ArrayList)fabrics).add(fabric);
                    fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "numVms", oldNumVms, new Integer(numVms)));
                }
            }
            return true;
        }
        return false;
    }

    public boolean setServiceProfile(String serviceProfile) {
        String oldServiceProfile = this.getServiceProfile();
        if (((EnclosureBase)this._baseModelObject).setServiceProfile(serviceProfile)) {
            HashedArrayList<Fabric> fabrics = new HashedArrayList<Fabric>();
            if (this.lnkEndPort != null) {
                Iterator<EndPort> it = this.lnkEndPort.iterator();
                while (it.hasNext()) {
                    Fabric fabric = it.next().getFabric();
                    if (fabric == null || ((ArrayList)fabrics).contains(fabric)) continue;
                    ((ArrayList)fabrics).add(fabric);
                    fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "serviceProfile", oldServiceProfile, serviceProfile));
                }
            }
            return true;
        }
        return false;
    }

    public boolean setServerBlade(String serverBlade) {
        String oldServerBlade = this.getServerBlade();
        if (((EnclosureBase)this._baseModelObject).setServerBlade(serverBlade)) {
            HashedArrayList<Fabric> fabrics = new HashedArrayList<Fabric>();
            if (this.lnkEndPort != null) {
                Iterator<EndPort> it = this.lnkEndPort.iterator();
                while (it.hasNext()) {
                    Fabric fabric = it.next().getFabric();
                    if (fabric == null || ((ArrayList)fabrics).contains(fabric)) continue;
                    ((ArrayList)fabrics).add(fabric);
                    fabric.addPropertyChangeEvent(new PropertyChangeEvent(this, "serverBlade", oldServerBlade, serverBlade));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        EnclosureBase encBase;
        this._san = null;
        if (this.lnkEndPort != null) {
            this.lnkEndPort.clear();
            this.lnkEndPort = null;
        }
        if ((encBase = (EnclosureBase)this._baseModelObject) != null) {
            encBase.setDMPath(null);
            encBase.setEnclosureName(null);
            encBase.setHbas(null);
            encBase.setIpAddress(null);
            encBase.setModel(null);
            encBase.setOSInfo(null);
            encBase.setScsiTarget(null);
            encBase.setVendor(null);
            encBase.setVersion(null);
            encBase = null;
        }
        super.destroy();
    }

    public String getModel() {
        String model = ((EnclosureBase)this._baseModelObject).getModel();
        if (model == null) {
            if (this.isTarget()) {
                ScsiTarget target = this.getScsiTarget();
                if (target != null) {
                    return target.getProductId();
                }
            } else {
                Hba[] hba = this.getHBAs();
                if (hba != null && hba.length > 0) {
                    return hba[0].getModel();
                }
            }
        }
        return model;
    }

    public void setModel(String model) {
        ((EnclosureBase)this._baseModelObject).setModel(model);
    }

    public String getVersion() {
        String version = ((EnclosureBase)this._baseModelObject).getVersion();
        if (version == null) {
            if (this.isTarget()) {
                ScsiTarget target = this.getScsiTarget();
                if (target != null) {
                    return target.getRevLevel();
                }
            } else {
                Hba[] hba = this.getHBAs();
                if (hba != null && hba.length > 0) {
                    return hba[0].getFirmwareVersion();
                }
            }
        }
        return version;
    }

    public String getOSInfo() {
        return ((EnclosureBase)this._baseModelObject).getOSInfo();
    }

    public void setVersion(String model) {
        ((EnclosureBase)this._baseModelObject).setVersion(model);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    List getMemberPKs() {
        return ((EnclosureBase)this._baseModelObject).getEndPortPKs();
    }

    @Override
    public String getDetails() {
        StringBuffer buf = new StringBuffer(512);
        buf.append(this.getName());
        try {
            int vmCount = this.getNumVms();
            if (vmCount > 0) {
                buf.append("\n");
                buf.append("VM Count: " + vmCount);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            boolean hasBlade;
            String profile = this.getServiceProfile();
            boolean hasProfile = profile != null && profile.length() > 0;
            String blade = this.getServerBlade();
            boolean bl = hasBlade = blade != null && blade.length() > 0;
            if (hasProfile) {
                buf.append("\nUCS Service Profile: " + profile);
            }
            if (hasBlade) {
                buf.append("\nUCS Blade: " + blade);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.lnkEndPort != null && this.lnkEndPort.size() > 0) {
            int i;
            MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
            PKIf fabricPK = null;
            if (mgmtDomain.isFabric()) {
                fabricPK = mgmtDomain.getFabric().getPK();
            }
            EndPort[] eps = this.lnkEndPort.toArray(new EndPort[this.lnkEndPort.size()]);
            Object[] details = new String[eps.length];
            for (i = 0; i < eps.length; ++i) {
                if (fabricPK != null) {
                    if (fabricPK.equals(eps[i].getFabricPK())) {
                        details[i] = eps[i].getDetails(true);
                        continue;
                    }
                    details[i] = "";
                    continue;
                }
                details[i] = eps[i].getDetails(true);
            }
            Arrays.sort(details);
            for (i = 0; i < eps.length; ++i) {
                if (((String)details[i]).length() <= 0) continue;
                buf.append("\n");
                buf.append((String)details[i]);
            }
        }
        return buf.toString();
    }

    public boolean areAnyMembersISCSI() {
        if (this.lnkEndPort != null) {
            for (int i = 0; i < this.lnkEndPort.size(); ++i) {
                EndPort ep = this.lnkEndPort.get(i);
                if (ep == null || ep.getBaseModelObject() == null || !ep.isISCSI()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean areAnyMembersVirtualized() {
        if (this.lnkEndPort != null) {
            for (int i = 0; i < this.lnkEndPort.size(); ++i) {
                EndPort ep = this.lnkEndPort.get(i);
                if (ep == null || ep.getBaseModelObject() == null || !ep.isVirtualized()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isVmHost() {
        return ((EnclosureBase)this._baseModelObject).isVmHost();
    }

    public String getCluster() {
        return ((EnclosureBase)this._baseModelObject).getClusterName();
    }

    public String getServiceProfile() {
        return ((EnclosureBase)this._baseModelObject).getServiceProfile();
    }

    public String getServerBlade() {
        return ((EnclosureBase)this._baseModelObject).getServerBlade();
    }

    public short getCpuCount() {
        return ((EnclosureBase)this._baseModelObject).getCpuCount();
    }

    public int getNumVms() {
        return ((EnclosureBase)this._baseModelObject).getNumVms();
    }

    public long getMemorySize() {
        return ((EnclosureBase)this._baseModelObject).getMemorySize();
    }

    public List<NameKey> getVmPKs() {
        return ((EnclosureBase)this._baseModelObject).getVmPKs();
    }

    public HostSystem getVHost() {
        return ((EnclosureBase)this._baseModelObject).getVHost();
    }

    public void setVHost(HostSystem hostSystem) {
        ((EnclosureBase)this._baseModelObject).setVHost(hostSystem);
    }
}

