/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.sm.client.model.AbstractMgmtDomain;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;

public class EnforcedZone
extends AbstractMgmtDomain
implements Comparator,
Comparable {
    private ZoneBase _zoneBase;
    private Vsan _vsan;
    Fabric _fabric;
    private Array<EnforcedZoneMember> _lnkEnforcedZoneMember = new Array();

    public EnforcedZone(ZoneBase zoneBase, Vsan vsan, Fabric fabric) {
        this._zoneBase = zoneBase;
        this._vsan = vsan;
        this._fabric = this._vsan == null ? fabric : this._vsan.getFabric();
        this.addMembers(this._zoneBase.getMembers());
    }

    @Override
    protected boolean inited() {
        return true;
    }

    public Vsan getVsan() {
        return this._vsan;
    }

    @Override
    public Fabric getFabric() {
        return this._fabric;
    }

    public San getSan() {
        return this._fabric.getSan();
    }

    @Override
    public Switch[] getSwitches() {
        return this._vsan.getSwitches();
    }

    @Override
    public ArrayList<Isl> getIsls(ArrayList<Isl> isls) {
        return this._vsan.getIsls(isls);
    }

    @Override
    public ArrayList<NpvLink> getNpvLinks(ArrayList<NpvLink> npvLinks) {
        return this._vsan.getNpvLinks(npvLinks);
    }

    @Override
    public ArrayList<EndPort> getEndPortsAsList() {
        if (this._lnkEnforcedZoneMember == null) {
            return null;
        }
        HashedArrayList<EndPort> endPorts = new HashedArrayList<EndPort>();
        for (int i = 0; i < this._lnkEnforcedZoneMember.size(); ++i) {
            EnforcedZoneMember zoneMember = this._lnkEnforcedZoneMember.elementAt(i);
            EndPort ep = zoneMember.getEndPort(this._vsan.getFabric());
            if (ep == null || ((ArrayList)endPorts).contains(ep)) continue;
            ((ArrayList)endPorts).add(ep);
        }
        return endPorts;
    }

    public HashMap<EndPort, EndPort> getEndPortsAsHashMap() {
        HashMap<EndPort, EndPort> map = new HashMap<EndPort, EndPort>();
        if (this._lnkEnforcedZoneMember == null) {
            return map;
        }
        for (int i = 0; i < this._lnkEnforcedZoneMember.size(); ++i) {
            EnforcedZoneMember zoneMember = this._lnkEnforcedZoneMember.elementAt(i);
            EndPort ep = zoneMember.getEndPort(this._vsan == null ? this.getFabric() : this._vsan.getFabric());
            if (ep == null || map.get(ep) != null) continue;
            map.put(ep, ep);
        }
        return map;
    }

    @Override
    public EndPort[] getEndPorts() {
        if (this._lnkEnforcedZoneMember == null) {
            return null;
        }
        ArrayList<EndPort> endPorts = this.getEndPortsAsList();
        return endPorts.toArray(new EndPort[endPorts.size()]);
    }

    @Override
    public ArrayList<EndPort> getEndPorts(ArrayList<EndPort> endPorts, boolean target) {
        if (endPorts == null) {
            endPorts = new HashedArrayList<EndPort>();
        }
        if (this._lnkEnforcedZoneMember == null) {
            return null;
        }
        for (int i = 0; i < this._lnkEnforcedZoneMember.size(); ++i) {
            EnforcedZoneMember zoneMember = this._lnkEnforcedZoneMember.elementAt(i);
            EndPort ep = zoneMember.getEndPort(this._vsan.getFabric());
            if (ep == null || !(target ? ep.isTarget() : !ep.isTarget()) || endPorts.contains(ep)) continue;
            endPorts.add(ep);
        }
        return endPorts;
    }

    @Override
    public EndPort[] getEndPorts(boolean target) {
        ArrayList<EndPort> endPorts = this.getEndPorts(null, target);
        return endPorts == null ? new EndPort[]{} : endPorts.toArray(new EndPort[endPorts.size()]);
    }

    public ZoneBase getZoneBase() {
        return this._zoneBase;
    }

    public int getCfsRegion() {
        return this._zoneBase.getCfsRegion();
    }

    @Override
    public MgmtDomainIf getParent() {
        return this._vsan != null ? this._vsan : this._fabric;
    }

    @Override
    public String getPath(char separator) {
        return this._vsan.getPath(separator) + separator + this._vsan.getEnforcedZoneSetName() + separator + this.getName();
    }

    public int hashCode() {
        return this._zoneBase.hashCode();
    }

    @Override
    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof EnforcedZone)) {
            return false;
        }
        return this._zoneBase.equals(x);
    }

    @Override
    public int getVsanId() {
        return this.getVsan().getVsanId();
    }

    @Override
    public int[] getUpIfIndices(Switch sw, short type) {
        EndPort[] eps;
        IntArray indices = new IntArray();
        if ((type == 4096 || type == 4352) && (eps = this.getEndPorts()) != null && eps.length > 0) {
            for (int i = 0; i < eps.length; ++i) {
                if (type == 4608 || !sw.equals(eps[i].getSwitch()) || indices.contains(eps[i].getSwitchIntKey()._index)) continue;
                indices.add(eps[i].getSwitchIntKey()._index);
            }
        }
        return indices.toArray(new int[indices.size()]);
    }

    @Override
    public SmFilter[] getFilters() {
        SmFilter[] filters = super.getFilters();
        return filters;
    }

    @Override
    public SnmpPeer[] getSnmpPeers() {
        return this._vsan.getSnmpPeers();
    }

    @Override
    public SnmpPeer[] getSnmpPeers(boolean needQuail) {
        return this._vsan.getSnmpPeers(needQuail, true);
    }

    @Override
    public boolean isZone() {
        return true;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        ZoneBase z1 = o1 instanceof EnforcedZone ? ((EnforcedZone)o1).getZoneBase() : (ZoneBase)o1;
        ZoneBase z2 = o2 instanceof EnforcedZone ? ((EnforcedZone)o2).getZoneBase() : (ZoneBase)o2;
        return z1.getName().compareToIgnoreCase(z2.getName());
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public int getIndex() {
        return this._zoneBase.getIndex();
    }

    @Override
    public String toString() {
        return this._zoneBase.toString();
    }

    @Override
    public String getName() {
        return this._zoneBase.getName();
    }

    public boolean isReadOnly() {
        return this._zoneBase.isReadOnly();
    }

    public boolean isQosSupported() {
        return this._zoneBase.isQosSupported();
    }

    public int getQosPriority() {
        return this._zoneBase.getQosPriority();
    }

    public boolean isBrodcastSupported() {
        return this._zoneBase.isBrodcastSupported();
    }

    public boolean isSmartZoningSupported() {
        return this._zoneBase.isSmartZoningSupported();
    }

    public Array getMembers() {
        return this._lnkEnforcedZoneMember;
    }

    public void clearMembers() {
        if (this._lnkEnforcedZoneMember != null) {
            this._lnkEnforcedZoneMember.clear();
        }
    }

    public void addMembers(Array members) {
        if (members == null || members.size() == 0) {
            return;
        }
        if (this._lnkEnforcedZoneMember == null) {
            this._lnkEnforcedZoneMember = new Array(members.size());
        }
        for (int i = 0; i < members.size(); ++i) {
            EnforcedZoneMember ezm = new EnforcedZoneMember((ZoneMemberBase)members.elementAt(i), this);
            if (this._lnkEnforcedZoneMember.findEquals(ezm) >= 0) continue;
            this._lnkEnforcedZoneMember.addElement(ezm);
        }
    }

    public void addMember(EnforcedZoneMember newMember) {
        this._lnkEnforcedZoneMember.addElement(newMember);
    }

    public byte[] getIfFormatSwitchWwn(byte[] id) {
        return this._zoneBase.getIfFormatSwitchWwn(id);
    }

    public static EnforcedZone findParent(EnforcedZone[] zones, int zoneIndex) {
        int hi = zones.length;
        int lo = 0;
        while (hi > lo) {
            int mid = (hi - lo) / 2 + lo;
            if (zones[mid].getIndex() == zoneIndex) {
                return zones[mid];
            }
            if (zones[mid].getIndex() > zoneIndex) {
                hi = mid;
                continue;
            }
            lo = mid + 1;
        }
        return null;
    }

    public static void destroyEnforcedZones(EnforcedZone[] oldEnforcedZones) {
        if (oldEnforcedZones != null && oldEnforcedZones.length > 0) {
            for (int i = 0; i < oldEnforcedZones.length; ++i) {
                EnforcedZone enfZone = oldEnforcedZones[i];
                enfZone.destroy();
            }
            oldEnforcedZones = null;
        }
    }

    void destroy() {
        try {
            this._vsan = null;
            this._fabric = null;
            this._filters = null;
            this.clearPropertyChangeListener();
            if (this._zoneBase != null) {
                this._zoneBase.getMembers().clear();
                this._zoneBase = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

