/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.model.AbstractEthLink;
import com.cisco.dcbu.sm.client.model.AbstractSwitch;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Lan;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vlan;
import com.cisco.dcbu.sm.common.model.AbstractEthLinkBase;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.EthIslBase;
import com.cisco.dcbu.sm.common.type.EthIslPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import java.util.List;

public class EthIsl
extends AbstractEthLink {
    protected EthIslBase _ethIslBase;
    protected Lan _lan;
    private AbstractSwitch _switch1;
    private AbstractSwitch _switch2;

    public EthIsl(AbstractEthLinkBase ethIslBase, Lan lan) {
        super(ethIslBase);
        this._ethIslBase = (EthIslBase)ethIslBase;
        this._lan = lan;
    }

    public EthIslBase getEthIslBase() {
        return this._ethIslBase;
    }

    @Override
    public void setBaseModelObject(BaseModelObject baseModelObject) {
        super.setBaseModelObject(baseModelObject);
        this._ethIslBase = (EthIslBase)baseModelObject;
    }

    @Override
    public int getIfIndex1() {
        return this._ethIslBase.getIfIndex1();
    }

    @Override
    public int getIfIndex2() {
        return this._ethIslBase.getIfIndex2();
    }

    public EthIslPK getIslPK() {
        return this._ethIslBase.getIslPK();
    }

    public PKIf getSwitch1PK() {
        return this._ethIslBase.getSwitch1PK();
    }

    public PKIf getSwitch2PK() {
        return this._ethIslBase.getSwitch2PK();
    }

    @Override
    public boolean isFcObject() {
        return false;
    }

    @Override
    public boolean isEthObject() {
        return true;
    }

    @Override
    public boolean isFcoeObject() {
        return false;
    }

    @Override
    public Lan getLan() {
        return this._lan;
    }

    public AbstractSwitch getSwitch1() {
        if (this._switch1 == null) {
            this._switch1 = this.getLan().findSwitchByPK(this.getSwitch1PK());
        }
        return this._switch1;
    }

    public AbstractSwitch getSwitch2() {
        if (this._switch2 == null) {
            this._switch2 = this.getLan().findSwitchByPK(this.getSwitch2PK());
        }
        return this._switch2;
    }

    @Override
    public AbstractSwitch getAbstractSwitch1() {
        return this.getSwitch1();
    }

    @Override
    public AbstractSwitch getAbstractSwitch2() {
        return this.getSwitch2();
    }

    @Override
    public String getName() {
        return this.getSwitch1().getName() + ',' + this.getIfIndex1Name() + " <-> " + this.getSwitch2().getName() + ',' + this.getIfIndex2Name();
    }

    @Override
    public String getIfIndex2Name() {
        if (this.getSwitch2() == null) {
            return String.valueOf(this.getIfIndex2());
        }
        return ((EthSwitch)this.getSwitch2()).ifIndexToName(this.getIfIndex2());
    }

    @Override
    public String getIfIndex1Name() {
        if (this.getSwitch1() == null) {
            return String.valueOf(this.getIfIndex1());
        }
        return ((EthSwitch)this.getSwitch1()).ifIndexToName(this.getIfIndex1());
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public String getDetails(boolean swap) {
        return this.toString(swap);
    }

    @Override
    public String toString(boolean swap) {
        StringBuffer sb = new StringBuffer();
        boolean lineBreak = false;
        if (swap) {
            sb.append(this.getSwitch2().getName()).append(',').append(this.getIfIndex2Name()).append(" <-> ").append(this.getSwitch1().getName()).append(',').append(this.getIfIndex1Name());
        } else {
            sb.append(this.getSwitch1().getName()).append(',').append(this.getIfIndex1Name()).append(" <-> ").append(this.getSwitch2().getName()).append(',').append(this.getIfIndex2Name());
        }
        if (this.getSpeed() != 0L) {
            sb.append(", " + MibVariableFormat.highSpeed(this.getSpeed() / 1000000L));
        }
        if (!this.isPresent() || this.isMinorAlarm()) {
            sb.append(", " + this.getStatus());
        }
        String vlans = null;
        try {
            vlans = this._ethIslBase.getVlanIdsAsString();
            lineBreak = sb.length() + vlans.length() > Switch.TooltipLineLength;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            vlans = "";
        }
        if (this._ethIslBase.getChildren() != null) {
            try {
                sb.append("\n");
                sb.append(this.getPCMemberLinksAsString(swap, Switch.TooltipLineLength));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            lineBreak = true;
        }
        if (lineBreak) {
            sb.append("\n");
        } else {
            sb.append(", ");
        }
        if (this._ethIslBase.getNumVlans() > 1) {
            sb.append("VLANs:");
        } else if (this._ethIslBase.getNumVlans() == 1) {
            sb.append("VLAN ");
        }
        if (vlans.length() > 100) {
            sb.append(vlans.substring(0, 100));
        } else {
            sb.append(vlans);
        }
        return sb.toString();
    }

    @Override
    public String getPCMemberLinksAsString() {
        return this.getPCMemberLinksAsString(false);
    }

    public String getPCMemberLinksAsString(boolean swap) {
        return this.getPCMemberLinksAsString(swap, -1);
    }

    public String getPCMemberLinksAsString(boolean swap, int eachSideLength) {
        List<int[]> children = this._ethIslBase.getChildren();
        if (children == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        int length = 0;
        AbstractSwitch sw1 = this.getSwitch1();
        AbstractSwitch sw2 = this.getSwitch2();
        for (int[] pair : children) {
            String str2;
            String str;
            if (swap) {
                str = sw2 != null ? sw2.ifIndexToName(pair[1]) : IfIndexUtil.ifIndexToName(pair[1]);
                str2 = sw1 != null ? sw1.ifIndexToName(pair[0]) : IfIndexUtil.ifIndexToName(pair[0]);
            } else {
                str = sw1 != null ? sw1.ifIndexToName(pair[0]) : IfIndexUtil.ifIndexToName(pair[0]);
                str2 = sw2 != null ? sw2.ifIndexToName(pair[1]) : IfIndexUtil.ifIndexToName(pair[1]);
            }
            if (eachSideLength >= 20 && (length += str.length() + 2) > eachSideLength) {
                sb.append(" <-> ");
                sb.append(sb2).append("\n");
                sb2.setLength(0);
                length = str.length() + 2;
            }
            sb.append(str).append(", ");
            sb2.append(str2).append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        if (sb2.length() > 2) {
            sb2.setLength(sb2.length() - 2);
            sb.append(" <-> ");
            sb.append(sb2);
        }
        return sb.toString();
    }

    @Override
    public String getAdditionalDetailsForDisplay() {
        return null;
    }

    @Override
    public String getStatus() {
        if (!this.isPresent()) {
            return "last seen " + SnmpTimeticks.getDateFormat().format(new Date(this._ethIslBase.getLastScanTime()));
        }
        return "ok";
    }

    public boolean isDWDM() {
        return false;
    }

    @Override
    public long getSpeed() {
        return this._ethIslBase.getSpeed();
    }

    public void setSpeed(long speed) {
        long old = this._ethIslBase.getSpeed();
        this._ethIslBase.setSpeed(speed);
        this._lan.addPropertyChangeEvent(new PropertyChangeEvent(this, "speed", new Long(old), new Long(speed)));
    }

    @Override
    public List<int[]> getChildren() {
        return this._ethIslBase.getChildren();
    }

    @Override
    public int getChildCount() {
        return this._ethIslBase.getChildCount();
    }

    void setChildren(List<int[]> children) {
        List<int[]> old = this.getChildren();
        this._ethIslBase.setChildren(this.getSwitch1PK(), this.getSwitch2PK(), children);
        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "children", old, children));
    }

    public boolean isMemberOfVlan(int vlanId) {
        return this._ethIslBase.containVlan((short)vlanId);
    }

    public boolean isMemberOfVlan(Vlan vlan) {
        List<Short> vlanIds = this.getVlanIds();
        return vlanIds != null && vlanIds.size() > 0 && vlanIds.contains(vlan.getId());
    }

    public void setVlanMembership(List<Short> vm) {
        HashedArrayList<Short> old = new HashedArrayList<Short>(this._ethIslBase.getVlans());
        if (this._ethIslBase.setVlans(vm)) {
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "vlanMembership", old, vm));
        }
    }

    public void setNativeVlan(short vlanId) {
        this._ethIslBase.setNativeVlan(vlanId);
    }

    public void setAccessVlan(short vlanId) {
        this._ethIslBase.setAccessVlan(vlanId);
    }

    public void setTrunk(boolean trunk) {
        this._ethIslBase.setTrunk(trunk);
    }
}

