/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.UserDefinedGroup;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;

public class Hub
extends AbstractModelObject {
    protected final SwitchIntKey _pkey;
    private Fabric _fabric;
    private Switch _sw;
    HashMap<EndPort, EndPort> _members;
    protected boolean _isCloud;
    private Object _userObj;
    boolean _isPresent = true;

    public Hub(Fabric fabric, WwnKey swPK, int ifIndex) {
        super(null);
        this._pkey = new SwitchIntKey(swPK, ifIndex);
        this._fabric = fabric;
        this._fabric.addHub(this);
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    @Override
    public Fabric getFabric() {
        return this._fabric;
    }

    public SwitchIntKey getSwitchIntKey() {
        return this._pkey;
    }

    public int getIfIndex() {
        return this._pkey._index;
    }

    public boolean isCloud() {
        return this._isCloud;
    }

    public void setCloud(boolean isCloud) {
        this._isCloud = isCloud;
    }

    @Override
    public Object getUserObject() {
        return this._userObj;
    }

    @Override
    public void setUserObject(Object obj) {
        this._userObj = obj;
    }

    public Switch getSwitch() {
        if (this._sw == null) {
            this._sw = this._fabric.findSwitchByPK(this._pkey._swPK);
        }
        return this._sw;
    }

    public String getIfIndexName() {
        EndPort ep;
        EndPort endPort = ep = this._members != null && this._members.size() > 0 ? this.getMembers().get(0) : null;
        if (ep == null) {
            return this.getSwitch().ifIndexToName(this._pkey._index);
        }
        return ep.getIfIndexName();
    }

    @Override
    public String toString() {
        return this.getSwitch().getName() + ',' + this.getIfIndexName();
    }

    @Override
    public int compare(Object o1, Object o2) {
        return 0;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public boolean equals(AbstractModelObject abstractModelObject) {
        return this._pkey.equals(((Hub)abstractModelObject)._pkey);
    }

    @Override
    public String getDetails() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSwitch().getName() + ", " + this.getIfIndexName());
        if (!this.isPresent()) {
            sb.append(", last seen ").append(SnmpTimeticks.getDateFormat().format(new Date(this._baseModelObject.getLastScanTime())));
        }
        if (this._members != null && this._members.size() > 0) {
            Object[] eps = this._members.values().toArray(new EndPort[this._members.size()]);
            Arrays.sort(eps);
            boolean isFCoE = false;
            for (int i = 0; i < eps.length; ++i) {
                Object ep = eps[i];
                if (i == 0 && !(isFCoE = ((EndPort)ep).isFCoE())) {
                    sb.append(", VSAN " + ((EndPort)ep).getVsansAsString());
                }
                if (isFCoE) {
                    sb.append("\n" + ((EndPort)ep).toString() + ", VSAN " + ((EndPort)ep).getVsansAsString());
                    continue;
                }
                sb.append("\n" + ((EndPort)ep).toString());
            }
        }
        return sb.toString();
    }

    public synchronized void addMember(EndPort ep) {
        if (this._members == null) {
            this._members = new HashMap();
        }
        if (!this._members.containsValue(ep)) {
            this._members.put(ep, ep);
        }
    }

    public synchronized boolean removeMember(EndPort ep) {
        if (this._members != null) {
            return this._members.remove(ep) != null;
        }
        return false;
    }

    public int getMemberCount() {
        return this._members == null ? 0 : this._members.size();
    }

    public synchronized ArrayList<EndPort> getMembers() {
        if (this._members == null) {
            return null;
        }
        HashedArrayList<EndPort> arrayList = new HashedArrayList<EndPort>(this._members.values());
        return arrayList;
    }

    public int getNumMembers() {
        return this._members.size();
    }

    public boolean isMemberOfVsan(Vsan vsan) {
        ArrayList<EndPort> gotMembers = this.getMembers();
        if (gotMembers != null) {
            for (int i = 0; i < gotMembers.size(); ++i) {
                try {
                    if (gotMembers.get(i).isMemberOfVsan(vsan)) {
                        return true;
                    }
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean isMemberOfGroup(UserDefinedGroup group) {
        ArrayList<EndPort> gotMembers = this.getMembers();
        if (gotMembers != null) {
            for (int i = 0; i < gotMembers.size(); ++i) {
                try {
                    if (group.exists(gotMembers.get(i))) {
                        return true;
                    }
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean isMember(EndPort ep) {
        return this._members != null && this._members.containsKey(ep);
    }

    boolean isInUse() {
        return this._members != null && this._members.size() > 1;
    }

    public void clearMembers() {
        ArrayList<EndPort> gotMembers = this.getMembers();
        if (gotMembers != null) {
            for (int i = 0; i < gotMembers.size(); ++i) {
                gotMembers.get(i).setHub(null);
            }
            this._members.clear();
            this._members = null;
        }
    }

    @Override
    public int hashCode() {
        return this._pkey.hashCode();
    }

    @Override
    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof Hub)) {
            return false;
        }
        return this._pkey.equals(((Hub)x)._pkey);
    }

    public long getLastScanTime() {
        return 0L;
    }

    @Override
    public void setLastScanTime(long time) {
    }

    @Override
    public boolean isPresent() {
        return this._isPresent;
    }

    @Override
    public void setPresent(boolean isPresent) {
        this._isPresent = isPresent;
    }

    public boolean hasDisappeared(long lastScanTime) {
        return false;
    }

    public boolean hasReappeared(long lastScanTime) {
        return false;
    }

    public String getStatus() {
        return "";
    }

    @Override
    public boolean isMinorAlarm() {
        return false;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public void destroy() {
        this._fabric = null;
        this._sw = null;
        if (this._members != null) {
            this._members.clear();
            this._members = null;
        }
        this._userObj = null;
        super.destroy();
    }
}

