/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.concurrent.PooledThreadExecutor;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.event.EventDispatcher;
import com.cisco.dcbu.sm.client.map.ShortestPathAlgorithm;
import com.cisco.dcbu.sm.client.map.ShortestPathLinkIf;
import com.cisco.dcbu.sm.client.map.ShortestPathNodeIf;
import com.cisco.dcbu.sm.client.model.AbstractFcLink;
import com.cisco.dcbu.sm.client.model.AbstractLink;
import com.cisco.dcbu.sm.client.model.AbstractMgmtDomain;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.ChannelMemberIsl;
import com.cisco.dcbu.sm.client.model.ChannelMemberNpvLink;
import com.cisco.dcbu.sm.client.model.DestroyFabric;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.UserDefinedGroupManager;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.dto.PCMemberTrustSec;
import com.cisco.dcbu.sm.common.dto.VsanDomain;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.ModelEvent;
import com.cisco.dcbu.sm.common.event.ModelEventType;
import com.cisco.dcbu.sm.common.model.AbstractFcLinkBase;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.type.ClusterPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class San
extends AbstractMgmtDomain {
    public static final String NAME = "SAN";
    public static final String TAB_NAME = "Paths";
    private Object _enclosureSync = new Object();
    private HashMap<Wwn, Enclosure> _enclosureByPWwn = new HashMap();
    private HashMap<NameKey, Enclosure> _enclosureByPK = new HashMap();
    private HashMap<FabricPK, Fabric> _fabricByPK = new HashMap();
    private static San _Instance;
    private static PooledThreadExecutor _executor;
    private HashMap<FabricPK, FabricPK> _loadingFabrics = new HashMap();
    private HashMap<WwnKey, Switch> _switchByPK = new HashMap();
    private HashMap<InetAddress, Switch> _switchByIpAddress = new HashMap();
    private HashMap<SwitchIntKey, Isl> _islBySwitchIntKey = new HashMap();
    private HashMap<SwitchIntKey, NpvLink> _npvLinkByFPortPK = new HashMap();
    private HashMap<SwitchIntKey, NpvLink> _npvLinkByPCMemberSwitchIntKey = new HashMap();
    private HashMap<SwitchIntKey, Isl> _islByPCMemberSwitchIntKey = new HashMap();
    private ArrayList<IslBase> _danglingIsls = new HashedArrayList<IslBase>();
    private ArrayList<NpvLinkBase> _danglingNpvLinks = new HashedArrayList<NpvLinkBase>();
    private ArrayList<EndPort> _selectedEndPorts = null;
    private boolean _restrictByHost = true;
    private HashMap<EndPort, EndPort> _restrictedTopologyEndPorts = new HashMap();
    private HashMap<Fabric, HashMap<Vsan, Vsan>> _restrictedTopologyFabrics = new HashMap();
    private HashMap<WwnKey, Switch> _targetSwitches = new HashMap();
    private HashMap<WwnKey, Switch> _sourceSwitches = new HashMap();
    private HashMap<WwnKey, Switch> _ivrSwitches = new HashMap();
    private ArrayList<AbstractFcLink> _restrictedTopologyTargetSwitchLinks = new HashedArrayList<AbstractFcLink>();
    private ArrayList<AbstractFcLink> _restrictedTopologySourceSwitchLinks = new HashedArrayList<AbstractFcLink>();
    private ArrayList<AbstractFcLink> _restrictedTopologySourceToTargetSwitchLinks = new HashedArrayList<AbstractFcLink>();
    public static final int FABRIC_CLOUD = 0;
    public static final int ALL_PATHS = 1;
    public static final int SHORTEST_PATHS = 2;
    private int _pathType = 0;
    private String _restrictedTopologyName = "";
    public static final String[] _restrictedTopologyPathTypeAsString;
    public static HashMap destroyFabricMap;

    public void dump(String item) {
        Fabric[] fabrics = this.getFabrics();
        if (fabrics != null) {
            for (int i = 0; i < fabrics.length; ++i) {
                if (item.equals("Fabric")) {
                    fabrics[i].dump(item);
                    continue;
                }
                this.dump(fabrics[i], item, true);
            }
        }
    }

    private void dump(Fabric fabric, String item, boolean inDetail) {
        StringBuffer sb = new StringBuffer();
        sb.append(LIL[0]).append(fabric.toString());
        if (fabric.getSeedSwitch() != null) {
            sb.append(LIL[1]).append("discovery seed switch: ").append(fabric.getSeedSwitch().getIpAddress());
        }
        DefaultLogger._DumpLogger.info((Object)sb);
        fabric.dump(item);
        if (inDetail) {
            DefaultLogger._DumpLogger.info((Object)("Fabric persistent: " + fabric.isPersistent()));
        }
    }

    public Switch findSwitchByPKInRestrictedTopology(PKIf swWwnKey) {
        return this._switchByPK.get(swWwnKey);
    }

    public boolean fabricsAreLicensed() {
        Fabric[] fabrics = this.getFabrics();
        if (fabrics == null) {
            return false;
        }
        for (int i = 0; i < fabrics.length; ++i) {
            if (fabrics[i].isLicensed() || fabrics[i].isEvalLicensed()) continue;
            return false;
        }
        return true;
    }

    public void setRestrictedTopologyPathType(int pathType) {
        if (pathType > 2) {
            pathType = 0;
        }
        this._pathType = pathType;
    }

    public int getRestrictedTopologyPathType() {
        return this._pathType;
    }

    public String getRestrictedTopologyPathTypeAsString() {
        return _restrictedTopologyPathTypeAsString[this._pathType];
    }

    public void refreshRestrictdTopology(ArrayList<EndPort> selectedEndPorts, boolean byHost) {
        if (this._switchByPK != null) {
            this._switchByPK.clear();
        }
        if (this._switchByIpAddress != null) {
            this._switchByIpAddress.clear();
        }
        if (this._islBySwitchIntKey != null) {
            this._islBySwitchIntKey.clear();
        }
        if (this._npvLinkByFPortPK != null) {
            this._npvLinkByFPortPK.clear();
        }
        if (this._npvLinkByPCMemberSwitchIntKey != null) {
            this._npvLinkByPCMemberSwitchIntKey.clear();
        }
        if (this._islByPCMemberSwitchIntKey != null) {
            this._islByPCMemberSwitchIntKey.clear();
        }
        if (this._danglingIsls != null) {
            this._danglingIsls.clear();
        }
        if (this._danglingNpvLinks != null) {
            this._danglingNpvLinks.clear();
        }
        if (this._restrictedTopologyFabrics != null) {
            this._restrictedTopologyFabrics.clear();
        }
        if (this._restrictedTopologyEndPorts != null) {
            this._restrictedTopologyEndPorts.clear();
        }
        if (this._targetSwitches != null) {
            this._targetSwitches.clear();
        }
        if (this._sourceSwitches != null) {
            this._sourceSwitches.clear();
        }
        if (this._ivrSwitches != null) {
            this._ivrSwitches.clear();
        }
        if (this._restrictedTopologyTargetSwitchLinks != null) {
            this._restrictedTopologyTargetSwitchLinks.clear();
        }
        if (this._restrictedTopologySourceSwitchLinks != null) {
            this._restrictedTopologySourceSwitchLinks.clear();
        }
        if (this._restrictedTopologySourceToTargetSwitchLinks != null) {
            this._restrictedTopologySourceToTargetSwitchLinks.clear();
        }
        this._selectedEndPorts = new HashedArrayList<EndPort>();
        this._selectedEndPorts.addAll(selectedEndPorts);
        this._restrictByHost = byHost;
        HashMap<Vsan, Vsan> restrictedTopologyVsans = null;
        this._restrictedTopologyFabrics = new HashMap();
        Fabric f = null;
        for (int i = 0; i < this._selectedEndPorts.size(); ++i) {
            Vsan[] vsans;
            EndPort host = this._selectedEndPorts.get(i);
            if (host == null || (f = host.getFabric()) == null || (vsans = host.getVsans()) == null || vsans.length == 0) continue;
            restrictedTopologyVsans = this._restrictedTopologyFabrics.get(f);
            if (restrictedTopologyVsans == null) {
                restrictedTopologyVsans = new HashMap();
            }
            for (int k = 0; k < vsans.length; ++k) {
                Vsan vsan = vsans[k];
                if (vsan == null) continue;
                restrictedTopologyVsans.put(vsan, vsan);
            }
            if (restrictedTopologyVsans.size() <= 0) continue;
            this._restrictedTopologyFabrics.put(f, restrictedTopologyVsans);
        }
        Fabric[] fabrics = San.getInstance().getFabrics();
        Fabric fabric = null;
        if (fabrics != null && fabrics.length > 0) {
            for (int i = 0; i < fabrics.length; ++i) {
                fabric = fabrics[i];
                if (!San.getInstance().isMemberOfRestrictedTopology(fabric)) continue;
                Switch[] switches = fabric.getSwitches();
                for (int j = 0; j < switches.length; ++j) {
                    SwitchBase switchBase = (SwitchBase)switches[j].getBaseModelObject();
                    if (switchBase == null || !San.getInstance().isMemberOfRestrictedTopology(switches[j])) continue;
                    this.addSwitch(switchBase, fabric);
                }
                Isl[] isls = fabric.getIsls();
                for (int j = 0; j < isls.length; ++j) {
                    IslBase islBase = (IslBase)isls[j].getBaseModelObject();
                    if (islBase == null || !San.getInstance().isMemberOfRestrictedTopology(isls[j])) continue;
                    this.addIsl(islBase, fabric);
                }
                NpvLink[] npvLinks = fabric.getNpvLinks();
                for (int j = 0; j < npvLinks.length; ++j) {
                    NpvLinkBase npvLinkBase = (NpvLinkBase)npvLinks[j].getBaseModelObject();
                    if (npvLinkBase == null || !San.getInstance().isMemberOfRestrictedTopology(npvLinks[j])) continue;
                    this.addNpvLink(npvLinkBase, fabric);
                }
            }
        }
        this.addEndPorts();
        switch (this._pathType) {
            case 0: {
                AbstractFcLink[] links = this.getRestrictdTopologyAbstractFcLinks();
                if (links == null) break;
                WwnKey sw1PK = null;
                WwnKey sw2PK = null;
                for (int i = 0; i < links.length; ++i) {
                    sw1PK = links[i].getSwitch1PK();
                    sw2PK = links[i].getSwitch2PK();
                    if (sw1PK == null || sw2PK == null) continue;
                    if (this._targetSwitches.get(sw1PK) != null && this._sourceSwitches.get(sw2PK) != null) {
                        this._restrictedTopologySourceToTargetSwitchLinks.add(links[i]);
                        continue;
                    }
                    if (this._targetSwitches.get(sw2PK) != null && this._sourceSwitches.get(sw1PK) != null) {
                        this._restrictedTopologySourceToTargetSwitchLinks.add(links[i]);
                        continue;
                    }
                    if (this._targetSwitches.get(sw1PK) != null || this._targetSwitches.get(sw2PK) != null) {
                        this._restrictedTopologyTargetSwitchLinks.add(links[i]);
                        continue;
                    }
                    if (this._sourceSwitches.get(sw2PK) == null && this._sourceSwitches.get(sw1PK) == null) continue;
                    this._restrictedTopologySourceSwitchLinks.add(links[i]);
                }
                break;
            }
            case 2: {
                HashMap<WwnKey, Switch> _shortestPathSwitchByPK = new HashMap<WwnKey, Switch>();
                ShortestPathAlgorithm shortestPathAlgorithm = new ShortestPathAlgorithm();
                for (Switch sourceSwitch : this._sourceSwitches.values()) {
                    for (Switch targetSwitch : this._targetSwitches.values()) {
                        ArrayList<ShortestPathNodeIf> shortestPath;
                        if (!targetSwitch.getFabric().equals(sourceSwitch.getFabric()) || (shortestPath = shortestPathAlgorithm.findShortestPath(this.getRestrictdTopologySwitches(), this.getRestrictdTopologyAbstractFcLinks(), sourceSwitch, targetSwitch)) == null) continue;
                        Switch sw = null;
                        this._logger.debug((Object)("shortestPath between " + sourceSwitch.getName() + " " + targetSwitch.getName()));
                        for (int k = 0; k < shortestPath.size(); ++k) {
                            sw = (Switch)shortestPath.get(k);
                            this._logger.debug((Object)("shortestPath " + k + " " + sw.getName()));
                            _shortestPathSwitchByPK.put(sw.getSwitchPK(), sw);
                        }
                        this._logger.debug((Object)"");
                    }
                }
                Switch ivrSwitch2 = null;
                for (Switch ivrSwitch2 : this._ivrSwitches.values()) {
                    _shortestPathSwitchByPK.put(ivrSwitch2.getSwitchPK(), ivrSwitch2);
                }
                HashedArrayList<WwnKey> sws = new HashedArrayList<WwnKey>(this._switchByPK.keySet());
                if (sws != null) {
                    PKIf swPK = null;
                    for (int i = 0; i < sws.size(); ++i) {
                        Switch sw;
                        Switch switchInShortestPath;
                        swPK = (PKIf)sws.get(i);
                        if (swPK == null || (switchInShortestPath = (Switch)_shortestPathSwitchByPK.get(swPK)) != null || (sw = this._switchByPK.remove(swPK)) == null) continue;
                        this._logger.debug((Object)("removed  switch=" + swPK));
                        if (sw.getInetAddress() != null) {
                            this.removeSwitchByIpAddress(sw.getInetAddress());
                        }
                        this.removeDeadEndIsls();
                    }
                }
                this.removeLongerIsls(shortestPathAlgorithm.getShortestFcLinksHashMap());
                break;
            }
            case 1: {
                int numSwitchesRemoved = 0;
                do {
                    numSwitchesRemoved = this.removeDeadEndSwitches();
                } while ((numSwitchesRemoved += this.removeSwitchOnlyLoops()) > 0);
            }
        }
        San.getInstance().setPeersUsingSanSwitches();
    }

    int removeNonEdgeSwitches() {
        int numSwitchesRemoved = 0;
        Switch[] sws = this.getRestrictdTopologySwitches();
        if (sws != null) {
            for (int i = 0; i < sws.length; ++i) {
                Switch sw;
                PKIf swPK = sws[i].getPK();
                if (this._targetSwitches.get(swPK) != null || this._sourceSwitches.get(swPK) != null || (sw = this._switchByPK.remove(swPK)) == null) continue;
                this._logger.debug((Object)("removed  switch=" + swPK));
                if (sw.getInetAddress() != null) {
                    this.removeSwitchByIpAddress(sw.getInetAddress());
                }
                ++numSwitchesRemoved;
            }
        }
        return numSwitchesRemoved;
    }

    int removeSwitchOnlyLoops() {
        HashedArrayList sws;
        NpvLink[] npvls;
        int numSwitchesRemoved = 0;
        HashMap<PKIf, ArrayList<PKIf>> connectedSwitch = new HashMap<PKIf, ArrayList<PKIf>>();
        PKIf sw1pk = null;
        PKIf sw2pk = null;
        Isl[] isls = this.getRestrictdTopologyIsls();
        if (isls != null) {
            Isl isl = null;
            for (int i = 0; i < isls.length; ++i) {
                isl = isls[i];
                if (isl == null || isl.getSwitch1() == null || isl.getSwitch2() == null) continue;
                sw1pk = isl.getSwitch1().getPK();
                sw2pk = isl.getSwitch2().getPK();
                this.addSwitch(sw1pk, sw2pk, connectedSwitch);
                this.addSwitch(sw2pk, sw1pk, connectedSwitch);
            }
        }
        if ((npvls = this.getRestrictdTopologyNpvLinks()) != null) {
            NpvLink npvl = null;
            for (int i = 0; i < npvls.length; ++i) {
                npvl = npvls[i];
                if (npvl == null || npvl.getSwitch1() == null || npvl.getSwitch2() == null) continue;
                sw1pk = npvl.getSwitch1().getPK();
                sw2pk = npvl.getSwitch2().getPK();
                this.addSwitch(sw1pk, sw2pk, connectedSwitch);
                this.addSwitch(sw2pk, sw1pk, connectedSwitch);
            }
        }
        HashMap<PKIf, PKIf> endPortSwitch = new HashMap<PKIf, PKIf>();
        HashedArrayList<EndPort> endPortList = new HashedArrayList<EndPort>(this.getRestrictdTopologyEndPorts().keySet());
        if (endPortList != null) {
            EndPort endPort = null;
            for (int i = 0; i < endPortList.size(); ++i) {
                endPort = (EndPort)endPortList.get(i);
                if (endPort == null || endPortSwitch.get(endPort.getSwitch().getPK()) != null) continue;
                endPortSwitch.put(endPort.getSwitch().getPK(), endPort.getSwitch().getPK());
            }
        }
        if ((sws = new HashedArrayList(connectedSwitch.keySet())) != null) {
            PKIf swPK = null;
            HashMap<PKIf, PKIf> map = new HashMap<PKIf, PKIf>();
            for (int i = 0; i < sws.size(); ++i) {
                ArrayList<PKIf> sw2pks;
                swPK = (PKIf)sws.get(i);
                if (swPK == null || endPortSwitch.get(swPK) != null || (sw2pks = connectedSwitch.get(swPK)) == null || sw2pks.size() != 2) continue;
                map.put(swPK, swPK);
            }
            HashedArrayList linearConnectedSwitch = new HashedArrayList(map.keySet());
            if (linearConnectedSwitch != null) {
                for (int i = 0; i < linearConnectedSwitch.size(); ++i) {
                    ArrayList<PKIf> circle = this.getCircularSwitchPath((PKIf)linearConnectedSwitch.get(i), connectedSwitch);
                    if (circle == null || circle.size() <= 0) continue;
                    for (int j = 0; j < circle.size(); ++j) {
                        swPK = circle.get(j);
                        this._logger.debug((Object)("REMoving switch=" + swPK));
                        Switch sw = this._switchByPK.remove(swPK);
                        if (sw == null) continue;
                        this._logger.debug((Object)("removed  switch=" + swPK));
                        if (sw.getInetAddress() == null) continue;
                        this.removeSwitchByIpAddress(sw.getInetAddress());
                        ++numSwitchesRemoved;
                    }
                    if (numSwitchesRemoved <= 0) continue;
                    this.removeDeadEndIsls();
                    return numSwitchesRemoved;
                }
            }
        }
        return numSwitchesRemoved;
    }

    ArrayList<PKIf> getCircularSwitchPath(PKIf sw1PK, HashMap<PKIf, ArrayList<PKIf>> connectedSwitch) {
        if (sw1PK == null || connectedSwitch == null) {
            return null;
        }
        ArrayList<PKIf> sw2pks = connectedSwitch.get(sw1PK);
        if (sw2pks == null || sw2pks.size() != 2) {
            return null;
        }
        if (sw2pks.get(0) == null || sw2pks.get(1) == null) {
            return null;
        }
        ArrayList<PKIf> circularSwitchPathA = this.getLinearSwitchPath(sw2pks.get(0), connectedSwitch);
        ArrayList<PKIf> circularSwitchPathB = this.getLinearSwitchPath(sw2pks.get(1), connectedSwitch);
        if (circularSwitchPathA == null || circularSwitchPathA.size() == 0) {
            return null;
        }
        if (circularSwitchPathB == null || circularSwitchPathB.size() == 0) {
            return null;
        }
        PKIf swPK_a = circularSwitchPathA.get(circularSwitchPathA.size() - 1);
        PKIf swPK_b = circularSwitchPathB.get(circularSwitchPathB.size() - 1);
        if (swPK_a == null || swPK_b == null) {
            return null;
        }
        if (!swPK_a.equals(swPK_b)) {
            return null;
        }
        circularSwitchPathA.remove(circularSwitchPathA.size() - 1);
        circularSwitchPathB.remove(circularSwitchPathB.size() - 1);
        circularSwitchPathA.addAll(circularSwitchPathB);
        return circularSwitchPathA;
    }

    ArrayList<PKIf> getLinearSwitchPath(PKIf swpk, HashMap<PKIf, ArrayList<PKIf>> connectedSwitch) {
        ArrayList<PKIf> sw2pks;
        ArrayList<PKIf> linearSwitchPath = new ArrayList<PKIf>();
        PKIf swpkNext = null;
        while ((swpkNext = this.getOtherSwitch(swpk, connectedSwitch)) != null && (sw2pks = connectedSwitch.get(swpkNext)) != null && sw2pks.size() == 2) {
            linearSwitchPath.add(swpkNext);
            swpk = swpkNext;
        }
        return linearSwitchPath;
    }

    PKIf getOtherSwitch(PKIf sw1PK, HashMap<PKIf, ArrayList<PKIf>> connectedSwitch) {
        if (sw1PK == null || connectedSwitch == null) {
            return null;
        }
        ArrayList<PKIf> sw2pks = connectedSwitch.get(sw1PK);
        if (sw2pks == null || sw2pks.size() != 2) {
            return null;
        }
        if (sw2pks.get(0) != null && sw2pks.get(0).equals(sw1PK)) {
            return sw2pks.get(1);
        }
        if (sw2pks.get(1) != null && sw2pks.get(1).equals(sw1PK)) {
            return sw2pks.get(0);
        }
        return null;
    }

    int removeDeadEndSwitches() {
        int i;
        HashedArrayList<Object> sws;
        NpvLink[] npvls;
        int numSwitchesRemoved = 0;
        HashMap<PKIf, ArrayList<PKIf>> connectedSwitch = new HashMap<PKIf, ArrayList<PKIf>>();
        PKIf sw1pk = null;
        PKIf sw2pk = null;
        Isl[] isls = this.getRestrictdTopologyIsls();
        if (isls != null) {
            Isl isl = null;
            for (int i2 = 0; i2 < isls.length; ++i2) {
                isl = isls[i2];
                if (isl == null || isl.getSwitch1() == null || isl.getSwitch2() == null) continue;
                sw1pk = isl.getSwitch1().getPK();
                sw2pk = isl.getSwitch2().getPK();
                this.addSwitch(sw1pk, sw2pk, connectedSwitch);
                this.addSwitch(sw2pk, sw1pk, connectedSwitch);
            }
        }
        if ((npvls = this.getRestrictdTopologyNpvLinks()) != null) {
            NpvLink npvl = null;
            for (int i3 = 0; i3 < npvls.length; ++i3) {
                npvl = npvls[i3];
                if (npvl == null || npvl.getSwitch1() == null || npvl.getSwitch2() == null) continue;
                sw1pk = npvl.getSwitch1().getPK();
                sw2pk = npvl.getSwitch2().getPK();
                this.addSwitch(sw1pk, sw2pk, connectedSwitch);
                this.addSwitch(sw2pk, sw1pk, connectedSwitch);
            }
        }
        HashMap<PKIf, PKIf> endPortSwitch = new HashMap<PKIf, PKIf>();
        HashedArrayList<EndPort> endPortList = new HashedArrayList<EndPort>(this.getRestrictdTopologyEndPorts().keySet());
        if (endPortList != null) {
            EndPort endPort = null;
            for (int i4 = 0; i4 < endPortList.size(); ++i4) {
                endPort = (EndPort)endPortList.get(i4);
                if (endPort == null || endPortSwitch.get(endPort.getSwitch().getPK()) != null) continue;
                endPortSwitch.put(endPort.getSwitch().getPK(), endPort.getSwitch().getPK());
            }
        }
        if ((sws = new HashedArrayList(connectedSwitch.keySet())) != null) {
            PKIf swPK = null;
            for (i = 0; i < sws.size(); ++i) {
                Switch sw;
                ArrayList<PKIf> sw2pks;
                swPK = (PKIf)sws.get(i);
                if (swPK == null || endPortSwitch.get(swPK) != null || (sw2pks = connectedSwitch.get(swPK)) == null || sw2pks.size() > 1 || (sw = this._switchByPK.remove(swPK)) == null) continue;
                this._logger.debug((Object)("removed  switch=" + swPK));
                if (sw.getInetAddress() != null) {
                    this.removeSwitchByIpAddress(sw.getInetAddress());
                }
                this.removeDeadEndIsls();
                ++numSwitchesRemoved;
                break;
            }
        }
        if ((sws = new HashedArrayList<WwnKey>(this._switchByPK.keySet())) != null) {
            PKIf swPK = null;
            for (i = 0; i < sws.size(); ++i) {
                swPK = (PKIf)sws.get(i);
                if (swPK == null || endPortSwitch.get(swPK) != null || connectedSwitch.get(swPK) != null) continue;
                this._logger.debug((Object)("REMoving switch=" + swPK));
                Switch sw = this._switchByPK.remove(swPK);
                if (sw == null) continue;
                this._logger.debug((Object)("removed  switch=" + swPK));
                if (sw.getInetAddress() == null) continue;
                this.removeSwitchByIpAddress(sw.getInetAddress());
                ++numSwitchesRemoved;
            }
        }
        return numSwitchesRemoved;
    }

    private void addSwitch(PKIf sw1pk, PKIf sw2pk, HashMap<PKIf, ArrayList<PKIf>> hashMap) {
        if (sw1pk == null || sw2pk == null || hashMap == null) {
            return;
        }
        ArrayList<PKIf> arrayList = hashMap.get(sw1pk);
        if (arrayList == null) {
            arrayList = new HashedArrayList<PKIf>();
            hashMap.put(sw1pk, arrayList);
        }
        if (!arrayList.contains(sw2pk)) {
            arrayList.add(sw2pk);
        }
    }

    private void removeLongerIsls(HashMap<PKIf, ShortestPathLinkIf> shortestLinks) {
        NpvLink[] npvls;
        PKIf pk;
        Isl mem;
        int j;
        List<Isl> members;
        Isl[] isls = this.getRestrictdTopologyIsls();
        if (isls != null) {
            Isl isl = null;
            for (int i = 0; i < isls.length; ++i) {
                IslPK islPK;
                isl = isls[i];
                if (isl == null || shortestLinks.containsKey(islPK = (IslPK)isl.getPK())) continue;
                this.removeIsl(islPK.getSwitchIntKey1());
                this.removeIsl(islPK.getSwitchIntKey2());
                if (!isl.isPortChannel() || isl.getNumPCMembers() <= 0) continue;
                members = isl.getPCMemberLinksAsIsls();
                for (j = 0; j < members.size(); ++j) {
                    mem = (ChannelMemberIsl)members.get(j);
                    pk = (IslPK)mem.getPK();
                    this._islByPCMemberSwitchIntKey.remove(((IslPK)pk).getSwitchIntKey1());
                    this._islByPCMemberSwitchIntKey.remove(((IslPK)pk).getSwitchIntKey2());
                }
            }
        }
        if ((npvls = this.getRestrictdTopologyNpvLinks()) != null) {
            NpvLink npvl = null;
            for (int i = 0; i < npvls.length; ++i) {
                npvl = npvls[i];
                if (npvl == null || shortestLinks.containsKey(npvl.getPK()) || (npvl = this._npvLinkByFPortPK.remove(npvl.getFPortPK())) == null || !npvl.isPortChannel() || npvl.getNumPCMembers() <= 0) continue;
                members = npvl.getPCMemberLinksAsNpvLink();
                for (j = 0; j < members.size(); ++j) {
                    mem = (ChannelMemberNpvLink)members.get(j);
                    pk = (SwitchIntKey)mem.getPK();
                    this._npvLinkByPCMemberSwitchIntKey.remove(pk);
                }
            }
        }
    }

    private void removeDeadEndIsls() {
        NpvLink[] npvls;
        PKIf pk;
        Isl mem;
        int j;
        List<Isl> members;
        Isl[] isls = this.getRestrictdTopologyIsls();
        if (isls != null) {
            Isl isl = null;
            for (int i = 0; i < isls.length; ++i) {
                isl = isls[i];
                if (isl == null || this.findSwitchByPKInRestrictedTopology(isl.getSwitch1PK()) != null && this.findSwitchByPKInRestrictedTopology(isl.getSwitch2PK()) != null) continue;
                this._logger.debug((Object)("removing isl=" + isl.getPK()));
                IslPK islPK = (IslPK)isl.getPK();
                if (isl == null || !islPK.equals(isl.getPK())) continue;
                Isl removedIsl = null;
                removedIsl = (Isl)this.removeIsl(islPK.getSwitchIntKey1());
                removedIsl = (Isl)this.removeIsl(islPK.getSwitchIntKey2());
                if (!isl.isPortChannel() || isl.getNumPCMembers() <= 0) continue;
                members = isl.getPCMemberLinksAsIsls();
                for (j = 0; j < members.size(); ++j) {
                    mem = (ChannelMemberIsl)members.get(j);
                    pk = (IslPK)mem.getPK();
                    removedIsl = this._islByPCMemberSwitchIntKey.remove(((IslPK)pk).getSwitchIntKey1());
                    removedIsl = this._islByPCMemberSwitchIntKey.remove(((IslPK)pk).getSwitchIntKey2());
                }
            }
        }
        if ((npvls = this.getRestrictdTopologyNpvLinks()) != null) {
            NpvLink npvl = null;
            for (int i = 0; i < npvls.length; ++i) {
                npvl = npvls[i];
                if (npvl == null || this.findSwitchByPKInRestrictedTopology(npvl.getSwitch1PK()) != null && this.findSwitchByPKInRestrictedTopology(npvl.getSwitch2PK()) != null) continue;
                this._logger.debug((Object)("removing npvl=" + npvl.getPK()));
                NpvLink removedNpvLink = null;
                removedNpvLink = npvl = this._npvLinkByFPortPK.remove(npvl.getFPortPK());
                if (npvl == null || !npvl.isPortChannel() || npvl.getNumPCMembers() <= 0) continue;
                members = npvl.getPCMemberLinksAsNpvLink();
                for (j = 0; j < members.size(); ++j) {
                    mem = (ChannelMemberNpvLink)members.get(j);
                    pk = (SwitchIntKey)mem.getPK();
                    removedNpvLink = this._npvLinkByPCMemberSwitchIntKey.remove(pk);
                }
            }
        }
    }

    public boolean isMemberOfRestrictedTopology(EndPort endPort) {
        if (endPort == null) {
            return false;
        }
        Fabric f = endPort.getFabric();
        if (f == null) {
            return false;
        }
        return this._restrictedTopologyEndPorts.get(endPort) != null;
    }

    public boolean isMemberOfRestrictedTopology(Enclosure enclosure) {
        HashMap<EndPort, EndPort> topology = San.getInstance().getRestrictdTopologyEndPorts();
        if (enclosure == null || topology == null || topology.size() == 0) {
            return false;
        }
        ArrayList<EndPort> endPorts = enclosure.getMembers();
        if (endPorts == null || endPorts.size() == 0) {
            return false;
        }
        EndPort endPort = null;
        for (int i = 0; i < endPorts.size(); ++i) {
            endPort = endPorts.get(i);
            if (endPort == null || topology.get(endPort) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberOfRestrictedTopology(Switch sw) {
        HashMap<Fabric, HashMap<Vsan, Vsan>> topology = this._restrictedTopologyFabrics;
        if (sw == null) {
            return false;
        }
        if (topology == null || topology.size() == 0) {
            return false;
        }
        Fabric f = sw.getFabric();
        if (f == null) {
            return false;
        }
        HashMap<Vsan, Vsan> topologyVsans = topology.get(f);
        if (topologyVsans == null || topologyVsans.size() == 0) {
            return false;
        }
        Vsan[] switchVsans = sw.getVsans();
        if (switchVsans == null || switchVsans.length == 0) {
            return false;
        }
        for (int i = 0; i < switchVsans.length; ++i) {
            if (topologyVsans.get(switchVsans[i]) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberOfRestrictedTopology(Isl isl) {
        HashMap<Fabric, HashMap<Vsan, Vsan>> topology = this._restrictedTopologyFabrics;
        if (isl == null || topology == null || topology.size() == 0) {
            return false;
        }
        Fabric f = isl.getFabric();
        if (f == null) {
            return false;
        }
        HashMap<Vsan, Vsan> topologyVsans = topology.get(f);
        if (topologyVsans == null || topologyVsans.size() == 0) {
            return false;
        }
        Vsan[] islVsans = isl.getVsans();
        if (islVsans == null || islVsans.length == 0) {
            return false;
        }
        for (int i = 0; i < islVsans.length; ++i) {
            if (topologyVsans.get(islVsans[i]) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberOfRestrictedTopology(NpvLink npvLink) {
        HashMap<Fabric, HashMap<Vsan, Vsan>> topology = this._restrictedTopologyFabrics;
        if (npvLink == null || topology == null || topology.size() == 0) {
            return false;
        }
        Fabric f = npvLink.getFabric();
        if (f == null) {
            return false;
        }
        HashMap<Vsan, Vsan> topologyVsans = topology.get(f);
        if (topologyVsans == null || topologyVsans.size() == 0) {
            return false;
        }
        Vsan[] npvLinkVsans = npvLink.getVsans();
        if (npvLinkVsans == null || npvLinkVsans.length == 0) {
            return false;
        }
        for (int i = 0; i < npvLinkVsans.length; ++i) {
            if (topologyVsans.get(npvLinkVsans[i]) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberOfRestrictedTopology(Fabric fabric) {
        return this._restrictedTopologyFabrics.get(fabric) != null;
    }

    private void addZoneMembersToMap(EndPort selectedEndPort, EnforcedZone zone, HashMap<EndPort, EndPort> map) {
        if (zone == null || map == null) {
            return;
        }
        Vsan vsan = zone.getVsan();
        HashMap<Object, Object> zoneMembers = new HashMap();
        zoneMembers = zone.getEndPortsAsHashMap();
        if (zoneMembers != null && zoneMembers.get(selectedEndPort) != null) {
            Set<Object> keys = zoneMembers.keySet();
            for (EndPort endPort : keys) {
                Switch sw;
                PKIf pk;
                if ((endPort == null || !this._restrictByHost || !endPort.isTarget()) && (this._restrictByHost || !endPort.isInitiator())) continue;
                if (vsan == null) {
                    map.put(endPort, endPort);
                    pk = endPort.getSwitch().getPK();
                    sw = this.findSwitchByPKInRestrictedTopology(pk);
                    if (sw == null) {
                        sw = this.addSwitch((WwnKey)pk);
                    }
                    if (sw == null) continue;
                    this._ivrSwitches.put((WwnKey)pk, sw);
                    if (endPort.isTarget()) {
                        this._targetSwitches.put((WwnKey)pk, sw);
                    }
                    if (!endPort.isInitiator()) continue;
                    this._sourceSwitches.put((WwnKey)pk, sw);
                    continue;
                }
                if (!endPort.isMemberOfVsan(vsan.getId())) continue;
                map.put(endPort, endPort);
                pk = endPort.getSwitch().getPK();
                sw = this.findSwitchByPKInRestrictedTopology(pk);
                if (sw == null) {
                    sw = this.addSwitch((WwnKey)pk);
                }
                if (sw == null) continue;
                if (endPort.isTarget()) {
                    this._targetSwitches.put((WwnKey)pk, sw);
                }
                if (!endPort.isInitiator()) continue;
                this._sourceSwitches.put((WwnKey)pk, sw);
            }
        }
    }

    public HashMap<EndPort, EndPort> getRestrictdTopologyEndPorts() {
        return this._restrictedTopologyEndPorts;
    }

    public void addEndPorts() {
        if (this._selectedEndPorts == null || this._selectedEndPorts.size() == 0) {
            return;
        }
        EndPort endPort = null;
        Vsan vsan = null;
        Vsan[] vsans = null;
        EnforcedZone[] zones = null;
        EnforcedZone zone = null;
        for (int i = 0; i < this._selectedEndPorts.size(); ++i) {
            try {
                endPort = this._selectedEndPorts.get(i);
                if (endPort == null) continue;
                try {
                    if (endPort != null && endPort.getFabric() != null && (zones = endPort.getFabric().getIvrEnforcedZones()) != null) {
                        for (int k = 0; k < zones.length; ++k) {
                            zone = zones[k];
                            if (zone == null) continue;
                            this.addZoneMembersToMap(endPort, zone, this._restrictedTopologyEndPorts);
                        }
                    }
                }
                catch (Exception ex) {
                    this._logger.error((Object)"error adding IVR zone members", (Throwable)ex);
                }
                vsans = endPort.getVsans();
                if (vsans == null || vsans.length == 0) continue;
                for (int j = 0; j < vsans.length; ++j) {
                    vsan = vsans[j];
                    if (vsan == null) continue;
                    try {
                        zones = vsan.getEnforcedZones();
                        if (zones == null) continue;
                        for (int k = 0; k < zones.length; ++k) {
                            zone = zones[k];
                            if (zone == null) continue;
                            this.addZoneMembersToMap(endPort, zone, this._restrictedTopologyEndPorts);
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        this._logger.error((Object)"error adding zone members", (Throwable)ex);
                    }
                }
                this._restrictedTopologyEndPorts.put(endPort, endPort);
                PKIf pk = endPort.getSwitch().getPK();
                Switch sw = this.findSwitchByPKInRestrictedTopology(pk);
                if (sw == null) {
                    sw = this.addSwitch((WwnKey)pk);
                }
                if (sw == null) continue;
                if (endPort.isTarget()) {
                    this._targetSwitches.put((WwnKey)pk, sw);
                }
                if (!endPort.isInitiator()) continue;
                this._sourceSwitches.put((WwnKey)pk, sw);
                continue;
            }
            catch (Exception ex) {
                this._logger.error((Object)"error in getRestrictdTopologyEndPorts", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fabric[] getRestrictdTopologyFabrics() {
        HashedArrayList<Fabric> fabrics = new HashedArrayList<Fabric>(this._restrictedTopologyFabrics.size());
        HashMap<Fabric, HashMap<Vsan, Vsan>> hashMap = this._restrictedTopologyFabrics;
        synchronized (hashMap) {
            for (Fabric f : this._restrictedTopologyFabrics.keySet()) {
                ((ArrayList)fabrics).add(f);
            }
        }
        return fabrics.toArray(new Fabric[fabrics.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Switch[] getRestrictdTopologySwitches() {
        HashedArrayList<Switch> switches = new HashedArrayList<Switch>(this._switchByPK.size());
        HashMap<WwnKey, Switch> hashMap = this._switchByPK;
        synchronized (hashMap) {
            for (Map.Entry<WwnKey, Switch> entry : this._switchByPK.entrySet()) {
                Switch sw = entry.getValue();
                ((ArrayList)switches).add(sw);
            }
        }
        return switches.toArray(new Switch[switches.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Isl[] getRestrictdTopologyIsls() {
        HashedArrayList<Isl> isls = new HashedArrayList<Isl>(this._islBySwitchIntKey.size());
        HashMap<SwitchIntKey, Isl> hashMap = this._islBySwitchIntKey;
        synchronized (hashMap) {
            for (Map.Entry<SwitchIntKey, Isl> entry : this._islBySwitchIntKey.entrySet()) {
                Isl isl = entry.getValue();
                if (!((PKIf)entry.getKey()).equals(((IslPK)isl.getPK())._p1)) continue;
                ((ArrayList)isls).add(isl);
            }
        }
        return isls.toArray(new Isl[isls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NpvLink[] getRestrictdTopologyNpvLinks() {
        HashedArrayList<NpvLink> npvLinks = new HashedArrayList<NpvLink>(this._npvLinkByFPortPK.size());
        HashMap<SwitchIntKey, NpvLink> hashMap = this._npvLinkByFPortPK;
        synchronized (hashMap) {
            for (Map.Entry<SwitchIntKey, NpvLink> entry : this._npvLinkByFPortPK.entrySet()) {
                NpvLink isl = entry.getValue();
                if (!entry.getKey().equals(isl.getFPortPK())) continue;
                ((ArrayList)npvLinks).add(isl);
            }
        }
        return npvLinks.toArray(new NpvLink[npvLinks.size()]);
    }

    public AbstractFcLink[] getRestrictdTopologyAbstractFcLinks() {
        int i;
        Isl[] islList = this.getRestrictdTopologyIsls();
        NpvLink[] npvLinkList = this.getRestrictdTopologyNpvLinks();
        int linkCount = islList.length + npvLinkList.length;
        HashedArrayList<Isl> fcLinkArray = new HashedArrayList<Isl>(linkCount);
        for (i = 0; i < islList.length; ++i) {
            ((ArrayList)fcLinkArray).add(islList[i]);
        }
        for (i = 0; i < npvLinkList.length; ++i) {
            ((ArrayList)fcLinkArray).add(npvLinkList[i]);
        }
        return fcLinkArray.toArray(new AbstractFcLink[linkCount]);
    }

    private Switch addSwitch(SwitchBase switchBase, Fabric fabric) {
        if (fabric == null) {
            return null;
        }
        if (switchBase == null) {
            this._logger.debug((Object)"addSwitch() switchBase == null", (Throwable)new NullPointerException());
            return null;
        }
        if (switchBase.getFabricPK() == null) {
            this._logger.debug((Object)"addSwitch() switchBase.getFabricPK() == null", (Throwable)new NullPointerException());
            return null;
        }
        Switch sw = this._switchByPK.get(switchBase.getPK());
        boolean added = false;
        if (sw == null) {
            sw = new Switch(switchBase, fabric, this);
            added = true;
            sw.setFCPortMap(fabric.findSwitchByPK(switchBase.getPK()).getFCPortMap());
        }
        if (this._switchByPK.get(switchBase.getPK()) == null) {
            this._switchByPK.put((WwnKey)switchBase.getSwitchPK(), sw);
        }
        if (switchBase.getPK() == null) {
            this._logger.debug((Object)("addSwitch() switchBase.getPK()==null" + sw), (Throwable)new NullPointerException());
        }
        this.addSwitchByIpAddress(sw);
        if (this.inited() && added) {
            this.addPropertyChangeEvent(new PropertyChangeEvent(this, "switchAdded", null, sw));
        }
        this.addDanglingLinks();
        return sw;
    }

    private void addSwitchByIpAddress(Switch sw) {
        if (sw.getInetAddress() == null) {
            this._logger.debug((Object)("addSwitchByIpAddress() sw.getInetAddress()==null sw=" + sw));
            return;
        }
        if (sw.getInetAddress() != null && this._switchByIpAddress.get(sw.getInetAddress()) == null) {
            this._switchByIpAddress.put(sw.getInetAddress(), sw);
        }
    }

    Switch addSwitch(WwnKey switchKey) {
        Switch sw = this._switchByPK.get(switchKey);
        if (sw == null && ClientController.getInstance().isServerActive()) {
            try {
                this._logger.debug((Object)("adding switch - " + switchKey));
                SwitchBase swBase = ClientController.getInstance().assertModelFacade().findSwitchByPK(switchKey);
                if (swBase == null) {
                    this._logger.debug((Object)("addSwitch " + switchKey + " swBase == null"), (Throwable)new NullPointerException());
                    return null;
                }
                sw = this.addSwitch(swBase, San.getInstance().getFabricBySwitchPK(swBase.getPK()));
                this._logger.debug((Object)("switch added for switchkey - " + switchKey + " - " + sw));
                if (sw != null) {
                    if (this.inited()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                San.this.firePropertyChangeEvents();
                            }
                        });
                    }
                    final Switch swtch = sw;
                    Runnable authSw = new Runnable(){

                        @Override
                        public void run() {
                            San.this._logger.debug((Object)("authenticating switch - " + swtch));
                            swtch.authenticate();
                            San.this._logger.debug((Object)("DONE authenticating switch - " + swtch));
                        }
                    };
                    _executor.execute(authSw);
                }
                return sw;
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in addSwitch " + switchKey), (Throwable)ex);
            }
        }
        return sw;
    }

    private Isl addIsl(IslBase islBase, Fabric fabric) {
        Isl isl;
        this._logger.trace((Object)"addIsl(IslBase)");
        if (islBase == null) {
            return null;
        }
        WwnKey switch1PK = islBase.getSwitch1PK();
        WwnKey switch2PK = islBase.getSwitch2PK();
        if (switch1PK != null) {
            this.addSwitch(switch1PK);
        }
        if (switch2PK != null) {
            this.addSwitch(switch2PK);
        }
        if ((isl = new Isl((AbstractFcLinkBase)islBase, fabric, this)).getSwitch1() == null && isl.getSwitch2() == null) {
            this._logger.info((Object)("addIsl() isl=" + isl.getPK().toString() + " MISSING_SWITCH_BOTH_SWITCHES"), (Throwable)new NullPointerException());
            return null;
        }
        if (isl.getSwitch1() == null) {
            this._logger.info((Object)("addIsl() isl=" + isl.getPK().toString() + " MISSING_SWITCH_1"), (Throwable)new NullPointerException());
            int i = this._danglingIsls.indexOf(islBase);
            if (i == -1) {
                this._danglingIsls.add(islBase);
            } else {
                this._danglingIsls.set(i, islBase);
            }
            return null;
        }
        if (isl.getSwitch2() == null) {
            this._logger.info((Object)("addIsl() isl=" + isl.getPK().toString() + " MISSING_SWITCH_2"), (Throwable)new NullPointerException());
            int i = this._danglingIsls.indexOf(islBase);
            if (i == -1) {
                this._danglingIsls.add(islBase);
            } else {
                this._danglingIsls.set(i, islBase);
            }
            return null;
        }
        this._logger.trace((Object)("addIsl() islAdded " + islBase.toString()));
        this._logger.trace((Object)("addIsl() islAdded " + isl.toString()));
        this._islBySwitchIntKey.put(islBase.getIslPK().getSwitchIntKey1(), isl);
        this._islBySwitchIntKey.put(islBase.getIslPK().getSwitchIntKey2(), isl);
        if (isl.isPortChannel() && isl.getNumPCMembers() > 0) {
            List<Isl> members = isl.getPCMemberLinksAsIsls();
            for (int i = 0; i < members.size(); ++i) {
                ChannelMemberIsl mem = (ChannelMemberIsl)members.get(i);
                IslPK pk = (IslPK)mem.getPK();
                this._islByPCMemberSwitchIntKey.put(pk.getSwitchIntKey1(), isl);
                this._islByPCMemberSwitchIntKey.put(pk.getSwitchIntKey2(), isl);
            }
        }
        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "islAdded", null, isl));
        return isl;
    }

    private NpvLink addNpvLink(NpvLinkBase npvlBase, Fabric fabric) {
        if (npvlBase == null) {
            return null;
        }
        WwnKey coreSwitchPK = npvlBase.getCoreSwitchPK();
        WwnKey edgeSwitchPK = npvlBase.getEdgeSwitchPK();
        if (coreSwitchPK != null && this.addSwitch(coreSwitchPK) == null) {
            int i = this._danglingNpvLinks.indexOf(npvlBase);
            if (i == -1) {
                this._danglingNpvLinks.add(npvlBase);
            } else {
                this._danglingNpvLinks.set(i, npvlBase);
            }
            this._logger.info((Object)("addNpvLink failed: core switch not found in client & server " + coreSwitchPK));
            return null;
        }
        if (edgeSwitchPK != null && this.addSwitch(edgeSwitchPK) == null) {
            int i = this._danglingNpvLinks.indexOf(npvlBase);
            if (i == -1) {
                this._danglingNpvLinks.add(npvlBase);
            } else {
                this._danglingNpvLinks.set(i, npvlBase);
            }
            this._logger.info((Object)("addNpvLink failed: edge switch not found in client & server " + edgeSwitchPK));
            return null;
        }
        NpvLink npvl = new NpvLink((AbstractFcLinkBase)npvlBase, fabric, this);
        this._npvLinkByFPortPK.put(npvlBase.getFPortPK(), npvl);
        if (npvl.isPortChannel() && npvl.getNumPCMembers() > 0) {
            List<NpvLink> members = npvl.getPCMemberLinksAsNpvLink();
            for (int i = 0; i < members.size(); ++i) {
                ChannelMemberNpvLink mem = (ChannelMemberNpvLink)members.get(i);
                SwitchIntKey pk = (SwitchIntKey)mem.getPK();
                this._npvLinkByPCMemberSwitchIntKey.put(pk, npvl);
            }
        }
        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "npvLinkAdded", null, npvl));
        return npvl;
    }

    private void addDanglingLinks() {
        int i;
        if (this._danglingIsls != null && this._danglingIsls.size() > 0) {
            for (i = this._danglingIsls.size() - 1; i >= 0; --i) {
                try {
                    IslBase islBase1 = ClientController.getInstance().assertModelFacade().findIslBySwitchIntKey(this._danglingIsls.get(i).getIslPK().getSwitchIntKey1());
                    IslBase islBase2 = ClientController.getInstance().assertModelFacade().findIslBySwitchIntKey(this._danglingIsls.get(i).getIslPK().getSwitchIntKey2());
                    if (islBase1 == null || islBase2 == null || !islBase1.getIslPK().equals(islBase2.getIslPK())) {
                        this._danglingIsls.remove(i);
                        continue;
                    }
                    Isl isl = this.addIsl(islBase1, San.getInstance().getFabricByIslSwitchIntKey(islBase1.getIslPK().getSwitchIntKey1()));
                    if (isl == null) continue;
                    this._danglingIsls.remove(i);
                    continue;
                }
                catch (Exception ex) {
                    this._danglingIsls.remove(i);
                    this._logger.warn((Object)ex);
                }
            }
        }
        if (this._danglingNpvLinks != null && this._danglingNpvLinks.size() > 0) {
            for (i = this._danglingNpvLinks.size() - 1; i >= 0; --i) {
                try {
                    NpvLinkBase npvLinkBase = ClientController.getInstance().assertModelFacade().findNpvLinkByFPortPK(this._danglingNpvLinks.get(i).getFPortPK());
                    if (npvLinkBase == null) {
                        this._danglingNpvLinks.remove(i);
                        continue;
                    }
                    NpvLink npvLink = this.addNpvLink(npvLinkBase, San.getInstance().getFabricByNpvLinkByFportKey(npvLinkBase.getFPortPK()));
                    if (npvLink == null) continue;
                    this._danglingNpvLinks.remove(i);
                    continue;
                }
                catch (Exception ex) {
                    this._danglingNpvLinks.remove(i);
                    this._logger.warn((Object)ex);
                }
            }
        }
    }

    public void setPeersUsingSanSwitches() {
        final Switch[] sws = this.getRestrictdTopologySwitches();
        Thread t = new Thread("San setPeersUsingSanSwitches Thread"){

            @Override
            public void run() {
                if (sws == null) {
                    return;
                }
                int unmanagableMDS = sws.length;
                do {
                    for (int i = 0; sws != null && i < sws.length; ++i) {
                        if (sws[i] != null) {
                            try {
                                SnmpPeer peer = null;
                                Switch swFromSan = San.getInstance().getSwitchByPK(sws[i].getPK());
                                if (swFromSan == null) continue;
                                peer = swFromSan.getSnmpPeer();
                                sws[i].setSnmpPeer(peer);
                                String sysName = sws[i].getSysName();
                                if (peer != null && sysName != null && sysName.length() > 0) {
                                    peer.setSysName(sysName);
                                }
                                --unmanagableMDS;
                            }
                            catch (Exception ex) {
                                San.this._logger.debug((Object)ex.getMessage(), (Throwable)ex);
                            }
                            continue;
                        }
                        --unmanagableMDS;
                    }
                    if (unmanagableMDS <= 0) continue;
                    try {
                        3.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (unmanagableMDS > 0);
                San.this.firePropertyChangeEvents();
            }
        };
        t.setPriority(1);
        t.start();
    }

    private boolean checkIsPresent(short propId, AbstractModelObject obj, Serializable nval) {
        if (obj == null || nval == null) {
            return false;
        }
        if (propId == 769 || propId == 1025 || propId == 1281 || propId == 3073 || propId == 1537 || propId == 1793) {
            if (!((Boolean)nval).booleanValue()) {
                obj.setLastScanTime(System.currentTimeMillis());
            }
            obj.setPresent((Boolean)nval);
            if (ClientController.isTrace()) {
                ClientController.trace(obj.toString() + " :::isPresent: " + obj.isPresent());
            }
            return true;
        }
        return false;
    }

    public Isl addIsl(SwitchIntKey swIntKey) {
        this._logger.trace((Object)"addIsl(SwitchIntKey)");
        Isl isl = this._islBySwitchIntKey.get(swIntKey);
        if (isl == null && ClientController.getInstance().isServerActive()) {
            try {
                IslBase islBase = ClientController.getInstance().assertModelFacade().findIslBySwitchIntKey(swIntKey);
                if (islBase == null || !islBase.isPresent()) {
                    return null;
                }
                isl = this.addIsl(islBase, San.getInstance().getFabricByIslSwitchIntKey(islBase.getIslPK().getSwitchIntKey1()));
                if (this.inited()) {
                    this.firePropertyChangeEvents();
                }
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in addIsl " + swIntKey), (Throwable)ex);
            }
        }
        return isl;
    }

    public Isl findIslBySwitchIntKey(PKIf swIntKey, boolean checkPCMembers) {
        Isl isl = this._islBySwitchIntKey.get(swIntKey);
        if (isl == null && checkPCMembers) {
            isl = this._islByPCMemberSwitchIntKey.get(swIntKey);
        }
        if (isl == null) {
            isl = this.addIsl((SwitchIntKey)swIntKey);
        }
        return isl;
    }

    public NpvLink findNpvLinkByFportKey(SwitchIntKey fpkey) {
        return this._npvLinkByFPortPK.get(fpkey);
    }

    public void fabricMembersAdded(BaseModelObject[] o) {
    }

    public void fabricMembersChanged(ChangedModelObject[] o) {
        if (!ClientController.getInstance().isRestrictedTopology()) {
            return;
        }
        if (o == null || o.length == 0) {
            return;
        }
        AbstractModelObject obj = null;
        block79: for (int i = 0; i < o.length; ++i) {
            try {
                if (o[i] == null) continue;
                PKIf pk = o[i].getPK();
                short propId = o[i]._propId;
                short attrType = (short)((propId & 0xFF00) >> 8 << 8);
                Serializable oval = o[i].getOldValue();
                Serializable nval = o[i].getNewValue();
                obj = null;
                switch (attrType) {
                    case 1024: {
                        Switch sw = this.findSwitchByPK((WwnKey)pk);
                        if (sw == null || sw.getUserObject() == null) {
                            return;
                        }
                        obj = sw;
                        switch (propId) {
                            case 1025: {
                                this.checkIsPresent(propId, obj, nval);
                                if (!((Boolean)nval).booleanValue()) break;
                                final Switch swtch = sw;
                                Runnable authSw = new Runnable(){

                                    @Override
                                    public void run() {
                                        San.this._logger.debug((Object)("authenticating switch - " + swtch));
                                        swtch.authenticate();
                                        San.this._logger.debug((Object)("DONE authenticating switch - " + swtch));
                                    }
                                };
                                _executor.execute(authSw);
                                break;
                            }
                            case 1040: {
                                sw.setManagementAddresses((InetAddress[])nval);
                                break;
                            }
                            case 1041: {
                                sw.setManagementAddressInUse((InetAddress)nval);
                                if (nval != null && !this._switchByIpAddress.containsKey(nval)) {
                                    this._switchByIpAddress.put((InetAddress)nval, sw);
                                }
                                final Switch swtch = sw;
                                Runnable authSw = new Runnable(){

                                    @Override
                                    public void run() {
                                        San.this._logger.debug((Object)("authenticating switch - " + swtch));
                                        swtch.authenticate(true);
                                        San.this._logger.debug((Object)("DONE authenticating switch - " + swtch));
                                    }
                                };
                                if (!sw.isManageableByServer()) break;
                                _executor.execute(authSw);
                                break;
                            }
                            case 1039: {
                                ((SwitchBase)sw._baseModelObject).setUnmanageableCause((String)((Object)nval));
                                break;
                            }
                            case 1038: {
                                sw.setManageable((Boolean)nval);
                                break;
                            }
                            case 1047: {
                                VsanDomain oldDomain = (VsanDomain)oval;
                                VsanDomain newDomain = (VsanDomain)nval;
                                if (newDomain != null) {
                                    sw.addVsan(newDomain);
                                    break;
                                }
                                if (oldDomain == null) break;
                                sw.removeVsan(oldDomain._vsanPK._id);
                                break;
                            }
                            case 1034: {
                                sw.setMDS((Boolean)nval);
                                break;
                            }
                            case 1035: {
                                sw.setModelType((Integer)nval);
                                break;
                            }
                            case 1027: {
                                sw.setSysName((String)((Object)nval));
                                break;
                            }
                            case 1028: {
                                sw.setSysContact((String)((Object)nval));
                                break;
                            }
                            case 1029: {
                                sw.setSysLocation((String)((Object)nval));
                                break;
                            }
                            case 1030: {
                                sw.setSysLastBootTime((Long)nval);
                                break;
                            }
                            case 1044: {
                                sw.setStandbySupState((Integer)nval);
                                break;
                            }
                            case 1046: {
                                sw.setFeatureFlags((boolean[])nval);
                                break;
                            }
                            case 1042: {
                                sw.setActiveSupPhysicalIndex((Integer)nval);
                                break;
                            }
                            case 1043: {
                                sw.setStandbySupSlot((Integer)nval);
                                break;
                            }
                            case 1045: {
                                sw.setConnUnitStatus((Integer)nval);
                                break;
                            }
                            case 1031: {
                                sw.setVersion((String)((Object)nval));
                                break;
                            }
                            case 1036: {
                                sw.setModelName((String)((Object)nval));
                                break;
                            }
                            case 1050: {
                                sw.setIsLicenseViolation((Boolean)nval);
                                break;
                            }
                            case 1048: {
                                sw.setTrapRegistered((Boolean)nval);
                                break;
                            }
                            case 1033: {
                                sw.setNumFcPorts((Integer)nval);
                                break;
                            }
                            case 1051: {
                                sw.setLicenses((LicenseInfo[])nval);
                                break;
                            }
                            case 1053: {
                                sw.setFcFeModuleId((Integer)nval);
                                break;
                            }
                            case 1054: {
                                sw.setModuleIndexOffset((Integer)nval);
                                break;
                            }
                            case 1026: {
                                break;
                            }
                            case 1032: {
                                sw.setSerialNumber((String)((Object)nval));
                                break;
                            }
                            case 1052: {
                                sw.setSysDescr((String)((Object)nval));
                                break;
                            }
                            case 1049: {
                                sw.setSyslogRegistered((Boolean)nval);
                                break;
                            }
                            case 1055: {
                                sw.setTelnetEnabled((Boolean)nval);
                                break;
                            }
                            case 1057: {
                                sw.setSSHEnabled((Boolean)nval);
                                break;
                            }
                            case 1056: {
                                sw.setDeviceAliasMode((Integer)nval);
                                break;
                            }
                            case 1065: {
                                sw.setVlanByVsanMap((Map)((Object)nval));
                                break;
                            }
                            case 1066: {
                                sw.setFCoECapable((Boolean)nval);
                                break;
                            }
                            case 1067: {
                                sw.setDelayLinkEnabled((Boolean)nval);
                                break;
                            }
                            case 1068: {
                                sw.setVsanZoneAttrs((Map)((Object)nval));
                                break;
                            }
                            case 1069: {
                                sw.setSwitchLastBootTime((Long)nval);
                            }
                        }
                        break;
                    }
                    case 2048: {
                        break;
                    }
                    case 1536: {
                        break;
                    }
                    case 768: {
                        break;
                    }
                    case 1280: {
                        obj = this.findIslBySwitchIntKey(((IslPK)pk).getSwitchIntKey1(), false);
                        if (obj == null || obj.getUserObject() == null) {
                            return;
                        }
                        AbstractModelObject isl = obj;
                        if (isl == null) break;
                        switch (propId) {
                            case 1284: {
                                ((Isl)isl).setVsanMembership((List)((Object)nval));
                                break;
                            }
                            case 1287: {
                                IslPK islpk;
                                ChannelMemberIsl mem;
                                List<AbstractFcLink> members;
                                if (((AbstractLink)isl).isPortChannel() && ((Isl)isl).getNumPCMembers() > 0) {
                                    members = ((Isl)isl).getPCMemberLinks();
                                    for (int j = 0; j < members.size(); ++j) {
                                        mem = (ChannelMemberIsl)members.get(j);
                                        islpk = (IslPK)mem.getPK();
                                        this._islByPCMemberSwitchIntKey.remove(islpk.getSwitchIntKey1());
                                        this._islByPCMemberSwitchIntKey.remove(islpk.getSwitchIntKey2());
                                    }
                                }
                                ((Isl)isl).setChildren((List)((Object)nval));
                                if (!((AbstractLink)isl).isPortChannel() || ((Isl)isl).getNumPCMembers() <= 0) break;
                                members = ((Isl)isl).getPCMemberLinks();
                                for (int j = 0; j < members.size(); ++j) {
                                    mem = (ChannelMemberIsl)members.get(j);
                                    islpk = (IslPK)mem.getPK();
                                    this._islByPCMemberSwitchIntKey.put(islpk.getSwitchIntKey1(), (Isl)isl);
                                    this._islByPCMemberSwitchIntKey.put(islpk.getSwitchIntKey2(), (Isl)isl);
                                }
                                break;
                            }
                            case 1286: {
                                ((Isl)isl).setConfigChildCount((Short)nval);
                                break;
                            }
                            case 1282: {
                                ((Isl)isl).setOperMode((Short)nval);
                                break;
                            }
                            case 1283: {
                                ((Isl)obj).setOperStatusCause(((Short)nval).shortValue());
                                break;
                            }
                            case 1285: {
                                ((Isl)obj).setAutoCreated((Boolean)nval);
                                break;
                            }
                            case 1288: {
                                ((Isl)obj).setSpeed((Long)nval);
                                break;
                            }
                            case 1289: {
                                ((Isl)obj).setFiconAddresses((Integer)nval);
                                break;
                            }
                            case 1292: {
                                ((Isl)obj).setFcspAuthenticated((Boolean)nval);
                                break;
                            }
                            case 1294: {
                                ((Isl)obj).setEspReady((Boolean)nval);
                                break;
                            }
                            case 1293: {
                                ((Isl)obj).setEspSecure((Boolean)nval);
                                break;
                            }
                            case 1290: {
                                ((Isl)obj).setFcConnectorType((Short)nval);
                                break;
                            }
                            case 1295: {
                                PCMemberTrustSec pcTS = (PCMemberTrustSec)nval;
                                ((Isl)obj).getIslBase().addTrustSec(pcTS.getIfIndexPair(), pcTS);
                            }
                        }
                        this.checkIsPresent(propId, obj, nval);
                        break;
                    }
                    case 3072: {
                        NpvLink npvl = this.findNpvLinkByFportKey((SwitchIntKey)pk);
                        obj = npvl;
                        if (npvl == null || npvl.getUserObject() == null) {
                            return;
                        }
                        switch (propId) {
                            case 3074: {
                                if (nval instanceof Short) {
                                    npvl.setOperStatusCause(((Short)nval).shortValue());
                                    break;
                                }
                                npvl.setOperStatusCause((Integer)nval);
                                break;
                            }
                            case 3075: {
                                npvl.setSpeed((Long)nval);
                                break;
                            }
                            case 3076: {
                                npvl.setVsanMembership((List)((Object)nval));
                                break;
                            }
                            case 3080: {
                                SwitchIntKey fPortPK;
                                ChannelMemberNpvLink mem;
                                List<AbstractFcLink> members;
                                if (npvl.isPortChannel() && npvl.getNumPCMembers() > 0) {
                                    members = npvl.getPCMemberLinks();
                                    for (int j = 0; j < members.size(); ++j) {
                                        mem = (ChannelMemberNpvLink)members.get(j);
                                        fPortPK = (SwitchIntKey)mem.getPK();
                                        this._npvLinkByPCMemberSwitchIntKey.remove(fPortPK);
                                    }
                                }
                                npvl.setChildren((List)((Object)nval));
                                if (!npvl.isPortChannel() || npvl.getNumPCMembers() <= 0) break;
                                members = npvl.getPCMemberLinks();
                                for (int j = 0; j < members.size(); ++j) {
                                    mem = (ChannelMemberNpvLink)members.get(j);
                                    fPortPK = (SwitchIntKey)mem.getPK();
                                    this._npvLinkByPCMemberSwitchIntKey.put(fPortPK, npvl);
                                }
                                break;
                            }
                            case 3079: {
                                npvl.setConfigChildCount((Short)nval);
                                break;
                            }
                            case 3081: {
                                npvl.setOperMode((Short)nval);
                                break;
                            }
                            case 3077: {
                                npvl.setNpPortPK((SwitchIntKey)nval);
                                break;
                            }
                            case 3078: {
                                npvl.setNpPortWwn((Wwn)nval);
                                break;
                            }
                            case 3082: {
                                npvl.setAutoCreated((Boolean)nval);
                            }
                        }
                        this.checkIsPresent(propId, obj, nval);
                        break;
                    }
                    case 1792: {
                        break;
                    }
                    case 2560: {
                        break;
                    }
                    case 2304: {
                        break;
                    }
                    case 512: {
                        continue block79;
                    }
                    default: {
                        if (!ClientController.isTrace()) break;
                        ClientController.trace("Unknown type changed : " + attrType + ": " + o[i].getClass().getName() + ": " + o[i]);
                    }
                }
                if (obj != null) {
                    this._logger.debug((Object)("CHANGED: " + o[i] + " ::: " + propId + " : " + oval + " -> " + nval));
                    continue;
                }
                this._logger.debug((Object)("Couldn't find(CHANGED): " + o[i] + " ::: " + propId + " : " + oval + " -> " + nval));
                continue;
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in fabricMemeberChanged " + o[i]), (Throwable)ex);
            }
        }
        this.firePropertyChangeEvents();
    }

    public void fabricMembersRemoved(PKIf[] pks) {
    }

    public void fabricMembersPurged(PKIf[] o) {
        if (!ClientController.getInstance().isRestrictedTopology()) {
            return;
        }
        if (o == null || o.length == 0) {
            this.purgeAll();
            this.firePropertyChangeEvents();
            return;
        }
        AbstractModelObject obj = null;
        for (int i = 0; i < o.length; ++i) {
            try {
                if (o[i] == null) continue;
                obj = null;
                this._logger.debug((Object)("REMOVED: " + o[i]));
                if (!(o[i] instanceof VsanPK)) {
                    if (o[i] instanceof SwitchIntKey) {
                        obj = (AbstractModelObject)this.removeNpvLink((SwitchIntKey)o[i]);
                    } else if (o[i] instanceof WwnKey) {
                        obj = this.removeSwitch(o[i]);
                    } else if (o[i] instanceof IslPK) {
                        obj = (Isl)this.removeIsl((IslPK)o[i]);
                    } else if (!(o[i] instanceof ClusterPK)) {
                        if (o[i] instanceof FabricPK) {
                            this.purgeAll();
                            break;
                        }
                        if (!(o[i] instanceof NameKey)) {
                            // empty if block
                        }
                    }
                }
                if (obj == null || !ClientController.isTrace()) continue;
                this._logger.info((Object)("Removed : " + obj));
                continue;
            }
            catch (Exception ex) {
                this._logger.error((Object)("Error in fabricMembersRemoved " + o[i]), (Throwable)ex);
            }
        }
        this.firePropertyChangeEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PKIf[] purgeAll() {
        HashedArrayList<PKIf> purgedKeys = new HashedArrayList<PKIf>(0);
        HashMap<SwitchIntKey, Isl> hashMap = this._islBySwitchIntKey;
        synchronized (hashMap) {
            Iterator<Map.Entry<SwitchIntKey, Isl>> it = this._islBySwitchIntKey.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<SwitchIntKey, Isl> entry = it.next();
                Isl isl = entry.getValue();
                if (isl.isPresent()) continue;
                if (((IslPK)isl.getPK())._p1.equals(entry.getKey())) {
                    purgedKeys.add(isl.getPK());
                }
                it.remove();
            }
        }
        purgedKeys.addAll(this.purge(this._switchByPK));
        this.purge(this._switchByIpAddress);
        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "purge", null, purgedKeys.toArray(new PKIf[purgedKeys.size()])));
        return purgedKeys.toArray(new PKIf[purgedKeys.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<PKIf> purge(HashMap map) {
        HashedArrayList<PKIf> purgedKeys = new HashedArrayList<PKIf>(map.size() / 4);
        boolean endportHash = false;
        try {
            HashMap hashMap = map;
            synchronized (hashMap) {
                Iterator en = map.entrySet().iterator();
                while (en.hasNext()) {
                    Map.Entry entry = en.next();
                    AbstractModelObject mo = (AbstractModelObject)entry.getValue();
                    if (mo.isPresent() && (!endportHash || ((EndPort)mo).getSwitch() != null && ((EndPort)mo).getSwitch().isPresent())) continue;
                    en.remove();
                    ((ArrayList)purgedKeys).add(mo.getPK());
                }
            }
        }
        catch (Exception ex) {
            this._logger.error((Object)"Error in purge", (Throwable)ex);
        }
        return purgedKeys;
    }

    public Object removeNpvLink(SwitchIntKey fportPK) {
        NpvLink npvl = this._npvLinkByFPortPK.remove(fportPK);
        if (npvl != null) {
            if (npvl.isPortChannel() && npvl.getNumPCMembers() > 0) {
                List<NpvLink> members = npvl.getPCMemberLinksAsNpvLink();
                for (int i = 0; i < members.size(); ++i) {
                    ChannelMemberNpvLink mem = (ChannelMemberNpvLink)members.get(i);
                    SwitchIntKey pk = (SwitchIntKey)mem.getPK();
                    this._npvLinkByPCMemberSwitchIntKey.remove(pk);
                }
            }
            if (this.inited()) {
                this.addPropertyChangeEvent(new PropertyChangeEvent(this, "npvLinkRemoved", npvl, null));
            }
        }
        return npvl;
    }

    public Switch removeSwitch(PKIf switchPK) {
        Switch sw = this._switchByPK.remove(switchPK);
        if (sw != null) {
            if (sw.getInetAddress() != null) {
                this.removeSwitchByIpAddress(sw.getInetAddress());
            }
            if (this.inited()) {
                this.addPropertyChangeEvent(new PropertyChangeEvent(this, "switchRemoved", sw, null));
            }
        }
        return sw;
    }

    private void removeSwitchByIpAddress(InetAddress swIpAddr) {
        this._switchByIpAddress.remove(swIpAddr);
        this._logger.info((Object)("removeSwitchByIpAddress switch removed swIpAddr=" + swIpAddr));
    }

    public Object removeIsl(IslPK islPK) {
        Isl isl = this._islBySwitchIntKey.get(islPK.getSwitchIntKey1());
        if (isl != null && islPK.equals(isl.getPK())) {
            this.removeIsl(islPK.getSwitchIntKey1());
            this.removeIsl(islPK.getSwitchIntKey2());
            if (isl.isPortChannel() && isl.getNumPCMembers() > 0) {
                List<Isl> members = isl.getPCMemberLinksAsIsls();
                for (int i = 0; i < members.size(); ++i) {
                    ChannelMemberIsl mem = (ChannelMemberIsl)members.get(i);
                    IslPK pk = (IslPK)mem.getPK();
                    this._islByPCMemberSwitchIntKey.remove(pk.getSwitchIntKey1());
                    this._islByPCMemberSwitchIntKey.remove(pk.getSwitchIntKey2());
                }
            }
            if (this.inited()) {
                this.addPropertyChangeEvent(new PropertyChangeEvent(this, "islRemoved", isl, null));
            }
            return isl;
        }
        return null;
    }

    private Object removeIsl(PKIf switchIntKey) {
        return this._islBySwitchIntKey.remove(switchIntKey);
    }

    private San() {
    }

    public static San getInstance() {
        return _Instance;
    }

    @Override
    protected boolean inited() {
        return true;
    }

    @Override
    public boolean isSan() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getPath(char separator) {
        return separator + this.getName();
    }

    public void setFabricLoading(FabricPK fabricPK, boolean isLoading) {
        if (fabricPK == null) {
            return;
        }
        if (isLoading) {
            this._loadingFabrics.put(fabricPK, fabricPK);
        } else {
            this._loadingFabrics.remove(fabricPK);
        }
    }

    public boolean isFabricLoading(FabricPK fabricPK) {
        if (fabricPK == null) {
            return false;
        }
        return this._loadingFabrics.get(fabricPK) != null;
    }

    public synchronized void addFabric(FabricBase fabricBase, SnmpUserOpt fabricOpt, final boolean isResync, boolean licensed, boolean evalLicensed) {
        if (fabricBase == null) {
            return;
        }
        long fStart = System.currentTimeMillis();
        final Fabric fabric = new Fabric(fabricBase, fabricOpt);
        fabric.setLicensed(licensed);
        fabric.setEvalLicensed(evalLicensed);
        long fStop = System.currentTimeMillis();
        StringBuffer result = new StringBuffer();
        if (this._logger.isInfoEnabled()) {
            result.append(fStop - fStart);
            result.append(" ms");
            this._logger.info((Object)("time in new Fabric(FabricBase, SnmpUserOpt) method - " + result.toString()));
        }
        this._fabricByPK.put(fabricBase.getPK(), fabric);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long fStart = System.currentTimeMillis();
                San.this._logger.debug((Object)"adding fabric added event to queue");
                if (isResync) {
                    San.this.addPropertyChangeEvent(new PropertyChangeEvent(this, "fabricAddedForResync", null, fabric));
                } else {
                    San.this.addPropertyChangeEvent(new PropertyChangeEvent(this, "fabricAdded", null, fabric));
                }
                San.this._logger.debug((Object)"firing events");
                San.this.firePropertyChangeEvents();
                long fStop = System.currentTimeMillis();
                StringBuffer result = new StringBuffer();
                if (San.this._logger.isInfoEnabled()) {
                    result.append(fStop - fStart);
                    result.append(" ms");
                    San.this._logger.info((Object)("time in fabricAdded propertyChangeEvent and firePropertyChangeEvents - " + result.toString()));
                }
            }
        });
    }

    public static Fabric reopenFabric(Fabric fabric) {
        if (fabric == null) {
            return null;
        }
        final FabricPK fabricPK = (FabricPK)fabric.getPK();
        _Instance.removeFabric(fabric);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventDispatcher.getInstance().enqueue(new ModelEvent(fabricPK, ModelEventType.FABRIC_OPENED, null));
            }
        });
        return null;
    }

    public Fabric removeFabric(Fabric fabric) {
        if (fabric == null) {
            return null;
        }
        this._loadingFabrics.remove(fabric.getPK());
        Fabric f = this._fabricByPK.remove(fabric.getPK());
        if (f != null) {
            this.addPropertyChangeEvent(new PropertyChangeEvent(_Instance, "fabricRemoved", f, null));
            this.firePropertyChangeEvents();
            _executor.execute(new DestroyFabric(f));
        }
        return f;
    }

    @Override
    public Fabric getFabric() {
        if (this._fabricByPK == null || this._fabricByPK.size() == 0) {
            return null;
        }
        return ClientController.getInstance().getFirstFabric();
    }

    public void setName(String name) {
    }

    public Fabric[] getFabrics() {
        if (this._fabricByPK == null || this._fabricByPK.size() == 0) {
            return null;
        }
        return this._fabricByPK.values().toArray(new Fabric[this._fabricByPK.size()]);
    }

    public Fabric getFabric(FabricPK fabricPK) {
        if (fabricPK == null || this._fabricByPK == null || this._fabricByPK.size() == 0) {
            return null;
        }
        return this._fabricByPK.get(fabricPK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enclosure[] getEnclosures() {
        Object object = this._enclosureSync;
        synchronized (object) {
            if (this._enclosureByPK == null || this._enclosureByPK.size() == 0) {
                return null;
            }
            HashedArrayList<Enclosure> enclosureList = new HashedArrayList<Enclosure>();
            for (Enclosure encl : this._enclosureByPK.values()) {
                if (encl.getSan() != this) continue;
                ((ArrayList)enclosureList).add(encl);
            }
            return enclosureList.toArray(new Enclosure[enclosureList.size()]);
        }
    }

    public Enclosure[] getEnclosures(HashMap<EndPort, EndPort> map) {
        HashedArrayList<Enclosure> enclosureList = new HashedArrayList<Enclosure>();
        Enclosure enclosureClone = null;
        Enclosure[] enclosures = this.getEnclosures();
        if (enclosures != null) {
            for (int i = 0; i < enclosures.length; ++i) {
                enclosureClone = this.getEnclosureForRestrictedTopology(enclosures[i], map);
                if (enclosureClone == null || enclosureClone.getMemberCount() <= 0) continue;
                ((ArrayList)enclosureList).add(enclosureClone);
            }
        }
        return enclosureList.toArray(new Enclosure[enclosureList.size()]);
    }

    private Enclosure getEnclosureForRestrictedTopology(Enclosure enclosure, HashMap<EndPort, EndPort> map) {
        if (enclosure == null || enclosure.getMemberCount() == 0) {
            return null;
        }
        Enclosure enclosureClone = null;
        try {
            enclosureClone = (Enclosure)enclosure.clone();
            enclosureClone._san = enclosure._san;
            enclosureClone.lnkEndPort = new HashedArrayList<EndPort>();
            ArrayList<EndPort> members = enclosure.getMembers();
            EndPort endPort = null;
            EndPort endPortClone = null;
            for (int i = 0; i < members.size(); ++i) {
                endPort = members.get(i);
                if (endPort == null || map.get(endPort) == null) continue;
                endPortClone = (EndPort)endPort.clone();
                enclosureClone.lnkEndPort.add(endPortClone);
                endPortClone.lnkEnclosure = enclosureClone;
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return enclosureClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enclosure[] getEnclosures(FabricPK fabricPK) {
        Object object = this._enclosureSync;
        synchronized (object) {
            if (this._enclosureByPK.size() == 0) {
                return null;
            }
            HashedArrayList<Enclosure> enclosureList = new HashedArrayList<Enclosure>();
            for (Enclosure encl : this._enclosureByPK.values()) {
                if (!encl.isMemberOf(fabricPK)) continue;
                ((ArrayList)enclosureList).add(encl);
            }
            return enclosureList.toArray(new Enclosure[enclosureList.size()]);
        }
    }

    public int getEnclosureCount() {
        return this._enclosureByPK.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enclosure findEnclosureByPK(PKIf enclPK) {
        Object object = this._enclosureSync;
        synchronized (object) {
            Enclosure encl = this._enclosureByPK.get(enclPK);
            if (encl == null) {
                try {
                    EnclosureBase enclosureBase = ClientController.getInstance().assertModelFacade().findEnclosureByPK((NameKey)enclPK);
                    if (enclosureBase != null) {
                        encl = this.addEnclosure(enclosureBase);
                    }
                }
                catch (Exception ex) {
                    this._logger.error((Object)("Error in findEnclosureByPK " + enclPK), (Throwable)ex);
                }
            }
            return encl;
        }
    }

    public Enclosure findEnclosureByName(String name) {
        if (name == null) {
            return null;
        }
        return this.findEnclosureByPK(new NameKey(name));
    }

    public Enclosure getEnclosure(String name) {
        return this.findEnclosureByName(name);
    }

    public Enclosure getEnclosure(NameKey name) {
        return this.findEnclosureByPK(name);
    }

    public void addEnclosures(EnclosureBase[] list) {
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                this.addEnclosure(list[i]);
            }
        }
    }

    public Enclosure addEnclosure(EnclosureBase enclosureBase) {
        if (enclosureBase == null) {
            return null;
        }
        return this.addEnclosure(new Enclosure(enclosureBase, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enclosure addEnclosure(Enclosure enclosure) {
        if (enclosure == null) {
            return null;
        }
        PKIf enclosurePK = enclosure.getPK();
        Object object = this._enclosureSync;
        synchronized (object) {
            List epKeys;
            if (!this._enclosureByPK.containsKey(enclosurePK)) {
                this._enclosureByPK.put((NameKey)enclosurePK, enclosure);
            }
            if ((epKeys = enclosure.getMemberPKs()) != null) {
                for (int i = 0; i < epKeys.size(); ++i) {
                    this._enclosureByPWwn.put(((WwnKey)epKeys.get((int)i))._wwn, enclosure);
                }
            }
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, "enclosureAdded", null, enclosure);
        this.addPropertyChangeEvent(event);
        return enclosure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enclosure removeEnclosure(PKIf enclNameKey) {
        Object object = this._enclosureSync;
        synchronized (object) {
            int i;
            ArrayList memberList;
            Enclosure encl = this._enclosureByPK.remove(enclNameKey);
            if (encl == null) {
                return null;
            }
            ArrayList list = encl.getFabricPKs();
            ArrayList arrayList = memberList = encl.getMembers() != null ? (ArrayList)encl.getMembers().clone() : null;
            if (memberList != null && memberList.size() > 0) {
                for (int i2 = 0; i2 < memberList.size(); ++i2) {
                    EndPort ep = (EndPort)memberList.get(i2);
                    this._enclosureByPWwn.remove(ep.getPortWwn());
                    ep.setEnclosure(null);
                }
            }
            PropertyChangeEvent event = new PropertyChangeEvent(this, "enclosureRemoved", encl, null);
            HashedArrayList<Fabric> fabrics = new HashedArrayList<Fabric>(list.size());
            if (list != null && list.size() > 0) {
                for (i = 0; i < list.size(); ++i) {
                    Fabric f = this.getFabric((FabricPK)list.get(i));
                    if (f == null || ((ArrayList)fabrics).contains(f)) continue;
                    ((ArrayList)fabrics).add(f);
                    f.addPropertyChangeEvent(event);
                }
            }
            this.addPropertyChangeEvent(event);
            this.firePropertyChangeEvents();
            for (i = 0; i < fabrics.size(); ++i) {
                ((Fabric)fabrics.get(i)).firePropertyChangeEvents();
            }
            return encl;
        }
    }

    public void enclosureMemberAdded(Enclosure enclosure, EndPort ep) {
        if (enclosure == null || ep == null) {
            return;
        }
        if (this._enclosureByPWwn.containsKey(ep.getPortWwn())) {
            this._enclosureByPWwn.put(ep.getPortWwn(), enclosure);
        }
    }

    public void enclosureMemberRemoved(Enclosure enclosure, EndPort ep) {
        if (enclosure == null || ep == null) {
            return;
        }
        this._enclosureByPWwn.remove(ep.getPortWwn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameEnclosure(Enclosure enclosure, String name) {
        Object object = this._enclosureSync;
        synchronized (object) {
            int i;
            Enclosure encl;
            String oldName = ((EnclosureBase)enclosure.getBaseModelObject()).getEnclosureName();
            if (GenUtil.equals(oldName, name)) {
                return false;
            }
            ArrayList memberList = enclosure.getMembers() != null ? (ArrayList)enclosure.getMembers().clone() : null;
            Enclosure old = this._enclosureByPK.remove(enclosure.getPK());
            if (old == null) {
                old = enclosure;
            }
            EnclosureBase enclosureBase = null;
            if (ClientController.getInstance().isServerActive()) {
                try {
                    enclosureBase = ClientController.getInstance().assertModelFacade().findEnclosureByPK(new NameKey(name));
                    if (enclosureBase != null) {
                        enclosureBase.setIpAddress(old.getIpAddress());
                    }
                }
                catch (Exception ex) {
                    this._logger.error((Object)("Error in renameEnclosure " + oldName + "->" + name), (Throwable)ex);
                }
            }
            if (enclosureBase == null) {
                enclosureBase = new EnclosureBase(name, old.getIpAddress(), old.isVirtual());
            }
            Enclosure enclosure2 = encl = name == null ? null : this.addEnclosure(enclosureBase);
            if (encl != null) {
                encl.sync(old);
                this.addEnclosure(encl);
            }
            ArrayList list = old.getFabricPKs();
            PropertyChangeEvent event = new PropertyChangeEvent(old, "enclosureName", old.getName(), name);
            if (list != null && list.size() > 0) {
                for (i = 0; i < list.size(); ++i) {
                    Fabric f = this.getFabric((FabricPK)list.get(i));
                    if (f == null || !enclosure.isMemberOf((FabricPK)f.getPK())) continue;
                    f.addPropertyChangeEvent(event);
                }
            }
            this.addPropertyChangeEvent(event);
            if (memberList != null && memberList.size() > 0) {
                for (i = 0; i < memberList.size(); ++i) {
                    ((EndPort)memberList.get(i)).setEnclosure(encl);
                }
            }
            this.addPropertyChangeEvent(event);
            old.firePropertyChangeEvents();
            this.firePropertyChangeEvents();
            return true;
        }
    }

    public Enclosure findEnclosureByPWwn(Wwn pwwn) {
        if (pwwn == null) {
            return null;
        }
        return this._enclosureByPWwn.get(pwwn);
    }

    public int getFabricCount() {
        return this._fabricByPK == null ? 0 : this._fabricByPK.size();
    }

    public FabricPK[] getFabricPKs() {
        if (this._fabricByPK == null) {
            return null;
        }
        return this._fabricByPK.keySet().toArray(new FabricPK[this._fabricByPK.size()]);
    }

    public FabricPK[] getFabricPKsForSwitch(InetAddress ipAddress) {
        if (ipAddress == null) {
            return new FabricPK[0];
        }
        Fabric[] fabrics = this.getFabrics();
        if (fabrics == null || fabrics.length == 0) {
            return new FabricPK[0];
        }
        HashedArrayList<FabricPK> list = new HashedArrayList<FabricPK>();
        for (int i = 0; i < fabrics.length; ++i) {
            if (fabrics[i].findSwitchByIpAddress(ipAddress) == null) continue;
            ((ArrayList)list).add((FabricPK)fabrics[i].getPK());
        }
        return list.toArray(new FabricPK[list.size()]);
    }

    public Fabric getFabricBySwitchWwn(Wwn swWwn) {
        if (swWwn == null) {
            return null;
        }
        Fabric[] fabrics = this.getFabrics();
        if (fabrics == null || fabrics.length == 0) {
            return null;
        }
        for (int i = 0; i < fabrics.length; ++i) {
            if (fabrics[i].getSwitchByPK(new WwnKey(swWwn)) == null) continue;
            return fabrics[i];
        }
        return null;
    }

    public Fabric getFabricBySwitchPK(PKIf swWwnKey) {
        if (swWwnKey == null) {
            return null;
        }
        Fabric[] fabrics = this.getFabrics();
        if (fabrics == null || fabrics.length == 0) {
            return null;
        }
        for (int i = 0; i < fabrics.length; ++i) {
            if (fabrics[i].findSwitchByPK(swWwnKey) == null) continue;
            return fabrics[i];
        }
        return null;
    }

    public Fabric getFabricByIslSwitchIntKey(PKIf swIntKey) {
        if (swIntKey == null) {
            return null;
        }
        Fabric[] fabrics = this.getFabrics();
        if (fabrics == null || fabrics.length == 0) {
            return null;
        }
        for (int i = 0; i < fabrics.length; ++i) {
            if (fabrics[i].findIslBySwitchIntKey(swIntKey) == null) continue;
            return fabrics[i];
        }
        return null;
    }

    public Fabric getFabricByNpvLinkByFportKey(SwitchIntKey fpkey) {
        if (fpkey == null) {
            return null;
        }
        Fabric[] fabrics = this.getFabrics();
        if (fabrics == null || fabrics.length == 0) {
            return null;
        }
        for (int i = 0; i < fabrics.length; ++i) {
            if (fabrics[i].findNpvLinkByFportKey(fpkey) == null) continue;
            return fabrics[i];
        }
        return null;
    }

    @Override
    public SnmpPeer[] getSnmpPeers() {
        return this.getSnmpPeers(false);
    }

    @Override
    public SnmpPeer[] getSnmpPeers(boolean needQuail) {
        return this.getSnmpPeers(needQuail, false);
    }

    public SnmpPeer[] getSnmpPeers(boolean needQuail, boolean filterNPV) {
        ArrayList<SnmpPeer> modlist = this.getSnmpPeers(null, needQuail, filterNPV);
        return modlist.size() == 0 ? null : modlist.toArray(new SnmpPeer[modlist.size()]);
    }

    public ArrayList<SnmpPeer> getSnmpPeers(ArrayList<SnmpPeer> list) {
        return this.getSnmpPeers(list, false);
    }

    public ArrayList<SnmpPeer> getSnmpPeers(ArrayList<SnmpPeer> list, boolean needQuail) {
        Switch[] switches;
        if (list == null) {
            list = new HashedArrayList<SnmpPeer>();
        }
        if ((switches = this.getSwitches()) == null || switches.length == 0) {
            return list;
        }
        for (int j = 0; j < switches.length; ++j) {
            Switch sw = switches[j];
            if (!sw.isMDS() && (!needQuail || !sw.isQuail()) || !sw.isLocallyManageable() || sw.getPeer() == null) continue;
            list.add(sw.getPeer());
        }
        return list;
    }

    public ArrayList<SnmpPeer> getSnmpPeers(ArrayList<SnmpPeer> list, boolean needQuail, boolean filterNPV) {
        Switch[] switches;
        if (list == null) {
            list = new HashedArrayList<SnmpPeer>();
        }
        if ((switches = this.getSwitches()) == null || switches.length == 0) {
            return list;
        }
        for (int j = 0; j < switches.length; ++j) {
            Switch sw = switches[j];
            if ((!sw.isMDS() || (sw.isNpvEnabled() || !filterNPV) && filterNPV) && (!needQuail || !sw.isQuail()) || !sw.isLocallyManageable() || sw.getPeer() == null) continue;
            list.add(sw.getPeer());
        }
        return list;
    }

    @Override
    public Switch[] getSwitches() {
        HashedArrayList<Switch> list = new HashedArrayList<Switch>();
        this.getSwitches(list);
        return list.size() == 0 ? new Switch[]{} : list.toArray(new Switch[list.size()]);
    }

    public ArrayList<Switch> getSwitches(ArrayList<Switch> list) {
        Fabric[] fabrics;
        if (list == null) {
            list = new HashedArrayList<Switch>();
        }
        if ((fabrics = this.getFabrics()) == null || fabrics.length == 0) {
            return list;
        }
        for (int i = 0; i < fabrics.length; ++i) {
            Switch[] switches = fabrics[i].getSwitches();
            if (switches == null || switches.length == 0) continue;
            for (int j = 0; j < switches.length; ++j) {
                Switch sw = switches[j];
                if (list.contains(sw)) continue;
                list.add(sw);
            }
        }
        return list;
    }

    @Override
    public ArrayList<Isl> getIsls(ArrayList<Isl> list) {
        Fabric[] fabrics;
        if (list == null) {
            list = new HashedArrayList<Isl>();
        }
        if ((fabrics = this.getFabrics()) == null || fabrics.length == 0) {
            return list;
        }
        for (int i = 0; i < fabrics.length; ++i) {
            Isl[] isls = fabrics[i].getIsls();
            if (isls == null || isls.length == 0) continue;
            for (int j = 0; j < isls.length; ++j) {
                Isl isl = isls[j];
                if (list.contains(isl)) continue;
                list.add(isl);
            }
        }
        return list;
    }

    @Override
    public ArrayList<NpvLink> getNpvLinks(ArrayList<NpvLink> list) {
        Fabric[] fabrics;
        if (list == null) {
            list = new HashedArrayList<NpvLink>();
        }
        if ((fabrics = this.getFabrics()) == null || fabrics.length == 0) {
            return list;
        }
        for (int i = 0; i < fabrics.length; ++i) {
            NpvLink[] npvLinks = fabrics[i].getNpvLinks();
            if (npvLinks == null || npvLinks.length == 0) continue;
            for (int j = 0; j < npvLinks.length; ++j) {
                NpvLink isl = npvLinks[j];
                if (list.contains(isl)) continue;
                list.add(isl);
            }
        }
        return list;
    }

    @Override
    public EndPort[] getEndPorts(boolean target) {
        ArrayList<EndPort> newlist = this.getEndPorts(null, target);
        return newlist.size() == 0 ? null : newlist.toArray(new EndPort[newlist.size()]);
    }

    @Override
    public ArrayList<EndPort> getEndPorts(ArrayList<EndPort> endPorts, boolean target) {
        HashedArrayList<EndPort> list = new HashedArrayList<EndPort>();
        this.getEndPorts(list);
        if (endPorts == null) {
            endPorts = new HashedArrayList<EndPort>(list.size());
        }
        for (int i = 0; i < list.size(); ++i) {
            EndPort ep = (EndPort)list.get(i);
            if (!(target ? ep.isTarget() : !ep.isTarget()) || endPorts.contains(ep)) continue;
            endPorts.add(ep);
        }
        return endPorts;
    }

    @Override
    public ArrayList<EndPort> getEndPortsAsList() {
        HashedArrayList<EndPort> list = new HashedArrayList<EndPort>();
        this.getEndPorts(list);
        return list;
    }

    @Override
    public EndPort[] getEndPorts() {
        ArrayList<EndPort> list = this.getEndPortsAsList();
        return list.size() == 0 ? null : list.toArray(new EndPort[list.size()]);
    }

    public ArrayList<EndPort> getEndPorts(ArrayList<EndPort> list) {
        Fabric[] fabrics;
        if (list == null) {
            list = new HashedArrayList<EndPort>();
        }
        if ((fabrics = this.getFabrics()) == null || fabrics.length == 0) {
            return list;
        }
        HashSet<EndPort> epsAll = new HashSet<EndPort>();
        for (int i = 0; i < fabrics.length; ++i) {
            HashSet<EndPort> eps = fabrics[i].getEndPortsAsSet();
            epsAll.addAll(eps);
        }
        list.addAll(epsAll);
        return list;
    }

    public void closeAll() {
        this.closeAll(null, false);
    }

    public void closeAll(List<FabricPK> fabricPKsToReopen, boolean isResync) {
        this._loadingFabrics.clear();
        UserDefinedGroupManager.getInstance().clear();
        if (this._fabricByPK.size() > 0) {
            Iterator<Fabric> itr = this._fabricByPK.values().iterator();
            while (itr.hasNext()) {
                try {
                    Fabric fabric = itr.next();
                    destroyFabricMap.put(fabric.getPK(), fabric.getPK());
                    itr.remove();
                    if (isResync || fabricPKsToReopen != null && fabricPKsToReopen.contains(fabric.getPK())) {
                        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "fabricRemovedForResync", fabric, null));
                    } else {
                        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "fabricRemoved", fabric, null));
                    }
                    this.firePropertyChangeEvents();
                    SwingUtilities.invokeLater(new DestroyFabric(fabric));
                }
                catch (Exception ex) {
                    this._logger.error((Object)"Error in closeAll", (Throwable)ex);
                }
            }
        }
    }

    public Switch[] findAttachedSwitches(Switch sw) {
        HashSet<Switch> sws = new HashSet<Switch>();
        Isl[] isls = sw.getFabric().getIsls();
        for (int i = 0; i < isls.length; ++i) {
            Isl isl = isls[i];
            if (isl.getSwitch1() == sw) {
                sws.add(isl.getSwitch2());
                continue;
            }
            if (isl.getSwitch2() != sw) continue;
            sws.add(isl.getSwitch1());
        }
        return sws.size() == 0 ? null : sws.toArray(new Switch[sws.size()]);
    }

    public Switch getSwitchByPK(PKIf swWwnKey) {
        Switch sw = null;
        if (this._fabricByPK.size() > 0) {
            for (Fabric fabric : this._fabricByPK.values()) {
                if (fabric == null || (sw = fabric.getSwitchByPK(swWwnKey)) == null) continue;
                return sw;
            }
        }
        return null;
    }

    public Switch findSwitchByPK(PKIf swWwnKey) {
        Switch sw = null;
        if (this._fabricByPK.size() > 0) {
            for (Fabric fabric : this._fabricByPK.values()) {
                if (fabric == null || (sw = fabric.findSwitchByPK(swWwnKey)) == null) continue;
                return sw;
            }
        }
        return null;
    }

    public void resync() {
        this.addPropertyChangeEvent(new PropertyChangeEvent(_Instance, "resync", null, null));
        this.firePropertyChangeEvents();
    }

    public boolean isEdgeSwitch(WwnKey pk) {
        return this._targetSwitches.get(pk) != null || this._sourceSwitches.get(pk) != null;
    }

    public ArrayList<AbstractFcLink> getRestrictedTopologySourceSwitchLinks() {
        return this._restrictedTopologySourceSwitchLinks;
    }

    public ArrayList<AbstractFcLink> getRestrictedTopologyTargetSwitchLinks() {
        return this._restrictedTopologyTargetSwitchLinks;
    }

    public ArrayList<AbstractFcLink> getRestrictedTopologySourceToTargetSwitchLinks() {
        return this._restrictedTopologySourceToTargetSwitchLinks;
    }

    public String getRestrictedTopologyName() {
        return this._restrictedTopologyName;
    }

    public void setRestrictedTopologyName(String name) {
        this._restrictedTopologyName = name;
    }

    public void removeEmptyEnclosures() {
        Enclosure encl;
        if (this._enclosureByPK != null && this._enclosureByPK.size() > 0) {
            encl = null;
            HashMap<NameKey, Enclosure> newEnclosureByPK = new HashMap<NameKey, Enclosure>();
            for (NameKey nameKey : this._enclosureByPK.keySet()) {
                encl = this._enclosureByPK.get(nameKey);
                if (encl == null || encl.getMemberCount() <= 0) continue;
                newEnclosureByPK.put(nameKey, encl);
            }
            this._enclosureByPK = newEnclosureByPK;
        }
        if (this._enclosureByPWwn != null && this._enclosureByPWwn.size() > 0) {
            encl = null;
            HashMap<Wwn, Enclosure> newEnclosureByPWwn = new HashMap<Wwn, Enclosure>();
            for (Wwn wwn : this._enclosureByPWwn.keySet()) {
                encl = this._enclosureByPWwn.get(wwn);
                if (encl == null || encl.getMemberCount() <= 0) continue;
                newEnclosureByPWwn.put(wwn, encl);
            }
            this._enclosureByPWwn = newEnclosureByPWwn;
        }
    }

    static {
        _executor = new PooledThreadExecutor("FabricThreadPool", 2, 20, 20000L);
        _restrictedTopologyPathTypeAsString = new String[]{"Fabric Paths", "All Paths", "First Shortest Path"};
        _Instance = new San();
        destroyFabricMap = new HashMap();
    }
}

