/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.FcPortBase;

public class SmFiconPortList
extends SnmpIntList {
    public SmFiconPortList(byte[] byteValue, Switch sw) {
        super(byteValue, (IfIndexIf)sw);
    }

    @Override
    public String toString() {
        if (this._value == null) {
            this._value = SmFiconPortList.toString(this._byteValue, this._ifIndexIf);
        }
        return this._value;
    }

    public static String toString(byte[] b, IfIndexIf ifIndexIf) {
        Switch sw = (Switch)ifIndexIf;
        if (!sw.hasFiconVsan()) {
            return SnmpIntList.toString(b, ifIndexIf);
        }
        if (b == null || b.length == 0) {
            return null;
        }
        int[] ifIndeces = SmFiconPortList.valueOf(b);
        StringBuffer sb = new StringBuffer(32);
        int ficonPort = SmFiconPortList.getFiconAddress(sw, ifIndeces[0]);
        sb.append(ficonPort == -1 ? "" : SnmpFiconPort.toString(ficonPort));
        boolean inRange = ifIndeces.length >= 2 && SmFiconPortList.contigious(ficonPort, SmFiconPortList.getFiconAddress(sw, ifIndeces[1]), ifIndexIf);
        for (int i = 1; i < ifIndeces.length; ++i) {
            int port2;
            int port1 = SmFiconPortList.getFiconAddress(sw, ifIndeces[i - 1]);
            if (!SmFiconPortList.contigious(port1, port2 = SmFiconPortList.getFiconAddress(sw, ifIndeces[i]), ifIndexIf)) {
                if (inRange) {
                    sb.append('-');
                    sb.append(port1 == -1 ? "" : SnmpFiconPort.toString(port1));
                }
                if (port2 != -1) {
                    sb.append(',');
                    sb.append(SnmpFiconPort.toString(port2));
                }
                inRange = false;
                continue;
            }
            inRange = true;
        }
        if (ifIndeces.length > 1 && inRange) {
            sb.append('-');
            ficonPort = SmFiconPortList.getFiconAddress(sw, ifIndeces[ifIndeces.length - 1]);
            sb.append(ficonPort == -1 ? "" : SnmpFiconPort.toString(ficonPort));
        }
        return sb.toString();
    }

    private static int getFiconAddress(Switch sw, int ifIndex) {
        FcPortBase port = sw.findFCPort(ifIndex);
        if (port != null) {
            return port.getFiconAddress();
        }
        return -1;
    }
}

