/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.snmp.SnmpPeer;

public class SmFilter {
    public static final short ANY_FILTER = Short.MAX_VALUE;
    public static final short NO_FILTER = Short.MAX_VALUE;
    public static final short VSAN = 4097;
    public static final short ALL_IF = 4096;
    public static final short PHYSICAL_IF = 4352;
    public static final short LOGICAL_IF = 4608;
    public static final short ISL_FILTER = 5120;
    public static final short VFC_IF_FILTER = 6144;
    public static final short FCIP_IF_FILTER = 6145;
    public static final short ISCSI_IF_FILTER = 6146;
    public static final short OTHER_LOGICAL_IF_FILTER = 6147;
    public static final short PORTCHANNEL_FILTER = 5136;
    public static final short PORTCHANNEL_MEMBER_FILTER = 5137;
    public static final short INDEX_NO_VSAN = 0;
    public static final short INDEX_PREPEND_VSAN = -1;
    public static final short INDEX_APPEND_VSAN = 1;
    private SnmpPeer _snmpPeer;
    private int[][] _indices;

    public SmFilter(SnmpPeer snmpPeer) {
        this(snmpPeer, null);
    }

    public SmFilter(SnmpPeer snmpPeer, int[][] indices) {
        this._snmpPeer = snmpPeer;
        this._indices = indices;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SmFilter)) {
            return false;
        }
        SmFilter filter = (SmFilter)obj;
        return this.equals(filter._snmpPeer, this._snmpPeer) && this.equals(filter._indices, this._indices);
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (!obj1.getClass().equals(obj2.getClass())) {
            return false;
        }
        if (obj1 instanceof int[][]) {
            return ((int[][])obj1).length == ((int[][])obj2).length;
        }
        return obj1.equals(obj2);
    }

    public SnmpPeer getSnmpPeer() {
        return this._snmpPeer;
    }

    public void setSnmpPeer(SnmpPeer snmpPeer) {
        this._snmpPeer = snmpPeer;
    }

    public int getIndex(int r, int c) throws IndexOutOfBoundsException {
        if (this._indices != null) {
            return this._indices[r][c];
        }
        throw new IndexOutOfBoundsException("SmFilter.getIndex() :" + r + ", " + c);
    }

    public int[][] getIndices() {
        return this._indices;
    }

    public int getIndicesCount() {
        int[][] indices = this.getIndices();
        return indices == null ? 0 : indices.length;
    }

    public int getIndicesCount(int row) {
        int[][] indices = this.getIndices();
        return indices == null ? 0 : (indices.length <= row ? 0 : indices[row].length);
    }

    public void setIndex(int r, int c, int value) {
        if (this._indices == null) {
            this._indices = new int[r + 1][c + 1];
        }
        this._indices[r][c] = value;
    }

    public void setIndices(int[][] indices) {
        this._indices = indices;
    }
}

