/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.model.AbstractMgmtDomain;
import com.cisco.dcbu.sm.client.model.AbstractModelObject;
import com.cisco.dcbu.sm.client.model.Enclosure;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class UserDefinedGroup
extends AbstractMgmtDomain
implements Comparator,
Comparable {
    private String _name = null;
    private short _type = 1;
    private HashMap<PKIf, AbstractModelObject> _members = new HashMap();
    private GroupBase _groupBase;

    public UserDefinedGroup(GroupBase groupBase) {
        if (groupBase != null) {
            this._name = groupBase.getPK().toString();
            this._type = groupBase.getType();
        }
        this._groupBase = groupBase;
    }

    private UserDefinedGroup(String name, short type) {
        this._name = name;
        this._type = type;
    }

    public GroupBase getBaseObject() {
        return this._groupBase;
    }

    void setGroupBase(GroupBase groupBase) {
        this._groupBase = groupBase;
    }

    @Override
    public PKIf getPK() {
        return this._groupBase.getPK();
    }

    @Override
    public boolean isCustomDefined() {
        return true;
    }

    @Override
    public String getName() {
        return this._name;
    }

    void setName(String name) throws Exception {
        if (this._groupBase != null) {
            throw new Exception("Can not change existing group name");
        }
        if (name == null || name.length() == 0 || GenUtil.equals(name, this._name)) {
            return;
        }
        String oldName = this._name;
        this._name = name;
        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "name", oldName, this._name));
    }

    public boolean isEditable() {
        if (this._groupBase != null) {
            return this._groupBase.isEditable();
        }
        return true;
    }

    public short getType() {
        return this._type;
    }

    public void setType(short type) throws Exception {
        if (this._groupBase != null) {
            throw new Exception("Can not change existing group type");
        }
        if (type == this._type) {
            return;
        }
        short oldType = this._type;
        this._type = type;
        this.addPropertyChangeEvent(new PropertyChangeEvent(this, "type", new Integer(oldType), new Integer(this._type)));
    }

    public void addMembers(AbstractModelObject[] objs) throws Exception {
        Exception savedEx = null;
        if (objs != null && objs.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < objs.length; ++i) {
                try {
                    this.addMember(objs[i]);
                    continue;
                }
                catch (Exception ex) {
                    savedEx = ex;
                    sb.append(objs[i]).append(", ");
                }
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            if (sb.length() > 2) {
                throw new Exception("Can't add : " + sb.toString(), savedEx);
            }
        }
    }

    public void addMember(AbstractModelObject obj) throws IllegalTypeException {
        if (obj == null) {
            return;
        }
        if (obj instanceof Switch) {
            if (this._type == 2) {
                throw new IllegalTypeException("Trying to add a Switch to a group of End Ports");
            }
        } else if (this._type == 1) {
            throw new IllegalTypeException("Trying to add an End Port to a group of Switches");
        }
        this._members.put(obj.getPK(), obj);
    }

    public Object removeMember(AbstractModelObject object) {
        return this._members.remove(object.getPK());
    }

    public Object removeMember(PKIf pk) {
        return this._members.remove(pk);
    }

    public void clearMembers() {
        this._members.clear();
    }

    public Object getMember(PKIf pk) {
        return this._members.get(pk);
    }

    public boolean isMember(PKIf pk) {
        return this.exists(pk);
    }

    public boolean exists(PKIf pk) {
        return this._members.get(pk) != null;
    }

    public boolean exists(AbstractModelObject obj) {
        if (obj == null || obj.getPK() == null) {
            return false;
        }
        return this._members.get(obj.getPK()) != null;
    }

    public boolean switchExists(AbstractModelObject obj) {
        ArrayList<EndPort> eps;
        if (this.exists(obj)) {
            return true;
        }
        if (this._type == 2 && (eps = this.getEndPortsAsList()) != null && eps.size() > 0) {
            for (int i = 0; i < eps.size(); ++i) {
                EndPort ep = eps.get(i);
                Switch sw = ep.getSwitch();
                if (sw == null || !sw.getPK().equals(obj.getPK())) continue;
                return true;
            }
        }
        return false;
    }

    public int getMemberCount() {
        return this._members.size();
    }

    @Override
    public SnmpPeer[] getSnmpPeers(boolean needQuail) {
        Switch[] sws = this.getSwitches();
        HashedArrayList<SnmpPeer> list = new HashedArrayList<SnmpPeer>(sws.length);
        if (sws != null && sws.length > 0) {
            for (int i = 0; i < sws.length; ++i) {
                if (!sws[i].isMDS() && (!needQuail || !sws[i].isQuail()) || !sws[i].isLocallyManageable() || sws[i].getPeer() == null) continue;
                ((ArrayList)list).add(sws[i].getPeer());
            }
        }
        return list.toArray(new SnmpPeer[list.size()]);
    }

    @Override
    public SnmpPeer[] getSnmpPeers() {
        return this.getSnmpPeers(false);
    }

    @Override
    public ArrayList<Isl> getIsls(ArrayList<Isl> list) {
        int i;
        Fabric[] fabrics;
        if (list == null) {
            list = new HashedArrayList<Isl>();
        }
        if ((fabrics = this.getFabrics()) == null || fabrics.length == 0) {
            return list;
        }
        Switch[] sws = this.getSwitches();
        HashMap<PKIf, Switch> swMap = new HashMap<PKIf, Switch>(sws == null ? 0 : sws.length);
        if (sws != null && sws.length > 0) {
            for (i = 0; i < sws.length; ++i) {
                swMap.put(sws[i].getPK(), sws[i]);
            }
        }
        for (i = 0; i < fabrics.length; ++i) {
            Fabric fabric = fabrics[i];
            Isl[] isls = fabric.getIsls();
            if (isls == null || isls.length == 0) continue;
            for (int j = 0; j < isls.length; ++j) {
                Isl isl = isls[j];
                if (this._type != 1 || this._groupBase == null || !this._groupBase.isEditable() ? swMap.get(isl.getSwitch1().getPK()) == null || swMap.get(isl.getSwitch2().getPK()) == null : swMap.get(isl.getSwitch1().getPK()) == null && swMap.get(isl.getSwitch2().getPK()) == null) continue;
                if (list.contains(isl)) continue;
                list.add(isl);
            }
        }
        return list;
    }

    @Override
    public ArrayList<NpvLink> getNpvLinks(ArrayList<NpvLink> list) {
        int i;
        Fabric[] fabrics;
        if (list == null) {
            list = new HashedArrayList<NpvLink>();
        }
        if ((fabrics = this.getFabrics()) == null || fabrics.length == 0) {
            return list;
        }
        Switch[] sws = this.getSwitches();
        HashMap<PKIf, Switch> swMap = new HashMap<PKIf, Switch>(sws == null ? 0 : sws.length);
        if (sws != null && sws.length > 0) {
            for (i = 0; i < sws.length; ++i) {
                swMap.put(sws[i].getPK(), sws[i]);
            }
        }
        for (i = 0; i < fabrics.length; ++i) {
            Fabric fabric = fabrics[i];
            NpvLink[] npvLinks = fabric.getNpvLinks();
            if (npvLinks == null || npvLinks.length == 0) continue;
            for (int j = 0; j < npvLinks.length; ++j) {
                NpvLink npvLink = npvLinks[j];
                if (this._type != 1 ? swMap.get(npvLink.getCoreSwitch().getPK()) == null || swMap.get(npvLink.getEdgeSwitch().getPK()) == null : swMap.get(npvLink.getCoreSwitch().getPK()) == null || swMap.get(npvLink.getEdgeSwitch().getPK()) == null) continue;
                if (list.contains(npvLink)) continue;
                list.add(npvLink);
            }
        }
        return list;
    }

    @Override
    public String getPath(char separator) {
        Fabric f = this.getFabric();
        if (f == null) {
            return "";
        }
        return f.getPath(separator) + separator + "Groups" + separator + this.getName();
    }

    @Override
    public EndPort[] getEndPorts(boolean isTarget) {
        ArrayList<EndPort> list = this.getEndPorts(null, isTarget);
        return list.toArray(new EndPort[list.size()]);
    }

    @Override
    public ArrayList<EndPort> getEndPortsAsList() {
        ArrayList list;
        block6: {
            block5: {
                boolean allEndPorts;
                list = new HashedArrayList<EndPort>();
                if (this._members.size() == 0) {
                    return list;
                }
                boolean bl = allEndPorts = (this._type & 2) == 0;
                if (!allEndPorts) break block5;
                Switch[] sws = this.getSwitches();
                if (sws == null || sws.length <= 0) break block6;
                for (int i = 0; i < sws.length; ++i) {
                    if (this._groupBase != null && !this._groupBase.isEditable() && sws[i].isNpivEnabled()) continue;
                    list = sws[i].getEndPorts(list);
                }
                break block6;
            }
            for (AbstractModelObject obj : this._members.values()) {
                if (obj instanceof Enclosure) {
                    ArrayList<EndPort> mem = ((Enclosure)obj).getMembers();
                    if (mem == null || mem.size() <= 0) continue;
                    for (int i = 0; i < mem.size(); ++i) {
                        EndPort ep = mem.get(i);
                        if (list.contains(ep)) continue;
                        list.add(ep);
                    }
                    continue;
                }
                if (!(obj instanceof EndPort) || list.contains(obj)) continue;
                list.add((EndPort)((EndPort)obj));
            }
        }
        return list;
    }

    @Override
    public ArrayList<EndPort> getEndPorts(ArrayList<EndPort> list, boolean isTarget) {
        if (list == null) {
            list = new HashedArrayList<EndPort>();
        }
        if (this._members.size() == 0) {
            return list;
        }
        ArrayList<EndPort> eps = this.getEndPortsAsList();
        if (eps != null && eps.size() > 0) {
            for (int i = 0; i < eps.size(); ++i) {
                EndPort ep = eps.get(i);
                if (!(isTarget ? ep.isTarget() : !ep.isTarget()) || list.contains(ep)) continue;
                list.add(ep);
            }
        }
        return list;
    }

    @Override
    public EndPort[] getEndPorts() {
        ArrayList<EndPort> list = this.getEndPortsAsList();
        return list.toArray(new EndPort[list.size()]);
    }

    @Override
    public Switch[] getSwitches() {
        Collection<AbstractModelObject> list = null;
        if ((this._type & 1) != 0) {
            list = this._members.values();
        } else {
            list = new HashedArrayList<AbstractModelObject>();
            ArrayList<EndPort> eps = this.getEndPortsAsList();
            if (eps != null && eps.size() > 0) {
                for (int i = 0; i < eps.size(); ++i) {
                    EndPort ep = eps.get(i);
                    if (list.contains(ep.getSwitch())) continue;
                    list.add(ep.getSwitch());
                }
            }
        }
        return list.toArray(new Switch[list.size()]);
    }

    public Fabric[] getFabrics() {
        HashedArrayList<Fabric> fabricList = new HashedArrayList<Fabric>();
        ArrayList<EndPort> list = this.getEndPortsAsList();
        if (list != null && list.size() > 0) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                PKIf fabricPK;
                Fabric f = ((EndPort)itr.next()).getFabric();
                PKIf pKIf = fabricPK = f == null ? null : f.getPK();
                if (f == null || fabricPK == null || San.getInstance().getFabric((FabricPK)fabricPK) == null || ((ArrayList)fabricList).contains(f)) continue;
                ((ArrayList)fabricList).add(f);
            }
        }
        for (AbstractModelObject obj : this._members.values()) {
            Fabric f;
            if (!(obj instanceof Switch) || (f = ((Switch)obj).getFabric()) == null || ((ArrayList)fabricList).contains(f)) continue;
            ((ArrayList)fabricList).add(f);
        }
        return fabricList.toArray(new Fabric[fabricList.size()]);
    }

    @Override
    public Fabric getFabric() {
        if (this._groupBase != null) {
            return San.getInstance().getFabric(this._groupBase.getGroupPK().getFabricPK());
        }
        return null;
    }

    @Override
    protected boolean inited() {
        return true;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return ((UserDefinedGroup)o1)._groupBase.compare(((UserDefinedGroup)o1)._groupBase, ((UserDefinedGroup)o2)._groupBase);
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (o == null || ((UserDefinedGroup)o)._groupBase == null) {
            return 1;
        }
        if (this._groupBase == null) {
            return -1;
        }
        return this.compare(this, o);
    }

    public static class IllegalTypeException
    extends Exception {
        public IllegalTypeException(String name) {
            super(name);
        }
    }
}

