/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.client.model.AbstractMgmtDomain;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.UserDefinedGroup;
import java.util.ArrayList;

public class UserDefinedGroupUnion
extends AbstractMgmtDomain {
    private Array<UserDefinedGroup> _groupArray = new Array();
    private String _name = null;
    private Fabric _fabric = null;

    public UserDefinedGroupUnion(String name) {
        this._name = name;
    }

    @Override
    public String toString() {
        return this._name;
    }

    public void addGroup(UserDefinedGroup group) {
        this._groupArray.addElement(group);
    }

    public void removeGroup(UserDefinedGroup group) {
        this._groupArray.removeElement(group);
    }

    @Override
    public EndPort[] getEndPorts() {
        if (this._groupArray == null || this._groupArray.size() == 0) {
            return new EndPort[0];
        }
        Array<EndPort> endPortArray = new Array<EndPort>();
        for (int i = 0; i < this._groupArray.size(); ++i) {
            EndPort[] endPorts;
            UserDefinedGroup group = this._groupArray.elementAt(i);
            if (group == null || (endPorts = group.getEndPorts()) == null || endPorts.length == 0) continue;
            for (int j = 0; j < endPorts.length; ++j) {
                endPortArray.addUniqueElement(endPorts[j]);
            }
        }
        return endPortArray.toArray(new EndPort[endPortArray.size()]);
    }

    @Override
    public EndPort[] getEndPorts(boolean target) {
        if (this._groupArray == null || this._groupArray.size() == 0) {
            return new EndPort[0];
        }
        Array<EndPort> endPortArray = new Array<EndPort>();
        for (int i = 0; i < this._groupArray.size(); ++i) {
            EndPort[] endPorts;
            UserDefinedGroup group = this._groupArray.elementAt(i);
            if (group == null || (endPorts = group.getEndPorts(target)) == null || endPorts.length == 0) continue;
            for (int j = 0; j < endPorts.length; ++j) {
                endPortArray.addUniqueElement(endPorts[j]);
            }
        }
        return endPortArray.toArray(new EndPort[endPortArray.size()]);
    }

    @Override
    public ArrayList<EndPort> getEndPorts(ArrayList<EndPort> endPorts, boolean target) {
        if (endPorts == null) {
            endPorts = new HashedArrayList<EndPort>();
        }
        if (this._groupArray == null || this._groupArray.size() == 0) {
            return endPorts;
        }
        if (endPorts == null) {
            endPorts = new HashedArrayList<EndPort>();
        }
        for (int i = 0; i < this._groupArray.size(); ++i) {
            UserDefinedGroup group = this._groupArray.elementAt(i);
            if (group == null) continue;
            group.getEndPorts(endPorts, target);
        }
        return endPorts;
    }

    @Override
    public ArrayList<EndPort> getEndPortsAsList() {
        HashedArrayList<EndPort> endPorts = new HashedArrayList<EndPort>();
        if (this._groupArray == null || this._groupArray.size() == 0) {
            return endPorts;
        }
        for (int i = 0; i < this._groupArray.size(); ++i) {
            UserDefinedGroup group = this._groupArray.elementAt(i);
            if (group == null) continue;
            ((ArrayList)endPorts).addAll(group.getEndPortsAsList());
        }
        return endPorts;
    }

    @Override
    public ArrayList<Isl> getIsls(ArrayList<Isl> isls) {
        if (this._groupArray == null || this._groupArray.size() == 0) {
            return isls;
        }
        if (isls == null) {
            isls = new HashedArrayList<Isl>();
        }
        for (int i = 0; i < this._groupArray.size(); ++i) {
            UserDefinedGroup group = this._groupArray.elementAt(i);
            if (group == null) continue;
            group.getIsls(isls);
        }
        return isls;
    }

    @Override
    public String getName() {
        if (this._groupArray == null || this._groupArray.size() == 0) {
            return null;
        }
        for (int i = 0; i < this._groupArray.size(); ++i) {
            UserDefinedGroup group = this._groupArray.elementAt(i);
            if (group == null || group.getName() == null) continue;
            return group.getName();
        }
        return null;
    }

    @Override
    public ArrayList<NpvLink> getNpvLinks(ArrayList<NpvLink> npvLinks) {
        if (npvLinks == null) {
            npvLinks = new HashedArrayList<NpvLink>();
        }
        if (this._groupArray == null || this._groupArray.size() == 0) {
            return npvLinks;
        }
        for (int i = 0; i < this._groupArray.size(); ++i) {
            UserDefinedGroup group = this._groupArray.elementAt(i);
            if (group == null) continue;
            group.getNpvLinks(npvLinks);
        }
        return npvLinks;
    }

    @Override
    public String getPath(char separator) {
        return this._fabric.getPath(separator) + separator + "Groups";
    }

    @Override
    public SnmpPeer[] getSnmpPeers() {
        if (this._groupArray == null || this._groupArray.size() == 0) {
            return new SnmpPeer[0];
        }
        Array<SnmpPeer> snmpPeerArray = new Array<SnmpPeer>();
        for (int i = 0; i < this._groupArray.size(); ++i) {
            SnmpPeer[] snmpPeers;
            UserDefinedGroup group = this._groupArray.elementAt(i);
            if (group == null || (snmpPeers = group.getSnmpPeers()) == null || snmpPeers.length == 0) continue;
            for (int j = 0; j < snmpPeers.length; ++j) {
                snmpPeerArray.addUniqueElement(snmpPeers[j]);
            }
        }
        return snmpPeerArray.toArray(new SnmpPeer[snmpPeerArray.size()]);
    }

    @Override
    public SnmpPeer[] getSnmpPeers(boolean needQuail) {
        if (this._groupArray == null || this._groupArray.size() == 0) {
            return new SnmpPeer[0];
        }
        Array<SnmpPeer> snmpPeerArray = new Array<SnmpPeer>();
        for (int i = 0; i < this._groupArray.size(); ++i) {
            SnmpPeer[] snmpPeers;
            UserDefinedGroup group = this._groupArray.elementAt(i);
            if (group == null || (snmpPeers = group.getSnmpPeers(needQuail)) == null || snmpPeers.length == 0) continue;
            for (int j = 0; j < snmpPeers.length; ++j) {
                snmpPeerArray.addUniqueElement(snmpPeers[j]);
            }
        }
        return snmpPeerArray.toArray(new SnmpPeer[snmpPeerArray.size()]);
    }

    @Override
    public Switch[] getSwitches() {
        if (this._groupArray == null || this._groupArray.size() == 0) {
            return new Switch[0];
        }
        Array<Switch> switchArray = new Array<Switch>();
        for (int i = 0; i < this._groupArray.size(); ++i) {
            Switch[] switches;
            UserDefinedGroup group = this._groupArray.elementAt(i);
            if (group == null || (switches = group.getSwitches()) == null || switches.length == 0) continue;
            for (int j = 0; j < switches.length; ++j) {
                switchArray.addUniqueElement(switches[j]);
            }
        }
        return switchArray.toArray(new Switch[switchArray.size()]);
    }

    @Override
    protected boolean inited() {
        return false;
    }

    public void setFabric(Fabric fabric) {
        this._fabric = fabric;
    }

    @Override
    public Fabric getFabric() {
        return this._fabric;
    }
}

