/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.model;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.sm.client.model.AbstractMgmtDomain;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.VsanBase;
import java.util.ArrayList;

public class VsanUnion
extends AbstractMgmtDomain {
    private Array<Vsan> _vsanArray = new Array();

    public VsanUnion(Vsan vsan) {
        this._vsanArray.addElement(vsan);
    }

    @Override
    public String getPath(char separator) {
        return this.getFabric().getPath(separator) + separator + this.getName();
    }

    @Override
    public String getPath() {
        return this.getPath('/');
    }

    @Override
    public Fabric getFabric() {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return null;
        }
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null || vsan.getFabric() == null) continue;
            return vsan.getFabric();
        }
        return null;
    }

    public void setVsans(Array<Vsan> vsanArray) {
        this._vsanArray = vsanArray;
    }

    public Vsan[] getVsans() {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return new Vsan[0];
        }
        return this._vsanArray.toArray((Vsan[])new Vsan[this._vsanArray.size()]);
    }

    @Override
    public EndPort[] getEndPorts() {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return new EndPort[0];
        }
        Array<EndPort> endPortArray = new Array<EndPort>();
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            EndPort[] endPorts;
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null || (endPorts = vsan.getEndPorts()) == null || endPorts.length == 0) continue;
            for (int j = 0; j < endPorts.length; ++j) {
                endPortArray.addUniqueElement(endPorts[j]);
            }
        }
        return endPortArray.toArray(new EndPort[endPortArray.size()]);
    }

    public EndPort[] getEndPortsIgnoreSwitch() {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return new EndPort[0];
        }
        Array<EndPort> endPortArray = new Array<EndPort>();
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            EndPort[] endPorts;
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null || (endPorts = vsan.getEndPortsIgnoreSwitch()) == null || endPorts.length == 0) continue;
            for (int j = 0; j < endPorts.length; ++j) {
                endPortArray.addUniqueElement(endPorts[j]);
            }
        }
        return endPortArray.toArray(new EndPort[endPortArray.size()]);
    }

    @Override
    public EndPort[] getEndPorts(boolean target) {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return new EndPort[0];
        }
        Array<EndPort> endPortArray = new Array<EndPort>();
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            EndPort[] endPorts;
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null || (endPorts = vsan.getEndPorts(target)) == null || endPorts.length == 0) continue;
            for (int j = 0; j < endPorts.length; ++j) {
                endPortArray.addUniqueElement(endPorts[j]);
            }
        }
        return endPortArray.toArray(new EndPort[endPortArray.size()]);
    }

    @Override
    public ArrayList<EndPort> getEndPorts(ArrayList<EndPort> isls, boolean target) {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return isls;
        }
        if (isls == null) {
            isls = new HashedArrayList<EndPort>();
        }
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null) continue;
            vsan.getEndPorts(isls, target);
        }
        return isls;
    }

    @Override
    public ArrayList<EndPort> getEndPortsAsList() {
        HashedArrayList<EndPort> isls = new HashedArrayList<EndPort>();
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return isls;
        }
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null) continue;
            ((ArrayList)isls).addAll(vsan.getEndPortsAsList());
        }
        return isls;
    }

    @Override
    public ArrayList<Isl> getIsls(ArrayList<Isl> isls) {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return isls;
        }
        if (isls == null) {
            isls = new HashedArrayList<Isl>();
        }
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null) continue;
            vsan.getIsls(isls);
        }
        return isls;
    }

    @Override
    public String getName() {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return null;
        }
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null || vsan.getBaseModelObject() == null || ((VsanBase)vsan.getBaseModelObject()).getName() == null) continue;
            return ((VsanBase)vsan.getBaseModelObject()).getName() + " (" + this._vsanArray.size() + " segments)";
        }
        return null;
    }

    @Override
    public ArrayList<NpvLink> getNpvLinks(ArrayList<NpvLink> npvLinks) {
        if (npvLinks == null) {
            npvLinks = new HashedArrayList<NpvLink>();
        }
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return npvLinks;
        }
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null) continue;
            vsan.getNpvLinks(npvLinks);
        }
        return npvLinks;
    }

    @Override
    public SnmpPeer[] getSnmpPeers() {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return new SnmpPeer[0];
        }
        Array<SnmpPeer> snmpPeerArray = new Array<SnmpPeer>();
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            SnmpPeer[] snmpPeers;
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null || (snmpPeers = vsan.getSnmpPeers()) == null || snmpPeers.length == 0) continue;
            for (int j = 0; j < snmpPeers.length; ++j) {
                snmpPeerArray.addUniqueElement(snmpPeers[j]);
            }
        }
        return snmpPeerArray.toArray(new SnmpPeer[snmpPeerArray.size()]);
    }

    @Override
    public int[] getUpIfIndices(Switch sw, short type) {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return new int[0];
        }
        IntArray indices = new IntArray();
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null) continue;
            indices.add(vsan.getUpIfIndices(sw, type));
        }
        return indices.toArray(new int[indices.size()]);
    }

    @Override
    public SnmpPeer[] getSnmpPeers(boolean needQuail) {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return new SnmpPeer[0];
        }
        Array<SnmpPeer> snmpPeerArray = new Array<SnmpPeer>();
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            SnmpPeer[] snmpPeers;
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null || (snmpPeers = vsan.getSnmpPeers(needQuail)) == null || snmpPeers.length == 0) continue;
            for (int j = 0; j < snmpPeers.length; ++j) {
                snmpPeerArray.addUniqueElement(snmpPeers[j]);
            }
        }
        return snmpPeerArray.toArray(new SnmpPeer[snmpPeerArray.size()]);
    }

    @Override
    public Switch[] getSwitches() {
        if (this._vsanArray == null || this._vsanArray.size() == 0) {
            return new Switch[0];
        }
        Array<Switch> switchArray = new Array<Switch>();
        for (int i = 0; i < this._vsanArray.size(); ++i) {
            Switch[] switches;
            Vsan vsan = this._vsanArray.elementAt(i);
            if (vsan == null || (switches = vsan.getSwitches()) == null || switches.length == 0) continue;
            for (int j = 0; j < switches.length; ++j) {
                switchArray.addUniqueElement(switches[j]);
            }
        }
        return switchArray.toArray(new Switch[switchArray.size()]);
    }

    @Override
    protected boolean inited() {
        return false;
    }
}

