/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.controller;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.script.AbstractWorker;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.npv.controller.AbstractAsyncSwitchTask;
import com.cisco.dcbu.sm.client.npv.controller.NpvSwitchTask;
import com.cisco.dcbu.sm.client.npv.controller.SwitchActionTracker;
import com.cisco.dcbu.sm.client.npv.controller.VerifyAccessTask;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.ProgressWindow;
import com.cisco.dcbu.sm.client.npv.view.SwitchChooserTableModel;
import com.cisco.dcbu.sm.client.npv.wizard.NpvCompleteStep;
import com.cisco.dcbu.sm.client.npv.wizard.NpvPairCreationStep;
import com.cisco.dcbu.sm.client.npv.wizard.NpvPortsCfgStep;
import com.cisco.dcbu.sm.client.npv.wizard.NpvSetupWizard;
import com.cisco.dcbu.sm.common.dto.NpvPortPairCfg;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class NpvSetupWizardController {
    public static final Logger _Logger = Logger.getLogger(NpvSetupWizardController.class);
    private static final Color AREA_BG_Color = UIManager.getColor("Label.background");
    private NpvSetupWizard wizard;
    private Fabric fabric;
    private List<Switch> npvCapableSwList = new ArrayList<Switch>();
    private List<Switch> npivCapableSwList = new ArrayList<Switch>();
    private List<Vsan> availVsanList = new ArrayList<Vsan>();
    private List<NpvLinkBase> npvlinkList = new ArrayList<NpvLinkBase>();
    private List<Switch> npvSelectedSwList = new ArrayList<Switch>();
    private List<Switch> npivSelectedSwList = new ArrayList<Switch>();
    private List<Switch> npvEnablingSwList = new ArrayList<Switch>();
    private List<Switch> npivEnablingSwList = new ArrayList<Switch>();
    private Map<Switch, Set<Switch>> npvSwPairs = new HashMap<Switch, Set<Switch>>();
    private Map<Switch, Set<Switch>> previousSwPairs = new HashMap<Switch, Set<Switch>>();
    private List<NpvPortPairCfg> npvPairCfgList = new ArrayList<NpvPortPairCfg>();
    private Map<Switch, List<FcPortBase>> npEnablingPorts = new HashMap<Switch, List<FcPortBase>>();
    private Map<Switch, List<FcPortBase>> fEnablingPorts = new HashMap<Switch, List<FcPortBase>>();
    private Map<Switch, List<FcPortBase>> fPorts = new HashMap<Switch, List<FcPortBase>>();
    private Map<Switch, List<FcPortBase>> npivEnablingPorts = new HashMap<Switch, List<FcPortBase>>();
    private Map<Switch, List<FcPortBase>> allPairVsanPorts = new HashMap<Switch, List<FcPortBase>>();
    private Map<Switch, List<FcPortBase>> vsanSetPorts = new HashMap<Switch, List<FcPortBase>>();
    private Map<Switch, List<FcPortBase>> allCoreVsanPorts = new HashMap<Switch, List<FcPortBase>>();
    private List<Switch> allVsanSwitches = new ArrayList<Switch>();
    private boolean runApply = false;
    private boolean isCanceled = false;
    private short selectedVsanId;
    private Vsan selectedVsan;
    private List<AbstractAsyncSwitchTask> taskList = new ArrayList<AbstractAsyncSwitchTask>();
    private List<AbstractWorker> workers = new ArrayList<AbstractWorker>();
    private int flexAttachMode = 0;

    public static String convertToHtml(String plainMessage) {
        String str = plainMessage;
        if (str != null && str.indexOf("<html>") < 0) {
            StringBuffer sb = new StringBuffer();
            str = str.replaceAll("\n", "<br>");
            str = str.replaceAll("<html>", "");
            str = str.replaceAll("</html>", "");
            str = "<html><body>" + str + "</body></html>";
            return str;
        }
        return plainMessage;
    }

    public static ArrayList convertToMultiLines(String plainMessage, int maxLen, String token) {
        ArrayList<String> list = new ArrayList<String>();
        if (plainMessage.length() <= maxLen) {
            list.add(plainMessage);
            return list;
        }
        if (token == null) {
            token = " ";
        }
        String[] substrs = plainMessage.split(token, 0);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < substrs.length; ++i) {
            if (sb.length() + substrs[i].length() > maxLen && sb.length() > 0) {
                list.add(sb.toString());
                sb.setLength(0);
            }
            sb.append(substrs[i]);
            if (i >= substrs.length - 1) continue;
            sb.append(token);
        }
        return list;
    }

    public static JPanel getIndentedPanel(JComponent[] comps, int indent) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.setBorder(new EmptyBorder(0, 0, 0, 0));
        p.add(Box.createHorizontalStrut(indent));
        for (JComponent comp : comps) {
            p.add(comp);
            p.add(Box.createRigidArea(new Dimension(5, 5)));
        }
        p.add(Box.createHorizontalGlue());
        return p;
    }

    public NpvSetupWizardController(NpvSetupWizard wizard) {
        this.wizard = wizard;
        this.fabric = ClientController.getInstance().getFabric();
    }

    public synchronized boolean isRunApply() {
        return this.runApply;
    }

    public synchronized void setCanceled(boolean b) {
        this.isCanceled = b;
    }

    public synchronized void setRunApply(boolean runApply) {
        this.runApply = runApply;
    }

    public Fabric getFabric() {
        return this.fabric;
    }

    public Object preloadData(ProgressWindow progressWindow) {
        try {
            progressWindow.setStatus("Loading all visible switches ...");
            List<Switch> swList = NpvClientHelper.getInstance().getSwitches(this.getFabric());
            progressWindow.setStatus("Loaded all visible switches");
            progressWindow.setProgress(5);
            if (swList.size() == 0) {
                throw new Exception("There are no switches visible to client.");
            }
            progressWindow.setStatus("Loading NPV capable switches ...");
            this.npvCapableSwList = NpvClientHelper.getInstance().getNpvCapableSwitches(swList, false);
            progressWindow.setStatus("Loaded NPV capable switches");
            progressWindow.setProgress(12);
            if (this.npvCapableSwList.size() == 0) {
                throw new Exception("There are no NPV capable switches.\nThey are either unmanageable or not present.\nNPV capable switches are MDS 9124, 9134, \nBlade Server or N5K with version 3.2(2) or later.\nNote: N5K only supported if NPV mode is already enabled and it contains physical FC Ports.\n");
            }
            progressWindow.setStatus("Loading NPIV capable switches ...");
            this.npivCapableSwList = NpvClientHelper.getInstance().getNpivCapableSwitches(swList);
            progressWindow.setStatus("Loaded NPIV capable switches");
            progressWindow.setProgress(14);
            if (this.npivCapableSwList.size() == 0) {
                throw new Exception("There are no NPIV capable switches.\nThey are either unmanageable or not present.\nAn NPIV capable switch is an MDS version 3.2(1) or later.\n");
            }
            progressWindow.setStatus("Loading available VSANs ...");
            this.availVsanList = NpvClientHelper.getInstance().getVsans(this.getFabric());
            progressWindow.setStatus("Loaded available VSANs");
            progressWindow.setProgress(20);
        }
        catch (Exception e) {
            _Logger.warn((Object)"Get exception from NPV preload: ", (Throwable)e);
            return e;
        }
        return null;
    }

    public void preSelectNpvCores(SwitchChooserTableModel model) {
        if (model == null) {
            return;
        }
        List<Switch[]> connectedSwList = NpvClientHelper.getInstance().queryConnectedPair(this.npvSelectedSwList, this.npivCapableSwList);
        ArrayList<WwnKey> coreList = new ArrayList<WwnKey>();
        for (Switch[] pair : connectedSwList) {
            if (pair == null || pair.length <= 1 || pair[1] == null) continue;
            coreList.add(pair[1].getSwitchPK());
        }
        model.setSelectedSwitchesOnKey(coreList);
        coreList.clear();
        connectedSwList.clear();
    }

    public void runSetupApply(final NpvCompleteStep step) {
        AbstractWorker worker = new AbstractWorker(){

            public void checkCanceled() throws Exception {
                if (NpvSetupWizardController.this.isCanceled) {
                    throw new Exception("NPV operations canceled by user");
                }
            }

            @Override
            public Object construct() {
                try {
                    int runs;
                    NpvSetupWizardController.this.setRunApply(true);
                    _Logger.debug((Object)"runSetupApply start to apply setup");
                    boolean hasError = false;
                    this.checkCanceled();
                    if (NpvSetupWizardController.this.getNpvEnablingSwList().size() > 0) {
                        int swCnt = NpvSetupWizardController.this.getNpvEnablingSwList().size();
                        NpvSwitchTask npvEnableTask = new NpvSwitchTask(AbstractAsyncSwitchTask.Type.EnableNPV, NpvSetupWizardController.this.getNpvEnablingSwList(), step.getSwitchFeatureEnableTableModel(), step.getProgressPanel());
                        runs = Math.max(Math.round(swCnt / 10), 5);
                        npvEnableTask.setTaskTimeout((long)runs * npvEnableTask.getMessageTimeout());
                        NpvSetupWizardController.this.taskList.add(npvEnableTask);
                        _Logger.info((Object)("run task " + (Object)((Object)npvEnableTask.getType()) + " on switches: " + npvEnableTask.getSwbList()));
                        npvEnableTask.run();
                        if (!npvEnableTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + (Object)((Object)npvEnableTask.getType()) + " with failed switches:" + npvEnableTask.getFailedSet()));
                            hasError = true;
                        } else {
                            _Logger.info((Object)("run task " + (Object)((Object)npvEnableTask.getType()) + " successful"));
                        }
                        npvEnableTask.closeTask();
                        NpvSetupWizardController.this.taskList.remove(npvEnableTask);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                step.getProgressPanel().setStatus("Waiting for switch(es) to reboot");
                            }
                        });
                        Thread.sleep(80000L);
                        this.checkCanceled();
                        VerifyAccessTask npvVerifyTask = new VerifyAccessTask(NpvSetupWizardController.this.getNpvEnablingSwList(), step.getSwitchFeatureEnableTableModel(), step.getProgressPanel(), true);
                        npvVerifyTask.setTaskTimeout(npvVerifyTask.getMessageTimeout());
                        NpvSetupWizardController.this.taskList.add(npvVerifyTask);
                        _Logger.info((Object)("run task " + (Object)((Object)npvVerifyTask.getType()) + " on switches: " + npvVerifyTask.getSwbList()));
                        npvVerifyTask.run();
                        if (!npvVerifyTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + (Object)((Object)npvVerifyTask.getType()) + " with failed switches:" + npvVerifyTask.getFailedSet()));
                            hasError = true;
                        } else {
                            _Logger.info((Object)("run task " + (Object)((Object)npvVerifyTask.getType()) + " successful"));
                        }
                        npvVerifyTask.closeTask();
                        NpvSetupWizardController.this.taskList.remove(npvVerifyTask);
                        this.checkCanceled();
                        List<SwitchBase> npvEnablingSwbList = NpvClientHelper.getInstance().convertToSwitchBase(NpvSetupWizardController.this.npvEnablingSwList);
                        Map<SwitchBase, List<FcPortBase>> npvPorts = NpvClientHelper.getInstance().findSwitchFcPortBase(npvEnablingSwbList);
                        if (npvPorts.size() != npvEnablingSwbList.size()) {
                            _Logger.warn((Object)"Cannot get ports from all switches enabling NPV");
                        }
                        HashMap<Switch, List<FcPortBase>> npvSwitchPortMap = new HashMap<Switch, List<FcPortBase>>();
                        for (Switch npvDev : NpvSetupWizardController.this.npvEnablingSwList) {
                            List<FcPortBase> ports = npvPorts.get(npvDev.getSwitchBase());
                            if (ports == null) {
                                _Logger.warn((Object)("Cannot get ports from enablingNPV:" + npvDev));
                            }
                            npvSwitchPortMap.put(npvDev, ports);
                        }
                        this.checkCanceled();
                        NpvSwitchTask npvEnablePortsTask = new NpvSwitchTask(AbstractAsyncSwitchTask.Type.EnablePorts, npvSwitchPortMap, step.getSwitchFeatureEnableTableModel(), step.getProgressPanel());
                        npvEnablePortsTask.setTaskTimeout((long)runs * npvEnablePortsTask.getMessageTimeout());
                        NpvSetupWizardController.this.taskList.add(npvEnablePortsTask);
                        _Logger.info((Object)("run task " + (Object)((Object)npvEnablePortsTask.getType()) + " on switches: " + npvSwitchPortMap));
                        npvEnablePortsTask.run();
                        if (!npvEnablePortsTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + (Object)((Object)npvEnablePortsTask.getType()) + " with failed switches:" + npvEnablePortsTask.getFailedSet()));
                            hasError = true;
                        } else {
                            _Logger.info((Object)("run task " + (Object)((Object)npvEnablePortsTask.getType()) + " successful"));
                        }
                        npvEnablePortsTask.closeTask();
                        NpvSetupWizardController.this.taskList.remove(npvEnablePortsTask);
                    }
                    this.checkCanceled();
                    if (NpvSetupWizardController.this.getNpivEnablingSwList().size() > 0) {
                        NpvSwitchTask npivEnableTask = new NpvSwitchTask(AbstractAsyncSwitchTask.Type.EnableNPIV, NpvSetupWizardController.this.getNpivEnablingSwList(), step.getSwitchFeatureEnableTableModel(), step.getProgressPanel());
                        int swCnt = NpvSetupWizardController.this.getNpivCapableSwList().size();
                        runs = Math.max(Math.round(swCnt / 10), 5);
                        npivEnableTask.setTaskTimeout((long)runs * npivEnableTask.getMessageTimeout());
                        NpvSetupWizardController.this.taskList.add(npivEnableTask);
                        _Logger.info((Object)("run task " + (Object)((Object)npivEnableTask.getType()) + " on switches: " + npivEnableTask.getSwbList()));
                        npivEnableTask.run();
                        if (!npivEnableTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + (Object)((Object)npivEnableTask.getType()) + " with failed switches:" + npivEnableTask.getFailedSet()));
                            hasError = true;
                            _Logger.info((Object)("run task " + (Object)((Object)npivEnableTask.getType()) + " successful"));
                        }
                        npivEnableTask.closeTask();
                        NpvSetupWizardController.this.taskList.remove(npivEnableTask);
                    }
                    this.checkCanceled();
                    if (NpvSetupWizardController.this.getNpEnablingPorts().size() > 0) {
                        NpvSwitchTask npPortTask = new NpvSwitchTask(AbstractAsyncSwitchTask.Type.SetNpPorts, NpvSetupWizardController.this.getNpEnablingPorts(), step.getSwitchFeatureEnableTableModel(), step.getProgressPanel());
                        int swCnt = NpvSetupWizardController.this.getNpEnablingPorts().size();
                        runs = Math.max(Math.round(swCnt / 10), 5);
                        npPortTask.setTaskTimeout((long)runs * npPortTask.getMessageTimeout());
                        NpvSetupWizardController.this.taskList.add(npPortTask);
                        _Logger.info((Object)("run task " + (Object)((Object)npPortTask.getType()) + " on switches: " + npPortTask.getSwbList() + "\n" + npPortTask.getPortList()));
                        npPortTask.run();
                        if (!npPortTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + (Object)((Object)npPortTask.getType()) + " with failed switches:" + npPortTask.getFailedSet()));
                            hasError = true;
                        } else {
                            _Logger.info((Object)("run task " + (Object)((Object)npPortTask.getType()) + " successful"));
                        }
                        npPortTask.closeTask();
                        NpvSetupWizardController.this.taskList.remove(npPortTask);
                    }
                    this.checkCanceled();
                    if (NpvSetupWizardController.this.getNpivEnablingPorts().size() > 0) {
                        NpvSwitchTask autoPortTask = new NpvSwitchTask(AbstractAsyncSwitchTask.Type.SetNpivPorts, NpvSetupWizardController.this.getNpivEnablingPorts(), step.getSwitchFeatureEnableTableModel(), step.getProgressPanel());
                        int swCnt = NpvSetupWizardController.this.getNpivEnablingPorts().size();
                        runs = Math.max(Math.round(swCnt / 10), 5);
                        autoPortTask.setTaskTimeout((long)runs * autoPortTask.getMessageTimeout());
                        NpvSetupWizardController.this.taskList.add(autoPortTask);
                        _Logger.info((Object)("run task " + (Object)((Object)autoPortTask.getType()) + " on switches: " + autoPortTask.getSwbList() + "\n" + autoPortTask.getPortList()));
                        autoPortTask.run();
                        if (!autoPortTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + (Object)((Object)autoPortTask.getType()) + " with failed switches:" + autoPortTask.getFailedSet()));
                            hasError = true;
                        } else {
                            _Logger.info((Object)("run task " + (Object)((Object)autoPortTask.getType()) + " successful"));
                        }
                        autoPortTask.closeTask();
                        NpvSetupWizardController.this.taskList.remove(autoPortTask);
                    }
                    this.checkCanceled();
                    if (NpvSetupWizardController.this.getFEnablingPorts().size() > 0) {
                        NpvSwitchTask fPortTask = new NpvSwitchTask(AbstractAsyncSwitchTask.Type.SetFPorts, NpvSetupWizardController.this.getFEnablingPorts(), step.getSwitchFeatureEnableTableModel(), step.getProgressPanel());
                        int swCnt = NpvSetupWizardController.this.getFEnablingPorts().size();
                        runs = Math.max(Math.round(swCnt / 10), 5);
                        fPortTask.setTaskTimeout((long)runs * fPortTask.getMessageTimeout());
                        NpvSetupWizardController.this.taskList.add(fPortTask);
                        _Logger.info((Object)("run task " + (Object)((Object)fPortTask.getType()) + " on switches: " + fPortTask.getSwbList() + "\n" + fPortTask.getPortList()));
                        fPortTask.run();
                        if (!fPortTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + (Object)((Object)fPortTask.getType()) + " with failed switches:" + fPortTask.getFailedSet()));
                            hasError = true;
                        } else {
                            _Logger.info((Object)("run task " + (Object)((Object)fPortTask.getType()) + " successful"));
                        }
                        fPortTask.closeTask();
                        NpvSetupWizardController.this.taskList.remove(fPortTask);
                    }
                    this.checkCanceled();
                    List<Switch> allVsanSwList = NpvSetupWizardController.this.getAllVsanSwitches();
                    if (allVsanSwList.size() > 0) {
                        NpvSwitchTask vsanSwitchTask = new NpvSwitchTask(AbstractAsyncSwitchTask.Type.AddVSANSwitches, allVsanSwList, NpvSetupWizardController.this.selectedVsanId, NpvSetupWizardController.this.selectedVsan, step.getSwitchFeatureEnableTableModel(), step.getProgressPanel());
                        int swCnt = allVsanSwList.size();
                        int runs2 = Math.max(Math.round(swCnt / 10), 5);
                        vsanSwitchTask.setTaskTimeout((long)runs2 * vsanSwitchTask.getMessageTimeout());
                        NpvSetupWizardController.this.taskList.add(vsanSwitchTask);
                        _Logger.info((Object)("run task " + (Object)((Object)vsanSwitchTask.getType()) + " on switches: " + vsanSwitchTask.getSwbList()));
                        vsanSwitchTask.run();
                        if (!vsanSwitchTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + (Object)((Object)vsanSwitchTask.getType()) + " with failed switches:" + vsanSwitchTask.getFailedSet()));
                            hasError = true;
                        } else {
                            _Logger.info((Object)("run task " + (Object)((Object)vsanSwitchTask.getType()) + " successful"));
                        }
                        vsanSwitchTask.closeTask();
                        NpvSetupWizardController.this.taskList.remove(vsanSwitchTask);
                    }
                    this.checkCanceled();
                    Map<Switch, List<FcPortBase>> allVsanPorts = NpvSetupWizardController.this.getAllVsanSetPorts();
                    if (allVsanPorts.size() > 0) {
                        NpvSwitchTask vsanPortsTask = new NpvSwitchTask(AbstractAsyncSwitchTask.Type.AddVSANPorts, allVsanPorts, NpvSetupWizardController.this.selectedVsanId, NpvSetupWizardController.this.selectedVsan, step.getSwitchFeatureEnableTableModel(), step.getProgressPanel());
                        int swCnt = allVsanPorts.size();
                        int runs3 = Math.max(Math.round(swCnt / 10), 5);
                        vsanPortsTask.setTaskTimeout((long)runs3 * vsanPortsTask.getMessageTimeout());
                        NpvSetupWizardController.this.taskList.add(vsanPortsTask);
                        _Logger.info((Object)("run task " + (Object)((Object)vsanPortsTask.getType()) + " on switches: " + vsanPortsTask.getSwbList() + "\n" + vsanPortsTask.getPortList()));
                        vsanPortsTask.run();
                        if (!vsanPortsTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + (Object)((Object)vsanPortsTask.getType()) + " with failed switches:" + vsanPortsTask.getFailedSet()));
                            hasError = true;
                        } else {
                            _Logger.info((Object)("run task " + (Object)((Object)vsanPortsTask.getType()) + " successful"));
                        }
                        vsanPortsTask.closeTask();
                        NpvSetupWizardController.this.taskList.remove(vsanPortsTask);
                    }
                    this.checkCanceled();
                    List<Switch> allSwList = NpvSetupWizardController.this.getAllVsanSwitches();
                    if (allSwList.size() > 0) {
                        NpvSwitchTask saveCfgTask = new NpvSwitchTask(AbstractAsyncSwitchTask.Type.SaveConfig, allSwList, null, step.getProgressPanel());
                        int swCnt = allSwList.size();
                        int runs4 = Math.max(Math.round(swCnt / 10), 5);
                        saveCfgTask.setTaskTimeout((long)runs4 * saveCfgTask.getMessageTimeout());
                        NpvSetupWizardController.this.taskList.add(saveCfgTask);
                        _Logger.info((Object)("run task " + (Object)((Object)saveCfgTask.getType()) + " on switches: " + saveCfgTask.getSwbList()));
                        saveCfgTask.run();
                        if (!saveCfgTask.isTaskSuccess()) {
                            _Logger.warn((Object)("run task " + (Object)((Object)saveCfgTask.getType()) + " with failed switches:" + saveCfgTask.getFailedSet()));
                        } else {
                            _Logger.info((Object)("run task " + (Object)((Object)saveCfgTask.getType()) + " successful"));
                        }
                        saveCfgTask.closeTask();
                        NpvSetupWizardController.this.taskList.remove(saveCfgTask);
                    }
                    return new Boolean(hasError);
                }
                catch (Exception e) {
                    if (NpvSetupWizardController.this.isCanceled) {
                        _Logger.warn((Object)(e.getMessage() + ".  Cancel pressed."));
                        return false;
                    }
                    _Logger.warn((Object)"Got exceptions from apply NPV settings:", (Throwable)e);
                    return e;
                }
            }

            @Override
            public void finished() {
                Object ret = this.getValue();
                NpvSetupWizardController.this.setRunApply(false);
                if (ret instanceof Exception) {
                    step.actionFinished(false);
                    Util.errorMessage((Component)step.getWizard(), (Exception)ret);
                } else if (ret instanceof Boolean) {
                    step.actionFinished((Boolean)ret == false);
                }
            }
        };
        worker.start();
    }

    public List<Switch[]> getConnectedPairs() {
        return NpvClientHelper.getInstance().queryConnectedPair(this.npvSelectedSwList, this.npivSelectedSwList);
    }

    public void runQueryISLNpvPorts(final NpvPortsCfgStep step) {
        AbstractWorker worker = new AbstractWorker(){
            List<NpvPortPairCfg> npvCfgList = new ArrayList<NpvPortPairCfg>();
            List<Map<Switch, List<FcPortBase>>> portSettings = null;
            Map<Switch, List<FcPortBase>> vsanSetPorts = null;
            List<Switch> allVsanSwitches = null;

            @Override
            public Object construct() {
                try {
                    if (NpvSetupWizardController.this.getNpvSwPairs().size() > 0) {
                        boolean hasNoneISLPair = NpvClientHelper.getInstance().queryNpvPortPairsfromIsls(NpvSetupWizardController.this.getNpvSwPairs(), this.npvCfgList);
                        this.portSettings = NpvClientHelper.getInstance().getNpvPortSettings(this.npvCfgList);
                        this.allVsanSwitches = NpvClientHelper.getInstance().queryAllVsanSwitches(NpvSetupWizardController.this.getNpvSelecteSwList(), this.npvCfgList);
                        this.vsanSetPorts = NpvClientHelper.getInstance().queryAllVsanPorts(NpvSetupWizardController.this.getNpvSelecteSwList(), this.npvCfgList, false);
                        return new Boolean(hasNoneISLPair);
                    }
                    throw new Exception("There are no NPV switch pairs");
                }
                catch (Exception e) {
                    _Logger.warn((Object)"Cannot query NPV port setting from ISLs:", (Throwable)e);
                    return e;
                }
            }

            @Override
            public void finished() {
                Object ret = this.getValue();
                NpvSetupWizardController.this.getWizard().setCursor(false);
                NpvSetupWizardController.this.getWizard().setStatus("");
                if (ret instanceof Exception) {
                    Util.errorMessage((Component)step.getWizard(), (Exception)ret);
                    step.actionFinished(false);
                } else if (ret instanceof Boolean) {
                    int option;
                    boolean hasNoneISLPair = (Boolean)ret;
                    if (hasNoneISLPair && (option = JOptionPane.showConfirmDialog(step.getWizard(), "Some NPV pairs have no ISLs and their ports will be skipped. \nAlready configured NPV devices will retain existing configurations. \nBlade server without ISLs will go into default NPV port configuration. \n\n\nDo you want to continue?", "Warning", 0, 3)) != 0) {
                        step.actionFinished(false);
                        return;
                    }
                    NpvSetupWizardController.this.setNpvPairCfgList(this.npvCfgList);
                    NpvSetupWizardController.this.setNpEnablingPorts(this.portSettings.get(0));
                    NpvSetupWizardController.this.setNpivEnablingPorts(this.portSettings.get(1));
                    NpvSetupWizardController.this.setFEnablingPorts(this.portSettings.get(2));
                    NpvSetupWizardController.this.setFPorts(this.portSettings.get(3));
                    NpvSetupWizardController.this.setAllVsanSwitches(this.allVsanSwitches);
                    NpvSetupWizardController.this.setVsanSetPorts(this.vsanSetPorts);
                    NpvSetupWizardController.this.addVsanSetPorts(NpvSetupWizardController.this.getNpEnablingPorts());
                    NpvSetupWizardController.this.addVsanSetPorts(NpvSetupWizardController.this.getNpivEnablingPorts());
                    NpvSetupWizardController.this.addVsanSetPorts(NpvSetupWizardController.this.getFEnablingPorts());
                    this.portSettings.clear();
                    step.actionFinished(true);
                }
            }
        };
        worker.start();
    }

    public void runQueryNpvPorts(final NpvPortsCfgStep step) {
        AbstractWorker worker = new AbstractWorker(){
            List<Map<Switch, List<FcPortBase>>> pSettings = null;
            Map<Switch, List<FcPortBase>> allVsanPorts = null;
            Map<Switch, List<FcPortBase>> vsanSetPorts = null;
            Map<Switch, List<FcPortBase>> allCoreVsanPorts = null;
            List<Switch> allVsanSwitches = null;
            int numNpvLinks = 0;

            public boolean compareList() {
                if (NpvSetupWizardController.this.previousSwPairs == null) {
                    return false;
                }
                Set keySet = NpvSetupWizardController.this.npvSwPairs.keySet();
                Set pKeySet = NpvSetupWizardController.this.previousSwPairs.keySet();
                if (keySet.size() != pKeySet.size()) {
                    return false;
                }
                HashSet keySetTmp = new HashSet();
                keySetTmp.addAll(keySet);
                keySetTmp.removeAll(pKeySet);
                if (keySetTmp.size() > 0) {
                    return false;
                }
                for (Switch key : keySet) {
                    if (!NpvSetupWizardController.this.previousSwPairs.containsKey(key)) {
                        return false;
                    }
                    Set pCores = (Set)NpvSetupWizardController.this.previousSwPairs.get(key);
                    Set cores = (Set)NpvSetupWizardController.this.npvSwPairs.get(key);
                    if (pCores.size() != cores.size()) {
                        return false;
                    }
                    HashSet tmp = new HashSet();
                    tmp.addAll(cores);
                    tmp.removeAll(pCores);
                    if (tmp.size() <= 0) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Object construct() {
                try {
                    if (this.compareList()) {
                        return false;
                    }
                    NpvSetupWizardController.this.previousSwPairs.clear();
                    Set setSw = NpvSetupWizardController.this.npvSwPairs.keySet();
                    for (Switch key : setSw) {
                        Set values = (Set)NpvSetupWizardController.this.npvSwPairs.get(key);
                        HashSet newVal = new HashSet();
                        newVal.addAll(values);
                        NpvSetupWizardController.this.previousSwPairs.put(key, newVal);
                    }
                    if (NpvSetupWizardController.this.npvSwPairs.size() > 0) {
                        ArrayList<NpvPortPairCfg> npvCfgList = new ArrayList<NpvPortPairCfg>();
                        Set swPairsSet = NpvSetupWizardController.this.npvSwPairs.entrySet();
                        for (Map.Entry entry : swPairsSet) {
                            Switch devSw = (Switch)entry.getKey();
                            Set cores = (Set)entry.getValue();
                            for (Switch coreSw : cores) {
                                NpvPortPairCfg cfg = new NpvPortPairCfg(devSw.getSwitchBase(), coreSw.getSwitchBase());
                                npvCfgList.add(cfg);
                            }
                        }
                        this.pSettings = NpvClientHelper.getInstance().getNpvPortSettings(npvCfgList);
                        this.allVsanSwitches = NpvClientHelper.getInstance().queryAllVsanSwitches(NpvSetupWizardController.this.getNpvSelecteSwList(), npvCfgList);
                        this.allVsanPorts = NpvClientHelper.getInstance().queryAllVsanPorts(new ArrayList<Switch>(NpvSetupWizardController.this.getNpvSwPairs().keySet()), npvCfgList, true);
                        this.vsanSetPorts = NpvClientHelper.getInstance().queryAllVsanPorts(NpvSetupWizardController.this.getNpvSelecteSwList(), npvCfgList, false);
                        this.allCoreVsanPorts = NpvClientHelper.getInstance().queryAllVsanPorts(NpvSetupWizardController.this.getNpivSelectedSwList(), npvCfgList, false);
                        return npvCfgList;
                    }
                    throw new Exception("There are no NPV switch pairs");
                }
                catch (Exception e) {
                    _Logger.warn((Object)"Cannot query NPV port setting from auto selection:", (Throwable)e);
                    return e;
                }
            }

            @Override
            public void finished() {
                Object ret = this.getValue();
                NpvSetupWizardController.this.getWizard().setCursor(false);
                NpvSetupWizardController.this.getWizard().setStatus("");
                if (ret instanceof Exception) {
                    Util.errorMessage((Component)step.getWizard(), (Exception)ret);
                    return;
                }
                if (ret instanceof List) {
                    List npvCfgList = (List)ret;
                    NpvSetupWizardController.this.setNpvPairCfgList(npvCfgList);
                    NpvSetupWizardController.this.setNpEnablingPorts(this.pSettings.get(0));
                    NpvSetupWizardController.this.setNpivEnablingPorts(this.pSettings.get(1));
                    NpvSetupWizardController.this.setFEnablingPorts(this.pSettings.get(2));
                    NpvSetupWizardController.this.setAllVsanSwitches(this.allVsanSwitches);
                    NpvSetupWizardController.this.setAllPairVsanPorts(this.allVsanPorts);
                    NpvSetupWizardController.this.setVsanSetPorts(this.vsanSetPorts);
                    NpvSetupWizardController.this.setAllCoreVsanPorts(this.allCoreVsanPorts);
                    this.pSettings.clear();
                    step.updatePortTree();
                }
            }
        };
        worker.start();
    }

    public void runQueryAutoNpvPorts(final NpvPortsCfgStep step) {
        AbstractWorker worker = new AbstractWorker(){
            List<Map<Switch, List<FcPortBase>>> pSettings = null;
            Map<Switch, List<FcPortBase>> vsanSetPorts = null;
            List<Switch> allVsanSwitches = null;
            int numNpvLinks = 0;

            @Override
            public Object construct() {
                try {
                    if (NpvSetupWizardController.this.npvSwPairs.size() > 0) {
                        ArrayList<NpvPortPairCfg> npvCfgList = new ArrayList<NpvPortPairCfg>();
                        Set swPairsSet = NpvSetupWizardController.this.npvSwPairs.entrySet();
                        for (Map.Entry entry : swPairsSet) {
                            Switch devSw = (Switch)entry.getKey();
                            Set cores = (Set)entry.getValue();
                            for (Switch coreSw : cores) {
                                NpvPortPairCfg cfg = new NpvPortPairCfg(devSw.getSwitchBase(), coreSw.getSwitchBase());
                                npvCfgList.add(cfg);
                            }
                        }
                        this.numNpvLinks = step.getNumberOfLinks();
                        List<NpvPortPairCfg> autoNpvCfgList = NpvClientHelper.getInstance().queryAutoNpvPairPortCfg(npvCfgList, this.numNpvLinks);
                        this.pSettings = NpvClientHelper.getInstance().getNpvPortSettings(autoNpvCfgList);
                        this.allVsanSwitches = NpvClientHelper.getInstance().queryAllVsanSwitches(NpvSetupWizardController.this.getNpvSelecteSwList(), autoNpvCfgList);
                        this.vsanSetPorts = NpvClientHelper.getInstance().queryAllVsanPorts(NpvSetupWizardController.this.getNpvSelecteSwList(), autoNpvCfgList, false);
                        return autoNpvCfgList;
                    }
                    throw new Exception("There are no NPV switch pairs");
                }
                catch (Exception e) {
                    _Logger.warn((Object)"Cannot query NPV port setting from auto selection:", (Throwable)e);
                    return e;
                }
            }

            @Override
            public void finished() {
                Object ret = this.getValue();
                NpvSetupWizardController.this.getWizard().setCursor(false);
                NpvSetupWizardController.this.getWizard().setStatus("");
                if (ret instanceof Exception) {
                    Util.errorMessage((Component)step.getWizard(), (Exception)ret);
                    step.actionFinished(false);
                    return;
                }
                if (ret instanceof List) {
                    List autoCfgList = (List)ret;
                    if (autoCfgList == null || autoCfgList.size() == 0) {
                        int option = JOptionPane.showConfirmDialog(step.getWizard(), "There are no automatic NPV port configuration available. \n\n\nDo you want to continue?", "Warning", 0, 3);
                        if (option != 0) {
                            step.actionFinished(false);
                            return;
                        }
                    } else {
                        ArrayList<Exception> errors = new ArrayList<Exception>();
                        for (NpvPortPairCfg cfg : autoCfgList) {
                            if (cfg.getException() != null) {
                                _Logger.warn((Object)("Got exceptions from queryAutoNpvPairPortCfg - NpvPortPairCfg:" + cfg), (Throwable)cfg.getException());
                                errors.add(new Exception("Npv Device (" + cfg.getDevice() + "), " + "Npv Core (" + cfg.getNpvCore() + "): " + cfg.getException().getMessage(), cfg.getException()));
                                continue;
                            }
                            if (cfg.getNPPorts() == null || cfg.getNPPorts().size() != this.numNpvLinks) {
                                _Logger.warn((Object)("From queryAutoNpvPairPortCfg - NpvPortPairCfg:" + cfg + " NPPorts do not match with NPV links"));
                                errors.add(new Exception("Npv Device (" + cfg.getDevice() + "), " + "Npv Core (" + cfg.getNpvCore() + "): " + "selected NP ports do not match with the number of NPV links."));
                                continue;
                            }
                            if (cfg.getCoreFPorts() != null && cfg.getCoreFPorts().size() == this.numNpvLinks) continue;
                            _Logger.warn((Object)("From queryAutoNpvPairPortCfg - NpvPortPairCfg:" + cfg + " Core Auto Ports do not match with NPV links"));
                            errors.add(new Exception("Npv Device (" + cfg.getDevice() + "), " + "Npv Core (" + cfg.getNpvCore() + "): " + "selected ports at core switch do not match with the number of NPV links."));
                        }
                        if (errors.size() > 0) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("Please review the followings:\n");
                            for (Exception e : errors) {
                                sb.append(e.getMessage());
                                sb.append("\n");
                            }
                            sb.append("\n\nDo you want to continue?");
                            int option = JOptionPane.showConfirmDialog(step.getWizard(), NpvSetupWizardController.convertToHtml(sb.toString()), "Warning", 0, 3);
                            if (option != 0) {
                                step.actionFinished(false);
                                return;
                            }
                        }
                        NpvSetupWizardController.this.setNpvPairCfgList(autoCfgList);
                        NpvSetupWizardController.this.setNpEnablingPorts(this.pSettings.get(0));
                        NpvSetupWizardController.this.setNpivEnablingPorts(this.pSettings.get(1));
                        NpvSetupWizardController.this.setFEnablingPorts(this.pSettings.get(2));
                        NpvSetupWizardController.this.setFPorts(this.pSettings.get(3));
                        NpvSetupWizardController.this.setAllVsanSwitches(this.allVsanSwitches);
                        NpvSetupWizardController.this.setVsanSetPorts(this.vsanSetPorts);
                        NpvSetupWizardController.this.addVsanSetPorts(NpvSetupWizardController.this.getNpEnablingPorts());
                        NpvSetupWizardController.this.addVsanSetPorts(NpvSetupWizardController.this.getNpivEnablingPorts());
                        NpvSetupWizardController.this.addVsanSetPorts(NpvSetupWizardController.this.getFEnablingPorts());
                        this.pSettings.clear();
                        step.actionFinished(true);
                    }
                }
            }
        };
        worker.start();
    }

    public boolean validateSwPairSelection(NpvPairCreationStep step) {
        Map<Switch, Set<Switch>> npvPairs = step.getNPVPairs();
        Map<Switch, Set<Switch>> segmentSwPairs = NpvClientHelper.getInstance().queryMaySegmentPairs(npvPairs, this.npvSelectedSwList);
        if (segmentSwPairs != null && segmentSwPairs.size() > 0) {
            JLabel area = new JLabel("", 2);
            StringBuffer sb = new StringBuffer();
            sb.append("The following connected pairs are not selected. \nThey may be segmented after NPV setup.\n");
            Iterator<Map.Entry<Switch, Set<Switch>>> it = segmentSwPairs.entrySet().iterator();
            String segmentPairStr = null;
            while (it.hasNext()) {
                Map.Entry<Switch, Set<Switch>> entry = it.next();
                Switch npvDev = entry.getKey();
                Iterator<Switch> coreIt = entry.getValue().iterator();
                while (coreIt.hasNext()) {
                    sb.append(npvDev.getName());
                    sb.append("<->");
                    sb.append(coreIt.next().getName());
                    sb.append("\n");
                }
            }
            segmentPairStr = sb.toString();
            sb.append("\n\nDo you want to continue?");
            area.setText(NpvSetupWizardController.convertToHtml(sb.toString()));
            JScrollPane sc = new JScrollPane(area);
            sc.setBorder(new EmptyBorder(0, 0, 0, 0));
            int option = JOptionPane.showConfirmDialog(step, sc, "Warning - NPV Setup Wizard", 0, 2);
            if (option == 0) {
                _Logger.info((Object)("User chosen NPV switch pairs may have segmentations:\n" + segmentPairStr));
            }
            return option == 0;
        }
        return true;
    }

    public List<Vsan> getAvailVsanList() {
        return this.availVsanList;
    }

    public void setAvailVsanList(List<Vsan> availVsanList) {
        this.availVsanList.clear();
        if (availVsanList != null) {
            this.availVsanList.addAll(availVsanList);
        }
    }

    public List<Switch> getNpivSelectedSwList() {
        return this.npivSelectedSwList;
    }

    public void setNpivSelectedSwList(List<Switch> npivSelectedSwList) {
        this.npivSelectedSwList.clear();
        if (npivSelectedSwList != null) {
            this.npivSelectedSwList.addAll(npivSelectedSwList);
        }
    }

    public List<Switch> getNpvSelecteSwList() {
        return this.npvSelectedSwList;
    }

    public void setNpvSelectedSwList(List<Switch> npvSelectedSwList) {
        this.npvSelectedSwList.clear();
        if (npvSelectedSwList != null) {
            this.npvSelectedSwList.addAll(npvSelectedSwList);
        }
    }

    @Deprecated
    public List<Switch> getNpivEnablingSwList() {
        return this.npivEnablingSwList;
    }

    public List<Switch> getEnableNpivList() {
        ArrayList<Switch> retList = new ArrayList<Switch>();
        for (Switch sw : this.npivEnablingSwList) {
            for (Set<Switch> npiv : this.npvSwPairs.values()) {
                if (!NpvClientHelper.contains(npiv, sw) || NpvClientHelper.contains(retList, sw)) continue;
                retList.add(sw);
            }
        }
        return retList;
    }

    public void setNpivEnablingSwList(List<Switch> npivEnablingSwList) {
        this.npivEnablingSwList.clear();
        if (npivEnablingSwList != null) {
            this.npivEnablingSwList.addAll(npivEnablingSwList);
        }
    }

    @Deprecated
    public List<Switch> getNpvEnablingSwList() {
        return this.npvEnablingSwList;
    }

    public List<Switch> getEnableNpvList() {
        List<Switch> selected = this.getNpvEnablingSwList();
        ArrayList<Switch> npvList = new ArrayList<Switch>();
        for (Switch sw : selected) {
            Set<Switch> npvSws = this.getNpvSwPairs().keySet();
            if (!NpvClientHelper.contains(npvSws, sw)) continue;
            npvList.add(sw);
        }
        return npvList;
    }

    public void setNpvEnablingSwList(List<Switch> npvEnablingSwList) {
        this.npvEnablingSwList.clear();
        if (npvEnablingSwList != null) {
            this.npvEnablingSwList.addAll(npvEnablingSwList);
        }
    }

    public List<Switch> getNpivCapableSwList() {
        return this.npivCapableSwList;
    }

    public List<Switch> updateNpivCapableSwList(List<Switch> selectedNpvList) {
        if (selectedNpvList != null) {
            List<Switch> npivCapable = NpvClientHelper.getInstance().getNpivCapableSwitches(NpvClientHelper.getInstance().getSwitches(this.getFabric()));
            ArrayList<Switch> newNpivList = new ArrayList<Switch>();
            HashSet<Switch> npvSwSet = new HashSet<Switch>(selectedNpvList);
            for (Switch npivSw : npivCapable) {
                if (npvSwSet.contains(npivSw)) continue;
                newNpivList.add(npivSw);
            }
            this.npivCapableSwList.clear();
            this.npivCapableSwList.addAll(newNpivList);
            newNpivList.clear();
        }
        return this.npivCapableSwList;
    }

    public void setNpivCapableSwList(List<Switch> npivCapableSwList) {
        this.npivCapableSwList.clear();
        if (npivCapableSwList != null) {
            this.npivCapableSwList.addAll(npivCapableSwList);
        }
    }

    public List<Switch> getNpvCapableSwList() {
        return this.npvCapableSwList;
    }

    public void setNpvCapableSwList(List<Switch> npvCapableSwList) {
        this.npvCapableSwList.clear();
        if (npvCapableSwList != null) {
            this.npvCapableSwList.addAll(npvCapableSwList);
        }
    }

    public Map<Switch, Set<Switch>> getNpvSwPairs() {
        return this.npvSwPairs;
    }

    public void setNpvSwPairs(Map<Switch, Set<Switch>> npvSwPairs) {
        if (this.npvSwPairs == npvSwPairs) {
            return;
        }
        for (Set<Switch> sws : this.npvSwPairs.values()) {
            if (sws == null) continue;
            sws.clear();
        }
        this.npvSwPairs.clear();
        if (npvSwPairs != null) {
            for (Map.Entry<Switch, Set<Switch>> entry : npvSwPairs.entrySet()) {
                HashSet swSet = new HashSet(entry.getValue());
                this.npvSwPairs.put(entry.getKey(), swSet);
            }
        }
    }

    public Map<Switch, List<FcPortBase>> getNpivEnablingPorts() {
        return this.npivEnablingPorts;
    }

    public void setNpivEnablingPorts(Map<Switch, List<FcPortBase>> ports) {
        if (this.npivEnablingPorts == ports) {
            return;
        }
        NpvClientHelper.clearMapList(this.npivEnablingPorts);
        NpvClientHelper.copyMapList(ports, this.npivEnablingPorts);
    }

    @Deprecated
    public Map<Switch, List<FcPortBase>> getFEnablingPorts() {
        return this.fEnablingPorts;
    }

    public Map<Switch, List<FcPortBase>> getEnableFPorts() {
        HashMap<Switch, List<FcPortBase>> retMap = new HashMap<Switch, List<FcPortBase>>();
        Set<Switch> npvSws = this.fEnablingPorts.keySet();
        Set<Switch> pairs = this.npvSwPairs.keySet();
        for (Switch sw : npvSws) {
            if (!NpvClientHelper.contains(pairs, sw)) continue;
            retMap.put(sw, this.fEnablingPorts.get(sw));
        }
        return retMap;
    }

    public void setFPorts(Map<Switch, List<FcPortBase>> ports) {
        NpvClientHelper.clearMapList(this.fPorts);
        NpvClientHelper.copyMapList(ports, this.fPorts);
    }

    public Map<Switch, List<FcPortBase>> getFPorts() {
        return this.fPorts;
    }

    public void setFEnablingPorts(Map<Switch, List<FcPortBase>> ports) {
        NpvClientHelper.clearMapList(this.fEnablingPorts);
        NpvClientHelper.copyMapList(ports, this.fEnablingPorts);
    }

    @Deprecated
    public Map<Switch, List<FcPortBase>> getNpEnablingPorts() {
        return this.npEnablingPorts;
    }

    public Map<Switch, List<FcPortBase>> getEnableNpPorts() {
        Set<Switch> eSws = this.npEnablingPorts.keySet();
        Set<Switch> npvSws = this.getNpvSwPairs().keySet();
        HashMap<Switch, List<FcPortBase>> retMap = new HashMap<Switch, List<FcPortBase>>();
        for (Switch sw : eSws) {
            if (!NpvClientHelper.contains(npvSws, sw)) continue;
            retMap.put(sw, this.npEnablingPorts.get(sw));
        }
        return retMap;
    }

    public void setNpEnablingPorts(Map<Switch, List<FcPortBase>> ports) {
        NpvClientHelper.clearMapList(this.npEnablingPorts);
        NpvClientHelper.copyMapList(ports, this.npEnablingPorts);
    }

    public short getSelectedVsanId() {
        return this.selectedVsanId;
    }

    public void setSelectedVsanId(short vsanId) {
        this.selectedVsanId = vsanId;
    }

    public Vsan getSelectedVsan() {
        return this.selectedVsan;
    }

    public void setSelectedVsan(Vsan selectedVsan) {
        this.selectedVsan = selectedVsan;
        if (selectedVsan != null) {
            this.selectedVsanId = selectedVsan.getId();
        }
    }

    public List<NpvPortPairCfg> getNpvPairCfgList() {
        return this.npvPairCfgList;
    }

    public void setNpvPairCfgList(List<NpvPortPairCfg> npvPairCfgList) {
        if (this.npvPairCfgList == npvPairCfgList) {
            return;
        }
        this.npvPairCfgList.clear();
        if (npvPairCfgList != null) {
            this.npvPairCfgList.addAll(npvPairCfgList);
        }
    }

    public Map<Switch, List<FcPortBase>> getAllPairVsanPorts() {
        return this.allPairVsanPorts;
    }

    public Map<Switch, List<FcPortBase>> getAllVsanSetPorts() {
        return this.vsanSetPorts;
    }

    public Map<Switch, List<FcPortBase>> getSetVsanPorts() {
        HashMap<Switch, List<FcPortBase>> retMap = new HashMap<Switch, List<FcPortBase>>();
        Set<Switch> Sws = this.vsanSetPorts.keySet();
        Set<Switch> npvPaired = this.npvSwPairs.keySet();
        for (Switch sw : Sws) {
            if (NpvClientHelper.contains(npvPaired, sw)) {
                retMap.put(sw, this.vsanSetPorts.get(sw));
            }
            for (Set<Switch> npiv : this.npvSwPairs.values()) {
                if (!NpvClientHelper.contains(npiv, sw) || NpvClientHelper.contains(retMap.keySet(), sw)) continue;
                retMap.put(sw, this.vsanSetPorts.get(sw));
            }
        }
        return retMap;
    }

    public Map<Switch, List<FcPortBase>> getAllCoreVsanPorts() {
        return this.allCoreVsanPorts;
    }

    public void setAllPairVsanPorts(Map<Switch, List<FcPortBase>> vsanAllPorts) {
        if (this.allPairVsanPorts == vsanAllPorts) {
            return;
        }
        NpvClientHelper.clearMapList(this.allPairVsanPorts);
        NpvClientHelper.copyMapList(vsanAllPorts, this.allPairVsanPorts);
    }

    public void setVsanSetPorts(Map<Switch, List<FcPortBase>> vsanPorts) {
        if (this.vsanSetPorts == vsanPorts) {
            return;
        }
        NpvClientHelper.clearMapList(this.vsanSetPorts);
        NpvClientHelper.copyMapList(vsanPorts, this.vsanSetPorts);
    }

    public void addVsanSetPorts(Map<Switch, List<FcPortBase>> newVsanPorts) {
        if (newVsanPorts == null) {
            return;
        }
        Set<Map.Entry<Switch, List<FcPortBase>>> vsanSet = newVsanPorts.entrySet();
        for (Map.Entry<Switch, List<FcPortBase>> entry : vsanSet) {
            Switch newSw = entry.getKey();
            if (this.vsanSetPorts.containsKey(newSw)) {
                List<FcPortBase> oldPortList = this.vsanSetPorts.get(newSw);
                List<FcPortBase> newPortList = entry.getValue();
                for (FcPortBase newP : newPortList) {
                    if (oldPortList.contains(newP)) continue;
                    oldPortList.add(newP);
                }
                continue;
            }
            this.vsanSetPorts.put(newSw, entry.getValue());
        }
    }

    public void setAllCoreVsanPorts(Map<Switch, List<FcPortBase>> vsanAllPorts) {
        if (this.allCoreVsanPorts == vsanAllPorts) {
            return;
        }
        NpvClientHelper.clearMapList(this.allCoreVsanPorts);
        NpvClientHelper.copyMapList(vsanAllPorts, this.allCoreVsanPorts);
    }

    @Deprecated
    public List<Switch> getAllVsanSwitches() {
        return this.allVsanSwitches;
    }

    public List<Switch> getSetVsanSwitches() {
        ArrayList<Switch> retList = new ArrayList<Switch>();
        for (Switch sw : this.allVsanSwitches) {
            if (NpvClientHelper.contains(this.npvSwPairs.keySet(), sw)) {
                retList.add(sw);
            }
            for (Set<Switch> npiv : this.npvSwPairs.values()) {
                if (!NpvClientHelper.contains(npiv, sw) || NpvClientHelper.contains(retList, sw)) continue;
                retList.add(sw);
            }
        }
        return retList;
    }

    public void setAllVsanSwitches(List<Switch> vsanAllSwitches) {
        if (this.allVsanSwitches == vsanAllSwitches) {
            return;
        }
        this.allVsanSwitches.clear();
        this.allVsanSwitches.addAll(vsanAllSwitches);
    }

    public void setFlexAttachMode(int mode) {
        this.flexAttachMode = mode;
    }

    public int getFlexAttachMode() {
        return this.flexAttachMode;
    }

    public List<SwitchActionTracker> createEnableFeatureActions(AbstractAsyncSwitchTask.Type taskType) {
        ArrayList<SwitchActionTracker> actions = new ArrayList<SwitchActionTracker>();
        List<Switch> enableSwList = null;
        String content = "";
        if (taskType == AbstractAsyncSwitchTask.EnableNPV) {
            enableSwList = this.getEnableNpvList();
            content = "Enable NPV (Cause Reboot)";
        } else if (taskType == AbstractAsyncSwitchTask.EnableNPIV) {
            enableSwList = this.getEnableNpivList();
            content = "Enable NPIV";
        } else if (taskType == AbstractAsyncSwitchTask.VerifyAccess) {
            enableSwList = this.getEnableNpvList();
            content = "Check NPV device accessibility";
        } else if (taskType == NpvSwitchTask.EnablePorts) {
            enableSwList = this.getEnableNpvList();
            content = "Enable all Ports on just enabled NPV device";
        } else {
            throw new IllegalArgumentException("Invalid task type:" + (Object)((Object)taskType));
        }
        if (enableSwList != null) {
            for (Switch sw : enableSwList) {
                SwitchActionTracker tracker = new SwitchActionTracker(sw, content, taskType);
                actions.add(tracker);
            }
        }
        return actions;
    }

    public List<SwitchActionTracker> createAllEnableFeatureAction() {
        ArrayList<SwitchActionTracker> actions = new ArrayList<SwitchActionTracker>();
        List<SwitchActionTracker> tmpActions = this.createEnableFeatureActions(AbstractAsyncSwitchTask.EnableNPV);
        actions.addAll(tmpActions);
        tmpActions.clear();
        tmpActions = this.createEnableFeatureActions(AbstractAsyncSwitchTask.VerifyAccess);
        actions.addAll(tmpActions);
        tmpActions.clear();
        tmpActions = this.createEnableFeatureActions(AbstractAsyncSwitchTask.EnablePorts);
        actions.addAll(tmpActions);
        tmpActions.clear();
        tmpActions = this.createEnableFeatureActions(AbstractAsyncSwitchTask.EnableNPIV);
        actions.addAll(tmpActions);
        tmpActions.clear();
        return actions;
    }

    public List<SwitchActionTracker> createPortSetActoins(AbstractAsyncSwitchTask.Type taskType) {
        ArrayList<SwitchActionTracker> actions = new ArrayList<SwitchActionTracker>();
        Map<Switch, List<FcPortBase>> enablePorts = null;
        String contentPrefix = "";
        if (taskType == AbstractAsyncSwitchTask.SetNpPorts) {
            enablePorts = this.getNpEnablingPorts();
            contentPrefix = "Set NP Ports: ";
        } else if (taskType == AbstractAsyncSwitchTask.SetFPorts) {
            enablePorts = this.getEnableFPorts();
            contentPrefix = "Set F Ports: ";
        } else if (taskType == AbstractAsyncSwitchTask.SetNpivPorts) {
            enablePorts = this.getNpivEnablingPorts();
            contentPrefix = "Set F Ports: ";
        }
        if (enablePorts != null) {
            for (Map.Entry<Switch, List<FcPortBase>> entry : enablePorts.entrySet()) {
                List<FcPortBase> ports = entry.getValue();
                if (ports == null || ports.size() < 1) continue;
                SwitchActionTracker tracker = new SwitchActionTracker(entry.getKey(), contentPrefix + NpvClientHelper.getPortsString(entry.getKey(), ports), taskType);
                actions.add(tracker);
            }
        }
        return actions;
    }

    public Vsan queryVsanById(short vsanId) {
        if (this.availVsanList == null) {
            return null;
        }
        for (Vsan vsan : this.availVsanList) {
            if (vsan.getId() != vsanId) continue;
            return vsan;
        }
        return null;
    }

    public List<SwitchActionTracker> createAllPortSetActoins() {
        ArrayList<SwitchActionTracker> actions = new ArrayList<SwitchActionTracker>();
        List<SwitchActionTracker> tmpActions = this.createPortSetActoins(NpvSwitchTask.SetNpPorts);
        actions.addAll(tmpActions);
        tmpActions.clear();
        tmpActions = this.createPortSetActoins(NpvSwitchTask.SetNpivPorts);
        actions.addAll(tmpActions);
        tmpActions.clear();
        tmpActions = this.createPortSetActoins(NpvSwitchTask.SetFPorts);
        actions.addAll(tmpActions);
        tmpActions.clear();
        return actions;
    }

    public List<SwitchActionTracker> createVSANSetActoins() {
        ArrayList<SwitchActionTracker> actions = new ArrayList<SwitchActionTracker>();
        List<Switch> allSwList = this.getSetVsanSwitches();
        String vsanStr = this.getSelectedVsan() == null ? String.valueOf(this.getSelectedVsanId()) : this.getSelectedVsan().getName();
        for (Switch sw : allSwList) {
            SwitchActionTracker tracker = new SwitchActionTracker(sw, "Add Switch to VSAN (" + vsanStr + ")", NpvSwitchTask.AddVSANSwitches);
            actions.add(tracker);
        }
        Map<Switch, List<FcPortBase>> allPortList = this.getSetVsanPorts();
        for (Map.Entry<Switch, List<FcPortBase>> entry : allPortList.entrySet()) {
            SwitchActionTracker tracker = new SwitchActionTracker(entry.getKey(), "Add Port to VSAN(" + vsanStr + "): " + NpvClientHelper.getPortsString(entry.getKey(), entry.getValue()), NpvSwitchTask.AddVSANPorts);
            actions.add(tracker);
        }
        return actions;
    }

    public List<SwitchActionTracker> createFlexAttachActions() {
        ArrayList<SwitchActionTracker> actions = new ArrayList<SwitchActionTracker>();
        List<Switch> npvSw = this.getNpvCapableSwList();
        for (Switch sw : npvSw) {
            SwitchActionTracker tracker = new SwitchActionTracker(sw, "Setting WWN for " + sw.toString(), NpvSwitchTask.SetFlexAttach);
            actions.add(tracker);
        }
        return actions;
    }

    public NpvSetupWizard getWizard() {
        return this.wizard;
    }

    public void clear() {
        for (AbstractAsyncSwitchTask task : this.taskList) {
            if (task == null) continue;
            try {
                task.cancelTask();
                task.closeTask();
            }
            catch (Exception e) {}
        }
        this.taskList.clear();
        this.npvSelectedSwList.clear();
        this.npivSelectedSwList.clear();
        this.npvEnablingSwList.clear();
        this.npivEnablingSwList.clear();
        this.npvCapableSwList.clear();
        this.npivCapableSwList.clear();
        this.npvPairCfgList.clear();
        this.availVsanList.clear();
        this.npvlinkList.clear();
        this.allVsanSwitches.clear();
        NpvClientHelper.clearMapList(this.npEnablingPorts);
        NpvClientHelper.clearMapList(this.fEnablingPorts);
        NpvClientHelper.clearMapList(this.npivEnablingPorts);
        NpvClientHelper.clearMapList(this.allPairVsanPorts);
        for (Set<Switch> sws : this.npvSwPairs.values()) {
            if (sws == null) continue;
            sws.clear();
        }
        this.npvSwPairs.clear();
        for (AbstractWorker worker : this.workers) {
            worker.stop();
        }
        this.workers.clear();
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }
}

