/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.mds.PortEditorCardAttribute;
import com.cisco.dcbu.lib.mds.PortEditorFilter;
import com.cisco.dcbu.lib.mds.PortSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.SmPortSetCellEditor;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.TETableModel;
import com.cisco.dcbu.sm.common.dto.TrafficMap;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.JToggleButton;

public class NPVPortCellEditor
extends SmPortSetCellEditor {
    private static final int channelIndex = "Channel".length();
    Set<Integer> exclusiveCol = new HashSet<Integer>();
    List<TrafficMap> trafficMap;
    Map<Switch, Map> serverIfToExternalIfUsageMap;
    Map<Switch, List<Integer>> ifs;
    private static int pRow = -1;
    private static int pCol = -1;

    public NPVPortCellEditor(JTable table, int[] exCols, PortEditorFilter filter, boolean includeFPCLogicalIfs) {
        this(table, exCols, filter, includeFPCLogicalIfs, SmPortSetCellEditor.SHOW_F_PC_BMP);
    }

    public NPVPortCellEditor(JTable table, int[] exCols, PortEditorFilter filter, boolean includeFPCLogicalIfs, short show_logical_map) {
        super(table, false, filter, show_logical_map);
        for (int ex : exCols) {
            this.exclusiveCol.add(ex);
        }
        this.setTextable(true);
    }

    public PortEditorCardAttribute[] getSlotMembers() {
        return this._slotMembers;
    }

    @Override
    public boolean stopCellEditing() {
        String value = (String)this.getCellEditorValue();
        if (value != null && "".equals(value.trim())) {
            return super.stopCellEditing();
        }
        try {
            Switch sw = ClientController.findFabricSwitchByIpAddress(this._node.getAddress());
            if (this.ifs == null || !this.ifs.containsKey(sw)) {
                return super.stopCellEditing();
            }
            if (this._table.getEditingColumn() == TETableModel.Column.ServerIf.ordinal()) {
                NPVPortCellEditor.checkServerIf((KTable)this._table, this._table.getEditingRow(), value, sw);
                List<Integer> ports = this.ifs.get(sw);
                if (ports != null) {
                    NpvClientHelper.findPortIfIndexes(ports, sw, value, false);
                }
            } else {
                NpvClientHelper.checkXternalIf(value, sw);
                List<Integer> ports = this.ifs.get(sw);
                if (ports != null && !value.startsWith("channel") && !value.startsWith("Channel")) {
                    NpvClientHelper.findPortIfIndexes(ports, sw, value, true);
                }
            }
            this.updateInUseIf((KTable)this._table, this._table.getEditingRow(), this._table.getEditingColumn(), value, sw);
        }
        catch (IllegalArgumentException iex) {
            Util.errorMessage((Component)this._table, iex.getMessage());
            return false;
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this._table, ex.getMessage());
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Object ob = table.getValueAt(row, TETableModel.Column.NpvDevice.ordinal());
        if (!(ob instanceof Switch)) {
            Util.errorMessage((Component)this.getComponent().getParent(), "Invalid NPV device, cannot open editor.");
            return null;
        }
        Switch npv = (Switch)ob;
        if (!npv.getSwitchBase().isBladeServer()) {
            this.filterServerIfs(table, row, column);
        }
        boolean exclusive = this.exclusiveCol.contains(column);
        this.setExclusive(exclusive);
        this.updateEditor(row, column);
        if (this._node != null) {
            Switch sw = ClientController.findFabricSwitchByIpAddress(this._node.getAddress());
            boolean isBlade = sw.getSwitchBase().isBladeServer();
            this.btn.setVisible(!isBlade);
        } else {
            this.btn.setVisible(false);
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    private void updateInUseIf(KTable table, int row, int col, String value, Switch sw) {
        if (col == TETableModel.Column.ServerIf.ordinal()) {
            if (value != null) {
                String useValue = "N/A";
                if (sw != null) {
                    Integer inUseExIf;
                    Map usageMap;
                    SwitchBase swBase = sw.getSwitchBase();
                    if (this.serverIfToExternalIfUsageMap != null && (usageMap = this.serverIfToExternalIfUsageMap.get(sw)) != null && !usageMap.isEmpty() && (inUseExIf = (Integer)usageMap.get(swBase.nameToIfIndex(value))) != null) {
                        useValue = swBase.ifIndexToName(inUseExIf);
                    }
                }
                table.setValueAt(useValue, row, TETableModel.Column.ExternalInUse.ordinal());
            } else {
                table.setValueAt("N/A", row, TETableModel.Column.ExternalInUse.ordinal());
            }
        }
    }

    private boolean isExist(PortSet ports) {
        Integer[] rows = ports.getCards();
        Integer[] cols = ports.getPorts();
        if (rows == null || cols == null) {
            return false;
        }
        if (rows.length != cols.length) {
            return false;
        }
        for (int i = 0; i < rows.length; ++i) {
            JToggleButton btn = this._portSetEditor.getButton(rows[i] - 1, cols[i] - 1);
            if (btn != null && btn.isVisible()) continue;
            return false;
        }
        return true;
    }

    protected static void checkServerIf(KTable table, int row, String value, Switch sw) throws Exception {
        try {
            int ifIndex = sw.nameToIfIndex(value);
            if (ifIndex == 0) {
                throw new Exception("Bad interface " + value);
            }
        }
        catch (IllegalArgumentException iex) {
            throw new Exception("Invalid entry " + value);
        }
        Array data = ((KTableModel)table.getModel()).getData();
        for (int i = 0; i < data.size(); ++i) {
            Object[] ob = (Object[])data.elementAt(i);
            if (ob == null) continue;
            String existIf = (String)ob[TETableModel.Column.ServerIf.ordinal()];
            Object swObj = ob[TETableModel.Column.NpvDevice.ordinal()];
            if (!(swObj instanceof Switch)) continue;
            Switch npv = (Switch)swObj;
            if (existIf == null || existIf.trim().equals("")) continue;
            int ifIndex = sw.nameToIfIndex(value);
            int existIfIndex = npv.nameToIfIndex(existIf);
            if (!value.equalsIgnoreCase(existIf) && ifIndex != existIfIndex || i == row || !sw.getPK().equals(npv.getPK())) continue;
            throw new Exception("Duplicate interface " + value);
        }
    }

    private void filterServerIfs(JTable table, int row, int column) {
        this.setDisablePorts(null);
        if (column == TETableModel.Column.ServerIf.ordinal()) {
            StringBuffer serverIfs = new StringBuffer();
            Switch sw = (Switch)table.getModel().getValueAt(row, this._peerCol);
            KTableModel tModel = (KTableModel)table.getModel();
            Array dataArray = tModel.getData();
            for (int i = 0; i < dataArray.size(); ++i) {
                Switch npvSw;
                Object[] data;
                Object ob;
                if (i == row || !((ob = (data = (Object[])dataArray.elementAt(i))[TETableModel.Column.NpvDevice.ordinal()]) instanceof Switch) || !(npvSw = (Switch)ob).equals(sw)) continue;
                String ifser = (String)data[TETableModel.Column.ServerIf.ordinal()];
                if (serverIfs.length() > 0) {
                    serverIfs.append(",");
                }
                serverIfs.append(ifser);
            }
            try {
                PortSet ports = PortSet.parse(serverIfs.toString());
                this.setDisablePorts(ports);
            }
            catch (SnmpException smEx) {
                throw new RuntimeException(smEx.getMessage());
            }
        }
    }

    public void setTrafficMap(List<TrafficMap> map) {
        this.trafficMap = map;
    }

    public void setServerIfToExternalIfUsageMap(Map<Switch, Map> map) {
        this.serverIfToExternalIfUsageMap = map;
    }

    public void setCellDisabled(String port) {
        this._portSetEditor.setCellDisabled(0, 1);
    }

    public void setIfs(Map<Switch, List<Integer>> interfaces) {
        this.ifs = interfaces;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            super.actionPerformed(e);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)this.getComponent().getParent(), ex.getMessage());
        }
    }
}

