/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.view.NPVTreeNode;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class NPVTreeModel
extends DefaultTreeModel {
    protected boolean isNPTreeModel;

    public NPVTreeModel(TreeNode root, boolean isNPTree) {
        super(root);
        this.isNPTreeModel = isNPTree;
    }

    @Override
    public Object getChild(Object parent, int idx) {
        if (parent instanceof NPVTreeNode) {
            return ((NPVTreeNode)parent).getChildAt(idx, this.isNPTreeModel);
        }
        return ((TreeNode)parent).getChildAt(idx);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof NPVTreeNode) {
            return ((NPVTreeNode)parent).getChildCount(this.isNPTreeModel);
        }
        return ((TreeNode)parent).getChildCount();
    }

    public Map<Switch, List<FcPortBase>> getNPVSelected() {
        HashMap<Switch, List<FcPortBase>> map = new HashMap<Switch, List<FcPortBase>>();
        Enumeration<? extends TreeNode> e = this.root.children();
        while (e.hasMoreElements()) {
            NPVTreeNode swNode = (NPVTreeNode)e.nextElement();
            int npChildCount = swNode.getChildCount(true);
            if (npChildCount < 1) continue;
            ArrayList<FcPortBase> ports = new ArrayList<FcPortBase>();
            Enumeration<TreeNode> children = swNode.children();
            while (children.hasMoreElements()) {
                NPVTreeNode child = (NPVTreeNode)children.nextElement();
                if (!child.isVisible()) continue;
                FcPortBase port = (FcPortBase)child.getUserObject();
                ports.add(port);
            }
            Switch sw = (Switch)swNode.getUserObject();
            map.put(sw, ports);
        }
        return map;
    }
}

