/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.ui.DialogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ProgressPanel
extends JPanel {
    private JProgressBar progressBar;
    private String message = "message";
    private String subMsg = "";
    private JLabel statusLabel;
    private JLabel subLabel;
    private int increment = 1;

    public ProgressPanel(String message) {
        this.message = message;
        this.statusLabel = new JLabel(message, 2);
        this.subLabel = new JLabel(this.subMsg, 4);
        this.progressBar = new JProgressBar();
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this.createMainPanel(), "Center");
        this.setVisible(false);
    }

    public void start() {
        this.progressBar.setMinimum(0);
        this.setVisible(true);
    }

    public void stop() {
        this.setVisible(false);
        this.progressBar.setIndeterminate(false);
    }

    public void setMaximum(int maximum) {
        this.progressBar.setMaximum(maximum);
    }

    public int getMaximum() {
        return this.progressBar.getMaximum();
    }

    public void setIncrement(int inc) {
        this.increment = inc;
    }

    public synchronized void increaseProgress() {
        this.setProgress(this.progressBar.getValue() + this.increment);
    }

    public synchronized void increaseProgress(int numOfIncrement) {
        this.setProgress(this.progressBar.getValue() + this.increment * numOfIncrement);
    }

    public synchronized void setProgress(int n) {
        this.progressBar.setValue(n);
    }

    public void setStatus(String message) {
        this.message = message;
        this.setMessage(this.statusLabel, message);
    }

    public void setSubMessage(String subMsg) {
        this.subMsg = subMsg;
        this.setMessage(this.subLabel, subMsg);
    }

    public void setMessage(final JLabel label, String message) {
        label.setText(message);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = label.getWidth();
                int height = label.getHeight();
                Rectangle rect = new Rectangle(0, 0, width, height);
                label.paintImmediately(rect);
            }
        });
    }

    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.2;
        DialogUtil.extend(gbc, mainPanel, this.progressBar);
        DialogUtil.extend(gbc, mainPanel, this.createMessagePanel());
        return mainPanel;
    }

    private JPanel createMessagePanel() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        p.add((Component)this.statusLabel, gc);
        p.add(Box.createHorizontalStrut(50), gc);
        gc.weightx = 0.0;
        gc.anchor = 13;
        p.add((Component)this.subLabel, gc);
        p.add(Box.createHorizontalStrut(10), gc);
        return p;
    }
}

