/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.view;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.util.NpvClientHelper;
import com.cisco.dcbu.sm.client.npv.view.NPVPortCellEditor;
import com.cisco.dcbu.sm.client.npv.view.TETableModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class TETable
extends SnmpKTable {
    private static final Font TableFont = (Font)UIManager.getDefaults().get("Table.font");

    public TETable(TETableModel model) {
        super(model);
        this.setSelectionMode(0);
        this.setAutoResizeMode(4);
        this.getSelectionModel().addListSelectionListener(this);
        this.getTableHeader().addMouseListener(new HeaderListener());
        this.setSortable(true);
        this.addPopupMenu();
    }

    public void setColumnWidth(int[] columnNumChars) {
        int cols = this.getColumnCount();
        if (cols > columnNumChars.length) {
            throw new IllegalArgumentException("");
        }
        for (int i = 0; i < cols; ++i) {
            int width = this.calcColumnWidth(i, TableFont, columnNumChars[i]);
            this.setColumnWidth(i, width);
        }
    }

    public int calcColumnWidth(int col, Font font, int charLen) {
        FontMetrics fm = this.getFontMetrics(font);
        KTableModel model = (KTableModel)this.getModel();
        int widest = this.getHeaderColumnWidth(fm, col);
        char[] chars = new char[charLen];
        for (int i = 0; i < charLen; ++i) {
            chars[i] = 77;
        }
        int cwidth = fm.charsWidth(chars, 0, charLen - 1);
        if (widest < cwidth) {
            widest = cwidth;
        }
        return widest + 4;
    }

    public void setColumnWidth(int col, int width) {
        this.getColumnModel().getColumn(col).setPreferredWidth(width);
    }

    @Override
    public void paste() {
        Component c;
        if (this.isEditing() && (c = this.getEditorComponent()) instanceof JTextComponent) {
            ((JTextComponent)c).paste();
            return;
        }
        Transferable selection = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        TETableModel model = (TETableModel)this.getModel();
        try {
            String text = (String)selection.getTransferData(DataFlavor.stringFlavor);
            String[] rows = StringUtil.tokenize(text, "\n");
            Cell cell = this.getCurrentCell();
            for (int r = 0; r < rows.length; ++r) {
                int viewRow = r + cell._row;
                String[] cols = StringUtil.tokenize(rows[r], "\t");
                for (int c2 = 0; c2 < cols.length; ++c2) {
                    int viewCol = this.convertColumnIndexToModel(c2 + cell._col);
                    if (!model.isCellEditable(viewRow, viewCol)) continue;
                    if (viewCol == TETableModel.Column.NpvDevice.ordinal()) {
                        String swName = cols[c2];
                        Switch selectableSw = model.getSwitch(swName);
                        if (selectableSw == null) {
                            throw new Exception("Invalid entry " + swName);
                        }
                        model.setValueAt(selectableSw, viewRow, viewCol);
                        return;
                    }
                    String ifs = cols[c2];
                    Object ob = this.getValueAt(viewRow, TETableModel.Column.NpvDevice.ordinal());
                    if (!(ob instanceof Switch)) {
                        throw new Exception("Invalid Npv device");
                    }
                    Switch npv = (Switch)ob;
                    if (viewCol == TETableModel.Column.ServerIf.ordinal()) {
                        NPVPortCellEditor.checkServerIf(this, viewRow, ifs, npv);
                        NpvClientHelper.findPortIfIndexes(model.ifs.get(npv), npv, ifs, false);
                    } else {
                        NpvClientHelper.checkXternalIf(ifs, npv);
                        NpvClientHelper.findPortIfIndexes(model.ifs.get(npv), npv, ifs, true);
                    }
                    model.setValueAt(cols[c2], viewRow, viewCol);
                }
            }
        }
        catch (Exception ex) {
            Toolkit.getDefaultToolkit().beep();
            Util.errorMessage((Component)this, ex.getMessage());
        }
    }
}

