/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.wizard;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.npv.view.SwitchChooserTable;
import com.cisco.dcbu.sm.client.npv.view.SwitchChooserTableModel;
import com.cisco.dcbu.sm.client.npv.wizard.TESetupWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TEDeviceSelectionStep
extends WizardPanel {
    public static final String StepTitle = "Select NPV Devices";
    public static final String StepDesp = "Select one or more NPV devices.  NPV devices are switches that have NPV mode enabled.  \nNote: Switches that aren't manageable/reachable will not be present in this list.";
    private JPanel mp;
    private SwitchChooserTableModel npvTm;
    private SwitchChooserTable npvTable;

    public TEDeviceSelectionStep() {
        super(StepTitle, StepDesp, TESetupWizard.TE_ICON);
        this.initialize();
    }

    public SwitchChooserTable getNPVTable() {
        return this.npvTable;
    }

    public SwitchChooserTableModel getNPVTableModel() {
        return this.npvTm;
    }

    public void setNPVTm(SwitchChooserTableModel npvTm) {
        this.npvTm = npvTm;
        this.npvTable.setModel(npvTm);
    }

    @Override
    public boolean refresh() {
        this.getNPVTableModel().updateSwitchList(((TESetupWizard)this.getWizard()).getController().getTECapableSwList());
        return super.refresh();
    }

    @Override
    public String getTitle() {
        return StepTitle;
    }

    @Override
    public void doNext() {
        List<Switch> npvSelectSwList = this.getNPVTableModel().getSelectedSwitches();
        if (npvSelectSwList.size() > 0) {
            ((TESetupWizard)this.getWizard()).getController().setTESelectedSwList(npvSelectSwList);
            this.setDataValid(false);
            super.doNext();
        } else {
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            this.getWizard().getNavigator().getBackBtn().setEnabled(true);
            Util.errorMessage((Component)this.getWizard(), new Exception("There are no NPV devices selected."));
        }
    }

    private void initialize() {
        this.mp = new JPanel(new BorderLayout());
        this.mp.setBorder(DialogUtil._Margin);
        this.npvTm = new SwitchChooserTableModel(new ArrayList(), new String[]{"Select", "NPV Device", "IP Address", "NPV State"}){

            @Override
            public boolean isFeatureEnabled(Switch sw) {
                return sw.isNpvEnabled();
            }
        };
        this.npvTm.setEditable(new boolean[]{true, false, false, false, false});
        this.npvTable = new SwitchChooserTable(this.npvTm){};
        this.npvTable.setColumnWidth(new int[]{6, 25, 15, 6});
        JScrollPane sc = new JScrollPane(this.npvTable);
        this.mp.add((Component)sc, "Center");
        this.add((Component)this.mp, "Center");
    }
}

