/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.npv.wizard;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.npv.controller.NpvSetupWizardController;
import com.cisco.dcbu.sm.client.npv.wizard.NpvSetupWizard;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class VsanSelectionStep
extends WizardPanel {
    public static final Logger _Logger = Logger.getLogger(VsanSelectionStep.class);
    public static final String StepTitle = "Select VSAN";
    public static final String StepDesp = "Specify one VSAN for all NPV associated switches and ports.";
    public static final String Vsan_Text = "Select a VSAN from the menu or enter a VSAN ID (1-4093):";
    public static final String SelectVsan_HelpText = "Selected switches and ports will be added to the specified VSAN.";
    public static final String Uplink_Text = "Configure NPV uplink ports";
    public static final String Physical_Text = "Physical WWNs";
    public static final String Virtual_Text = "Virtual WWNs.";
    public static final String Uplink_HelpText = "Virtual port WWNs are automatically generated. The advantage of virtual port WWNs is that the physical switch can be replaced at a later time without making zone changes.";
    public static final int MIN_VsanId = 1;
    public static final int MAX_VsanId = 4093;
    private JPanel mp;
    private JComboBox vsanSelection;
    private JRadioButton pWwnBtn;
    private JRadioButton vWwnBtn;
    private Object selectedVsan;

    public VsanSelectionStep() {
        super(StepTitle, StepDesp, NpvSetupWizard.NPV_ICON);
        this.initialize();
    }

    @Override
    public boolean refresh() {
        ((NpvSetupWizard)this.getWizard()).updateStepTitle(false);
        this.setVSANList(((NpvSetupWizard)this.getWizard()).getController().getAvailVsanList());
        ((NpvSetupWizard)this.getWizard()).getNavigator().getRootPane().setDefaultButton(((NpvSetupWizard)this.getWizard()).getNavigator().getNextBtn());
        return super.refresh();
    }

    @Override
    public String getTitle() {
        return StepTitle;
    }

    public void setVSANList(List<Vsan> vsanList) {
        ArrayList<Vsan> sortedList = new ArrayList<Vsan>();
        sortedList.addAll(vsanList);
        Collections.sort(sortedList);
        Object[] items = sortedList.toArray();
        DefaultComboBoxModel<Object> selectModel = new DefaultComboBoxModel<Object>(items);
        this.vsanSelection.setModel(selectModel);
        if (this.selectedVsan != null) {
            this.vsanSelection.setSelectedItem(this.selectedVsan);
        }
        sortedList.clear();
    }

    @Override
    public void doPrevious() {
        this.selectedVsan = this.vsanSelection.getSelectedItem();
        super.doPrevious();
    }

    @Override
    public void doNext() {
        Object selectedItem = this.vsanSelection.getSelectedItem();
        short vsanId = -1;
        try {
            if (selectedItem instanceof Vsan) {
                ((NpvSetupWizard)this.getWizard()).getController().setSelectedVsan((Vsan)selectedItem);
            } else {
                String intStr = String.valueOf(selectedItem).trim();
                int num = Integer.parseInt(String.valueOf(intStr));
                if (num < 1 || num > 4093) {
                    throw new Exception("VSAN ID is an integer of range (1-4093), entered invalid VSAN ID:" + String.valueOf(selectedItem));
                }
                vsanId = (short)num;
                Vsan vsan = ((NpvSetupWizard)this.getWizard()).getController().queryVsanById(vsanId);
                ((NpvSetupWizard)this.getWizard()).getController().setSelectedVsanId(vsanId);
                ((NpvSetupWizard)this.getWizard()).getController().setSelectedVsan(vsan);
            }
            this.setDataValid(false);
            super.doNext();
        }
        catch (NumberFormatException e) {
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            this.getWizard().getNavigator().getBackBtn().setEnabled(true);
            Util.errorMessage((Component)this.getWizard(), new Exception("VSAN ID is an integer of range (1-4093), entered invalid VSAN ID:" + selectedItem));
        }
        catch (Exception e) {
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            this.getWizard().getNavigator().getBackBtn().setEnabled(true);
            Util.errorMessage((Component)this.getWizard(), e);
        }
    }

    public boolean isWwnVirtual() {
        return !this.pWwnBtn.isSelected();
    }

    private void initialize() {
        JLabel vsanLable = new JLabel(Vsan_Text, 2);
        Object[] vsans = new Object[]{};
        this.vsanSelection = new JComboBox<Object>(vsans);
        this.vsanSelection.setEditable(true);
        this.pWwnBtn = new JRadioButton(Physical_Text);
        this.vWwnBtn = new JRadioButton(Virtual_Text);
        ButtonGroup group = new ButtonGroup();
        group.add(this.pWwnBtn);
        group.add(this.vWwnBtn);
        group.setSelected(this.pWwnBtn.getModel(), true);
        JTextArea uplinkExplain = new JTextArea(Uplink_HelpText);
        uplinkExplain.setFont(this.pWwnBtn.getFont());
        uplinkExplain.setEditable(false);
        uplinkExplain.setWrapStyleWord(true);
        uplinkExplain.setLineWrap(true);
        uplinkExplain.setBackground(this.pWwnBtn.getBackground());
        JTextArea vsanHelpLabel = new JTextArea(SelectVsan_HelpText);
        vsanHelpLabel.setFont(this.pWwnBtn.getFont());
        vsanHelpLabel.setEditable(false);
        vsanHelpLabel.setWrapStyleWord(true);
        vsanHelpLabel.setLineWrap(true);
        vsanHelpLabel.setBackground(this.pWwnBtn.getBackground());
        this.mp = new JPanel(new GridBagLayout());
        this.mp.setBorder(DialogUtil._Margin);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        int y = 0;
        DialogUtil.constrain(this.mp, vsanLable, gbc, 0, y++, 0, 17);
        DialogUtil.constrain(this.mp, NpvSetupWizardController.getIndentedPanel(new JComponent[]{this.vsanSelection}, 8), gbc, 0, y++, 0, 17);
        DialogUtil.constrain(this.mp, NpvSetupWizardController.getIndentedPanel(new JComponent[]{vsanHelpLabel}, 8), gbc, 0, y++, 2, 17);
        JPanel p = new JPanel(new GridBagLayout());
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.weighty = 0.1;
        p.add((Component)this.mp, gbc);
        ++gbc.gridy;
        this.add((Component)p, "Center");
    }
}

