/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.portchnl;

import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.map.SmMap;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.portchnl.WizIslLink;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class PChnlActions {
    private static PChnlActions _instance;

    public static void disablePchnlMember(JFrame parent) {
        ArrayList<Object> arLst = new ArrayList<Object>();
        ArrayList coll = SmMap.getSelectedMap().getSelectedLinks();
        for (TopologyLink lnk : coll) {
            Isl islLnk;
            Object obLnk = lnk.getModel();
            if (!(obLnk instanceof Isl) || !(islLnk = (Isl)obLnk).isPortChannel() || !islLnk.isPresent()) continue;
            arLst.add(obLnk);
        }
        if (arLst.size() != 1) {
            Util.errorMessage((Component)parent, "Please select a Port Channel between two Cisco Storage Switches.\n");
            return;
        }
        Isl isl = (Isl)arLst.get(0);
        Switch swA = isl.getSwitch1();
        Switch swB = isl.getSwitch2();
        List<Isl> lnksPc = isl.getPCMemberLinksAsIsls();
        Object[] data = new WizIslLink[lnksPc.size()];
        for (int k = 0; k < lnksPc.size(); ++k) {
            if (!lnksPc.get(k).isPresent()) continue;
            data[k] = new WizIslLink(lnksPc.get(k));
        }
        if (data.length == 0) {
            Util.errorMessage((Component)parent, "The ISLs in selected port channels are not up.\n");
            return;
        }
        WizIslLink selIsl = (WizIslLink)JOptionPane.showInputDialog(parent, "Gracefully stop traffic for selected ISL member\n(This operation may take few seconds):", swA + " " + swA.ifIndexToName(isl.getIfIndex1()) + " - " + swB + " " + swB.ifIndexToName(isl.getIfIndex2()), 3, null, data, data[0]);
        if (selIsl != null) {
            StringBuffer buf = new StringBuffer();
            int ifIndex = selIsl.getIfIndex1();
            Vsh vshCon1 = null;
            Vsh vshCon2 = null;
            try {
                vshCon1 = Vsh.get(parent, swA.getPeer(), false);
                if (vshCon1 != null && swA.isVersionGreaterThanEqual("1.3(0)") && swA.isVersionLessThan("2.0(0)")) {
                    PChnlActions.doQuiese(ifIndex, vshCon1, swA);
                }
            }
            catch (Exception ex) {
                buf.append(swA + " " + ex.getMessage());
            }
            try {
                ifIndex = selIsl.getIfIndex2();
                vshCon2 = Vsh.get(parent, swB.getPeer(), false);
                if (vshCon2 != null && swB.isVersionGreaterThanEqual("1.3(0)") && swB.isVersionLessThan("2.0(0)")) {
                    PChnlActions.doQuiese(ifIndex, vshCon2, swB);
                }
            }
            catch (Exception ex) {
                buf.append(swB + " " + ex.getMessage());
            }
            if (buf.length() > 0) {
                Util.errorMessage((Component)parent, buf.toString());
            } else {
                try {
                    PChnlActions.disablePort(selIsl.getIfIndex1(), vshCon1, swA);
                    PChnlActions.disablePort(selIsl.getIfIndex2(), vshCon2, swB);
                }
                catch (IOException ex) {
                    Util.errorMessage((Component)parent, ex.getMessage());
                }
            }
            Vsh.put(vshCon1);
            Vsh.put(vshCon2);
        }
    }

    private static boolean doQuiese(int ifIndex, Vsh vshCon, Switch sw) throws Exception {
        vshCon.send("quiesce interface " + sw.ifIndexToName(ifIndex) + " force\n");
        String out = vshCon.readPrompt();
        int i = out.indexOf(vshCon.getPrompt());
        int j = -1;
        j = out.indexOf("error");
        if (j != -1 || (j = out.indexOf("command detected at")) != -1 || (j = out.indexOf("cannot")) != -1) {
            Vsh.put(vshCon);
            if (i != -1 && j != -1 && j < i) {
                throw new Exception(out.substring(j, i));
            }
            throw new Exception(out);
        }
        return true;
    }

    private static boolean disablePort(int ifIndex, Vsh vshCon, Switch sw) throws IOException {
        vshCon.send("conf t\n");
        vshCon.expect("#");
        vshCon.send("interface " + sw.ifIndexToName(ifIndex) + "\n");
        vshCon.expect("#");
        vshCon.send("shutdown\n");
        vshCon.expect("#");
        vshCon.send("end\n");
        vshCon.expect("#");
        return true;
    }

    public static PChnlActions getInstance() {
        if (_instance == null) {
            _instance = new PChnlActions();
        }
        return _instance;
    }

    private PChnlActions() {
    }
}

