/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.qos;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.qos.QoSStatement;
import java.util.ArrayList;

public class QoSSnmp {
    static int MAX_CLASSMAPS = 1023;
    static int MAX_CLASSMAP_STATEMENTS = 64;
    static int MAX_POLICYMAPS = 1023;
    static int MAX_POLICYMAP_CLASSMAP = 255;
    static int DSCPAF1 = 12;
    static int DSCPAF2 = 18;
    static SnmpOID _dscpAF1Oid = null;
    static SnmpOID _dscpAF2Oid = null;
    SnmpOID _policyMapOid = null;
    int[] _classmapIndexGold = new int[0];
    int[] _classmapIndexSilver = new int[0];
    Switch _sw;
    int[] diffServClfrIdOid = QoSSnmp.getOid("diffServClfrId");
    int[] diffServClfrElementIdOid = QoSSnmp.getOid("diffServClfrElementId");
    int[] diffServClfrElementNextOid = QoSSnmp.getOid("diffServClfrElementNext");
    int[] diffServClfrElementSpecificOid = QoSSnmp.getOid("diffServClfrElementSpecific");
    int[] diffServClfrElementStatusOid = QoSSnmp.getOid("diffServClfrElementStatus");

    public QoSSnmp() {
    }

    public QoSSnmp(Switch sw) {
        this._sw = sw;
    }

    public void setSwitch(Switch sw) {
        this._sw = sw;
    }

    public SnmpPeer getSPeer() {
        return this._sw.getPeer();
    }

    static int[] getOid(String name) {
        return MibNode.get(name).getOid();
    }

    protected int getNextIndex1(int[] rowStatusOid, int maxRows, boolean isClearExistingRows) throws SnmpException {
        SnmpPeer peer = this.getSPeer();
        VarBindList vbl = new VarBindList();
        vbl.add(new SnmpVarBind(new SnmpOID(rowStatusOid)));
        SnmpPDU pdu = SnmpFetch.getBulk(peer, vbl);
        int nextIndex = 0;
        vbl = pdu.getVariables();
        if (vbl.size() > 0) {
            nextIndex = vbl.getVb(vbl.size() - 1).getOid().getIndex(1)[0];
        }
        return ++nextIndex;
    }

    protected int[] createClassMapHeader(ArrayList stmts, String name, int matchOperator, int vsanId, boolean isGold) throws SnmpException {
        int[] cdsmFCMultiFieldClfrNameOid = QoSSnmp.getOid("cdsmFCMultiFieldClfrName");
        int[] cdsmFCMultiFieldClfrMatchOid = QoSSnmp.getOid("cdsmFCMultiFieldClfrMatch");
        int[] cdsmFCMultiFieldClfrStatusOid = QoSSnmp.getOid("cdsmFCMultiFieldClfrStatus");
        int[] returnInt = new int[stmts.size()];
        SnmpPeer peer = this.getSPeer();
        VarBindList vbl = new VarBindList();
        int index = 1;
        int j = 0;
        index = this.getNextIndex1(cdsmFCMultiFieldClfrStatusOid, MAX_CLASSMAPS, false);
        boolean maxReached = false;
        for (int i = 0; i < stmts.size(); ++i) {
            QoSStatement qosStmt = (QoSStatement)stmts.get(i);
            if (!qosStmt.getInitPort().getSwitch().getIpAddress().equalsIgnoreCase(this._sw.getIpAddress()) && !qosStmt.getTargetPort().getSwitch().getIpAddress().equalsIgnoreCase(this._sw.getIpAddress())) {
                returnInt[j++] = 0;
                continue;
            }
            returnInt[j++] = index + i;
            int currentIndex = index + i;
            if (returnInt[j - 1] > 1023) {
                maxReached = true;
                break;
            }
            String internalName = name + "-" + currentIndex;
            vbl.add(cdsmFCMultiFieldClfrStatusOid, currentIndex, (SnmpVar)new SnmpInt(4));
            vbl.add(cdsmFCMultiFieldClfrNameOid, currentIndex, (SnmpVar)new SnmpString(internalName));
            vbl.add(cdsmFCMultiFieldClfrMatchOid, currentIndex, (SnmpVar)new SnmpInt(matchOperator));
        }
        int[] tempArr = new int[j];
        System.arraycopy(returnInt, 0, tempArr, 0, j);
        returnInt = tempArr;
        if (vbl.size() > 0) {
            SnmpFetch.set(peer, vbl);
        }
        if (maxReached) {
            throw new SnmpException(" Maximum number of classmaps reached ");
        }
        if (isGold) {
            this._classmapIndexGold = returnInt;
        } else {
            this._classmapIndexSilver = returnInt;
        }
        return returnInt;
    }

    public void createClassMapStatement(ArrayList stmts, int[] classMapIndex) throws SnmpException {
        int[] cdsmFCMultiFieldMatchSrcAddrOid = QoSSnmp.getOid("cdsmFCMultiFieldMatchSrcAddr");
        int[] cdsmFCMultiFieldMatchDstAddrOid = QoSSnmp.getOid("cdsmFCMultiFieldMatchDstAddr");
        int[] cdsmFCMultiFieldMatchIntfOid = QoSSnmp.getOid("cdsmFCMultiFieldMatchIntf");
        int[] cdsmFCMultiFieldMatchStatusOid = QoSSnmp.getOid("cdsmFCMultiFieldMatchStatus");
        SnmpPeer peer = this.getSPeer();
        VarBindList vbl = new VarBindList(stmts.size());
        int[] index = new int[2];
        boolean maxReached = false;
        for (int i = 0; i < stmts.size(); ++i) {
            if (classMapIndex[i] == 0) continue;
            index[0] = classMapIndex[i];
            int[] newOid = new int[cdsmFCMultiFieldMatchSrcAddrOid.length + 1];
            System.arraycopy(cdsmFCMultiFieldMatchSrcAddrOid, 0, newOid, 0, cdsmFCMultiFieldMatchSrcAddrOid.length);
            newOid[newOid.length - 1] = classMapIndex[i];
            index[1] = 1;
            if (index[1] > 1023) {
                maxReached = true;
                break;
            }
            QoSStatement stmt = (QoSStatement)stmts.get(i);
            EndPort ep = stmt.getInitPort();
            byte[] pwwn = ep.getPortWwn().getValue();
            vbl.add(cdsmFCMultiFieldMatchStatusOid, index, (SnmpVar)new SnmpInt(4));
            vbl.add(cdsmFCMultiFieldMatchSrcAddrOid, index, (SnmpVar)new SnmpString(pwwn));
            ep = stmt.getTargetPort();
            pwwn = ep.getPortWwn().getValue();
            vbl.add(cdsmFCMultiFieldMatchDstAddrOid, index, (SnmpVar)new SnmpString(pwwn));
            vbl.add(cdsmFCMultiFieldMatchIntfOid, index, (SnmpVar)new SnmpInt(stmt.getInterfaceIndex()));
        }
        if (vbl.size() > 0) {
            SnmpFetch.set(peer, vbl);
        }
        if (maxReached) {
            throw new SnmpException("Maximum number of classmap Statements per Classmap reached. ");
        }
    }

    public int createPolicyMapHeader(String name) throws SnmpException {
        int[] cdsmClfrNameOid = QoSSnmp.getOid("cdsmClfrName");
        int[] diffServClfrStatusOid = QoSSnmp.getOid("diffServClfrStatus");
        SnmpPeer peer = this.getSPeer();
        VarBindList vbl = new VarBindList();
        int index = 1;
        index = this.getNextIndex1(diffServClfrStatusOid, MAX_POLICYMAPS, false);
        if (index > 1023) {
            throw new SnmpException("Maximum number of policy maps reached");
        }
        vbl.add(diffServClfrStatusOid, index, (SnmpVar)new SnmpInt(4));
        vbl.add(cdsmClfrNameOid, index, (SnmpVar)new SnmpString(name));
        SnmpFetch.set(peer, vbl);
        this._policyMapOid = new SnmpOID(diffServClfrStatusOid, index);
        return index;
    }

    public void assocPolicyMapToClassMap(int policyMapIndex, int desiredDscpValue, boolean isGold) throws SnmpException {
        SnmpOID dscpOid = QoSSnmp.getDscpOid(desiredDscpValue);
        int[] index = new int[2];
        int[] newOid = new int[this.diffServClfrElementStatusOid.length + 1];
        System.arraycopy(this.diffServClfrElementStatusOid, 0, newOid, 0, this.diffServClfrElementStatusOid.length);
        newOid[newOid.length - 1] = policyMapIndex;
        int pmElementIndex = this.getNextIndex1(newOid, MAX_POLICYMAP_CLASSMAP, false);
        index[0] = policyMapIndex;
        index[1] = pmElementIndex;
        int[] classmapIndex = isGold ? this._classmapIndexGold : this._classmapIndexSilver;
        for (int i = 0; i < classmapIndex.length; ++i) {
            if (classmapIndex[i] == 0) continue;
            if (i != 0) {
                index[1] = index[1] + 1;
            }
            if (index[1] > 255) {
                throw new SnmpException(" Maximum number of classmap entries per policymap entries reached ");
            }
            VarBindList vbl = new VarBindList();
            SnmpOID classMapOid = new SnmpOID(MibNode.get("cdsmFCMultiFieldClfrStatus").getOid(), classmapIndex[i]);
            vbl.add(this.diffServClfrElementStatusOid, index, (SnmpVar)new SnmpInt(4));
            vbl.add(this.diffServClfrElementNextOid, index, (SnmpVar)dscpOid);
            vbl.add(this.diffServClfrElementSpecificOid, index, (SnmpVar)classMapOid);
            SnmpPDU pdu = new SnmpPDU(-93, vbl);
            this.getSPeer().set(pdu);
        }
    }

    public static SnmpOID getDscpOid(int dscpValue) throws SnmpException {
        if (_dscpAF1Oid == null || _dscpAF2Oid == null) {
            QoSSnmp.populateDscpArray();
        }
        if (dscpValue == DSCPAF1) {
            return _dscpAF1Oid;
        }
        if (dscpValue == DSCPAF2) {
            return _dscpAF2Oid;
        }
        return null;
    }

    public static void populateDscpArray() throws SnmpException {
        int[] diffServActionSpecificOid = QoSSnmp.getOid("diffServActionStatus");
        _dscpAF1Oid = new SnmpOID(diffServActionSpecificOid, DSCPAF1 + 1);
        _dscpAF2Oid = new SnmpOID(diffServActionSpecificOid, DSCPAF2 + 1);
    }

    public void assocPolicyMapVsan(int vsanId, long policyMapId) throws SnmpException {
        int[] cdsmDataPathClfrIdOid = QoSSnmp.getOid("cdsmDataPathClfrStart");
        int cdsmDataDirection = 1;
        int[] index = new int[2];
        SnmpPeer peer = this.getSPeer();
        VarBindList vbl = new VarBindList();
        index[0] = vsanId;
        index[1] = cdsmDataDirection;
        int[] getBulkIndex = new int[cdsmDataPathClfrIdOid.length + 2];
        System.arraycopy(cdsmDataPathClfrIdOid, 0, getBulkIndex, 0, cdsmDataPathClfrIdOid.length);
        getBulkIndex[getBulkIndex.length - 2] = vsanId;
        getBulkIndex[getBulkIndex.length - 1] = cdsmDataDirection;
        VarBindList vbList = new VarBindList();
        vbList.add(new SnmpVarBind(new SnmpOID(getBulkIndex)));
        SnmpPDU resp = SnmpFetch.getBulk(peer, vbList);
        if (resp.getVariables().size() != 0) {
            vbl.add(cdsmDataPathClfrIdOid, resp.getVariables().getVb(0).getOid().getIndex(2), (SnmpVar)this._policyMapOid);
        } else {
            vbl.add(cdsmDataPathClfrIdOid, index, (SnmpVar)this._policyMapOid);
        }
        SnmpFetch.set(peer, vbl);
    }

    public void checkAndEnableQoS() throws SnmpException {
        int qosFeatureId = 7;
        this.checkAndEnableFeature(qosFeatureId);
    }

    public void enableFCC() throws SnmpException {
        ClientController.getInstance();
        Switch sw = ClientController.findFabricSwitchByIpAddress(this.getSPeer().getAddress());
        if (!sw.isParadise()) {
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get("cFCCEnable").getOid(), 0), new SnmpInt(1));
            this.getSPeer().set(pdu);
        }
    }

    public Object isQosEnabled() throws SnmpException {
        SnmpPeer peer = this.getSPeer();
        int featureId = 7;
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get("cfcFeatureCtrlOpStatus").getOid(), featureId));
        pdu.addNull(new SnmpOID(MibNode.get("cfcFeatureCtrlLastFailureReason").getOid(), featureId));
        SnmpPDU resp = peer.set(pdu);
        if (resp.getVariables().intValue(0) == 2) {
            return Boolean.TRUE;
        }
        return resp.getVariables().stringValue(1);
    }

    public void checkAndEnableFeature(int featureId) throws SnmpException {
        SnmpPeer peer = this.getSPeer();
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(MibNode.get("cfcFeatureCtrlOpStatus").getOid(), featureId));
        SnmpPDU resp = peer.set(pdu);
        if (resp.getVariables().intValue(0) != 2) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get("cfcFeatureCtrlAction").getOid(), featureId), new SnmpInt(2));
            peer.set(pdu);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }
}

