/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.rmon;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpAggregrateIf;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.NpvLink;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.rmon.Rmon;
import com.cisco.dcbu.sm.client.rmon.RmonWizard;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class FinalPanel
extends WizardPanel
implements SnmpCallbackIf,
SnmpAggregrateIf {
    static final int[] EventDescription = MibNode.get("eventDescription").getOid();
    static final int[] EventStatus = MibNode.get("eventStatus").getOid();
    static final int[] EventType = MibNode.get("eventType").getOid();
    static final int[] EventOwner = MibNode.get("eventOwner").getOid();
    static final int[] RmonAlarmEnable = MibNode.get("rmonAlarmEnable").getOid();
    static final int[] RmonMaxAlarms = MibNode.get("rmonMaxAlarms").getOid();
    static final int[] RmonConfiguredAlarms = MibNode.get("rmonConfiguredAlarms").getOid();
    static final int[] IfHighSpeed = MibNode.get("ifHighSpeed").getOid();
    static final int[] CHcAlarmStatus = MibNode.get("cHcAlarmStatus").getOid();
    static final int[] CHcAlarmVariable = MibNode.get("cHcAlarmVariable").getOid();
    static final int[] CHcAlarmSampleType = MibNode.get("cHcAlarmSampleType").getOid();
    static final int[] CHcAlarmInterval = MibNode.get("cHcAlarmInterval").getOid();
    static final int[] CHcAlarmStartupAlarm = MibNode.get("cHcAlarmStartupAlarm").getOid();
    static final int[] CHcAlarmRisingThreshAbsValueHi = MibNode.get("cHcAlarmRisingThreshAbsValueHi").getOid();
    static final int[] cHcAlarmRisingThreshAbsValueLo = MibNode.get("cHcAlarmRisingThreshAbsValueLo").getOid();
    static final int[] CHcAlarmFallingThreshAbsValueHi = MibNode.get("cHcAlarmFallingThreshAbsValueHi").getOid();
    static final int[] CHcAlarmFallingThreshAbsValueLo = MibNode.get("cHcAlarmFallingThreshAbsValueLo").getOid();
    static final int[] CHcAlarmRisingThresholdValStatus = MibNode.get("cHcAlarmRisingThresholdValStatus").getOid();
    static final int[] CHcAlarmFallingThrsholdValStatus = MibNode.get("cHcAlarmFallingThrsholdValStatus").getOid();
    static final int[] CHcAlarmRisingEventIndex = MibNode.get("cHcAlarmRisingEventIndex").getOid();
    static final int[] CHcAlarmFallingEventIndex = MibNode.get("cHcAlarmFallingEventIndex").getOid();
    static final int[] CHcAlarmOwner = MibNode.get("cHcAlarmOwner").getOid();
    static final int WARNING_EVENT = 4;
    static final int HI = 1;
    static final int LOW = 0;
    static final int DELTA_TYPE = 2;
    static final int RISING_ALARM = 1;
    JFrame _parent;
    SnmpKTable _table;
    RmonWizard _wiz;
    Object[] _lastComponent;
    boolean _needTarget;
    JList _list;
    DefaultListModel _resultModel = new DefaultListModel();
    Array _setErrMsg;
    HashMap _operationalSwList = new HashMap();
    HashMap _nextAvailabeIndex = new HashMap();

    public FinalPanel(JFrame parent, RmonWizard wiz, ImageIcon icon) {
        super("RMON Configuration status.", "Showing progress of each configuration.", icon);
        this._wiz = wiz;
        this._parent = parent;
        this._list = new JList<Object>(new Object[0]);
        JPanel center = new JPanel(new BorderLayout());
        JScrollPane sp = new JScrollPane(this._list);
        sp.setPreferredSize(new Dimension(300, 100));
        center.add("Center", sp);
        this.add("Center", center);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            String[] dummy = new String[]{"Check Events...", "Create Events...", "Create RMON ifHCInOctet.fc3/2 on sw172-22-46-220...", "Create RMON ifHCInOctet.fc7/1 on sw172-22-46-220...", "Create RMON ifHCInOctet.channel1 on sw172-22-46-220...", "Create RMON ifHCInOctet.fcip3 on sw172-22-46-220...", "Succeed."};
            JButton btn = this.getWizard().getNavigator().getNextBtn();
            btn.setEnabled(false);
            btn.setVisible(false);
            btn = this.getWizard().getNavigator().getBackBtn();
            btn.setEnabled(false);
            btn.setVisible(false);
            this._operationalSwList = new HashMap();
            this._resultModel = new DefaultListModel();
            this._list.setModel(this._resultModel);
            try {
                this.createRmon(this._wiz.getSelections());
            }
            catch (Exception ex) {
                System.out.println("here");
            }
            this.addMessage("\nDone.");
            btn = this.getWizard().getNavigator().getCancel();
            btn.setText("Close");
        }
        super.setVisible(b);
    }

    private void createRmon(DefaultListModel list) throws Exception {
        HashMap rmonPdus = new HashMap();
        HashMap rmonVerifyPdus = new HashMap();
        HashMap<SnmpPeer, VarBindList> speedPdus = new HashMap<SnmpPeer, VarBindList>();
        HashMap<SnmpPeer, SnmpPDU> checkRmonPdus = new HashMap<SnmpPeer, SnmpPDU>();
        HashMap<SnmpPeer, SnmpPDU> eventPdus = new HashMap<SnmpPeer, SnmpPDU>();
        HashMap msgs = new HashMap();
        HashMap excludedHash = new HashMap();
        HashMap ifNameHash = new HashMap();
        Switch sw = null;
        int ifIndex = -1;
        String ifIndexName = "";
        for (int i = 0; i < list.size(); ++i) {
            Array<String> message;
            SnmpPDU checkRmonPdu;
            if (list.elementAt(i) instanceof NpvLink) {
                sw = ((NpvLink)list.elementAt(i)).getSwitch1();
                ifIndex = ((NpvLink)list.elementAt(i)).getIfIndex1();
                ifIndexName = ((NpvLink)list.elementAt(i)).getIfIndex1Name();
            } else if (list.elementAt(i) instanceof Isl) {
                sw = ((Isl)list.elementAt(i)).getSwitch1();
                ifIndex = ((Isl)list.elementAt(i)).getIfIndex1();
                ifIndexName = ((Isl)list.elementAt(i)).getIfIndex1Name();
            } else if (list.elementAt(i) instanceof EndPort) {
                sw = ((EndPort)list.elementAt(i)).getSwitch();
                ifIndex = ((EndPort)list.elementAt(i)).getIfIndex();
                ifIndexName = ((EndPort)list.elementAt(i)).getIfIndexName();
            }
            if (sw == null || ifIndex == -1) continue;
            SnmpPeer node = sw.getPeer();
            SnmpPDU eventPdu = (SnmpPDU)eventPdus.get(node);
            this.operationalSwitchList(false, node);
            if (eventPdu == null) {
                eventPdu = new SnmpPDU(-96, new VarBindList());
                eventPdus.put(node, eventPdu);
            }
            if ((checkRmonPdu = (SnmpPDU)checkRmonPdus.get(node)) == null) {
                checkRmonPdu = new SnmpPDU(-96, new VarBindList());
                checkRmonPdus.put(node, checkRmonPdu);
            }
            VarBindList speedPdu = (VarBindList)speedPdus.get(node);
            HashMap<Integer, ifNameOwnerString> ifNameList = (HashMap<Integer, ifNameOwnerString>)ifNameHash.get(node);
            if (speedPdu == null) {
                speedPdu = new VarBindList();
                speedPdus.put(node, speedPdu);
            }
            if (ifNameList == null) {
                ifNameList = new HashMap<Integer, ifNameOwnerString>();
                ifNameHash.put(node, ifNameList);
            }
            if ((message = (Array<String>)msgs.get(node)) == null) {
                message = new Array<String>();
                msgs.put(node, message);
            }
            speedPdu.add(IfHighSpeed, ifIndex);
            ifNameList.put(ifIndex, new ifNameOwnerString(ifIndexName, this.getOwnerString(list.elementAt(i))));
            message.addElement(ifIndexName);
        }
        this.showApplyLog(speedPdus.keySet().iterator(), speedPdus.values().iterator(), speedPdus, msgs, "Check valid operSpeed on ");
        msgs = new HashMap();
        this.checkSpeed(speedPdus, ifNameHash, rmonPdus, rmonVerifyPdus, excludedHash, msgs);
        this.checkRmon(checkRmonPdus, rmonPdus);
        this.createEvent(eventPdus);
        if (this._operationalSwList.size() == 0 || rmonPdus.size() == 0) {
            this.addMessage("no switch to proceed.");
            this.addMessage("\nDone.");
            return;
        }
        this.showExcludedList(excludedHash.keySet().iterator(), excludedHash.values().iterator());
        this.showApplyLog(rmonPdus.keySet().iterator(), rmonPdus.values().iterator(), rmonPdus, msgs, "Create RMON on ");
        this.applyChanges(this, rmonPdus);
        this.showApplyLog(rmonVerifyPdus.keySet().iterator(), rmonVerifyPdus.values().iterator(), rmonVerifyPdus, msgs, "Activate RMON on ");
        this.applyChanges(this, rmonVerifyPdus);
    }

    void showApplyLog(Iterator peers, Iterator pdus, HashMap pduHash, HashMap msgs, String title) {
        while (pdus.hasNext() && peers.hasNext()) {
            SnmpPeer node = (SnmpPeer)peers.next();
            if (!this.isSwitchOperational(node)) {
                pduHash.remove(node);
                continue;
            }
            Array message = (Array)msgs.get(node);
            this.addMessage(title + node + " for the following interface(s)...");
            for (int i = 0; i < message.size(); ++i) {
                this.addMessage(message.elementAt(i).toString());
            }
        }
    }

    void showExcludedList(Iterator peers, Iterator list) {
        while (list.hasNext()) {
            SnmpPeer node = (SnmpPeer)peers.next();
            Array excludedList = (Array)list.next();
            if (!this.isSwitchOperational(node) || excludedList.size() <= 0) continue;
            this.addMessage("Pre-existing RMON entry(s) for " + node.toString() + " :");
            for (int i = 0; i < excludedList.size(); ++i) {
                this.addMessage(excludedList.elementAt(i).toString());
            }
        }
    }

    public void checkRmon(HashMap checkRmonPdus, HashMap rmonPdus) throws Exception {
        int i;
        if (checkRmonPdus == null || checkRmonPdus.size() == 0 || this._operationalSwList.size() == 0) {
            return;
        }
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(RmonAlarmEnable, 0));
        pdu.addNull(new SnmpOID(RmonMaxAlarms, 0));
        pdu.addNull(new SnmpOID(RmonConfiguredAlarms, 0));
        this.addMessage("\n\nCheck RMON for the following switch(s)...");
        SnmpPeer[] peers = checkRmonPdus.keySet().toArray(new SnmpPeer[checkRmonPdus.size()]);
        for (int i2 = 0; i2 < peers.length; ++i2) {
            this.addMessage(peers[i2].toString());
        }
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        SnmpPDU[] responses = aggregrate.get(peers, pdu.getVariables(), false);
        HashMap<SnmpPeer, SnmpPDU> enableRmonPdus = new HashMap<SnmpPeer, SnmpPDU>();
        for (i = 0; i < responses.length; ++i) {
            SnmpPDU rmonPdu;
            boolean isRmonEnabled;
            this.operationalSwitchList(responses[i].getError() != 0, responses[i].getPeer());
            if (responses[i].getError() != 0) {
                this.addMessage(responses[i].getAddress().getHostName() + ": " + SnmpException.toError(responses[i].getError()));
                continue;
            }
            boolean bl = isRmonEnabled = responses[i].getVariables().intValue(0) == 1;
            if (!isRmonEnabled) {
                this.addMessage(responses[i].getPeer() + ": RMON disabled.");
                pdu = new SnmpPDU(-93, new VarBindList(1));
                pdu.addVar(new SnmpOID(RmonAlarmEnable, 0), new SnmpInt(1));
                enableRmonPdus.put(responses[i].getPeer(), pdu);
            }
            if ((rmonPdu = (SnmpPDU)rmonPdus.get(responses[i].getPeer())) == null) continue;
            int maxAlarm = responses[i].getVariables().intValue(1);
            int configuredAlarm = responses[i].getVariables().intValue(2);
            int totalAlarm = configuredAlarm + rmonPdu.getVariables().size();
            if (totalAlarm <= maxAlarm) continue;
            this.addMessage(responses[i].getPeer() + ": alarms will exceed max alarm.");
        }
        if (enableRmonPdus.size() > 0) {
            this.addMessage("\nEnabling RMON for the following switch(s)...");
            peers = enableRmonPdus.keySet().toArray(new SnmpPeer[enableRmonPdus.size()]);
            for (i = 0; i < peers.length; ++i) {
                this.addMessage(peers[i].toString());
            }
            this.applyChanges(this, enableRmonPdus);
        }
    }

    public void createEvent(HashMap eventPdus) throws Exception {
        if (eventPdus == null || eventPdus.size() == 0 || this._operationalSwList.size() == 0) {
            return;
        }
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(EventDescription, 4));
        this.addMessage("\n\nCheck WARNING event for the following switch(s)...");
        SnmpPeer[] peers = eventPdus.keySet().toArray(new SnmpPeer[eventPdus.size()]);
        for (int i = 0; i < peers.length; ++i) {
            this.addMessage(peers[i].toString());
        }
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        SnmpPDU[] responses = aggregrate.get(peers, pdu.getVariables(), false);
        this.addMessage("\n\nCreate WARNING event for the following switch(s)...");
        eventPdus = new HashMap<SnmpPeer, SnmpPDU>();
        SnmpString owner = new SnmpString(InetAddress.getLocalHost().getHostName());
        for (int i = 0; i < responses.length; ++i) {
            this.operationalSwitchList(responses[i].getError() != 0, responses[i].getPeer());
            if (responses[i].getError() != 0) {
                this.addMessage(responses[i].getAddress().getHostName() + ": " + SnmpException.toError(responses[i].getError()));
                continue;
            }
            SnmpVarBind vb = responses[i].getVariables().get(0);
            if (vb.getVar().getType() == 4) continue;
            pdu = new SnmpPDU(-93, new VarBindList(4));
            pdu.addVar(new SnmpOID(EventStatus, 4), new SnmpInt(2));
            pdu.addVar(new SnmpOID(EventDescription, 4), new SnmpString("WARNING(4)"));
            pdu.addVar(new SnmpOID(EventOwner, 4), owner);
            pdu.addVar(new SnmpOID(EventType, 4), new SnmpInt(4));
            pdu.addVar(new SnmpOID(EventStatus, 4), new SnmpInt(1));
            this.addMessage(responses[i].getPeer().toString());
            eventPdus.put(responses[i].getPeer(), pdu);
        }
        if (eventPdus.size() > 0) {
            this.applyChanges(this, eventPdus);
        }
    }

    public void checkSpeed(HashMap speedPdus, HashMap ifNameHash, HashMap rmonPdus, HashMap rmonVerifyPdus, HashMap excludedHash, HashMap msgs) throws Exception {
        if (speedPdus == null || speedPdus.size() == 0) {
            return;
        }
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        SnmpPeer[] peers = speedPdus.keySet().toArray(new SnmpPeer[speedPdus.size()]);
        VarBindList[] vbls = speedPdus.values().toArray(new VarBindList[speedPdus.size()]);
        SnmpPDU[] responses = aggregrate.get(peers, vbls);
        for (int i = 0; i < responses.length; ++i) {
            Array<String> excludedList;
            Array<String> message;
            SnmpPDU rmonVerifyPdu;
            this.operationalSwitchList(responses[i].getError() != 0, responses[i].getPeer());
            if (responses[i].getError() != 0) {
                this.addMessage(responses[i].getAddress().getHostName() + ": " + SnmpException.toError(responses[i].getError()));
                continue;
            }
            VarBindList vbl = responses[i].getVariables();
            SnmpPeer node = responses[i].getPeer();
            HashMap ifNameList = (HashMap)ifNameHash.get(node);
            SnmpPDU rmonPdu = (SnmpPDU)rmonPdus.get(node);
            if (rmonPdu == null) {
                rmonPdu = new SnmpPDU(-93, new VarBindList());
                rmonPdus.put(node, rmonPdu);
            }
            if ((rmonVerifyPdu = (SnmpPDU)rmonVerifyPdus.get(node)) == null) {
                rmonVerifyPdu = new SnmpPDU(-93, new VarBindList());
                rmonVerifyPdus.put(node, rmonVerifyPdu);
            }
            if ((message = (Array<String>)msgs.get(node)) == null) {
                message = new Array<String>();
                msgs.put(node, message);
            }
            if ((excludedList = (Array<String>)excludedHash.get(node)) == null) {
                excludedList = new Array<String>();
                excludedHash.put(node, excludedList);
            }
            for (int j = 0; j < vbl.size(); ++j) {
                String ifName;
                String ownerString;
                SnmpVar vb = vbl.get(i).getVar();
                int[] oid = vbl.get(i).getOid().getValue();
                int ifIndex = oid[oid.length - 1];
                ifNameOwnerString name = (ifNameOwnerString)ifNameList.get(ifIndex);
                if (name == null) {
                    ifName = ownerString = Integer.toString(ifIndex);
                } else {
                    ifName = name.getIfName();
                    ownerString = name.getOwnerString();
                }
                if (vb.getType() == 5) {
                    this.addMessage(node + " " + ifName + ": speed unknown");
                    continue;
                }
                int highSpeed = (int)((SnmpGauge)vb).getValue();
                long ifSpeed = (long)highSpeed * 100000L;
                String[] rmonObjs = new String[]{"ifHCInOctets", "ifHCOutOctets"};
                for (int k = 0; k < rmonObjs.length; ++k) {
                    StringBuffer sb = new StringBuffer(rmonObjs[k]);
                    sb.append('.');
                    sb.append(ifName);
                    String rmonObjString = sb.toString();
                    boolean isRmonConfigExists = this._wiz._rmonTable == null ? null : Boolean.valueOf(this._wiz._rmonTable.get(new Rmon(node, rmonObjString)) != null);
                    if (!isRmonConfigExists) {
                        try {
                            this.buildRmonPDU(rmonPdu, rmonVerifyPdu, this.getNextAlarmIndex(node), rmonObjs[k], ifIndex, ifSpeed, ownerString);
                            message.addElement(rmonObjString);
                        }
                        catch (Exception ex) {
                            this.addMessage(node + ": " + ifName + "  exception: " + ex.getMessage());
                        }
                        continue;
                    }
                    excludedList.addElement(rmonObjString);
                }
            }
        }
    }

    private void buildRmonPDU(SnmpPDU pdu, SnmpPDU actPdu, int alarmIndex, String mibObj, int ifIndex, long ifSpeed, String ownerString) throws Exception {
        SnmpGauge[] thresholdVars_rising = this.getThreshold4PercentageObj(ifSpeed, this._wiz.getSpeed(), this._wiz.getInterval());
        SnmpGauge[] thresholdVars_falling = this.getThreshold4PercentageObj(ifSpeed, this._wiz.getSpeed() - 1L, this._wiz.getInterval());
        pdu.addVar(new SnmpOID(CHcAlarmStatus, alarmIndex), new SnmpInt(2));
        pdu.addVar(new SnmpOID(CHcAlarmVariable, alarmIndex), new SnmpOID(MibNode.get(mibObj).getOid(), ifIndex));
        pdu.addVar(new SnmpOID(CHcAlarmSampleType, alarmIndex), new SnmpInt(2));
        pdu.addVar(new SnmpOID(CHcAlarmInterval, alarmIndex), new SnmpInt(this._wiz.getInterval()));
        pdu.addVar(new SnmpOID(CHcAlarmStartupAlarm, alarmIndex), new SnmpInt(1));
        if (thresholdVars_rising[1].getValue() != 0L) {
            pdu.addVar(new SnmpOID(CHcAlarmRisingThreshAbsValueHi, alarmIndex), thresholdVars_rising[1]);
        }
        pdu.addVar(new SnmpOID(cHcAlarmRisingThreshAbsValueLo, alarmIndex), thresholdVars_rising[0]);
        pdu.addVar(new SnmpOID(CHcAlarmRisingThresholdValStatus, alarmIndex), new SnmpInt(2));
        if (thresholdVars_falling[1].getValue() != 0L) {
            pdu.addVar(new SnmpOID(CHcAlarmFallingThreshAbsValueHi, alarmIndex), thresholdVars_falling[1]);
        }
        pdu.addVar(new SnmpOID(CHcAlarmFallingThreshAbsValueLo, alarmIndex), thresholdVars_falling[0]);
        pdu.addVar(new SnmpOID(CHcAlarmFallingThrsholdValStatus, alarmIndex), new SnmpInt(2));
        pdu.addVar(new SnmpOID(CHcAlarmRisingEventIndex, alarmIndex), new SnmpInt(4));
        pdu.addVar(new SnmpOID(CHcAlarmFallingEventIndex, alarmIndex), new SnmpInt(4));
        pdu.addVar(new SnmpOID(CHcAlarmOwner, alarmIndex), new SnmpString(ownerString));
        actPdu.addVar(new SnmpOID(CHcAlarmStatus, alarmIndex), new SnmpInt(1));
    }

    private SnmpGauge[] getThreshold4PercentageObj(long speed, long value, int interval) throws Exception {
        long val = speed * value / 100L;
        BigInteger valB = new BigInteger(String.valueOf(val));
        valB = valB.multiply(new BigInteger(String.valueOf(interval)));
        return this.getThresholdVars(valB);
    }

    private SnmpGauge[] getThresholdVars(BigInteger val) throws Exception {
        SnmpGauge[] thresholdVars = new SnmpGauge[2];
        byte[] valByte = val.toByteArray();
        if (valByte.length > 8) {
            throw new Exception("number too big, not supported");
        }
        long[] long32 = this.byteTo32LongArray(valByte);
        thresholdVars[1] = long32.length > 1 ? new SnmpGauge(long32[1]) : new SnmpGauge(0L);
        thresholdVars[0] = new SnmpGauge(long32[0]);
        return thresholdVars;
    }

    private long[] byteTo32LongArray(byte[] b) {
        long[] long32 = new long[b.length / 4 + 1];
        int i = b.length - 1;
        int j = 0;
        while (i >= 0) {
            int n = j / 4;
            long32[n] = long32[n] | ((long)b[i] & 0xFFL) << 8 * (j % 4);
            --i;
            ++j;
        }
        return long32;
    }

    private String getOwnerString(Object selection) {
        StringBuffer ownerString = new StringBuffer();
        if (selection instanceof NpvLink) {
            ownerString.append('.');
            ownerString.append(((NpvLink)selection).getIfIndex1Name());
            ownerString.append("<->");
            ownerString.append(((NpvLink)selection).getSwitch2());
            ownerString.append(((NpvLink)selection).getIfIndex2Name());
        } else if (selection instanceof Isl) {
            ownerString.append('.');
            ownerString.append(((Isl)selection).getIfIndex1Name());
            ownerString.append("<->");
            ownerString.append(((Isl)selection).getSwitch2());
            ownerString.append(' ');
            ownerString.append(((Isl)selection).getIfIndex2Name());
        } else if (selection instanceof EndPort) {
            ownerString.append('.');
            ownerString.append(((EndPort)selection).getIfIndexName());
            ownerString.append('(');
            ownerString.append(((EndPort)selection).toString());
            ownerString.append(')');
        }
        ownerString.append('@');
        try {
            ownerString.append(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException ex) {
            ownerString.append("UnknownHost");
        }
        return ownerString.toString();
    }

    public int applyChangesSet(HashMap pdus, SnmpAggregrateIf applyChangesCallback) throws Exception {
        SnmpAggregrate aggregrate = new SnmpAggregrate();
        int successfulSets = aggregrate.set(pdus.keySet().iterator(), pdus.values().iterator(), pdus.values().iterator(), applyChangesCallback, false);
        return successfulSets;
    }

    public boolean applyChanges(SnmpAggregrateIf applyChangesCallback, HashMap pdus) throws Exception {
        if (pdus == null || pdus.size() == 0) {
            return false;
        }
        int successfulSets = this.applyChangesSet(pdus, applyChangesCallback);
        if (successfulSets == 0) {
            return false;
        }
        if (successfulSets < pdus.size()) {
            int failedSets = pdus.size() - successfulSets;
            return false;
        }
        return true;
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
    }

    @Override
    public void snmpAggregrate(SnmpPDU pdu, String err) {
        if (err != null && err.length() != 0) {
            this.addMessage(pdu.getPeer() + " error: " + err);
            if (this._operationalSwList.get(pdu.getPeer()) != null) {
                this._operationalSwList.remove(pdu.getPeer());
            }
        }
    }

    void operationalSwitchList(boolean hasErr, SnmpPeer sw) {
        if (hasErr) {
            this._operationalSwList.remove(sw);
        } else if (this._operationalSwList.get(sw) == null) {
            this._operationalSwList.put(sw, "");
        }
    }

    int getNextAlarmIndex(SnmpPeer node) {
        Integer index = (Integer)this._nextAvailabeIndex.get(node);
        if (index == null) {
            Object o = this._wiz._rmonNextAvailable.get(node);
            index = (Integer)this._wiz._rmonNextAvailable.get(node);
            if (index == null) {
                index = new Integer(1);
                this._nextAvailabeIndex.put(node, index);
                return index;
            }
        }
        index = new Integer(index + 1);
        this._nextAvailabeIndex.put(node, index);
        return index;
    }

    void addMessage(String message) {
        this._resultModel.addElement(message);
    }

    boolean isSwitchOperational(SnmpPeer peer) {
        return this._operationalSwList != null && this._operationalSwList.get(peer) != null;
    }

    class ifNameOwnerString {
        String _ifName;
        String _ownerString;

        ifNameOwnerString(String ifName, String ownerString) {
            this._ifName = ifName;
            this._ownerString = ownerString;
        }

        String getIfName() {
            return this._ifName;
        }

        String getOwnerString() {
            return this._ownerString;
        }
    }
}

