/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.sanexttuner;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.sanexttuner.SanExtTunerBasePanel;
import com.cisco.dcbu.sm.client.sanexttuner.SanExtTunerConfigPanel;
import com.cisco.dcbu.sm.client.sanexttuner.SanExtTunerPortPanel;
import com.cisco.dcbu.sm.client.sanexttuner.SanExtTunerResultPanel;
import java.awt.Cursor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class SanExtTunerWizard
extends JWizard {
    SanExtTunerPortPanel _portPanel;
    protected final AtomicInteger _numThreadWaiting = new AtomicInteger(0);
    public static final String INITIATOR_SW = "Initiator Switch";
    public static final String TARGET_SW = "Target Switch";
    public static final String INIT_PORT = "Initiator PORT";
    public static final String TARGET_PORT = "Target PORT";
    public static final String INIT_SMLHANDLE = "Initiator SmlHandler";
    public static final String TARGET_SMLHANDLE = "Target SmlHandler";
    public static final String INIT_VSAN = "Initiator VSAN";
    public static final String TARGET_VSAN = "Target VSAN";
    public static final String TRANSFER_SIZE = "Transfer Size";
    public static final String READ_IO = "Read I/O";
    public static final String WRITE_IO = "Write I/O";
    public static final String USE_PATTERNFILE = "Use Pattern File";
    public static final String PATTERNFILE = "Pattern File";
    public static final String FCIP_LINK = "FCIP Link";
    public static ImageIcon _Image = Util.loadIcon("icons/SAN_Ext_Tuner.gif");
    protected Isl _selectedFcipLink;
    private static SanExtTunerWizard _Instance;

    public static SanExtTunerWizard getInstance() {
        return _Instance;
    }

    public SanExtTunerWizard(JFrame parent, Isl selectedFcipLink) {
        super(parent);
        this._selectedFcipLink = selectedFcipLink;
        this.setTitle("SAN Extension Tuner Wizard" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.setSize(479, 430);
        this._portPanel = new SanExtTunerPortPanel(this, selectedFcipLink);
        this.addPanel("Port", this._portPanel);
        this.addPanel("Config Parameters", new SanExtTunerConfigPanel(this));
        this.addPanel("Output", new SanExtTunerResultPanel(this));
        this.first();
        _Instance = this;
        this.setLocationRelativeTo(this.getParent());
    }

    void setCursor(boolean busy) {
        this.setCursor(Cursor.getPredefinedCursor(busy ? 3 : 0));
    }

    public Isl getSelectedFCIP() {
        return this._selectedFcipLink;
    }

    @Override
    public void dispose() {
        _Instance = null;
        SanExtTunerBasePanel panel = (SanExtTunerBasePanel)this.getCurrent();
        if (panel != null && panel.processDispose()) {
            this.cleanupAndExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAndExit() {
        if (this._numThreadWaiting.get() > 0) {
            AtomicInteger atomicInteger = this._numThreadWaiting;
            synchronized (atomicInteger) {
                this._numThreadWaiting.set(0);
                this._numThreadWaiting.notifyAll();
            }
        }
        super.dispose();
    }
}

