/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.se;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.se.SEconfigThread;
import com.cisco.dcbu.sm.client.se.SecureEraseManager;
import com.cisco.dcbu.sm.common.rif.SecureEraseRif;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SEconfigPanel
extends WizardPanel {
    volatile SEconfigThread _cfgThread;
    boolean _finish = false;

    public SEconfigPanel(String name, String description, JWizard wizard, ImageIcon image) {
        super(name, description, wizard, image);
    }

    @Override
    public void doCancel() {
        this.dispose();
    }

    public SecureEraseRif getRif() {
        return SecureEraseManager.getInstance().getRif();
    }

    @Override
    public void dispose() {
        if (SecureEraseManager.getInstance().isJobCreated() && !this._finish) {
            int opt = JOptionPane.showConfirmDialog(this, "Job will be deleted. Do you wish to continue?", this.getTitle(), 2);
            if (opt == 0) {
                ConfigCancelJobThread thread = new ConfigCancelJobThread(this.getWizard());
                thread.start();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.dispose();
        } else {
            super.dispose();
        }
    }

    protected void goNext() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SEconfigPanel.this.continueToNext();
            }
        });
    }

    @Override
    public void doPrevious() {
        System.out.println("Removing panels " + this.getWizard().getPanelCount());
        this.getWizard().removeAllPanelAfterCurrent();
        this.getWizard().getCurrent().setDataValid(false);
        System.out.println("after Removing panels " + this.getWizard().getPanelCount());
        super.doPrevious();
    }

    private void continueToNext() {
        super.doNext();
    }

    private class RetryThread
    implements Runnable {
        boolean retry = true;
        JWizard _wiz = null;

        RetryThread(JWizard w) {
            this._wiz = w;
        }

        @Override
        public void run() {
            int opt = JOptionPane.showConfirmDialog(this._wiz, "Job could not be deleted. Do you wish to retry?", SEconfigPanel.this.getTitle(), 0);
            if (opt != 0) {
                this.retry = false;
            }
        }

        public boolean isRetry() {
            return this.retry;
        }
    }

    class ConfigCancelJobThread
    extends SEconfigThread {
        public ConfigCancelJobThread(JWizard wizard) {
            super(wizard);
        }

        @Override
        public void run() {
            if (SEconfigPanel.this._cfgThread != null) {
                SEconfigPanel.this._cfgThread = null;
            }
            if (SecureEraseManager.getInstance().isJobCreated()) {
                try {
                    this.setupConfigStatus(true, false, null);
                    SecureEraseManager.getInstance().deleteJob();
                    this.setupConfigStatus(false, false, null);
                    if (this._wizard != null && this._wizard.getNavigator() != null) {
                        this._wizard.getNavigator().getCancel().setEnabled(false);
                    }
                    SEconfigPanel.this._finish = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    SEconfigPanel.this._finish = true;
                    Util.errorMessage((Component)this._wizard, "Job could not be deleted. Please go to status view to try again. " + ex.getMessage());
                }
            }
        }
    }
}

