/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.se;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardNavigator;
import com.cisco.dcbu.sm.common.rif.SEException;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.SwingUtilities;

public class SEconfigThread
extends Thread {
    JWizard _wizard;

    public SEconfigThread(JWizard wizard) {
        this._wizard = wizard;
    }

    protected boolean keepRunning(Thread targetThread) {
        return Thread.currentThread() == targetThread;
    }

    protected void setupConfigStatus(boolean start, boolean handleBack, Exception ex) {
        SwingUtilities.invokeLater(new UpdateConfigStatus(start, handleBack, ex));
    }

    class UpdateConfigStatus
    implements Runnable {
        boolean _start;
        boolean _handleBack;
        Exception _ex;

        public UpdateConfigStatus(boolean start, boolean handleBack, Exception ex) {
            this._start = start;
            this._handleBack = handleBack;
            this._ex = ex;
        }

        @Override
        public void run() {
            SEconfigThread.this._wizard.setStatus("");
            SEconfigThread.this._wizard.setCursor(this._start ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor());
            WizardNavigator nav = SEconfigThread.this._wizard.getNavigator();
            if (nav != null) {
                nav.getNextBtn().setEnabled(!this._start);
                if (this._handleBack) {
                    nav.getBackBtn().setEnabled(!this._start);
                }
            }
            if (this._ex != null) {
                if (this._ex instanceof SEException) {
                    Util.errorMessage((Component)SEconfigThread.this._wizard, ((SEException)this._ex).getMessage());
                } else {
                    Util.errorMessage((Component)SEconfigThread.this._wizard, this._ex);
                }
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)this._ex.getMessage(), (Throwable)this._ex);
                }
            }
        }
    }
}

