/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.se;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.DataViewModelIf;
import com.cisco.dcbu.sm.client.gui.SmCommand;
import com.cisco.dcbu.sm.client.se.AlgorithmCellRenderer;
import com.cisco.dcbu.sm.client.se.SESessionTableModel;
import com.cisco.dcbu.sm.client.se.SEStatusTable;
import com.cisco.dcbu.sm.client.se.SEconfigPanel;
import com.cisco.dcbu.sm.client.se.SecureEraseManager;
import com.cisco.dcbu.sm.client.se.SecureEraseWizard;
import com.cisco.dcbu.sm.client.se.SessionCellRenderer;
import com.cisco.dcbu.sm.client.se.SessionTableRow;
import com.cisco.dcbu.sm.client.se.TreeNodeCellRenderer;
import com.cisco.dcbu.sm.common.model.se.SEAlgoInfo;
import com.cisco.dcbu.sm.common.model.se.SELun;
import com.cisco.dcbu.sm.common.model.se.SETarget;
import com.jidesoft.grid.BooleanCheckBoxCellEditor;
import com.jidesoft.grid.BooleanCheckBoxCellRenderer;
import com.jidesoft.grid.CellEditorFactory;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.ListComboBoxCellEditor;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.grid.TreeTableModel;
import com.jidesoft.swing.TableSearchable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.CellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class SEsessionPanel
extends SEconfigPanel {
    private TreeTable _table;
    private TreeTableModel _tableModel;
    private List<SETarget> lunMap;
    private List<SEAlgoInfo> algoList;
    ArrayList<Long> _lunIds;
    static final TableCellRenderer TREECELL_RENDERER = new TreeNodeCellRenderer();
    static final TableCellRenderer ALGORITHM_RENDERER = new AlgorithmCellRenderer();
    static final TableCellRenderer SESSION_RENDERER = new SessionCellRenderer();
    TableCellEditor _sessionEditor = null;
    TableCellEditor _algorithmEditor = null;

    public SEsessionPanel(JWizard wizard) {
        super("", "Select the LUNs to create sessions for and choose the algorithm to be used for each. Finish will add sessions for each LUN to the job.", wizard, SecureEraseWizard.IMAGE);
    }

    @Override
    public boolean refresh() {
        this.removeAll();
        try {
            this.lunMap = this.getRif().getLunMap(SecureEraseManager.getInstance().getJob());
            this.algoList = SecureEraseManager.getInstance().getAlgoList();
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.errorMessage((Component)this.getWizard(), e);
        }
        this.setTitle("Step " + ((SecureEraseWizard)this.getWizard()).getNextStep() + ": Create Sessions");
        JPanel topPanel = new JPanel(null);
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        this._tableModel = this.populateTable();
        this._table = new TreeTable((TableModel)this._tableModel);
        this._table.setSortable(true);
        this._table.setExpandAllAllowed(false);
        this._table.setRowHeight(18);
        this._table.setShowTreeLines(true);
        this._table.setShowGrid(false);
        this._table.setIntercellSpacing(new Dimension(0, 0));
        this._table.setSelectRowWhenToggling(false);
        this._table.getColumnModel().getColumn(0).setPreferredWidth(300);
        this._table.getColumnModel().getColumn(1).setPreferredWidth(25);
        this._table.getColumnModel().getColumn(2).setPreferredWidth(50);
        this._table.getColumnModel().getColumn(0).setCellRenderer(TREECELL_RENDERER);
        this._table.getColumnModel().getColumn(2).setCellRenderer(ALGORITHM_RENDERER);
        CellRendererManager.initDefaultRenderer();
        BooleanCheckBoxCellRenderer booleanCheckBoxCellRenderer = new BooleanCheckBoxCellRenderer();
        CellRendererManager.registerRenderer(Boolean.class, (TableCellRenderer)booleanCheckBoxCellRenderer);
        CellRendererManager.registerRenderer(Boolean.TYPE, (TableCellRenderer)booleanCheckBoxCellRenderer);
        CellEditorManager.initDefaultEditor();
        CellEditorManager.registerEditor(Boolean.class, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                return new BooleanCheckBoxCellEditor();
            }
        });
        CellEditorManager.registerEditor(Boolean.TYPE, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                return new BooleanCheckBoxCellEditor();
            }
        });
        CellEditorManager.registerEditor(Enum.class, (CellEditorFactory)new CellEditorFactory(){

            public CellEditor create() {
                return new ListComboBoxCellEditor((Object[])SecureEraseManager.getInstance().getValidAlgoList().toArray(new SEAlgoInfo[0]));
            }
        });
        TableSearchable searchable = new TableSearchable((JTable)this._table){

            protected String convertElementToString(Object item) {
                if (item instanceof SessionTableRow) {
                    return ((SessionTableRow)item).getName();
                }
                return super.convertElementToString(item);
            }
        };
        searchable.setMainIndex(0);
        JScrollPane scrollPane = new JScrollPane((Component)this._table);
        scrollPane.getViewport().setBackground(Color.WHITE);
        scrollPane.getViewport().setForeground(Color.BLACK);
        JPanel panel = new JPanel(new BorderLayout(6, 6));
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize(new Dimension(700, 500));
        topPanel.add(panel);
        this.add(topPanel);
        return true;
    }

    private TreeTableModel populateTable() {
        ArrayList<SessionTableRow> rootList = new ArrayList<SessionTableRow>();
        for (SETarget root : this.lunMap) {
            SessionTableRow n = new SessionTableRow(root);
            List<SELun> children = root.getLuns();
            ArrayList<SessionTableRow> c = new ArrayList<SessionTableRow>();
            for (SELun lun : children) {
                c.add(new SessionTableRow(lun));
            }
            n.setChildren(c);
            rootList.add(n);
        }
        for (SessionTableRow node : rootList) {
            node.calculateAlgo();
        }
        return new SESessionTableModel(rootList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFinish() {
        block8: {
            try {
                ArrayList<SETarget> map = new ArrayList<SETarget>();
                this._tableModel.refresh();
                List rows = this._tableModel.getRows();
                boolean flag = false;
                for (SessionTableRow row : rows) {
                    if (!row.hasChildren()) continue;
                    List<?> children = row.getChildren();
                    ArrayList<SELun> luns = new ArrayList<SELun>();
                    System.out.println("\nFINAL LUNs session = ");
                    for (Object child : children) {
                        SELun lun = (SELun)((SessionTableRow)child).getNodeObj();
                        if (!((SessionTableRow)child).isSession()) continue;
                        lun.setAlgorithm(((SessionTableRow)child).getAlgorithm());
                        luns.add(lun);
                        flag = true;
                    }
                    SETarget target = (SETarget)row.getNodeObj();
                    target.setLuns(luns);
                    map.add(target);
                }
                if (!flag) {
                    throw new Exception("No LUNs selected for session creation.");
                }
                this.getRif().createSessions(SecureEraseManager.getInstance().getJob(), map);
                this._finish = true;
                this.getWizard().dispose();
                DataView dv = BrowserFrame.getDataView();
                DataViewModelIf dvModel = dv.getDataViewModelIf();
                if (dvModel instanceof SEStatusTable) {
                    ((SEStatusTable)dvModel).refresh();
                    break block8;
                }
                SmCommand.DMStatus(BrowserFrame.getDataView(), "Secure Erase Status", null, null, null, null);
            }
            catch (Exception e) {
                Util.errorMessage((Component)this, e);
            }
        }
    }
}

