/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.se;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.CliCommandHandler;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.se.SEconfigPanel;
import com.cisco.dcbu.sm.client.se.SEconfigThread;
import com.cisco.dcbu.sm.client.se.SEsessionPanel;
import com.cisco.dcbu.sm.client.se.SecureEraseWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SEzonePanel
extends SEconfigPanel
implements ActionListener {
    JButton _actBtn;
    JStatusTextArea _result;
    CliCommandHandler _smlCmd;
    String _showStatusCmd;
    static final String ACT_BTN_STATUS = "Status";
    static final String ACT_BTN_CMD = "actBtn";
    static final int ACTIVATE_BTN = 0;
    static final int STATUS_BTN = 1;

    public SEzonePanel(JWizard wizard) {
        super("", "Each selected DPP VI is zoned with VSAN. Press Status to view the Zone Creation and Activation status. \n", wizard, SecureEraseWizard.IMAGE);
    }

    @Override
    public boolean refresh() {
        this.removeAll();
        this.setTitle("Step " + ((SecureEraseWizard)this.getWizard()).getNextStep() + ": Zone Activation Status");
        JTextArea zoneNameField = (JTextArea)this.getModelValue("ZoneNameFieldLabel");
        zoneNameField.setBackground(Color.LIGHT_GRAY);
        this._smlCmd = (CliCommandHandler)this.getModelValue("ZoneSml");
        this._showStatusCmd = (String)this.getModelValue("ShowZoneStatusCmd");
        JPanel upPanel = new JPanel(new BorderLayout());
        upPanel.add("North", zoneNameField);
        JPanel center = new JPanel(new BorderLayout());
        this._result = new JStatusTextArea();
        this._result.setEditable(false);
        this._result.setWrapStyleWord(true);
        this._result.setLineWrap(true);
        this._result.setFont(ChangedCellRenderer.getNormalFont());
        JScrollPane sp = new JScrollPane(this._result);
        sp.setPreferredSize(new Dimension(200, 80));
        center.add("Center", sp);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 4));
        this._actBtn = new JButton(ACT_BTN_STATUS);
        this._actBtn.setActionCommand(ACT_BTN_CMD);
        this._actBtn.addActionListener(this);
        buttonPanel.add(this._actBtn);
        center.add("South", buttonPanel);
        upPanel.add("Center", center);
        this.getStatus(this._smlCmd, this._showStatusCmd, this._result);
        this.add("Center", upPanel);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton btn = (AbstractButton)e.getSource();
        this.getStatus(this._smlCmd, this._showStatusCmd, this._result);
    }

    void getStatus(CliCommandHandler smlCmd, String showStatusCmd, JStatusTextArea result) {
        block2: {
            try {
                smlCmd.reconnect(true);
                String status = smlCmd.executeCLICommandPromptError(showStatusCmd, (String)null, false);
                StringBuffer b = new StringBuffer(showStatusCmd);
                b.append("/n");
                b.append(status);
                SwingUtilities.invokeLater(new ShowStatus(showStatusCmd, status, result));
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this.getWizard(), ex.getMessage());
                if (!SnmpSession.isTrace()) break block2;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void doNext() {
        this._cfgThread = new ZoneConfigThread(this.getWizard());
        this._cfgThread.start();
    }

    class JStatusTextArea
    extends JTextArea
    implements ActionListener {
        protected JPopupMenu _menu;

        public JStatusTextArea() {
            this.addMouseListener(new MouseAdapter(){

                void checkPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        if (JStatusTextArea.this._menu == null) {
                            JStatusTextArea.this._menu = JStatusTextArea.this.buildMenu();
                        }
                        JStatusTextArea.this._menu.show(JStatusTextArea.this, e.getX(), e.getY());
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.checkPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.checkPopup(e);
                }
            });
        }

        protected JPopupMenu buildMenu() {
            JPopupMenu menu = new JPopupMenu();
            String[] labels = new String[]{"Clear"};
            for (int i = 0; i < labels.length; ++i) {
                JMenuItem mi = new JMenuItem(labels[i]);
                menu.add(mi);
                mi.addActionListener(this);
            }
            return menu;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = ((AbstractButton)e.getSource()).getText();
            switch (cmd.charAt(0)) {
                case 'C': {
                    if (cmd.charAt(1) != 'l') break;
                    this.clearStatusArea();
                }
            }
        }

        public void clearStatusArea() {
            this.setText(" ");
            this.setText(null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    System.gc();
                }
            });
        }
    }

    class ZoneConfigThread
    extends SEconfigThread {
        public ZoneConfigThread(JWizard wizard) {
            super(wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.setupConfigStatus(true, false, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SEzonePanel.this.getWizard().setStatus("Getting Lun Map Correlation and Preparing Session input...");
                    }
                });
                if (!this.keepRunning(SEzonePanel.this._cfgThread)) {
                    return;
                }
                this.setupConfigStatus(false, false, null);
                System.out.println("Adding SESSION_PANEL " + SEzonePanel.this.getWizard().getPanelCount());
                SEzonePanel.this.getWizard().addPanel("sessionPanel", new SEsessionPanel(SEzonePanel.this.getWizard()));
                SEzonePanel.this.goNext();
            }
            catch (Exception ex) {
                if (!this.keepRunning(SEzonePanel.this._cfgThread)) {
                    return;
                }
                this.setupConfigStatus(false, false, ex);
                return;
            }
        }
    }

    class ShowStatus
    implements Runnable {
        String _cmd;
        String _status;
        JStatusTextArea _result;

        public ShowStatus(String cmd, String status, JStatusTextArea result) {
            this._cmd = cmd;
            this._status = status;
            this._result = result;
        }

        @Override
        public void run() {
            this._result.clearStatusArea();
            if (this._result.getLineCount() == 1) {
                this._result.setForeground(Color.BLUE);
                this._result.setText(this._cmd);
                this._result.setForeground(Color.BLACK);
                this._result.setText(this._status);
            } else {
                this._result.append("\n\n");
                this._result.append(this._status);
            }
        }
    }
}

