/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.se;

import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.se.SEAlgoInfo;
import com.cisco.dcbu.sm.common.model.se.SEJob;
import com.cisco.dcbu.sm.common.model.se.SESession;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.rif.SecureEraseRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecureEraseManager {
    private static SecureEraseManager _instance;
    SecureEraseRif _seRif;
    public static final String SE_FEATURE_NAME = "se";
    private boolean _jobCreated = false;
    private FabricPK _fabric = null;
    private Switch[] _switch = null;
    private SEJob _job = null;
    private List<Card> _seEnabledModules = new ArrayList<Card>();
    private List<SEAlgoInfo> _algoList = new ArrayList<SEAlgoInfo>();

    private SecureEraseManager() {
        try {
            this._seRif = ClientController.getInstance().getSecureEraseRif();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static SecureEraseManager getInstance() {
        if (_instance == null) {
            _instance = new SecureEraseManager();
        }
        return _instance;
    }

    boolean isJobCreated() {
        return this._jobCreated;
    }

    void setJobCreated(boolean flag) {
        this._jobCreated = flag;
    }

    SecureEraseRif getRif() {
        return this._seRif;
    }

    Switch[] getSwitches() {
        return this._switch;
    }

    void setSwitches(Switch[] s) {
        this._switch = s;
    }

    FabricPK getFabric() {
        return this._fabric;
    }

    void setFabric(FabricPK f) {
        this._fabric = f;
    }

    List<Integer> getVsanIDs() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (EndPortBase port : this.getJob().getTargetPorts()) {
            short[] vsans;
            if (!port.getFabricPK().equals(this._fabric) || (vsans = port.getVsanMembership()) == null) continue;
            for (int j = 0; j < vsans.length; ++j) {
                Integer vsanId = new Integer(vsans[j]);
                list.add(vsanId);
            }
        }
        return list;
    }

    void setEnabledModules() throws Exception {
        FabricPK[] fbs = this.findAllFabricForEndPortList(this.getJob().getTargetPorts());
        if (fbs == null || fbs.length == 0) {
            throw new Exception("Cannot find valid fabric information for target port(s) selection.");
        }
        if (fbs.length > 1) {
            throw new Exception("Target ports belong to more than one fabric.");
        }
        SecureEraseManager.getInstance().setFabric(fbs[0]);
        List<SwitchBase> swList = this.findAllSwitchForEndPortList(this.getJob().getTargetPorts());
        if (swList.size() == 0) {
            throw new Exception("Cannot find valid switch information for target port(s) selection.");
        }
        ModelFacadeRif modelF = ClientController.getInstance().assertModelFacade();
        this._seEnabledModules = modelF.getCardsWithFeatureEnabled(swList, SE_FEATURE_NAME);
    }

    private FabricPK[] findAllFabricForEndPortList(List<EndPortBase> endPorts) {
        ArrayList<FabricPK> fabricList = new ArrayList<FabricPK>();
        for (EndPortBase port : endPorts) {
            FabricPK fb = port.getFabricPK();
            if (fabricList.contains(fb)) continue;
            fabricList.add(fb);
        }
        return fabricList.toArray(new FabricPK[fabricList.size()]);
    }

    private List<SwitchBase> findAllSwitchForEndPortList(List<EndPortBase> endPorts) {
        ArrayList<SwitchBase> swList = new ArrayList<SwitchBase>();
        FabricPK[] fabrics = this.findAllFabricForEndPortList(endPorts);
        Map vsans = this.getVsans(endPorts, fabrics[0]);
        for (Vsan v : vsans.values()) {
            Switch[] sws = v.getSwitches();
            for (int i = 0; i < sws.length; ++i) {
                SwitchBase s;
                if (sws[i] == null || swList.contains(s = sws[i].getSwitchBase())) continue;
                System.out.println("SWITCH = " + s.getWwn());
                swList.add(s);
            }
        }
        return swList;
    }

    public Map getVsans(List<EndPortBase> ports, FabricPK fabricPK) {
        HashMap<Integer, Vsan> ret = new HashMap<Integer, Vsan>();
        Fabric fabric = San.getInstance().getFabric(fabricPK);
        for (EndPortBase port : ports) {
            short[] vsans;
            if (port == null || !port.getFabricPK().equals(fabricPK) || (vsans = port.getVsanMembership()) == null) continue;
            for (int j = 0; j < vsans.length; ++j) {
                Integer vsanId = new Integer(vsans[j]);
                Vsan vsan = fabric.getVsansById(vsanId)[0];
                ret.put(vsanId, vsan);
            }
        }
        return ret;
    }

    List<Card> getSEEnabledModules() {
        return this._seEnabledModules;
    }

    public SEJob createJob() throws RemoteException {
        SEJob job = this.getRif().createJob(this.getJob());
        this.setJobCreated(job != null);
        this._job = job;
        return job;
    }

    public void deleteJob() throws RemoteException {
        this.getRif().deleteJob(this._job);
        this.setJobCreated(false);
        this._job = null;
    }

    public SEJob getJob() {
        if (this._job == null) {
            this._job = new SEJob();
            System.out.println(" NULL JOB. Creating new job...");
        }
        return this._job;
    }

    public List<SEAlgoInfo> getAlgoList() {
        if (this._algoList.size() == 0) {
            try {
                this._algoList = this.getRif().getAlgoList(this._job);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return this._algoList;
    }

    public List<SEJob> getJobList() throws RemoteException {
        ArrayList<SEJob> jobList = new ArrayList();
        jobList = this.getRif().getJobList();
        return jobList;
    }

    public List<SESession> getSessionList(SEJob job) throws RemoteException {
        ArrayList<SESession> sessions = new ArrayList();
        sessions = this.getRif().getSessionList(job);
        return sessions;
    }

    public String getJobLog(SEJob job) throws RemoteException {
        return this.getRif().getJobLog(job);
    }

    public List<SEAlgoInfo> getValidAlgoList() {
        ArrayList<SEAlgoInfo> list = new ArrayList<SEAlgoInfo>();
        for (SEAlgoInfo algo : this.getAlgoList()) {
            if (algo.getType() < 0) continue;
            list.add(algo);
        }
        return list;
    }

    public void dispose() {
        _instance = null;
        this._job = null;
    }
}

