/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.table.BorderCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.State12;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.Upgrade;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradeImpactRenderer;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradePanel;
import com.cisco.dcbu.sm.client.upgrade.u3_0_3.UpgradeWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableColumnModel;

public class FinalPanel
extends UpgradePanel
implements ActionListener {
    SnmpKTable _table;
    SnmpKTable _table2;
    JScrollPane _sp;
    JScrollPane _sp2;
    JLabel _statusTitle;
    JLabel _flagTitle;
    static final int POLL_INTERVAL = 3000;
    Timer _timer;
    int _totalTime;
    int _currentSwitch = 0;

    public FinalPanel(JFrame parent, UpgradeWizard wiz, Upgrade upgrade) {
        super("Download and Install Status", "The following tables show status of software download and install. Click on the status column for a switch to view job status details on the bottom table if available.\nNOTE: If bios/loader/bootrom upgrade is performed, please do not remove or power off the module in the middle of the process.", parent, wiz, upgrade);
        Box box = new Box(1);
        String[] cols = new String[]{"Select", "Switch", "Action", "Status"};
        boolean[] attrs = new boolean[]{false, false, false, false};
        this._flagTitle = new JLabel();
        box.add(this._flagTitle);
        this._table = this.buildTable(cols, attrs, new Array(), false);
        this.setAllowedAddRemoveColumn(this._table, false);
        this._table.addMouseListener(new TableMouseListener());
        this._table.setRowSelectionAllowed(true);
        this._table.setSortable(false);
        TableColumnModel cm = this._table.getColumnModel();
        cm.setColumnSelectionAllowed(true);
        TableButtonRenderer brndr = new TableButtonRenderer();
        brndr.setHorizontalAlignment(0);
        brndr.setToolTipText("Click to abort");
        cm.getColumn(0).setCellRenderer(brndr);
        cm.getColumn(0).setMaxWidth(60);
        cm.getColumn(3).setCellRenderer(new StatusRenderer());
        this._sp = new JScrollPane(this._table);
        this._sp.setPreferredSize(this._table.calcPreferredSize());
        box.add(this._sp);
        this._statusTitle = new JLabel();
        box.add(this._statusTitle);
        this._table2 = this.buildTable(State12.STATUS_COLS, null, new Array(), false);
        this.setAllowedAddRemoveColumn(this._table2, false);
        this._table2.setAutoResizeMode(0);
        this._sp2 = new JScrollPane(this._table2);
        TableColumnModel cm2 = this._table2.getColumnModel();
        cm2.getColumn(2).setCellRenderer(new InfoColRenderer());
        this._sp2.setPreferredSize(this._table2.calcPreferredSize());
        box.add(this._sp2);
        this.add(box);
    }

    void setStatus(String status) {
        this.getWizard().setStatus(status);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            StringBuffer setting = new StringBuffer();
            String actionString = "";
            if (this._upgrade.getCopyImageOnly()) {
                setting.append("Copy Image Only");
            } else {
                setting.append(this._upgrade.skipDownload() ? "Skip Remote Image File Copy" : "Copy Remote Image Files");
            }
            if (this._upgrade.getIgnoreVersion()) {
                if (setting.toString().length() > 0) {
                    setting.append("/ ");
                }
                setting.append("Install without version check Prompting");
            }
            if (this._upgrade.getIgnoreInstall()) {
                if (setting.toString().length() > 0) {
                    setting.append("/ ");
                }
                setting.append("Compatibility Check Only");
            } else {
                actionString = " Install";
            }
            if (setting.toString().length() > 0) {
                setting.append("/ ");
            }
            setting.append(this._upgrade.getParallelInstall() ? "Parallel" : "Serialized");
            setting.append(actionString);
            this._flagTitle.setText("Setting: " + setting.toString());
            Switch[] sws = this.getSwitches();
            Array data = FinalPanel.getData(this._table);
            data.clear();
            for (int i = 0; i < sws.length; ++i) {
                Switch sw = sws[i];
                Object[] row = new Object[]{"abort", sw.toString(), "", "", null, sw};
                data.addElement(row);
            }
            FinalPanel.getModel(this._table).fireTableDataChanged();
            this._sp.setPreferredSize(this._table.calcPreferredSize());
            data = FinalPanel.getData(this._table2);
            data.clear();
            FinalPanel.getModel(this._table2).fireTableDataChanged();
            this._sp2.setPreferredSize(this._table2.calcPreferredSize());
            JButton btn = this.getWizard().getNavigator().getNextBtn();
            btn.setEnabled(false);
            btn.setVisible(false);
            btn = this.getWizard().getNavigator().getBackBtn();
            btn.setEnabled(false);
            btn.setVisible(false);
            this._table.setSortable(false);
            this._table2.setSortable(false);
            this._timer = new Timer(3000, this);
            this._timer.setInitialDelay(0);
            this._timer.start();
            this._totalTime = 0;
        }
        super.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._upgrade._upgradeLogger.debug((Object)("FinalPanel actionPerform  event " + e));
        if (e.getSource() == this._timer) {
            try {
                this._upgrade._upgradeLogger.debug((Object)"FinalPanel  actionPerform timer event...");
                this._upgrade.tick();
                this.setStatus(this._totalTime / 60000 + " mins, " + this._totalTime % 60000 / 1000 + " secs elapsed (" + DateFormat.getInstance().format(new Date()) + ")");
                this._totalTime += 3000;
                this.updateTable();
                if (this._upgrade.isFinished()) {
                    if (this._upgrade.getIgnoreInstall()) {
                        boolean isFinished = this.showAllVersionCheckInfo();
                        this.updateTable();
                        if (isFinished) {
                            this._upgrade._upgradeLogger.debug((Object)"Upgrade, finshed...");
                            this.setStatus("Install Finished " + this._totalTime / 60000 + " mins, " + this._totalTime % 60000 / 1000 + " secs (" + DateFormat.getInstance().format(new Date()) + ")");
                            this.updateTable();
                            this.cleanup();
                        } else {
                            this._upgrade._upgradeLogger.debug((Object)"Upgrade, finished Version Check, Continue to Install...");
                            this.setIgnoreInstall(false);
                            this.setIgnoreVersion(true);
                            StringBuffer setting = new StringBuffer(this._flagTitle.getText());
                            setting.append("  ->  ");
                            setting.append("Install without version check Prompting");
                            this._flagTitle.setText(setting.toString());
                            Array data = FinalPanel.getData(this._table);
                            for (int i = 0; i < data.size(); ++i) {
                                if (!this._upgrade.isDoneVersionCheck(i)) continue;
                                Object[] row = (Object[])data.elementAt(i);
                                row[0] = "abort";
                                row[2] = "";
                                row[3] = "";
                            }
                            FinalPanel.getModel(this._table).fireTableDataChanged();
                            this._sp.setPreferredSize(this._table.calcPreferredSize());
                            data = FinalPanel.getData(this._table2);
                            data.clear();
                            FinalPanel.getModel(this._table2).fireTableDataChanged();
                            this._sp2.setPreferredSize(this._table2.calcPreferredSize());
                            this._upgrade.resume();
                        }
                    } else {
                        this._upgrade._upgradeLogger.debug((Object)"Upgrade, finshed...");
                        this.setStatus("Install Finished " + this._totalTime / 60000 + " mins, " + this._totalTime % 60000 / 1000 + " secs (" + DateFormat.getInstance().format(new Date()) + ")");
                        this.updateTable();
                        this.cleanup();
                    }
                }
            }
            catch (Exception ex) {
                this._upgrade._upgradeLogger.debug((Object)("FinalPanel actionPerform  ex " + ex + ". Do Cancel..."), (Throwable)ex);
                this.doCancel();
            }
        }
    }

    void updateTable() {
        this._upgrade._upgradeLogger.debug((Object)"FinalPanel  updateTable()....");
        Array data = FinalPanel.getData(this._table);
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            String msg = (String)row[0];
            if (!this._upgrade.isUp(i) && !msg.equals("aborted")) {
                row[0] = "done";
            }
            if (this._upgrade.isAbort(i)) {
                row[0] = "aborted";
            }
            row[2] = this._upgrade.getAction(i);
            row[3] = this._upgrade.getStatus(i);
            if (this._upgrade.getParallelInstall()) continue;
            this.updateStatus(i);
        }
        if (this._upgrade.getParallelInstall()) {
            this.updateStatus(this._currentSwitch);
        }
        FinalPanel.getModel(this._table).fireTableDataChanged();
        this._sp.setPreferredSize(this._table.calcPreferredSize());
    }

    void updateStatus(int index) {
        Array data = FinalPanel.getData(this._table2);
        data = this._upgrade.getMoreStatus(index);
        if (data != null && data.size() >= 0) {
            this._statusTitle.setText((String)FinalPanel.getModel(this._table).getValueAt(index, this._table.convertColumnIndexToView(1)) + " Job Status Details - " + DateFormat.getInstance().format(new Date()));
            FinalPanel.getModel(this._table2).setData(data);
            FinalPanel.getModel(this._table2).fireTableDataChanged();
            this._sp2.setPreferredSize(this._table2.calcPreferredSize());
        }
        if (this._upgrade.isFinished()) {
            this._statusTitle.setText("");
            FinalPanel.getModel(this._table2).setData(new Array());
            FinalPanel.getModel(this._table2).fireTableDataChanged();
            this._sp2.setPreferredSize(this._table2.calcPreferredSize());
        }
    }

    @Override
    public void doCancel() {
        this._upgrade._upgradeLogger.debug((Object)"FinalPanel  doCancel...");
        if (this._upgrade.doCancel()) {
            this.cleanup();
            super.doCancel();
        }
    }

    @Override
    public void doPrevious() {
        this.cleanup();
        this.setStatus("");
        JButton btn = this.getWizard().getNavigator().getNextBtn();
        btn.setEnabled(true);
        btn.setVisible(true);
        this.showAttrPanel();
    }

    void cleanup() {
        this._upgrade._upgradeLogger.debug((Object)"FinalPanel  clenup()");
        if (this._timer != null) {
            this._upgrade._upgradeLogger.debug((Object)"FinalPanel  clenup()  stop timer...");
            this._timer.stop();
        }
        this._upgrade.dispose();
        JButton btn = this.getWizard().getNavigator().getCancel();
        btn.setText("Close");
        btn.setEnabled(true);
        btn.setVisible(true);
    }

    boolean showAllVersionCheckInfo() {
        if (!this._upgrade.isDoneVersionCheck()) {
            return true;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(8, 8, 8, 8));
        panel.setLayout(new BorderLayout());
        JPanel north = new JPanel(new BorderLayout());
        JTextArea explain = new JTextArea();
        try {
            explain.getDocument().remove(0, explain.getDocument().getLength() - 1);
            explain.setText("Press 'Ok' to dismiss Version Check Results and ready to close wizard.\nPress 'Continue to Install' to install.\nNOTE: If choose to continue to Install, Version Check will be re-run again without prompting.\n");
        }
        catch (Exception ex) {
            System.out.println("Incorrect location");
            this._upgrade._upgradeLogger.debug((Object)"showAllVersionCheckInfo, failed to remove document from TextArea");
        }
        explain.setWrapStyleWord(true);
        explain.setEditable(false);
        explain.setLineWrap(true);
        explain.setOpaque(false);
        explain.setFont((Font)UIManager.getDefaults().get("Table.font"));
        north.add((Component)explain, "Center");
        SnmpTableModel model = new SnmpTableModel();
        model.setData(this._upgrade._vercheckAllData);
        model.setHeaders(State12.VER_COLS);
        SnmpKTable table = this.buildTable(State12.VER_COLS, null, this._upgrade._vercheckAllData);
        table.getColumnModel().getColumn(3).setCellRenderer(new UpgradeImpactRenderer());
        JScrollPane sp = new JScrollPane(table);
        Dimension prefSize = table.calcPreferredSize();
        prefSize.height = 250;
        sp.setPreferredSize(new Dimension(prefSize.width, prefSize.height));
        JPanel topPanel = new JPanel(new BorderLayout());
        String time = DateFormat.getInstance().format(new Date());
        Font normalFont = (Font)UIManager.getDefaults().get("Table.font");
        Font boldFont = new Font(normalFont.getName(), 1, normalFont.getSize());
        JLabel label2 = new JLabel(time);
        topPanel.add("Center", label2);
        topPanel.add("South", sp);
        north.add("South", topPanel);
        panel.add("North", north);
        this._upgrade.buildIncompatInfoAllData();
        if (this._upgrade._incompatAllData.size() != 0) {
            JPanel iPanel = new JPanel(new BorderLayout());
            iPanel.add("North", new DialogSeparator("Incompatibilities"));
            table = this.buildTable(State12.CHECK_COLS, null, this._upgrade._incompatAllData);
            table.setAutoResizeMode(0);
            sp = new JScrollPane(table);
            prefSize = table.calcPreferredSize();
            prefSize.height = 120;
            table.colWidthToWidest();
            sp.setPreferredSize(new Dimension(prefSize.width, prefSize.height));
            iPanel.add("Center", sp);
            panel.add("Center", iPanel);
        }
        this._upgrade.buildMiscInfoAllData();
        if (this._upgrade._miscInfoAllData.size() != 0) {
            JPanel mPanel = new JPanel(new BorderLayout());
            mPanel.add("North", new DialogSeparator("Additional Information"));
            table = this.buildTable(State12.MISC_COLS, null, this._upgrade._miscInfoAllData);
            table.setAutoResizeMode(0);
            sp = new JScrollPane(table);
            prefSize = table.calcPreferredSize();
            prefSize.height = 120;
            table.colWidthToWidest();
            sp.setPreferredSize(new Dimension(prefSize.width, prefSize.height));
            mPanel.add("Center", sp);
            panel.add("South", mPanel);
        }
        String title = "Version Check Results";
        Object[] options = new String[]{"Ok", "Continue to Install"};
        JOptionPane pane = new JOptionPane(panel, 1, 0, null, options);
        JDialog dlg = pane.createDialog(this._upgrade._parent, title);
        dlg.setModal(true);
        dlg.setResizable(true);
        dlg.pack();
        dlg.toFront();
        dlg.setVisible(true);
        Object value = pane.getValue();
        this._upgrade._upgradeLogger.debug((Object)"showAllVersionCheckInfo, continue to Install, get user input");
        boolean isFinished = true;
        if (value != null && value instanceof String) {
            isFinished = ((String)value).charAt(0) == 'O';
            this._upgrade._upgradeLogger.debug((Object)("showAllVersionCheckInfo, continue to Install ?  User input: " + value));
        }
        return isFinished;
    }

    class InfoColRenderer
    extends BorderCellRenderer {
        InfoColRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                String info = value.toString().toLowerCase().trim();
                if (info.indexOf(FinalPanel.this._upgrade.NOLONGER_ABORT) != -1) {
                    this.setBackground(Color.yellow);
                } else {
                    this.setBackground(table.getBackground());
                }
            } else {
                this.setBackground(table.getBackground());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class StatusRenderer
    extends BorderCellRenderer {
        StatusRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                String status = value.toString().toLowerCase();
                int spc = status.indexOf(32);
                String first = status.trim();
                if (spc != -1) {
                    first = first.substring(0, spc);
                }
                if (first.endsWith("inprogress")) {
                    this.setBackground(Color.yellow);
                } else if (first.endsWith("success")) {
                    Switch sw = (Switch)UpgradePanel.getModel((SnmpKTable)table).getValueAt(row, 5);
                    if (FinalPanel.this._upgrade.isUp(sw)) {
                        this.setBackground(Color.yellow);
                    } else {
                        this.setBackground(new Color(128, 255, 128));
                    }
                } else if (first.endsWith("failure")) {
                    this.setBackground(Color.pink);
                } else {
                    this.setBackground(table.getBackground());
                }
            } else {
                this.setBackground(table.getBackground());
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class TableButtonRenderer
    extends BorderCellRenderer {
        Color _oldColor;

        TableButtonRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value != null) {
                String msg = (String)value;
                if (this._oldColor == null) {
                    this._oldColor = this.getForeground();
                }
                if (!msg.equals("abort")) {
                    this.setForeground(Color.GRAY);
                } else {
                    this.setForeground(this._oldColor);
                }
                this.setBorder(BorderFactory.createBevelBorder(0));
                super.setValue(value);
            } else {
                this.setText("");
            }
        }
    }

    class TableMouseListener
    extends MouseInputAdapter {
        TableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            SnmpKTable t = (SnmpKTable)e.getSource();
            int row = t.rowAtPoint(p);
            int col = t.columnAtPoint(p);
            if (col == 0) {
                String act = (String)UpgradePanel.getModel(FinalPanel.this._table).getValueAt(row, FinalPanel.this._table.convertColumnIndexToView(0));
                if (act.equals("abort")) {
                    FinalPanel.this._upgrade._upgradeLogger.debug((Object)"User action abort button clicked");
                    if (!FinalPanel.this._upgrade.isAbortable(row)) {
                        FinalPanel.this._upgrade._upgradeLogger.debug((Object)"User action abort button clicked failed due to not abortable");
                        JOptionPane.showMessageDialog(FinalPanel.this._upgrade._parent, "Upgrade can no longer be aborted", "Upgrade Abort", 0);
                        return;
                    }
                    UpgradePanel.getModel(FinalPanel.this._table).setValueAt("aborted", row, 0);
                    if (FinalPanel.this._upgrade.isUp(row)) {
                        FinalPanel.this._upgrade._upgradeLogger.debug((Object)("User abort, row " + row + " up, upgrade.abort()..."));
                        FinalPanel.this._upgrade.abort(row);
                    }
                    UpgradePanel.getModel(FinalPanel.this._table).fireTableDataChanged();
                    FinalPanel.this._table.setSortable(false);
                }
            } else {
                FinalPanel.this._currentSwitch = row;
                Array more = FinalPanel.this._upgrade.getMoreStatus(row);
                if (more == null) {
                    FinalPanel.this._statusTitle.setText((String)UpgradePanel.getModel(FinalPanel.this._table).getValueAt(row, FinalPanel.this._table.convertColumnIndexToView(1)) + " No Job Status Details - " + DateFormat.getInstance().format(new Date()));
                    more = UpgradePanel.getData(FinalPanel.this._table2);
                    more.clear();
                } else {
                    FinalPanel.this._statusTitle.setText((String)UpgradePanel.getModel(FinalPanel.this._table).getValueAt(row, FinalPanel.this._table.convertColumnIndexToView(1)) + " Job Status Details - " + DateFormat.getInstance().format(new Date()));
                }
                UpgradePanel.getModel(FinalPanel.this._table2).setData(more);
                UpgradePanel.getModel(FinalPanel.this._table2).fireTableDataChanged();
                FinalPanel.this._sp2.setPreferredSize(FinalPanel.this._table2.calcPreferredSize());
                FinalPanel.this._table.setSortable(false);
            }
        }
    }
}

