/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.upgrade.u3_0_3;

import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.sm.client.model.Switch;
import java.net.InetAddress;

class ImageSpec {
    String _model;
    Switch _sw;
    InetAddress _addr;
    int _protocol;
    String _username;
    String _password;
    boolean _local;
    boolean _bootSpec;
    int _requiredSpace;
    String[] _vars;
    String[] _vals;

    final String getModel() {
        return this._model;
    }

    final Switch getSwitch() {
        return this._sw;
    }

    final InetAddress getServer() {
        return this._addr;
    }

    final int getProtocol() {
        return this._protocol;
    }

    final String getUsername() {
        return this._username;
    }

    final String getPassword() {
        return this._password;
    }

    final boolean isLocal() {
        return this._local;
    }

    final int getRequiredSpace() {
        return this._requiredSpace;
    }

    final String[] getVars() {
        return this._vars;
    }

    final String[] getVals() {
        return this._vals;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this._vars.length; ++i) {
            if (this._vals[i] == null || this._vals[i].length() == 0) continue;
            buff.append(this._vars[i]);
            buff.append(" ");
        }
        return buff.toString();
    }

    ImageSpec(String model, InetAddress addr, int protocol, String username, String password, boolean local, String[] vars, String[] vals, int requiredSpace) {
        this._model = model;
        this._addr = addr;
        this._protocol = protocol;
        this._username = username;
        this._password = password;
        this._local = local;
        this._vars = vars;
        this._vals = vals;
        this._requiredSpace = requiredSpace;
    }

    ImageSpec(Switch sw, String[] vars, String[] vals) {
        this._sw = sw;
        this._vars = vars;
        this._vals = vals;
        this._bootSpec = true;
    }

    String getFlashUri(Switch sw, int index, boolean isSkipDownload) {
        SwitchVersion asmVer = new SwitchVersion("2.1(0)");
        SwitchVersion swVer = new SwitchVersion(sw.getVersion());
        if (this._bootSpec) {
            return this._vals[index];
        }
        if (this._vars[index].equals("ssi") && !swVer.lessThanEqual(asmVer)) {
            StringBuffer uriSb = new StringBuffer();
            switch (this._protocol) {
                case -1: 
                case 1: {
                    uriSb.append("tftp://");
                    break;
                }
                case 4: {
                    uriSb.append("ftp://");
                    break;
                }
                case 5: {
                    uriSb.append("scp://");
                    break;
                }
                case 6: {
                    uriSb.append("sftp://");
                }
            }
            if (this._protocol != 1 && this._protocol != -1) {
                uriSb.append(this._username);
                uriSb.append(":");
                uriSb.append(this._password);
                uriSb.append("@");
            }
            uriSb.append(this._addr.getHostAddress());
            uriSb.append("/");
            if (this._protocol == -1) {
                uriSb.append(ImageSpec.baseName(this._vals[index]));
            } else {
                uriSb.append(this._vals[index]);
            }
            return uriSb.toString();
        }
        String baseVal = ImageSpec.baseName(this._vals[index]);
        if (baseVal != null) {
            baseVal = "bootflash:/" + baseVal;
        }
        return baseVal;
    }

    static String baseName(String uri) {
        int index;
        if (uri == null || uri.length() == 0) {
            return null;
        }
        int sep = 47;
        if (uri.lastIndexOf(sep) == -1) {
            sep = 92;
        }
        if ((index = uri.lastIndexOf(sep)) != -1) {
            uri = uri.substring(index + 1);
        }
        return uri;
    }
}

