/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.wizardTask;

import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import java.util.ArrayList;
import java.util.List;

public class ObjectActionTracker {
    public static final Status SUCCESS = Status.SUCCESS;
    public static final Status FAILED = Status.FAILED;
    public static final Status STARTED = Status.STARTED;
    public static final Status INPROGRESS = Status.INPROGRESS;
    public static final Status WARNING = Status.WARNING;
    public static final Status ERROR = Status.ERROR;
    public static final Status NA = Status.NA;
    public static final Status BLANK = Status.BLANK;
    public static final Status UNKNOW = Status.UNKNOWN;
    private SnmpUserOpt swUser;
    private Object target;
    private Status status = BLANK;
    private String message = "";
    private String result = null;
    private String content = "";
    private Integer actionTypeId;
    private List<Exception> errors = new ArrayList<Exception>();
    private List history = new ArrayList();
    private boolean success = false;

    public ObjectActionTracker(Object objTarget, String content, Integer type) {
        if (objTarget == null || content == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        this.target = objTarget;
        this.content = content;
        this.actionTypeId = type;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getContent() {
        return this.content;
    }

    public Integer getType() {
        return this.actionTypeId;
    }

    public void addError(Exception error) {
        this.errors.add(error);
    }

    public List<Exception> getErrors() {
        return this.errors;
    }

    public Exception getLastError() {
        if (this.hasError()) {
            return this.errors.get(this.errors.size() - 1);
        }
        return null;
    }

    public boolean hasError() {
        return this.errors.size() > 0;
    }

    public List getHistory() {
        return this.history;
    }

    public String getLongMessage() {
        return this.status.getName() + ": " + this.getMessage();
    }

    public String getMessage() {
        return this.message;
    }

    public String getShortMessage() {
        return this.status.getName();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status, String message, Exception error) {
        this.status = status;
        this.message = message == null ? "" : message;
        if (error != null) {
            this.addError(error);
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void clear() {
        this.status = Status.NA;
        this.message = "";
        this.result = null;
        this.content = "";
        if (this.errors != null) {
            this.errors.clear();
        }
        if (this.history != null) {
            this.history.clear();
        }
        this.success = false;
    }

    public SnmpUserOpt getSwitchUser() {
        return this.swUser;
    }

    public void setSwitchUser(SnmpUserOpt swUser) {
        this.swUser = swUser;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AbstractActionTracker[");
        sb.append("target=");
        sb.append(this.target);
        sb.append(", content=");
        sb.append(this.content);
        sb.append(", type=");
        sb.append(this.actionTypeId);
        sb.append(", status=");
        sb.append(this.getLongMessage());
        sb.append("]");
        return sb.toString();
    }

    protected void addHistory(Status status, String message, Exception error) {
        Object[] entry = new Object[]{status, message, error};
        this.history.add(entry);
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    public static enum Status {
        SUCCESS("Success"),
        FAILED("Failed"),
        STARTED("Started"),
        INPROGRESS("In progress"),
        BLANK(""),
        WARNING("Warning"),
        ERROR("Error"),
        NA("N/A"),
        UNKNOWN("Unknown");

        private String statusName;

        private Status(String name) {
            this.statusName = name;
        }

        public String getName() {
            return this.statusName;
        }

        public Status getStatus(int value) {
            if (value >= 0 && value < Status.values().length) {
                return Status.values()[value];
            }
            return NA;
        }
    }
}

