/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.zm.AbstractMdsAction;
import com.cisco.dcbu.lib.mds.zm.PollerCallbackIf;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.common.afidVsanSwitches;
import java.util.ArrayList;
import java.util.HashMap;

public class CopyTopologyAction
extends AbstractMdsAction {
    private StatusIf _statusIf;
    private Object _sourcePeer;
    protected Object _destinationPeer;
    private SnmpPeer _srcPeer;
    private SnmpPeer _dstPeer;
    private VarBindList _topology;
    private boolean _enableIvr;
    private boolean _activate;
    public static final int DEFAULT_TOPO = 0;
    public static final int FABRICID_TOPO = 1;
    public static final int ACTIVE_TOPO = 2;

    private CopyTopologyAction(PollerCallbackIf callback, StatusIf statusIf, Object destinationPeer) {
        super(callback);
        this._statusIf = statusIf;
        this._destinationPeer = destinationPeer;
    }

    public CopyTopologyAction(PollerCallbackIf callback, StatusIf statusIf, Object destinationPeer, Object sourcePeer) {
        this(callback, statusIf, destinationPeer);
        this._sourcePeer = sourcePeer;
    }

    public CopyTopologyAction(PollerCallbackIf callback, StatusIf statusIf, Object destinationPeer, VarBindList topology) {
        this(callback, statusIf, destinationPeer);
        this._topology = topology;
    }

    public void enableTopologyActivation() {
        this._activate = true;
    }

    @Override
    public void startAction() throws SnmpException {
        StringBuffer version = new StringBuffer();
        this._dstPeer = SmZoneUtil.getSwitchPeer(this._destinationPeer, version);
        if (this._topology == null && this._sourcePeer != null) {
            this._srcPeer = SmZoneUtil.getSwitchPeer(this._sourcePeer, null);
        }
        if (this._srcPeer != null && this._srcPeer.getAddress().equals(this._dstPeer.getAddress()) && this._topology == null) {
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get("civrTopologyCopyActiveToConfig").getOid(), 0), new SnmpInt(1));
            SnmpFetch.set(this._srcPeer, pdu);
        } else {
            this.populateTopology();
        }
    }

    protected void populateTopology() throws SnmpException {
        SnmpPDU pdu;
        if (this._topology == null) {
            this._topology = CopyTopologyAction.buildFullTopology(this._srcPeer);
            if (this._topology == null || this._topology.size() == 0) {
                throw new SnmpException("Full topology is not present at " + this._srcPeer);
            }
        }
        if (this._enableIvr) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get("ivrEnabled").getOid(), 0), new SnmpInt(1));
            SnmpFetch.set(this._dstPeer, pdu);
        }
        pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get("civrTopologyClearConfigured").getOid(), 0), new SnmpInt(1));
        SnmpFetch.set(this._dstPeer, pdu);
        SnmpFetch.set(this._dstPeer, new SnmpPDU(-93, this._topology));
        if (this._activate) {
            pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get("civrTopologyActivate").getOid(), 0), new SnmpInt(1));
            SnmpFetch.set(this._dstPeer, pdu);
        }
    }

    public static VarBindList buildActiveTopology(SnmpPeer peer) throws SnmpException {
        return CopyTopologyAction.buildTopology(peer, new String[]{"", "civrTopologyActiveSwitchVsan2k", "civrTopologyActiveSwitchVsan4k"}, new String[]{"civrTopologyConfigRowStatus", "civrTopologyConfigSwitchVsan2k", "civrTopologyConfigSwitchVsan4k"});
    }

    public static VarBindList buildFabricIdTopology(SnmpPeer peer) throws SnmpException {
        String[] ob = new String[]{"civrTopologyAfidConfRowStatus", "civrTopologyAfidConfSwitchVsan2k", "civrTopologyAfidConfSwitchVsan4k"};
        return CopyTopologyAction.buildTopology(peer, ob, ob);
    }

    protected static VarBindList buildTopology(SnmpPeer peer, String[] srcObjects, String[] dstObjects) throws SnmpException {
        VarBindList vbL = new VarBindList();
        vbL.add(MibNode.get(srcObjects[1]).getOid());
        vbL.add(MibNode.get(srcObjects[2]).getOid());
        vbL = SnmpFetch.getBulk(peer, vbL).getVariables();
        VarBindList vbLConfig = new VarBindList();
        for (int i = 0; i < vbL.size(); i += 2) {
            int[] oid = vbL.getVb(i).getOid().getValue();
            int[] index = new int[9];
            System.arraycopy(oid, oid.length - 9, index, 0, 9);
            vbLConfig.add(MibNode.get(dstObjects[0]).getOid(), index, (SnmpVar)new SnmpInt(4));
            vbLConfig.add(MibNode.get(dstObjects[1]).getOid(), index, vbL.getVb(i).getVar());
            vbLConfig.add(MibNode.get(dstObjects[2]).getOid(), index, vbL.getVb(i + 1).getVar());
        }
        return vbLConfig;
    }

    private static VarBindList buildFullTopology(SnmpPeer peer) throws SnmpException {
        VarBindList vbL = new VarBindList();
        vbL.add(MibNode.get("civrTopologyConfigSwitchVsan2k").getOid());
        vbL.add(MibNode.get("civrTopologyConfigSwitchVsan4k").getOid());
        vbL = SnmpFetch.getBulk(peer, vbL).getVariables();
        VarBindList vbLConfig = new VarBindList();
        CopyTopologyAction.buildTopologyVbl(vbLConfig, vbL);
        return vbLConfig;
    }

    private static void buildTopologyVbl(VarBindList vbLConfig, VarBindList refVbl) {
        for (int i = 0; i < refVbl.size(); i += 2) {
            int[] oid = refVbl.getVb(i).getOid().getValue();
            int[] index = new int[9];
            System.arraycopy(oid, oid.length - 9, index, 0, 9);
            vbLConfig.add(MibNode.get("civrTopologyConfigRowStatus").getOid(), index, (SnmpVar)new SnmpInt(4));
            vbLConfig.add(MibNode.get("civrTopologyConfigSwitchVsan2k").getOid(), index, refVbl.getVb(i).getVar());
            vbLConfig.add(MibNode.get("civrTopologyConfigSwitchVsan4k").getOid(), index, refVbl.getVb(i + 1).getVar());
        }
    }

    @Override
    public VarBindList getPollVarBind() {
        return null;
    }

    @Override
    public VarBindList getActionVarBind() throws SnmpException {
        return null;
    }

    @Override
    public VarBindList getCleanUpVarBind() {
        return null;
    }

    @Override
    public boolean isPollableAction() {
        return false;
    }

    @Override
    public String toString() {
        return "Copy Topology to " + this._destinationPeer;
    }

    private void showStatus(String str) {
        CopyTopologyAction.writeOut(this._out, str);
        this._statusIf.setStatus(str);
    }

    @Override
    public void failed(PollerManager manager, SnmpException ex) {
        this.showStatus(this._dstPeer + ":Topology copy failed");
        super.failed(manager, ex);
    }

    @Override
    public void success(PollerManager manager, StringBuffer status) {
        this.showStatus(this._dstPeer + ":Topology copy successful");
        super.success(manager, status);
    }

    public static ArrayList buildVsanList(VarBindList vbl, Fabric f) {
        ArrayList<Vsan> vsans = new ArrayList<Vsan>();
        for (int i = 0; i < vbl.size(); i += 3) {
            byte[] vsan2K = vbl.byteValue(i + 1);
            for (int v = 1; v < vsan2K.length * 8; ++v) {
                Vsan[] vs;
                if (!SnmpBitmap.getBitBase0(vsan2K, v) || (vs = f.getVsansById(v + 2048)) == null) continue;
                for (int k = 0; k < vs.length; ++k) {
                    if (vsans.contains(vs[k])) continue;
                    vsans.add(vs[k]);
                }
            }
            byte[] vsan4K = vbl.byteValue(i + 2);
            for (int v = 0; v < vsan4K.length * 8; ++v) {
                Vsan[] vs;
                if (!SnmpBitmap.getBitBase0(vsan4K, v) || (vs = f.getVsansById(v + 2048)) == null) continue;
                for (int k = 0; k < vs.length; ++k) {
                    if (vsans.contains(vs[k])) continue;
                    vsans.add(vs[k]);
                }
            }
        }
        return vsans;
    }

    public static void buildVsanToAfidSwitchMap(VarBindList topology, HashMap map, int whichTopo) {
        if (topology.size() == 0) {
            return;
        }
        for (int i = 0; i < topology.size(); i += whichTopo == 0 ? 1 : 3) {
            int afId;
            int[] oid = topology.getVb(i).getOid().getValue();
            int n = whichTopo == 0 ? topology.intValue(i) : (afId = whichTopo == 1 ? oid[oid.length - 1] : oid[oid.length - 9]);
            int switchByteOffset = whichTopo == 0 ? 8 : (whichTopo == 1 ? 9 : 8);
            byte[] swWwn = new byte[8];
            for (int k = 0; k < 8; ++k) {
                swWwn[k] = (byte)oid[oid.length - switchByteOffset + k];
            }
            ClientController.getInstance();
            Switch sw = ClientController.findFabricSwitchByWwn(new Wwn(swWwn));
            if (sw == null) continue;
            ArrayList<Vsan> vsanList = new ArrayList<Vsan>();
            if (whichTopo != 0) {
                Vsan vv;
                int pos;
                byte[] vsan2K = topology.byteValue(i + 1);
                byte[] vsan4K = topology.byteValue(i + 2);
                for (pos = 1; pos < vsan2K.length * 8; ++pos) {
                    if (!SnmpString.getBitBase0(vsan2K, pos)) continue;
                    vv = sw.getVsan((short)pos);
                    if (vv == null) {
                        vv = sw.getFabric().findVsanById(pos);
                    }
                    if (vv == null) continue;
                    vsanList.add(vv);
                }
                for (pos = 0; pos < vsan4K.length * 8; ++pos) {
                    if (!SnmpString.getBitBase0(vsan4K, pos)) continue;
                    vv = sw.getVsan((short)(pos + 2048));
                    if (vv == null) {
                        vv = sw.getFabric().findVsanById(pos + 2048);
                    }
                    if (vv == null) continue;
                    vsanList.add(vv);
                }
            } else {
                Vsan[] swVsans = sw.getVsans();
                for (int vs = 0; vs < swVsans.length; ++vs) {
                    vsanList.add(swVsans[vs]);
                }
            }
            for (int k = 0; k < vsanList.size(); ++k) {
                Vsan vv = (Vsan)vsanList.get(k);
                ArrayList<afidVsanSwitches> ob = (ArrayList<afidVsanSwitches>)map.get(vv);
                if (ob == null) {
                    ob = new ArrayList<afidVsanSwitches>();
                    map.put(vv, ob);
                }
                ArrayList switchList = null;
                afidVsanSwitches obMatch = null;
                for (int lst = 0; lst < ob.size(); ++lst) {
                    afidVsanSwitches obData = (afidVsanSwitches)ob.get(lst);
                    if ((obData == null || obData._afId != afId) && (whichTopo != 0 || !obData._switchList.contains(sw))) continue;
                    switchList = obData._switchList;
                    obMatch = obData;
                    break;
                }
                if (obMatch == null) {
                    switchList = new ArrayList();
                    obMatch = new afidVsanSwitches(afId, vv, switchList);
                    ob.add(obMatch);
                }
                if (switchList.contains(sw)) continue;
                switchList.add(sw);
            }
        }
    }
}

