/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.common;

import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.table.MultiRowTable;
import com.cisco.dcbu.lib.ui.tree.Tree;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.map.actions.HighlightAction;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.EndPortSelector;
import com.cisco.dcbu.sm.common.rif.WebAnalysisRif;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TracePortPath
extends JDialog
implements ActionListener,
TreeSelectionListener {
    static final int POLL_INTERVAL = 5000;
    private JComboBox vsanCb;
    private FieldPanel port1Fp;
    private FieldPanel port2Fp;
    private Vsan v1;
    private Vsan v2;
    private JLabel port1Vsan;
    private JLabel port2Vsan;
    private MultiRowTable pathTable;
    private KTableModel pathModel;
    private Tree pathsTree;
    private DefaultMutableTreeNode root;
    private JLabel statusLbl;
    private Timer statusTimer;
    private int reportId = -1;
    private HashMap pathTraceMap = new HashMap();
    private JButton[] dialogBtns;
    private EndPort[] fPorts;
    public static Logger _Logger = Logger.getLogger((String)"com.cisco.dcbu.sm.client.zm");

    public TracePortPath(JFrame parent, Fabric f, Vsan v, EndPort[] ports) {
        super(parent);
        this.fPorts = ports;
        this.buildUI(parent, f, v, ports);
    }

    private void buildUI(JFrame parent, Fabric f, Vsan v, EndPort[] ports) {
        this.setDefaultCloseOperation(2);
        this.setTitle("Trace Path - " + f.getPath('/'));
        JTextArea notes = new JTextArea();
        notes.setWrapStyleWord(true);
        notes.setEditable(false);
        notes.setLineWrap(true);
        notes.setOpaque(false);
        notes.setFont((Font)UIManager.getDefaults().get("Table.font"));
        notes.append("Please select End devices.  Press Trace Path button to find a data path between these devices.");
        JPanel mainPnl = new JPanel(new BorderLayout());
        mainPnl.add((Component)notes, "North");
        Object[] vsan = f.getVsans();
        ArrayList<Object> arVsan = new ArrayList<Object>();
        if (vsan != null) {
            Arrays.sort(vsan);
            for (int i = 0; i < vsan.length; ++i) {
                arVsan.add(vsan[i]);
            }
        }
        arVsan.add(0, "All Vsans");
        this.vsanCb = new JComboBox<Object>(arVsan.toArray());
        if (v != null) {
            this.vsanCb.setSelectedItem(v);
        }
        JButton prtEllipsis1 = this.buildPortEllipsis("1port");
        JPanel btnPnl1 = new JPanel(new FlowLayout());
        btnPnl1.add(prtEllipsis1);
        this.port1Vsan = new JLabel();
        btnPnl1.add(this.port1Vsan);
        JButton prtEllipsis2 = this.buildPortEllipsis("2port");
        JPanel btnPnl2 = new JPanel(new FlowLayout());
        btnPnl2.add(prtEllipsis2);
        this.port2Vsan = new JLabel();
        btnPnl2.add(this.port2Vsan);
        this.port1Fp = new FieldPanel(21, (JComponent)btnPnl1);
        this.port2Fp = new FieldPanel(21, (JComponent)btnPnl2);
        if (ports != null) {
            if (ports.length >= 1) {
                this.port1Fp.setText(SnmpString.toHexString(ports[0].getPortWwn().getValue()));
            }
            if (ports.length >= 2) {
                this.port2Fp.setText(SnmpString.toHexString(ports[1].getPortWwn().getValue()));
            }
        }
        String[] labels = new String[]{"Show Devices From:", "Source Device WWN:", "Destination Device WWN:"};
        this.pathModel = new KTableModel();
        this.pathModel.setHeaders(new String[]{"Source", "Destination", "via ISLs", "Cost", "VSAN Change"});
        this.pathModel.setData(new Array());
        this.pathTable = new MultiRowTable(this.pathModel);
        JScrollPane pane = new JScrollPane(this.pathTable);
        JScrollPane treePane = new JScrollPane();
        this.root = new DefaultMutableTreeNode("Route(Cost)");
        this.pathsTree = new Tree(this.root);
        this.pathsTree.setCellRenderer(new PathTreeRenderer());
        this.pathsTree.setEditable(false);
        this.pathsTree.setShowsRootHandles(true);
        this.pathsTree.addTreeSelectionListener(this);
        treePane.setViewportView(this.pathsTree);
        JSplitPane splitPane = new JSplitPane(1, treePane, pane);
        splitPane.setDividerSize(8);
        splitPane.setDividerLocation(100);
        JPanel centerPnl = new JPanel(new BorderLayout());
        centerPnl.add((Component)DialogUtil.buildPanel(DialogUtil.buildLabels(labels), new JComponent[]{this.vsanCb, this.port1Fp, this.port2Fp}), "North");
        centerPnl.add((Component)splitPane, "Center");
        mainPnl.add((Component)centerPnl, "Center");
        this.statusLbl = new JLabel(" ");
        this.statusLbl.setFont((Font)UIManager.getDefaults().get("Table.font"));
        this.statusLbl.setBorder(null);
        this.dialogBtns = DialogUtil.buildButtons(new String[]{"Trace Path", "Close"}, (ActionListener)this);
        this.dialogBtns[0].setVisible(true);
        JPanel lowerPnl = DialogUtil.buildStatusPanel(this.dialogBtns, this.statusLbl);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)mainPnl, lowerPnl);
        this.setSize(this.getPreferredSize().width + 100, this.getPreferredSize().height + 10);
        this.setResizable(true);
        this.setModal(false);
    }

    private JButton buildPortEllipsis(String actionCmd) {
        JButton portEllipsis = new JButton("...");
        portEllipsis.setToolTipText("Select End Device");
        portEllipsis.setActionCommand(actionCmd);
        portEllipsis.setMargin(Util.getNoBorder());
        portEllipsis.addActionListener(this);
        return portEllipsis;
    }

    private void presentData(ArrayList rptData) {
        if (rptData == null) {
            return;
        }
        this.pathModel.fireTableDataChanged();
        ArrayList<CostBasedDefTreeNode> treeNodeList = new ArrayList<CostBasedDefTreeNode>();
        for (int i = 0; i < rptData.size(); ++i) {
            ArrayList pathList = (ArrayList)rptData.get(i);
            Array<Object[]> modelDat = new Array<Object[]>();
            StringBuffer logData = new StringBuffer();
            int pathCost = 0;
            for (int k = pathList.size() - 1; k >= 0; --k) {
                Object[] row = new Object[5];
                Object[] routeData = (Object[])pathList.get(k);
                try {
                    Switch sw2;
                    Switch switch_;
                    Switch sw1;
                    Switch switch_2;
                    if (routeData[0] == null && routeData[1] == null || routeData[1] == null && pathList.size() > 1) continue;
                    if (routeData[0] != null) {
                        ClientController.getInstance();
                        switch_2 = ClientController.findFabricSwitchByIpAddress(InetAddress.getByName(new String((byte[])routeData[0])));
                    } else {
                        switch_2 = sw1 = null;
                    }
                    if (routeData[1] != null) {
                        ClientController.getInstance();
                        switch_ = ClientController.findFabricSwitchByIpAddress(InetAddress.getByName(new String((byte[])routeData[1])));
                    } else {
                        switch_ = sw2 = null;
                    }
                    if (sw2 == null && sw1 == null) continue;
                    row[0] = sw2 != null ? sw2 : sw1;
                    row[1] = sw1 != null ? sw1 : sw2;
                    short vsanId1 = ((short[])routeData[2])[0];
                    short vsanId2 = ((short[])routeData[2])[1];
                    if (vsanId1 != vsanId2) {
                        Switch refSw = (Switch)row[1];
                        Vsan vsan2 = refSw.getVsan(vsanId2);
                        Vsan vsan1 = refSw.getVsan(vsanId1);
                        row[4] = (vsan1 != null ? vsan1 : "VSAN" + vsanId1) + "<-->" + (vsan2 != null ? vsan2 : "VSAN" + vsanId2);
                    }
                    int[][] islInfo = (int[][])routeData[3];
                    StringBuffer isls = new StringBuffer();
                    if (islInfo != null) {
                        int minCost = Integer.MAX_VALUE;
                        for (int ii = 0; ii < islInfo.length; ++ii) {
                            int port1 = islInfo[ii][0];
                            int port2 = islInfo[ii][1];
                            int cost = islInfo[ii][2];
                            if (cost > minCost) continue;
                            if (cost < minCost) {
                                isls.setLength(0);
                            }
                            minCost = cost;
                            if (isls.length() > 0) {
                                isls.append(", ");
                            }
                            isls.append(sw1.ifIndexToName(port2) + "<->" + sw2.ifIndexToName(port1));
                        }
                        row[2] = isls.toString();
                        row[3] = new Integer(minCost);
                        pathCost += minCost;
                    }
                }
                catch (UnknownHostException ex) {
                    row[0] = (String)routeData[0];
                }
                modelDat.addElement(row);
                if (row == null) continue;
                for (int r = 0; r < row.length - 1; ++r) {
                    logData.append(row[r] + ", ");
                }
                logData.append("\n");
            }
            DefaultMutableTreeNode nd = new DefaultMutableTreeNode("p" + i + "(" + pathCost + ")");
            this.pathTraceMap.put(nd, new Object[]{modelDat, logData});
            treeNodeList.add(new CostBasedDefTreeNode(nd, pathCost));
        }
        Collections.sort(treeNodeList);
        HashMap oldMap = this.pathTraceMap;
        this.pathTraceMap = new HashMap();
        for (int t = 0; t < treeNodeList.size(); ++t) {
            CostBasedDefTreeNode nd = (CostBasedDefTreeNode)treeNodeList.get(t);
            nd.trNode.setUserObject("P" + t + "(" + nd.pathCost + ")");
            Object[] data = (Object[])oldMap.get(nd.trNode);
            this.pathTraceMap.put(nd.trNode, data);
            this.root.add(nd.trNode);
            _Logger.debug((Object)("Node:" + nd.trNode));
            _Logger.debug(data[1]);
        }
        this.pathsTree.repaint();
        int pathsCount = this.root.getChildCount();
        if (rptData.size() > 0 && pathsCount > 0) {
            this.pathsTree.setSelectionPath(new TreePath(((DefaultTreeModel)this.pathsTree.getModel()).getPathToRoot(this.root.getChildAt(0))));
        }
        this.statusLbl.setText(pathsCount > 0 ? pathsCount + " paths" : "No Paths");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.statusTimer) {
            if (this.statusTimer == null) {
                return;
            }
            try {
                WebAnalysisRif webProxy = ClientController.getInstance().assertwebAnalysis();
                if (webProxy.isErrorInProcessing(9, this.reportId)) {
                    this.cleanUpTimer(true, Cursor.getDefaultCursor());
                    Exception errException = webProxy.getErrorException(9, this.reportId);
                    this.clearServerSideReport();
                    if (errException != null) {
                        Util.errorMessage((Component)this, errException.getMessage());
                    }
                    this.statusLbl.setText("Failed");
                    return;
                }
                if (webProxy.isReportRunning(9, this.reportId)) {
                    this.statusLbl.setText(webProxy.getReportStatus(9, this.reportId));
                    return;
                }
                ArrayList reportData = webProxy.getReport(9, this.reportId);
                webProxy.stopAsyncReport(this.reportId, false);
                this.cleanUpTimer(true, Cursor.getDefaultCursor());
                this.clearServerSideReport();
                this.reportId = -1;
                this.statusLbl.setText(reportData.size() > 0 ? "Finished" : "No Paths");
                this.presentData(reportData);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex.getMessage());
                _Logger.info((Object)("Error:" + ex != null ? ex.getMessage() : "Unknown"));
                this.cleanUpTimer(true, Cursor.getDefaultCursor());
            }
            return;
        }
        char cmd = e.getActionCommand().charAt(0);
        Object selVsanOb = this.vsanCb.getSelectedItem();
        boolean allPorts = !(selVsanOb instanceof Vsan);
        switch (cmd) {
            case '1': 
            case '2': {
                Vsan[] vsans;
                EndPortSelector prtSel = new EndPortSelector((JFrame)SwingUtilities.windowForComponent(this), allPorts ? null : (Vsan)selVsanOb, null, false, null);
                prtSel.setVisible(true);
                EndPort[] ep = prtSel.getSelectedEndPort();
                if (ep != null && ep.length > 0) {
                    FieldPanel selPnl = cmd == '1' ? this.port1Fp : this.port2Fp;
                    selPnl.setText(SnmpString.toHexString(ep[0].getPortWwn().getValue()));
                }
                if ((vsans = prtSel.getSelectedEndPortVsans()) == null || vsans.length <= 0) break;
                Vsan vv = vsans[0];
                if (cmd == '1') {
                    this.v1 = vv;
                } else {
                    this.v2 = vv;
                }
                JLabel lbl = cmd == '1' ? this.port1Vsan : this.port2Vsan;
                lbl.setText(vv != null ? vv.getName() : "");
                break;
            }
            case 'T': {
                this.statusLbl.setText(" ");
                this.clearServerSideReport();
                Object[] portsInfo = this.validateData();
                if (portsInfo == null) {
                    return;
                }
                this.pathTraceMap.clear();
                this.root.removeAllChildren();
                DefaultTreeModel model = (DefaultTreeModel)this.pathsTree.getModel();
                model.reload();
                this.pathModel.setData(new Array());
                this.pathModel.fireTableDataChanged();
                try {
                    WebAnalysisRif webProxy = ClientController.getInstance().assertwebAnalysis();
                    EndPort ep1 = (EndPort)portsInfo[1];
                    this.v1 = this.v1 != null ? (ep1.isMemberOfVsan(this.v1) ? this.v1 : ep1.getFirstVsan()) : ep1.getFirstVsan();
                    EndPort ep2 = (EndPort)portsInfo[3];
                    this.v2 = this.v2 != null ? (ep2.isMemberOfVsan(this.v2) ? this.v2 : ep2.getFirstVsan()) : ep2.getFirstVsan();
                    this.port1Vsan.setText(this.v1.getName());
                    this.port2Vsan.setText(this.v2.getName());
                    this.fPorts = new EndPort[]{ep1, ep2};
                    Vsan vv = (Vsan)portsInfo[4];
                    this.dialogBtns[0].setEnabled(false);
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.statusLbl.setText("Start Running Trace Path Report...");
                    this.reportId = webProxy.startASyncReportWithNewInstance(1, "", new Object[]{portsInfo[0], portsInfo[2], new short[]{this.v1.getId(), this.v2.getId()}}, 9, "Trace Path", -1L, -1L);
                    this.statusTimer = new Timer(5000, this);
                    this.statusTimer.start();
                    break;
                }
                catch (Exception exx) {
                    Util.errorMessage((Component)this, exx.getMessage());
                    return;
                }
            }
            case 'C': {
                this.dispose();
            }
        }
    }

    private void cleanUpTimer(boolean finishBtnState, Cursor cur) {
        if (this.statusTimer != null) {
            this.statusTimer.stop();
            this.statusTimer = null;
        }
        this.dialogBtns[0].setEnabled(finishBtnState);
        this.setCursor(cur);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] paths;
        if (e.getSource() == this.pathsTree && e.getNewLeadSelectionPath() != null && (paths = this.pathsTree.getSelectionPaths()) != null && paths.length > 0) {
            TreeNode nd = (TreeNode)paths[0].getLastPathComponent();
            Object[] allData = (Object[])this.pathTraceMap.get(nd);
            Array modelData = allData == null ? new Array() : (Array)allData[0];
            this.pathModel.setData(modelData);
            this.pathTable.calcPreferredSize();
            this.pathModel.fireTableDataChanged();
            this.statusLbl.setText("Hops:" + modelData.size());
            this.HighLightPath(modelData);
        }
    }

    private void HighLightPath(Array modelData) {
        if (modelData != null && modelData.size() > 0) {
            ArrayList<Object> switches = new ArrayList<Object>();
            ArrayList<Isl> isls = new ArrayList<Isl>();
            for (int i = 0; i < modelData.size(); ++i) {
                String[] ports;
                String islData;
                Object[] rowData = (Object[])modelData.elementAt(i);
                switches.add(rowData[0]);
                if (i == modelData.size() - 1) {
                    switches.add(rowData[1]);
                }
                if ((islData = (String)rowData[2]) == null || (ports = StringUtil.tokenize(islData, ",")) == null || ports.length <= 0) continue;
                for (int p = 0; p < ports.length; ++p) {
                    int ind = ports[p].indexOf("<");
                    if (ind == -1) continue;
                    Switch sw1 = (Switch)rowData[0];
                    try {
                        Isl portIsl = sw1.getFabric().findIslBySwitchIfIndex(sw1, sw1.nameToIfIndex(ports[p].substring(0, ind).trim()));
                        if (portIsl == null) continue;
                        isls.add(portIsl);
                        continue;
                    }
                    catch (IllegalArgumentException exx) {
                        _Logger.info((Object)("Invalid ISL:" + ports[p].substring(0, ind)));
                        System.out.println("Invalid ISL:" + ports[p].substring(0, ind));
                    }
                }
            }
            switches.addAll(isls);
            switches.add(this.fPorts[0]);
            switches.add(this.fPorts[1]);
            HighlightAction.getInstance().clearHighlight();
            HighlightAction.getInstance().setObjects(switches, null);
            HighlightAction.getInstance().execute();
        } else {
            HighlightAction.getInstance().clearHighlight();
        }
    }

    private Object[] validateData() {
        byte[] port1 = null;
        byte[] port2 = null;
        EndPort ep1 = null;
        EndPort ep2 = null;
        StringBuffer errMsg = new StringBuffer();
        StringBuffer notinFabVsanMsg = new StringBuffer();
        Object vOb = this.vsanCb.getSelectedItem();
        Vsan vv = vOb instanceof Vsan ? (Vsan)vOb : null;
        try {
            port1 = SnmpWWN.parse(this.port1Fp.getText().trim(), false);
            ClientController.getInstance();
            ep1 = ClientController.findFabricEndPortByWwn(new Wwn(port1));
            if (ep1 == null || vv != null && !ep1.isMemberOfVsan(vv.getId())) {
                notinFabVsanMsg.append(SnmpString.toHexString(port1) + "\n");
            }
        }
        catch (NumberFormatException ex) {
            errMsg.append("Invalid Port: " + this.port1Fp.getText() + "\n");
        }
        try {
            port2 = SnmpWWN.parse(this.port2Fp.getText().trim(), false);
            ClientController.getInstance();
            ep2 = ClientController.findFabricEndPortByWwn(new Wwn(port2));
            if (ep2 == null || vv != null && !ep2.isMemberOfVsan(vv.getId())) {
                notinFabVsanMsg.append(SnmpString.toHexString(port2) + "\n");
            }
        }
        catch (NumberFormatException ex) {
            errMsg.append("Invalid Port " + this.port2Fp.getText() + "\n");
            return null;
        }
        if (notinFabVsanMsg.length() > 0) {
            errMsg.append("Following selected Port(s) not present in Fabric or selected VSAN\n");
            errMsg.append(notinFabVsanMsg);
        }
        if (errMsg.length() > 0) {
            Util.errorMessage((Component)this, errMsg.toString());
            return null;
        }
        return new Object[]{port1, ep1, port2, ep2, vv};
    }

    @Override
    public void dispose() {
        if (this.statusTimer != null) {
            this.statusTimer.stop();
            this.statusTimer = null;
            this.clearServerSideReport();
        }
        super.dispose();
    }

    private void clearServerSideReport() {
        try {
            WebAnalysisRif webProxy = ClientController.getInstance().assertwebAnalysis();
            webProxy.stopAsyncReport(this.reportId, false);
            webProxy.cleanUpExistingReport(9, this.reportId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class CostBasedDefTreeNode
    implements Comparator,
    Comparable {
        DefaultMutableTreeNode trNode;
        int pathCost;

        public CostBasedDefTreeNode(DefaultMutableTreeNode nd, int cost) {
            this.trNode = nd;
            this.pathCost = cost;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            CostBasedDefTreeNode f1 = (CostBasedDefTreeNode)o1;
            CostBasedDefTreeNode f2 = (CostBasedDefTreeNode)o2;
            return f1.pathCost - f2.pathCost;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            if (o == null) {
                return 1;
            }
            return this.compare(this, (CostBasedDefTreeNode)o);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof CostBasedDefTreeNode) {
                return this.equals((CostBasedDefTreeNode)obj);
            }
            return false;
        }

        public boolean equals(CostBasedDefTreeNode entry) {
            return this.compareTo(entry) == 0;
        }
    }

    class PathTreeRenderer
    extends DefaultTreeCellRenderer {
        PathTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object o = ((DefaultMutableTreeNode)value).getUserObject();
            if (leaf) {
                this.setLeafIcon(null);
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

