/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.merge;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.SmZoneMember;
import com.cisco.dcbu.sm.client.zm.merge.Legend;
import com.cisco.dcbu.sm.client.zm.merge.ZExecutePanel;
import com.cisco.dcbu.sm.client.zm.merge.ZMergeTableModel;
import com.cisco.dcbu.sm.client.zm.merge.ZModelKeys;
import com.cisco.dcbu.sm.client.zm.merge.ZTreeCellRenderer;
import com.cisco.dcbu.sm.client.zm.merge.ZWrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;

public class ZStageZoneset
extends WizardPanel
implements ZModelKeys {
    private String _desc = "After the merge a new zoneset Stage_ZS1 will be created and zones will be added to it.";
    public static final ImageIcon ICON = Util.loadIcon("icons/zonemerge.gif");
    private JPanel _core = new JPanel(new BorderLayout());
    private JLabel _lblVsan = new JLabel();
    private JCheckBox _readOnly = new JCheckBox("Convert \"Read Only\" conflict to \"Read Only\" staged zone.");
    private JScrollPane _sp1 = new JScrollPane();
    private JScrollPane _sp2 = new JScrollPane();
    private JScrollPane _sp3 = new JScrollPane();
    private DefaultMutableTreeNode _mergeRootNode = null;
    private SnmpPeer _sourcePeer;
    private SnmpPeer _targetPeer;
    private String _sourceVersion;
    private String _targetVersion;
    private ZoneSet _sourceActive;
    private ZoneSet _targetActive;
    private HashMap _sourceMap;
    private HashMap _targetMap;
    private Vsan _vsan;
    private String _newName;
    private ZMergeTableModel _model;
    static final String _DEFAULT_ZONE = "$default_zone$";
    private static final Color DIFF_SRC = new Color(192, 192, 255);
    private static final Color DIFF_TGT = new Color(192, 255, 192);
    private static final Color DIFF_CMN = new Color(255, 192, 192);
    static final String Prefix = "Staging_";

    public ZStageZoneset(String home) {
        super("Step 3 of 4: Select Zone Members To Merge", "", ICON);
        super.setDescription(this._desc);
        JPanel top = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"VSAN:"}), new JComponent[]{this._lblVsan});
        JPanel tmp1 = new JPanel(new GridLayout(1, 2));
        JPanel tmp2 = new JPanel(new GridLayout(2, 1));
        tmp1.add(this._sp1);
        tmp1.add(this._sp2);
        tmp2.add(tmp1);
        JPanel t = new JPanel(new BorderLayout());
        t.add((Component)this._readOnly, "North");
        t.add((Component)this._sp3, "Center");
        tmp2.add(t);
        this._core.add((Component)top, "North");
        this._core.add((Component)tmp2, "Center");
        JPanel bot = DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"Legend:", "Source Members:", "Target Members:", "Common Members:"}), new JComponent[]{new JLabel(), new Legend(DIFF_SRC), new Legend(DIFF_TGT), new Legend(DIFF_CMN)});
        this._core.add((Component)bot, "South");
        this.add((Component)this._core, "Center");
    }

    public void doInitialize() {
        try {
            this._sourcePeer = (SnmpPeer)this.getModelValue("SOURCE_PEER");
            this._sourceVersion = (String)this.getModelValue("SOURCE_VER2");
            this._targetPeer = (SnmpPeer)this.getModelValue("TARGET_PEER");
            this._targetVersion = (String)this.getModelValue("TARGET_VER2");
            this._vsan = (Vsan)this.getModelValue("VSAN");
            this._sourceActive = (ZoneSet)this.getModelValue("SOURCE_ZONESET");
            this._targetActive = (ZoneSet)this.getModelValue("TARGET_ZONESET");
            this._sourceMap = (HashMap)this.getModelValue("SOURCE_ZONES");
            this._targetMap = (HashMap)this.getModelValue("TARGET_ZONES");
            this._model = (ZMergeTableModel)this.getModelValue("MODEL");
            this._newName = (String)this.getModelValue("NEW_NAME");
            this._lblVsan.setText(this._vsan.toString());
            JTree c1 = this.getTreeForZoneset(this._sourceActive, this._sourceMap);
            JTree c2 = this.getTreeForZoneset(this._targetActive, this._targetMap);
            JTree c3 = this.buildPreview();
            this._sp1.setViewportView(c1);
            this._sp2.setViewportView(c2);
            this._sp3.setViewportView(c3);
            this._sp1.setBorder(BorderFactory.createTitledBorder("Source Zoneset"));
            this._sp2.setBorder(BorderFactory.createTitledBorder("Target Zoneset"));
            ((JComponent)this._sp3.getParent()).setBorder(BorderFactory.createTitledBorder("Staging Zoneset"));
        }
        catch (Exception ex) {
            this.getWizard().setStatus(ex.getMessage());
            Util.errorMessage((Component)this.getWizard(), ex);
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doNext() {
        try {
            this.getWizard().setCursor(new Cursor(3));
            this.getWizard().setStatus("");
            StringBuffer buf1 = this.getCLI(this._mergeRootNode, this._vsan, this._sourcePeer, new StringBuffer(this._sourceVersion));
            StringBuffer buf2 = this.getCLI(this._mergeRootNode, this._vsan, this._targetPeer, new StringBuffer(this._targetVersion));
            this.setModelValue("SOURCE_CLI", buf1);
            this.setModelValue("TARGET_CLI", buf2);
            ((ZExecutePanel)this.getModelValue("ZExecutePanel")).doInitialize();
            super.doNext();
        }
        catch (Exception ex) {
            this.getWizard().setStatus(ex.getMessage());
            Util.errorMessage((Component)this.getWizard(), ex);
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.getWizard().setCursor(new Cursor(0));
        }
    }

    private JTree getTreeForZoneset(ZoneSet zs, HashMap map) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(zs);
        HashMap details = map;
        if (details != null) {
            for (Map.Entry obEntry : details.entrySet()) {
                Zone zone = (Zone)obEntry.getKey();
                ArrayList members = (ArrayList)obEntry.getValue();
                if (zone == null || zone.toString().trim().equals(_DEFAULT_ZONE)) continue;
                DefaultMutableTreeNode zoneNode = new DefaultMutableTreeNode(zone.getZoneName());
                if (members != null) {
                    for (int j = 0; j < members.size(); ++j) {
                        if (!(members.get(j) instanceof SmZoneMember)) continue;
                        DefaultMutableTreeNode memberNode = new DefaultMutableTreeNode(members.get(j));
                        zoneNode.add(memberNode);
                    }
                }
                root.add(zoneNode);
            }
        }
        JTree tree = new JTree(root);
        tree.setVisibleRowCount(10);
        ((DefaultTreeCellRenderer)tree.getCellRenderer()).setLeafIcon(null);
        return tree;
    }

    private JTree buildPreview() {
        DefaultMutableTreeNode root;
        this._mergeRootNode = root = new DefaultMutableTreeNode(new ZWrapper(this._newName, 0));
        HashMap tmp1 = this._sourceMap;
        HashMap tmp2 = this._targetMap;
        HashMap sourceOnly = this.getDistinguished(tmp1, tmp2, 2);
        HashMap targetOnly = this.getDistinguished(tmp2, tmp1, 3);
        HashMap common = this.getCommon(tmp1, tmp2, this._model);
        HashMap treeNodes = new HashMap();
        treeNodes.putAll(sourceOnly);
        treeNodes.putAll(targetOnly);
        treeNodes.putAll(common);
        boolean hasReadonlyConflict = false;
        for (Map.Entry obEntry : treeNodes.entrySet()) {
            ArrayList members;
            Object zone = obEntry.getKey();
            ZWrapper tmp = (ZWrapper)zone;
            boolean bl = hasReadonlyConflict = hasReadonlyConflict || tmp.isReadOnlyConflict();
            if (zone.toString().trim().equals(_DEFAULT_ZONE) || (members = (ArrayList)obEntry.getValue()) == null) continue;
            DefaultMutableTreeNode zoneNode = new DefaultMutableTreeNode(zone);
            for (int i = 0; i < members.size(); ++i) {
                ZWrapper wrap;
                if (!(members.get(i) instanceof ZWrapper) || !((wrap = (ZWrapper)members.get(i)).getValue() instanceof SmZoneMember)) continue;
                DefaultMutableTreeNode memberNode = new DefaultMutableTreeNode(members.get(i));
                zoneNode.add(memberNode);
            }
            root.add(zoneNode);
        }
        this._readOnly.setEnabled(hasReadonlyConflict);
        JTree tree = new JTree(root);
        ZTreeCellRenderer r = new ZTreeCellRenderer(DIFF_SRC, DIFF_TGT, DIFF_CMN);
        tree.setCellRenderer(r);
        tree.setVisibleRowCount(10);
        return tree;
    }

    private HashMap getDistinguished(HashMap zs1, HashMap zs2, int type) {
        HashMap result = new HashMap();
        for (Map.Entry obEntry : zs1.entrySet()) {
            String sourceZn = obEntry.getKey().toString();
            ArrayList members = (ArrayList)obEntry.getValue();
            boolean found = false;
            for (Map.Entry obEntryT : zs2.entrySet()) {
                String targetZn = obEntryT.getKey().toString();
                if (!sourceZn.equals(targetZn)) continue;
                found = true;
                break;
            }
            if (found || sourceZn.trim().equals(_DEFAULT_ZONE) || members == null) continue;
            ArrayList<ZWrapper> nuList = new ArrayList<ZWrapper>();
            for (int i = 0; i < members.size(); ++i) {
                nuList.add(new ZWrapper(members.get(i), type));
            }
            result.put(new ZWrapper(obEntry.getKey(), type), nuList);
        }
        return result;
    }

    private HashMap getCommon(HashMap zs1, HashMap zs2, ZMergeTableModel model) {
        HashMap<ZWrapper, ArrayList> result = new HashMap<ZWrapper, ArrayList>();
        block0: for (Map.Entry obEntry : zs1.entrySet()) {
            String sourceZn = obEntry.getKey().toString();
            Zone sZone = (Zone)obEntry.getKey();
            if (sourceZn.trim().equals(_DEFAULT_ZONE)) continue;
            ArrayList membersS = (ArrayList)obEntry.getValue();
            for (Map.Entry obEntryT : zs2.entrySet()) {
                String targetZn = obEntryT.getKey().toString();
                if (!sourceZn.equals(targetZn)) continue;
                Zone tZone = (Zone)obEntryT.getKey();
                boolean conflict = sZone.isReadOnly() ^ tZone.isReadOnly();
                Zone commonZone = sZone.isReadOnly() ? tZone : sZone;
                ArrayList membersT = (ArrayList)obEntryT.getValue();
                ArrayList members = this.getMergeMembers(sourceZn.trim(), membersS, membersT, model);
                if (members == null || members.size() <= 0) continue block0;
                ZWrapper w = new ZWrapper(commonZone, 1);
                w.setReadOnlyConflict(conflict);
                result.put(w, members);
                continue block0;
            }
        }
        return result;
    }

    private ArrayList getMergeMembers(String zone, ArrayList m1, ArrayList m2, ZMergeTableModel model) {
        ArrayList res = this.unite(m1, m2);
        for (int i = 0; i < model.getRowCount(); ++i) {
            ZWrapper obj;
            Iterator itr;
            String currentZone = model.getValueAt(i, 0).toString().trim();
            if (!currentZone.equals(zone)) continue;
            String str = (String)model.getValueAt(i, 3);
            if (str.equals("<")) {
                itr = res.iterator();
                while (itr.hasNext()) {
                    obj = (ZWrapper)itr.next();
                    if (obj.getState() == 2) continue;
                    itr.remove();
                }
                continue;
            }
            if (str.equals(">")) {
                itr = res.iterator();
                while (itr.hasNext()) {
                    obj = (ZWrapper)itr.next();
                    if (obj.getState() == 3) continue;
                    itr.remove();
                }
                continue;
            }
            res = new ArrayList();
        }
        return res;
    }

    private ArrayList unite(ArrayList m1, ArrayList m2) {
        int i;
        ArrayList<ZWrapper> res = new ArrayList<ZWrapper>();
        if (m1 != null) {
            for (i = 0; i < m1.size(); ++i) {
                Object src = m1.get(i);
                if (m2.indexOf(src) == -1) {
                    res.add(new ZWrapper(src, 2));
                    continue;
                }
                res.add(new ZWrapper(src, 1));
                m2.remove(m2.indexOf(src));
            }
        }
        if (m2 != null) {
            for (i = 0; i < m2.size(); ++i) {
                Object dst = m2.get(i);
                res.add(new ZWrapper(dst, 3));
            }
        }
        return res;
    }

    private StringBuffer getCLI(DefaultMutableTreeNode root, Vsan v, SnmpPeer peer, StringBuffer version) throws SnmpException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("config terminal\n");
        buffer.append("zoneset name " + root.getUserObject() + " vsan " + v.getId() + "\n");
        ArrayList zoneCommands = this.getZoneCommands(root, peer, version);
        for (int i = 0; i < zoneCommands.size(); ++i) {
            buffer.append(zoneCommands.get(i) + "\n");
        }
        buffer.append("exit\n");
        return buffer;
    }

    private ArrayList getZoneCommands(DefaultMutableTreeNode root, SnmpPeer peer, StringBuffer version) throws SnmpException {
        ArrayList<String> cli = new ArrayList<String>();
        if (root == null) {
            return cli;
        }
        Enumeration<TreeNode> enums = root.children();
        while (enums.hasMoreElements()) {
            DefaultMutableTreeNode zoneNode = (DefaultMutableTreeNode)enums.nextElement();
            ZWrapper zoneWrapper = (ZWrapper)zoneNode.getUserObject();
            Zone zone = (Zone)zoneWrapper.getValue();
            if (zoneWrapper.isReadOnlyConflict()) {
                cli.add("zone name Staging_" + zone.toString());
            } else {
                cli.add("zone name " + zoneWrapper.toString());
            }
            if (zoneWrapper.isReadOnlyConflict() && this._readOnly.isSelected()) {
                cli.add("attribute read-only");
            } else if (zone.isReadOnly()) {
                cli.add("attribute read-only");
            }
            Enumeration<TreeNode> enum2 = zoneNode.children();
            while (enum2.hasMoreElements()) {
                DefaultMutableTreeNode memberNode = (DefaultMutableTreeNode)enum2.nextElement();
                ZWrapper memberWrapper = (ZWrapper)memberNode.getUserObject();
                SmZoneMember member = (SmZoneMember)memberWrapper.getValue();
                byte[] lun = member.getMemLunId();
                int format = member.getMemFormat();
                byte[] id = member.getMemId();
                cli.add(ZStageZoneset.getMemberCLI(format, id, lun, peer, version, false));
            }
            cli.add("exit");
        }
        return cli;
    }

    private static String getMemberCLI(int format, byte[] id, byte[] lun, SnmpPeer targetSwitch, StringBuffer version, boolean verChk) throws SnmpException {
        String command = "";
        boolean ver13 = version.toString() != null && version.toString().indexOf("1.3") != -1;
        boolean ver12 = version.toString() != null && version.toString().indexOf("1.2") != -1;
        boolean ver10 = version.toString() != null && version.toString().startsWith("1.0");
        String cliLun = "";
        if (lun != null && lun.length > 0) {
            if (verChk && !ver12 && !ver13) {
                throw new SnmpException("Luns not supported by " + targetSwitch);
            }
            cliLun = ZStageZoneset.convertLunToCLI(lun);
        }
        switch (format) {
            case 1: 
            case 11: {
                command = "member pwwn " + SnmpString.toHexString(id) + (cliLun.length() > 0 ? " lun " + cliLun : "");
                break;
            }
            case 3: 
            case 12: {
                command = "member fcid " + SnmpFcAddressId.toHexString(id) + (cliLun.length() > 0 ? " lun " + cliLun : "");
                break;
            }
            case 2: {
                if (verChk && !ver12 && !ver13) {
                    throw new SnmpException("Domain id not supported by " + targetSwitch);
                }
                command = "member domain-id " + (0xFF & id[0]) + " port-number " + (0xFF & id[1]);
                break;
            }
            case 4: {
                if (verChk && ver10) {
                    throw new SnmpException("Fabric port wwn not supported by " + targetSwitch);
                }
                command = "member fwwn " + SnmpString.toHexString(id);
                break;
            }
            case 6: {
                if (verChk && !ver12 && !ver13) {
                    throw new SnmpException("Interface format not supported by " + targetSwitch);
                }
                byte[] b2 = null;
                if (id.length > 4 && id.length <= 12) {
                    b2 = new byte[8];
                    System.arraycopy(id, 4, b2, 0, 8);
                }
                String swwn = null;
                if (b2 != null) {
                    swwn = SnmpString.toHexString(b2);
                }
                if (swwn != null) {
                    command = "member interface " + ClientController.findFabricSwitchByIpAddress(targetSwitch.getAddress()).ifIndexToName(EnforcedZoneMember.getIfFormatIfIndex(id, 0)) + " swwn " + swwn;
                    break;
                }
                command = "member interface " + IfIndexUtil.ifIndexToName(EnforcedZoneMember.getIfFormatIfIndex(id, 0));
                break;
            }
            case 5: {
                if (verChk && !ver12 && !ver13) {
                    throw new SnmpException("Iscsi not supported by " + targetSwitch);
                }
                command = "member  symbolic-nodename " + new String(id);
                break;
            }
            case 8: {
                if (verChk && !ver13) {
                    throw new SnmpException("Port Ip Address not supported by " + targetSwitch);
                }
                byte[] add = new byte[4];
                byte[] mask = new byte[4];
                System.arraycopy(id, 0, add, 0, 4);
                if (id.length > 4) {
                    System.arraycopy(id, 4, mask, 0, 4);
                    command = "member ip-address " + SnmpIpAddress.toString(add) + " " + SnmpIpAddress.toString(mask);
                    break;
                }
                command = "member ip-address " + SnmpIpAddress.toString(add);
                break;
            }
            case 7: {
                if (verChk && !ver13) {
                    throw new SnmpException("Domain Id Interface format not supported by " + targetSwitch);
                }
                int tmp = id[1] << 24 & 0xFF000000 | id[2] << 16 & 0xFF0000 | id[3] << 8 & 0xFF00 | id[4] & 0xFF;
                String fcid = ClientController.findFabricSwitchByIpAddress(targetSwitch.getAddress()).ifIndexToName(tmp);
                command = "member interface " + fcid + " domain-id " + (id[0] & 0xFF);
                break;
            }
        }
        return command;
    }

    public static String convertLunToCLI(byte[] lun) {
        boolean empty = true;
        for (int i = 0; i < lun.length; ++i) {
            if ((lun[i] & 0xFF) == 0) continue;
            empty = false;
            break;
        }
        if (empty) {
            return "";
        }
        StringBuffer sb = new StringBuffer("0x");
        for (int i = 0; i < lun.length; i += 2) {
            sb.append(SnmpString.HEX_DIGIT[lun[i] >> 4 & 0xF]);
            sb.append(SnmpString.HEX_DIGIT[lun[i] & 0xF]);
            sb.append(SnmpString.HEX_DIGIT[lun[i + 1] >> 4 & 0xF]);
            sb.append(SnmpString.HEX_DIGIT[lun[i + 1] & 0xF]);
            if (i + 3 >= lun.length) continue;
            sb.append(':');
        }
        return sb.toString();
    }
}

