/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.merge;

import com.cisco.dcbu.lib.ui.table.ColumnGroup;
import com.cisco.dcbu.lib.ui.table.GroupableTableHeader;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.table.MultiLineTableCellRenderer;
import com.cisco.dcbu.lib.ui.table.MultiRowTable;
import com.cisco.dcbu.lib.ui.table.MultiRowTableModel;
import com.cisco.dcbu.sm.client.zm.merge.ZMergeTableModel;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class ZoneMergeTable
extends MultiRowTable {
    private int _rowHeight;

    public ZoneMergeTable(ZMergeTableModel dataModel) {
        super(dataModel);
        this.setTableHeader(new GroupableTableHeader(this.getColumnModel()));
        this.getTableHeader().addMouseListener(new HeaderListener());
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
                    return;
                }
                if (((JComponent)e.getSource()).getCursor() != Cursor.getPredefinedCursor(11)) {
                    ZoneMergeTable.this.calcPreferredSize();
                }
            }
        });
        this.setSortable(true);
        this.setSelectionMode(2);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(true);
        this.setAutoResizeMode(0);
        this._rowHeight = this.getRowHeight();
        MultiLineTableCellRenderer multiLineRenderer = new MultiLineTableCellRenderer();
        this.setDefaultRenderer(ArrayList.class, multiLineRenderer);
    }

    public void setRowHeight() {
        MultiRowTableModel tableModel = (MultiRowTableModel)this.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            this.setRowHeight(i, this._rowHeight * tableModel.getRequiredRows(i));
        }
    }

    @Override
    public void removeSelectedRows() {
        int[] rows = this.getSelectedRows();
        if (rows != null) {
            int i;
            KTableModel model = (KTableModel)this.getModel();
            Object[] removedObjects = new Object[rows.length];
            for (i = 0; i < rows.length; ++i) {
                removedObjects[i] = model.getData().elementAt(rows[i]);
            }
            for (i = 0; i < rows.length; ++i) {
                model.getData().removeElement(removedObjects[i]);
            }
            model.fireTableDataChanged();
            this.setRowHeight();
        }
    }

    @Override
    protected String getCellString(TableModel model, int row, int col) {
        Object o = model.getValueAt(row, col);
        if (o != null) {
            if (o instanceof ArrayList && ((ArrayList)o).size() > 0) {
                return ((ArrayList)o).get(0).toString();
            }
            return o.toString();
        }
        return null;
    }

    @Override
    public void buildColGroups(String[] group, int[][] ranges) {
        TableColumnModel cm = this.getColumnModel();
        GroupableTableHeader header = (GroupableTableHeader)this.getTableHeader();
        header.clearColumnGroups();
        for (int i = 0; i < group.length; ++i) {
            ColumnGroup cg1 = new ColumnGroup(group[i]);
            for (int j = ranges[i][0]; j <= ranges[i][1]; ++j) {
                cg1.add(cm.getColumn(j));
            }
            header.addColumnGroup(cg1);
        }
    }
}

