/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.migrate.transfer;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.Util;
import java.util.ArrayList;
import java.util.HashMap;

public class EndPortInfo {
    private String[] _pWWNs = null;
    private String[] _nWWNs = null;
    private EndPort[] _ep = null;
    private HashMap _mapNwwnPwwn = new HashMap();

    public EndPortInfo() {
        this.findAllPWWNAndNWWNs();
    }

    public boolean isPWWN(String pWWN) {
        for (int i = 0; i < this._pWWNs.length; ++i) {
            if (!this._pWWNs[i].equals(pWWN)) continue;
            return true;
        }
        return false;
    }

    public boolean isNWWN(String nWWN) {
        for (int i = 0; i < this._nWWNs.length; ++i) {
            if (!this._nWWNs[i].equals(nWWN)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getPWWNs(String nWWN) {
        return (ArrayList)this._mapNwwnPwwn.get(nWWN);
    }

    private void findAllPWWNAndNWWNs() {
        this._ep = this.getAllEndPorts();
        int size = this._ep.length;
        this._pWWNs = new String[size];
        this._nWWNs = new String[size];
        for (int i = 0; i < size; ++i) {
            this._pWWNs[i] = this._ep[i].getPortWwn().toString();
            this._nWWNs[i] = this._ep[i].getNodeWwn().toString();
            this.mapNWWNtoPWWN(this._nWWNs[i], this._pWWNs[i]);
        }
    }

    private EndPort[] getAllEndPorts() {
        Fabric fabric = Util.getThisFabric();
        return fabric.getEndPorts();
    }

    private void mapNWWNtoPWWN(String nWWN, String pWWN) {
        ArrayList<String> pWWNList = (ArrayList<String>)this._mapNwwnPwwn.get(nWWN);
        if (pWWNList == null) {
            pWWNList = new ArrayList<String>();
            pWWNList.add(pWWN);
        } else {
            pWWNList.add(pWWN);
        }
        this._mapNwwnPwwn.put(nWWN, pWWNList);
    }

    private void printEndPortInfo() {
        int i;
        DefaultLogger._DefLogger.debug((Object)"PWWNs : ");
        for (i = 0; i < this._pWWNs.length; ++i) {
            DefaultLogger._DefLogger.debug((Object)("    " + this._pWWNs[i]));
        }
        for (i = 0; i < this._nWWNs.length; ++i) {
            DefaultLogger._DefLogger.debug((Object)("    " + this._nWWNs[i]));
        }
        DefaultLogger._DefLogger.debug((Object)"\n\nNWWNs with member PWWNs : ");
        for (String theNode : this._mapNwwnPwwn.keySet()) {
            DefaultLogger._DefLogger.debug((Object)("    NWWn : " + theNode));
            ArrayList pWWNList = (ArrayList)this._mapNwwnPwwn.get(theNode);
            for (int ii = 0; ii < pWWNList.size(); ++ii) {
                DefaultLogger._DefLogger.debug((Object)("         PWWN :" + (String)pWWNList.get(ii)));
            }
            DefaultLogger._DefLogger.debug((Object)"\n\n");
        }
    }
}

